/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphUtil {
    public static <T> Collection<Set<T>> stronglyConnectedComponent(Map<T, ? extends Collection<T>> graph) {
        Map<T, Set<T>> reversed = GraphUtil.reverse(graph);
        HashMap sccsByRoot = new HashMap();
        HashSet assigned = new HashSet();
        for (T root : GraphUtil.kosarajuSort(graph)) {
            LinkedList<T> todo = new LinkedList<T>();
            todo.add(root);
            while (!todo.isEmpty()) {
                Object current = todo.removeLast();
                if (!assigned.add(current)) continue;
                Set component = GraphUtil.getOrAdd(sccsByRoot, root);
                component.add(current);
                todo.addAll((Collection)reversed.get(current));
            }
        }
        return sccsByRoot.values();
    }

    static <T> Map<T, Set<T>> reverse(Map<T, ? extends Collection<T>> graph) {
        HashMap result = new HashMap();
        for (Map.Entry<T, Collection<T>> entry : graph.entrySet()) {
            T predecessor = entry.getKey();
            GraphUtil.getOrAdd(result, predecessor);
            for (T successor : entry.getValue()) {
                Set predecessors = GraphUtil.getOrAdd(result, successor);
                predecessors.add(predecessor);
            }
        }
        return result;
    }

    private static <T> Set<T> getOrAdd(Map<T, Set<T>> map, T key) {
        Set<T> predecessors = map.get(key);
        if (predecessors == null) {
            predecessors = new HashSet<T>();
            map.put(key, predecessors);
        }
        return predecessors;
    }

    static <T> Deque<T> kosarajuSort(Map<T, ? extends Collection<T>> graph) {
        HashSet reached = new HashSet();
        HashSet processed = new HashSet();
        LinkedList sorted = new LinkedList();
        LinkedList<T> todo = new LinkedList<T>(graph.keySet());
        while (!todo.isEmpty()) {
            Object current = todo.getLast();
            if (reached.add(current)) {
                Collection<T> successors = graph.get(current);
                if (successors == null) continue;
                for (T successor : successors) {
                    if (reached.contains(successor)) continue;
                    todo.add(successor);
                }
                continue;
            }
            todo.removeLast();
            if (!processed.add(current)) continue;
            sorted.addFirst(current);
        }
        return sorted;
    }

    public static <T> List<T> findPath(Map<T, ? extends Collection<T>> graph, T start, T end) {
        HashMap predecessors = new HashMap();
        ArrayList<T> todo = new ArrayList<T>();
        todo.add(start);
        while (!todo.isEmpty()) {
            ArrayList<T> nextTodo = new ArrayList<T>();
            for (Object current : todo) {
                Collection<T> successors = graph.get(current);
                if (successors == null) continue;
                for (T successor : successors) {
                    if (predecessors.containsKey(successor)) continue;
                    predecessors.put(successor, current);
                    nextTodo.add(successor);
                }
            }
            todo = nextTodo;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(end);
        Object current = end;
        do {
            if ((current = predecessors.get(current)) == null) {
                return null;
            }
            result.add(current);
        } while (!current.equals(start));
        Collections.reverse(result);
        return result;
    }
}

