/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.CompilationUnitResolver;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.ArrayLiteral;
import net.jangaroo.jooc.ast.AsExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BinaryOpExpr;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.BreakStatement;
import net.jangaroo.jooc.ast.CaseStatement;
import net.jangaroo.jooc.ast.Catch;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.ConditionalExpr;
import net.jangaroo.jooc.ast.ContinueStatement;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.DefaultStatement;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DoStatement;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.EmptyDeclaration;
import net.jangaroo.jooc.ast.EmptyStatement;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.ForInStatement;
import net.jangaroo.jooc.ast.ForInitializer;
import net.jangaroo.jooc.ast.ForStatement;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.IdeWithTypeParam;
import net.jangaroo.jooc.ast.IfStatement;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.InfixOpExpr;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.IsExpr;
import net.jangaroo.jooc.ast.LabeledStatement;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NamespaceDeclaration;
import net.jangaroo.jooc.ast.NamespacedIde;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.OpExpr;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.PostfixOpExpr;
import net.jangaroo.jooc.ast.PredefinedTypeDeclaration;
import net.jangaroo.jooc.ast.PrefixOpExpr;
import net.jangaroo.jooc.ast.PropertyDeclaration;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.Statement;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.SwitchStatement;
import net.jangaroo.jooc.ast.ThrowStatement;
import net.jangaroo.jooc.ast.TryStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.UseNamespaceDirective;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.ast.VectorLiteral;
import net.jangaroo.jooc.ast.WhileStatement;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.jooc.types.ExpressionType;

public abstract class CodeGeneratorBase
implements AstVisitor {
    protected static final String PROPERTY_CLASS_INSTANCE = "INSTANCE";
    protected final CompilationUnitResolver compilationUnitModelResolver;
    protected JsWriter out;
    private ListMultimap<BlockStatement, CodeGenerator> blockStartCodeGenerators = ArrayListMultimap.create();

    public CodeGeneratorBase(JsWriter out, CompilationUnitResolver compilationUnitModelResolver) {
        this.out = out;
        this.compilationUnitModelResolver = compilationUnitModelResolver;
    }

    protected void addBlockStartCodeGenerator(BlockStatement block, CodeGenerator codeGenerator) {
        this.blockStartCodeGenerators.put((Object)block, (Object)codeGenerator);
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) throws IOException {
        this.out.writeSymbol(blockStatement.getLBrace());
        boolean first = true;
        List codeGenerators = this.blockStartCodeGenerators.get((Object)blockStatement);
        if (codeGenerators != null) {
            for (CodeGenerator codeGenerator : codeGenerators) {
                codeGenerator.generate(this.out, first);
                first = false;
            }
        }
        this.visitBlockStatementDirectives(blockStatement);
        this.out.writeSymbol(blockStatement.getRBrace());
    }

    protected void visitBlockStatementDirectives(BlockStatement blockStatement) throws IOException {
        this.visitAll(blockStatement.getDirectives());
    }

    protected void writeModifiers(IdeDeclaration declaration) throws IOException {
        for (JooSymbol modifier : declaration.getSymModifiers()) {
            this.out.writeSymbol(modifier);
        }
    }

    @Override
    public void visitLiteralExpr(LiteralExpr literalExpr) throws IOException {
        this.out.writeSymbol(literalExpr.getValue());
    }

    @Override
    public final void visitPostfixOpExpr(PostfixOpExpr postfixOpExpr) throws IOException {
        postfixOpExpr.getArg().visit(this);
        this.out.writeSymbol(postfixOpExpr.getOp());
    }

    @Override
    public void visitDotExpr(DotExpr dotExpr) throws IOException {
        this.visitPostfixOpExpr(dotExpr);
        dotExpr.getIde().visit(this);
    }

    @Override
    public void visitPrefixOpExpr(PrefixOpExpr prefixOpExpr) throws IOException {
        this.out.writeSymbol(prefixOpExpr.getOp());
        prefixOpExpr.getArg().visit(this);
    }

    @Override
    public final void visitBinaryOpExpr(BinaryOpExpr binaryOpExpr) throws IOException {
        binaryOpExpr.getArg1().visit(this);
        this.out.writeSymbol(binaryOpExpr.getOp());
        binaryOpExpr.getArg2().visit(this);
    }

    @Override
    public final void visitIsExpr(IsExpr isExpr) throws IOException {
        this.visitInfixOpExpr(isExpr);
    }

    @Override
    public final void visitConditionalExpr(ConditionalExpr conditionalExpr) throws IOException {
        conditionalExpr.getCond().visit(this);
        this.out.writeSymbol(conditionalExpr.getSymQuestion());
        conditionalExpr.getIfTrue().visit(this);
        this.out.writeSymbol(conditionalExpr.getSymColon());
        conditionalExpr.getIfFalse().visit(this);
    }

    @Override
    public final <T extends AstNode> void visitCommaSeparatedList(CommaSeparatedList<T> commaSeparatedList) throws IOException {
        this.visitIfNotNull((AstNode)commaSeparatedList.getHead());
        if (commaSeparatedList.getSymComma() != null) {
            this.out.writeSymbol(commaSeparatedList.getSymComma());
            this.visitIfNotNull(commaSeparatedList.getTail());
        }
    }

    protected TypedIdeDeclaration findMemberWithBindableAnnotation(Ide qIde, MethodType methodType, TypeDeclaration typeDeclaration) {
        TypedIdeDeclaration member;
        String memberName = qIde.getIde().getText();
        TypeDeclaration currentTypeDeclaration = typeDeclaration;
        ArrayList<TypedIdeDeclaration> incorrectOverrides = new ArrayList<TypedIdeDeclaration>();
        while ((member = this.lookupPropertyDeclaration(currentTypeDeclaration, memberName, methodType)) != null && member.isPublic() && member.getClassDeclaration() != null) {
            if (this.isBindableWithoutAccessor(member)) {
                for (TypedIdeDeclaration incorrectOverride : incorrectOverrides) {
                    qIde.getScope().getCompiler().getLog().warning((FilePosition)incorrectOverride.getSymbol(), String.format("Ext config '%s' with annotation [Bindable(style=\"methods\")] must be redeclared/overwritten with the same annotation.", memberName));
                }
                return member;
            }
            currentTypeDeclaration = member.getClassDeclaration().getSuperTypeDeclaration();
            incorrectOverrides.add(member);
            if (currentTypeDeclaration != null) continue;
        }
        return null;
    }

    boolean isBindableWithoutAccessor(TypedIdeDeclaration member) {
        Annotation bindableAnnotation = member.getAnnotation("Bindable");
        return bindableAnnotation != null && (bindableAnnotation.getPropertiesByName().get("style") != null || "ext".equals(member.getClassDeclaration().getQualifiedName()[0]));
    }

    private TypedIdeDeclaration lookupPropertyDeclaration(TypeDeclaration classDeclaration, String memberName, MethodType methodType) {
        if (classDeclaration == null) {
            return null;
        }
        TypedIdeDeclaration member = classDeclaration.getMemberDeclaration(memberName);
        if (member instanceof PropertyDeclaration) {
            member = ((PropertyDeclaration)member).getAccessor(methodType == MethodType.SET);
        }
        if (member instanceof VariableDeclaration) {
            if (((VariableDeclaration)member).isConst() && methodType == MethodType.SET) {
                member = null;
            }
        } else if (member instanceof FunctionDeclaration) {
            MethodType foundMethodType;
            FunctionDeclaration method = (FunctionDeclaration)member;
            MethodType methodType2 = method.isGetter() ? MethodType.GET : (foundMethodType = method.isSetter() ? MethodType.SET : null);
            if (methodType != foundMethodType) {
                member = null;
            }
        }
        if (member == null) {
            member = this.lookupPropertyDeclaration(classDeclaration.getSuperTypeDeclaration(), memberName, methodType);
        }
        return member;
    }

    protected static Map<String, Object> getBindablePropertiesByName(TypedIdeDeclaration member) {
        return member.getAnnotations("Bindable").get(0).getPropertiesByName();
    }

    protected static String getBindablePropertyName(MethodType methodType, TypedIdeDeclaration member) {
        Object bindableAnnotationValue = CodeGeneratorBase.getBindablePropertiesByName(member).get(null);
        if (bindableAnnotationValue == null) {
            return (Object)((Object)methodType) + MxmlUtils.capitalize(member.getName());
        }
        return (String)bindableAnnotationValue;
    }

    @Override
    public void visitParameters(Parameters parameters) throws IOException {
        this.visitCommaSeparatedList(parameters);
    }

    @Override
    public final void visitPredefinedTypeDeclaration(PredefinedTypeDeclaration predefinedTypeDeclaration) {
        throw new IllegalStateException("there should be no code generation for predefined types");
    }

    protected void writeOptSymbol(JooSymbol symbol) throws IOException {
        if (symbol != null) {
            this.out.writeSymbol(symbol);
        }
    }

    protected void writeOptSymbolWhitespace(JooSymbol symbol) throws IOException {
        if (symbol != null) {
            this.out.writeSymbolWhitespace(symbol);
        }
    }

    protected void writeOptSymbol(JooSymbol optSymbol, String defaultToken) throws IOException {
        if (optSymbol != null) {
            this.out.writeSymbol(optSymbol);
        } else {
            this.out.writeToken(defaultToken);
        }
    }

    protected void writeSymbolReplacement(JooSymbol symbol, String replacementToken) throws IOException {
        if (symbol == null) {
            this.out.writeToken(replacementToken);
        } else {
            this.out.writeSymbolWhitespace(symbol);
            this.out.writeTokenForSymbol(replacementToken, symbol);
        }
    }

    protected void visitIfNotNull(AstNode args) throws IOException {
        if (args != null) {
            args.visit(this);
        }
    }

    protected void visitIfNotNull(AstNode args, String replacementToken) throws IOException {
        if (args != null) {
            args.visit(this);
        } else {
            this.out.writeToken(replacementToken);
        }
    }

    protected void visitAll(Iterable<? extends AstNode> nodes) throws IOException {
        for (AstNode astNode : nodes) {
            astNode.visit(this);
        }
    }

    protected List<AssignmentOpExpr> getPropertiesClassAssignments(FunctionDeclaration constructorDeclaration, boolean includeLiterals, boolean includeReferences) {
        if (constructorDeclaration == null) {
            return Collections.emptyList();
        }
        ArrayList<AssignmentOpExpr> result = new ArrayList<AssignmentOpExpr>();
        for (Directive constructorDirective : constructorDeclaration.getBody().getDirectives()) {
            boolean isLiteral;
            AssignmentOpExpr assignmentOpExpr;
            Map.Entry<Expr, AstNode> objectAndProperty;
            Expr arg;
            AstNode optStatement;
            if (!(constructorDirective instanceof SemicolonTerminatedStatement) || !((optStatement = ((SemicolonTerminatedStatement)constructorDirective).getOptStatement()) instanceof AssignmentOpExpr) || !((arg = (objectAndProperty = this.getObjectAndProperty(assignmentOpExpr = (AssignmentOpExpr)optStatement)).getKey()) instanceof IdeExpr) || !((IdeExpr)arg).getIde().isThis() || (isLiteral = assignmentOpExpr.getArg2() instanceof LiteralExpr) != includeLiterals && !isLiteral != includeReferences) continue;
            result.add(assignmentOpExpr);
        }
        return result;
    }

    protected void renderPropertiesClassValues(List<AssignmentOpExpr> propertyAssignments, boolean useComments, boolean useDeclarationComments, boolean startWithComma) throws IOException {
        for (AssignmentOpExpr propertyAssignment : propertyAssignments) {
            if (startWithComma) {
                this.out.writeToken(",");
            } else {
                startWithComma = true;
            }
            AstNode index = this.getObjectAndProperty(propertyAssignment).getValue();
            if (useComments) {
                if (useDeclarationComments && index instanceof Ide && ((Ide)index).getDeclaration(false) != null) {
                    IdeDeclaration declaration = ((Ide)index).getDeclaration();
                    this.out.writeSymbolWhitespace(declaration.getSymbol());
                } else {
                    this.out.writeSymbolWhitespace(propertyAssignment.getSymbol());
                }
            } else {
                this.out.write("\n  ");
            }
            index.visit(this);
            this.out.writeToken(":");
            propertyAssignment.getArg2().visit(this);
        }
    }

    protected Map.Entry<Expr, AstNode> getObjectAndProperty(AssignmentOpExpr assignmentOpExpr) {
        Expr lhs = assignmentOpExpr.getArg1();
        if (lhs instanceof IdeExpr) {
            lhs = ((IdeExpr)lhs).getNormalizedExpr();
        }
        if (lhs instanceof DotExpr) {
            DotExpr dotExpr = (DotExpr)lhs;
            return new AbstractMap.SimpleEntry<Expr, AstNode>(dotExpr.getArg(), dotExpr.getIde());
        }
        if (lhs instanceof ArrayIndexExpr) {
            ArrayIndexExpr arrayIndexExpr = (ArrayIndexExpr)lhs;
            return new AbstractMap.SimpleEntry<Expr, AstNode>(arrayIndexExpr.getArray(), arrayIndexExpr.getIndexExpr().getExpr());
        }
        throw new CompilerError("Properties class constructor code does not match standard format.");
    }

    @Override
    public void visitTypeRelation(TypeRelation typeRelation) throws IOException {
        this.out.writeSymbol(typeRelation.getSymbol());
        typeRelation.getType().visit(this);
    }

    @Override
    public void visitAnnotationParameter(AnnotationParameter annotationParameter) throws IOException {
        this.visitIfNotNull(annotationParameter.getOptName());
        this.writeOptSymbol(annotationParameter.getOptSymEq());
        this.visitIfNotNull(annotationParameter.getValue());
    }

    @Override
    public void visitExtends(Extends anExtends) throws IOException {
        this.out.writeSymbol(anExtends.getSymExtends());
        anExtends.getSuperClass().visit(this);
    }

    protected static boolean isPropertiesClass(IdeDeclaration primaryDeclaration) {
        return primaryDeclaration instanceof ClassDeclaration && primaryDeclaration.getName().endsWith("_properties");
    }

    protected static boolean isPropertiesSubclass(IdeDeclaration primaryDeclaration) {
        String classname = primaryDeclaration.getName();
        return CodeGeneratorBase.isPropertiesClass(primaryDeclaration) && classname.substring(0, classname.length() - "_properties".length()).contains("_");
    }

    @Override
    public void visitInitializer(Initializer initializer) throws IOException {
        this.out.writeSymbol(initializer.getSymEq());
        initializer.getValue().visit(this);
    }

    @Override
    public void visitObjectField(ObjectField objectField) throws IOException {
        DotExpr exmlAppendOrPrepend = this.getExmlAppendOrPrepend(objectField.getValue());
        if (exmlAppendOrPrepend != null) {
            this.handleExmlAppendPrepend(objectField, exmlAppendOrPrepend);
        } else {
            objectField.getLabel().visit(this);
            this.out.writeSymbol(objectField.getSymColon());
            this.visitObjectFieldValue(objectField);
        }
    }

    protected void visitObjectFieldValue(ObjectField objectField) throws IOException {
        objectField.getValue().visit(this);
    }

    protected abstract void handleExmlAppendPrepend(ObjectField var1, DotExpr var2) throws IOException;

    private DotExpr getExmlAppendOrPrepend(Expr value) {
        DotExpr dotExpr;
        String methodName;
        ApplyExpr applyExpr;
        if (value instanceof ApplyExpr && (applyExpr = (ApplyExpr)value).getFun() instanceof DotExpr && ((methodName = (dotExpr = (DotExpr)applyExpr.getFun()).getIde().getName()).equals("append") || methodName.equals("prepend")) && "net.jangaroo.ext.Exml".equals(CodeGeneratorBase.getArgFQN(dotExpr))) {
            return dotExpr;
        }
        return null;
    }

    static String getArgFQN(DotExpr dotExpr) {
        IdeExpr ideExpr;
        IdeDeclaration declaration;
        if (dotExpr.getArg() instanceof IdeExpr && (declaration = (ideExpr = (IdeExpr)dotExpr.getArg()).getIde().getDeclaration(false)) != null) {
            return declaration.getQualifiedNameStr();
        }
        return null;
    }

    @Override
    public void visitForInitializer(ForInitializer forInitializer) throws IOException {
        if (forInitializer.getDecl() != null) {
            forInitializer.getDecl().visit(this);
        } else {
            this.visitIfNotNull(forInitializer.getExpr());
        }
    }

    @Override
    public void visitCompilationUnit(CompilationUnit compilationUnit) throws IOException {
        compilationUnit.getPackageDeclaration().visit(this);
        this.out.writeSymbol(compilationUnit.getLBrace());
        this.visitAll(compilationUnit.getDirectives());
        IdeDeclaration primaryDeclaration = compilationUnit.getPrimaryDeclaration();
        primaryDeclaration.visit(this);
        this.out.writeSymbol(compilationUnit.getRBrace());
        if (primaryDeclaration instanceof ClassDeclaration) {
            this.visitAll(((ClassDeclaration)primaryDeclaration).getSecondaryDeclarations());
        }
    }

    @Override
    public void visitIde(Ide ide) throws IOException {
        this.out.writeSymbol(ide.getIde());
    }

    @Override
    public void visitQualifiedIde(QualifiedIde qualifiedIde) throws IOException {
        qualifiedIde.getQualifier().visit(this);
        this.out.writeSymbol(qualifiedIde.getSymDot());
        this.visitIde(qualifiedIde);
    }

    @Override
    public void visitIdeWithTypeParam(IdeWithTypeParam ideWithTypeParam) throws IOException {
        this.out.writeSymbol(ideWithTypeParam.getIde());
        this.out.writeSymbol(ideWithTypeParam.getSymDotLt());
        ideWithTypeParam.getType().visit(this);
        this.out.writeSymbol(ideWithTypeParam.getSymGt());
    }

    @Override
    public void visitNamespacedIde(NamespacedIde namespacedIde) throws IOException {
        namespacedIde.getNamespace().visit(this);
        this.out.writeSymbol(namespacedIde.getSymNamespaceSep());
        this.out.writeSymbol(namespacedIde.getIde());
    }

    @Override
    public void visitImplements(Implements anImplements) throws IOException {
        this.out.writeSymbol(anImplements.getSymImplements());
        anImplements.getSuperTypes().visit(this);
    }

    @Override
    public void visitType(Type type) throws IOException {
        type.getIde().visit(this);
    }

    @Override
    public void visitObjectLiteral(ObjectLiteral objectLiteral) throws IOException {
        this.out.writeSymbol(objectLiteral.getLBrace());
        this.visitIfNotNull(objectLiteral.getFields());
        this.writeOptSymbol(objectLiteral.getOptComma());
        this.out.writeSymbol(objectLiteral.getRBrace());
    }

    @Override
    public void visitIdeExpression(IdeExpr ideExpr) throws IOException {
        ideExpr.getIde().visit(this);
    }

    @Override
    public <T extends Expr> void visitParenthesizedExpr(ParenthesizedExpr<T> parenthesizedExpr) throws IOException {
        if (parenthesizedExpr.getParentNode() instanceof OpExpr && parenthesizedExpr.getExpr() instanceof InfixOpExpr) {
            this.generateInfixOpExpr((InfixOpExpr)parenthesizedExpr.getExpr(), parenthesizedExpr.getLParen(), parenthesizedExpr.getRParen());
        } else {
            this.out.writeSymbol(parenthesizedExpr.getLParen());
            this.visitIfNotNull((AstNode)parenthesizedExpr.getExpr());
            this.out.writeSymbol(parenthesizedExpr.getRParen());
        }
    }

    @Override
    public void visitArrayLiteral(ArrayLiteral arrayLiteral) throws IOException {
        this.visitParenthesizedExpr(arrayLiteral);
    }

    @Override
    public void visitAssignmentOpExpr(AssignmentOpExpr assignmentOpExpr) throws IOException {
        this.visitBinaryOpExpr(assignmentOpExpr);
    }

    @Override
    public void visitInfixOpExpr(InfixOpExpr infixOpExpr) throws IOException {
        this.generateInfixOpExpr(infixOpExpr, new JooSymbol("("), new JooSymbol(")"));
    }

    private void generateInfixOpExpr(InfixOpExpr infixOpExpr, JooSymbol lParenSym, JooSymbol rParenSym) throws IOException {
        this.out.writeSymbolWhitespace(lParenSym);
        this.out.writeToken(this.builtInIdentifierCode(infixOpExpr.getOp().getText()));
        this.out.writeSymbol(lParenSym);
        infixOpExpr.getArg1().visit(this);
        this.out.write(44);
        this.out.writeSymbolWhitespace(infixOpExpr.getOp());
        infixOpExpr.getArg2().visit(this);
        this.out.writeSymbol(rParenSym);
    }

    @Override
    public void visitAsExpr(AsExpr asExpr) throws IOException {
        this.visitInfixOpExpr(asExpr);
    }

    @Override
    public void visitArrayIndexExpr(ArrayIndexExpr arrayIndexExpr) throws IOException {
        arrayIndexExpr.getArray().visit(this);
        arrayIndexExpr.getIndexExpr().visit(this);
    }

    protected static FunctionDeclaration findFunctionDeclaration(AstNode node) {
        AstNode parent = node;
        do {
            if (!((parent = parent.getParentNode()) instanceof FunctionDeclaration)) continue;
            return (FunctionDeclaration)parent;
        } while (parent != null);
        return null;
    }

    @Override
    public void visitFunctionExpr(FunctionExpr functionExpr) throws IOException {
        this.out.writeSymbol(functionExpr.getSymFunction());
        this.visitIfNotNull(functionExpr.getIde());
        this.generateFunctionExprSignature(functionExpr);
        this.visitIfNotNull(functionExpr.getBody());
    }

    @Override
    public void visitVectorLiteral(VectorLiteral vectorLiteral) throws IOException {
        this.out.writeSymbol(vectorLiteral.getSymNew());
        this.out.writeSymbol(vectorLiteral.getSymLt());
        vectorLiteral.getVectorType().visit(this);
        this.out.writeSymbol(vectorLiteral.getSymGt());
        vectorLiteral.getArrayLiteral().visit(this);
    }

    @Override
    public void visitApplyExpr(ApplyExpr applyExpr) throws IOException {
        applyExpr.getFun().visit(this);
        this.visitApplyExprArguments(applyExpr);
    }

    public void visitApplyExprArguments(ApplyExpr applyExpr) throws IOException {
        ParenthesizedExpr<CommaSeparatedList<Expr>> args = applyExpr.getArgs();
        if (args != null) {
            FunctionDeclaration functionDeclaration = applyExpr.resolveFunction();
            if (functionDeclaration != null) {
                this.writeArgumentsWithOptCoercesAndDefaultValues(applyExpr, functionDeclaration);
            } else {
                args.visit(this);
            }
        }
    }

    private void writeArgumentsWithOptCoercesAndDefaultValues(ApplyExpr applyExpr, FunctionDeclaration methodDeclaration) throws IOException {
        ParenthesizedExpr<CommaSeparatedList<Expr>> args = applyExpr.getArgs();
        this.out.writeSymbol(args.getLParen());
        List<Annotation> parameterAnnotations = methodDeclaration.getAnnotations("Parameter");
        CommaSeparatedList<Expr> arguments = args.getExpr();
        Parameters params = methodDeclaration.getParams();
        boolean first = true;
        HashMap<String, String> propertiesClassByParamName = new HashMap<String, String>();
        while (params != null || arguments != null) {
            Initializer parameterInitializer;
            Annotation parameterAnnotation;
            Parameter parameter = params == null ? null : (Parameter)params.getHead();
            Annotation annotation = parameterAnnotation = parameter == null || parameterAnnotations == null ? null : (Annotation)parameterAnnotations.stream().filter(someParameterAnnotation -> parameter.getName().equals(someParameterAnnotation.getPropertiesByName().get(null))).findAny().orElse(null);
            if (arguments != null) {
                Object coerceToObj = parameterAnnotation == null ? null : parameterAnnotation.getPropertiesByName().get("coerceTo");
                boolean coerced = false;
                Expr argument = arguments.getHead();
                if (coerceToObj instanceof String) {
                    String coerceTo = (String)coerceToObj;
                    if ("PropertiesClass".equals(coerceTo)) {
                        ClassDeclaration propertiesClass = applyExpr.getPropertiesClass(argument);
                        String propertiesClassAccessCode = null;
                        if (propertiesClass != null) {
                            coerced = true;
                            propertiesClassAccessCode = this.compilationUnitAccessCode(propertiesClass);
                            this.out.write(propertiesClassAccessCode);
                        }
                        propertiesClassByParamName.put(parameter.getName(), propertiesClassAccessCode);
                    } else if (coerceTo.startsWith("keyof ")) {
                        if (!(argument instanceof LiteralExpr)) {
                            String referencedParam = coerceTo.substring("keyof ".length());
                            if (!propertiesClassByParamName.containsKey(referencedParam)) {
                                throw JangarooParser.error(argument.getSymbol(), String.format("Referenced properties class parameter name '%s' not found.", referencedParam));
                            }
                            String referencedPropertiesClass = (String)propertiesClassByParamName.get(referencedParam);
                            if (referencedPropertiesClass != null) {
                                coerced = true;
                                this.generateTypeAssertion(argument, "keyof " + referencedPropertiesClass);
                            }
                        }
                    } else {
                        ExpressionType type = argument.getType();
                        if (type == null || !type.getAS3Type().toString().equals(coerceTo)) {
                            coerced = true;
                            this.out.write(coerceTo + "(");
                            argument.visit(this);
                            this.out.write(")");
                        }
                    }
                }
                if (!coerced && !this.renderSingleSpreadValue(argument, parameter == null ? null : parameter.getIde().getScope().getExpressionType(parameter))) {
                    argument.visit(this);
                }
                this.writeOptSymbol(arguments.getSymComma());
                arguments = arguments.getTail();
            } else if (parameterAnnotation != null && (parameterInitializer = parameter.getOptInitializer()) != null && parameterAnnotation.getPropertiesByName().containsKey("required")) {
                if (!first) {
                    this.out.write(",");
                }
                parameterInitializer.getValue().visit(this);
            }
            if (params != null) {
                params = params.getTail();
            }
            first = false;
        }
        this.out.writeSymbol(args.getRParen());
    }

    boolean renderSingleSpreadValue(Expr argument, ExpressionType parameterType) throws IOException {
        return false;
    }

    void generateTypeAssertion(Expr argument, String type) throws IOException {
        argument.visit(this);
    }

    @Override
    public void visitNewExpr(NewExpr newExpr) throws IOException {
        this.out.writeSymbol(newExpr.getSymNew());
        newExpr.getApplyConstructor().visit(this);
    }

    @Override
    public void visitClassBody(ClassBody classBody) throws IOException {
        this.out.writeSymbol(classBody.getLBrace());
        this.visitClassBodyDirectives(classBody.getDirectives());
        this.out.writeSymbol(classBody.getRBrace());
    }

    public void visitClassBodyDirectives(List<Directive> classBodyDirectives) throws IOException {
        ArrayList<Directive> staticInitializerDirectives = null;
        for (Directive directive : classBodyDirectives) {
            boolean isStaticInitializer;
            boolean bl = directive instanceof EmptyStatement ? staticInitializerDirectives != null : (isStaticInitializer = directive instanceof Statement && !(directive instanceof Declaration));
            if (isStaticInitializer) {
                if (staticInitializerDirectives == null) {
                    staticInitializerDirectives = new ArrayList<Directive>();
                }
                staticInitializerDirectives.add(directive);
                continue;
            }
            if (staticInitializerDirectives != null) {
                this.generateStaticInitializer((List<Directive>)staticInitializerDirectives);
                staticInitializerDirectives = null;
            }
            directive.visit(this);
        }
        if (staticInitializerDirectives != null) {
            this.generateStaticInitializer(staticInitializerDirectives);
        }
    }

    abstract void generateStaticInitializer(List<Directive> var1) throws IOException;

    @Override
    public void visitDefaultStatement(DefaultStatement defaultStatement) throws IOException {
        this.out.writeSymbol(defaultStatement.getSymDefault());
        this.out.writeSymbol(defaultStatement.getSymColon());
    }

    @Override
    public void visitLabeledStatement(LabeledStatement labeledStatement) throws IOException {
        labeledStatement.getIde().visit(this);
        this.out.writeSymbol(labeledStatement.getSymColon());
        labeledStatement.getStatement().visit(this);
    }

    @Override
    public void visitIfStatement(IfStatement ifStatement) throws IOException {
        this.out.writeSymbol(ifStatement.getSymKeyword());
        ifStatement.getCond().visit(this);
        ifStatement.getIfTrue().visit(this);
        if (ifStatement.getSymElse() != null) {
            this.out.writeSymbol(ifStatement.getSymElse());
            ifStatement.getIfFalse().visit(this);
        }
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) throws IOException {
        this.out.writeSymbol(caseStatement.getSymKeyword());
        caseStatement.getExpr().visit(this);
        this.out.writeSymbol(caseStatement.getSymColon());
    }

    @Override
    public void visitTryStatement(TryStatement tryStatement) throws IOException {
        this.out.writeSymbol(tryStatement.getSymKeyword());
        tryStatement.getBlock().visit(this);
        this.visitAll(tryStatement.getCatches());
        if (tryStatement.getSymFinally() != null) {
            this.out.writeSymbol(tryStatement.getSymFinally());
            tryStatement.getFinallyBlock().visit(this);
        }
    }

    protected abstract String builtInIdentifierCode(String var1);

    @Override
    public void visitCatch(Catch aCatch) throws IOException {
        List<Catch> catches = aCatch.getParentTryStatement().getCatches();
        Catch firstCatch = catches.get(0);
        boolean isFirst = aCatch.equals(firstCatch);
        boolean isLast = aCatch.equals(catches.get(catches.size() - 1));
        TypeRelation typeRelation = aCatch.getParam().getOptTypeRelation();
        boolean hasCondition = aCatch.hasCondition();
        if (!hasCondition && !isLast) {
            throw JangarooParser.error(aCatch.getRParen(), "Only last catch clause may be untyped.");
        }
        JooSymbol errorVar = firstCatch.getParam().getIde().getIde();
        JooSymbol localErrorVar = aCatch.getParam().getIde().getIde();
        this.out.writeSymbolWhitespace(aCatch.getSymKeyword());
        if (isFirst) {
            this.out.writeSymbolToken(aCatch.getSymKeyword());
            this.out.writeSymbol(aCatch.getLParen(), !hasCondition);
            this.out.writeSymbol(errorVar, !hasCondition);
            if (!hasCondition && typeRelation != null) {
                this.out.beginComment();
                typeRelation.visit(this);
                this.out.endComment();
            }
            this.out.writeSymbol(aCatch.getRParen(), !hasCondition);
            if (hasCondition || !isLast) {
                this.out.writeToken("{");
            }
        } else {
            this.out.writeToken("else");
        }
        if (hasCondition) {
            this.out.writeToken("if(" + this.builtInIdentifierCode("is"));
            this.out.writeSymbol(aCatch.getLParen());
            this.out.writeSymbolWhitespace(localErrorVar);
            this.out.writeSymbolToken(errorVar);
            this.out.writeSymbolWhitespace(typeRelation.getSymRelation());
            this.out.writeToken(",");
            Ide typeIde = typeRelation.getType().getIde();
            this.out.writeSymbolWhitespace(typeIde.getIde());
            this.out.writeToken(this.compilationUnitAccessCode(typeIde.getDeclaration()));
            this.out.writeSymbol(aCatch.getRParen());
            this.out.writeToken(")");
        }
        if (!localErrorVar.getText().equals(errorVar.getText())) {
            this.addBlockStartCodeGenerator(aCatch.getBlock(), new VarCodeGenerator(localErrorVar, errorVar));
        }
        aCatch.getBlock().visit(this);
        if (isLast) {
            if (hasCondition) {
                this.out.writeToken("else throw");
                this.out.writeSymbolToken(errorVar);
                this.out.writeToken(";");
            }
            if (!isFirst || hasCondition) {
                this.out.writeToken("}");
            }
        }
    }

    abstract String compilationUnitAccessCode(IdeDeclaration var1);

    @Override
    public void visitForInStatement(ForInStatement forInStatement) throws IOException {
        this.out.writeSymbol(forInStatement.getSymKeyword());
        this.writeOptSymbol(forInStatement.getSymEach());
        this.out.writeSymbol(forInStatement.getLParen());
        this.visitIfNotNull(forInStatement.getDecl());
        this.visitIfNotNull(forInStatement.getLValue());
        this.out.writeSymbol(forInStatement.getSymIn());
        forInStatement.getExpr().visit(this);
        this.out.writeSymbol(forInStatement.getRParen());
        forInStatement.getBody().visit(this);
    }

    @Override
    public void visitWhileStatement(WhileStatement whileStatement) throws IOException {
        this.out.writeSymbol(whileStatement.getSymKeyword());
        this.visitIfNotNull(whileStatement.getOptCond());
        whileStatement.getBody().visit(this);
    }

    @Override
    public void visitForStatement(ForStatement forStatement) throws IOException {
        this.out.writeSymbol(forStatement.getSymKeyword());
        this.out.writeSymbol(forStatement.getLParen());
        this.visitIfNotNull(forStatement.getForInit());
        this.out.writeSymbol(forStatement.getSymSemicolon1());
        this.visitIfNotNull(forStatement.getOptCond());
        this.out.writeSymbol(forStatement.getSymSemicolon2());
        this.visitIfNotNull(forStatement.getOptStep());
        this.out.writeSymbol(forStatement.getRParen());
        forStatement.getBody().visit(this);
    }

    @Override
    public void visitDoStatement(DoStatement doStatement) throws IOException {
        this.out.writeSymbol(doStatement.getSymKeyword());
        doStatement.getBody().visit(this);
        this.out.writeSymbol(doStatement.getSymWhile());
        doStatement.getOptCond().visit(this);
        this.out.writeSymbol(doStatement.getSymSemicolon());
    }

    @Override
    public void visitSwitchStatement(SwitchStatement switchStatement) throws IOException {
        this.out.writeSymbol(switchStatement.getSymKeyword());
        switchStatement.getCond().visit(this);
        switchStatement.getBlock().visit(this);
    }

    @Override
    public void visitBreakStatement(BreakStatement breakStatement) throws IOException {
        this.out.writeSymbol(breakStatement.getSymKeyword());
        this.visitIfNotNull(breakStatement.getOptStatement());
        this.visitIfNotNull(breakStatement.getOptLabel());
        this.writeOptSymbol(breakStatement.getOptSymSemicolon());
    }

    @Override
    public void visitEmptyStatement(EmptyStatement emptyStatement) throws IOException {
        this.visitSemicolonTerminatedStatement(emptyStatement);
    }

    @Override
    public void visitEmptyDeclaration(EmptyDeclaration emptyDeclaration) throws IOException {
        this.out.writeSymbolWhitespace(emptyDeclaration.getSymSemicolon());
    }

    @Override
    public void visitSemicolonTerminatedStatement(SemicolonTerminatedStatement semicolonTerminatedStatement) throws IOException {
        this.visitIfNotNull(semicolonTerminatedStatement.getOptStatement());
        this.writeOptSymbol(semicolonTerminatedStatement.getOptSymSemicolon());
    }

    @Override
    public void visitContinueStatement(ContinueStatement continueStatement) throws IOException {
        this.out.writeSymbol(continueStatement.getSymKeyword());
        this.visitIfNotNull(continueStatement.getOptStatement());
        this.visitIfNotNull(continueStatement.getOptLabel());
        this.writeOptSymbol(continueStatement.getOptSymSemicolon());
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) throws IOException {
        this.out.writeSymbol(throwStatement.getSymKeyword());
        this.visitIfNotNull(throwStatement.getOptStatement());
        this.writeOptSymbol(throwStatement.getOptSymSemicolon());
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) throws IOException {
        this.out.writeSymbol(returnStatement.getSymKeyword());
        if (returnStatement.getOptStatement() != null) {
            returnStatement.getOptStatement().visit(this);
        } else {
            FunctionDeclaration functionDeclaration = CodeGeneratorBase.findFunctionDeclaration(returnStatement);
            if (functionDeclaration != null && "this".equals(functionDeclaration.getFun().getReturnTypeFromAnnotation())) {
                this.out.writeToken("this");
            }
        }
        this.writeOptSymbol(returnStatement.getOptSymSemicolon());
    }

    @Override
    public void visitParameter(Parameter parameter) throws IOException {
        this.writeOptSymbol(parameter.getOptSymRest());
        parameter.getIde().visit(this);
        this.visitParameterTypeRelation(parameter);
        this.visitIfNotNull(parameter.getOptInitializer());
    }

    void visitParameterTypeRelation(Parameter parameter) throws IOException {
        TypeRelation typeRelation = parameter.getOptTypeRelation();
        if (typeRelation != null && !typeRelation.getSymRelation().isVirtual()) {
            typeRelation.visit(this);
        }
    }

    void visitDeclarationAnnotationsAndModifiers(IdeDeclaration declaration) throws IOException {
        this.visitAll(declaration.getAnnotations());
        this.writeModifiers(declaration);
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration variableDeclaration) throws IOException {
        this.visitDeclarationAnnotationsAndModifiers(variableDeclaration);
        this.writeVarOrConst(variableDeclaration);
        this.visitVariableDeclarationBase(variableDeclaration);
        this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
        this.writeOptSymbol(variableDeclaration.getOptSymSemicolon());
    }

    void writeVarOrConst(VariableDeclaration variableDeclaration) throws IOException {
        this.writeOptSymbol(variableDeclaration.getOptSymConstOrVar());
    }

    void visitVariableDeclarationBase(VariableDeclaration variableDeclaration) throws IOException {
        variableDeclaration.getIde().visit(this);
        this.visitIfNotNull(variableDeclaration.getOptTypeRelation());
        this.visitIfNotNull(variableDeclaration.getOptInitializer());
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) throws IOException {
        this.visitDeclarationAnnotationsAndModifiers(functionDeclaration);
        this.out.writeSymbol(functionDeclaration.getSymbol());
        this.writeOptSymbol(functionDeclaration.getSymGetOrSet());
        functionDeclaration.getIde().visit(this);
        this.generateFunctionExprSignature(functionDeclaration.getFun());
        this.visitIfNotNull(functionDeclaration.getFun().getBody());
        this.writeOptSymbol(functionDeclaration.getOptSymSemicolon());
    }

    void generateFunctionExprSignature(FunctionExpr functionExpr) throws IOException {
        this.out.writeSymbol(functionExpr.getLParen());
        this.visitIfNotNull(functionExpr.getParams());
        this.out.writeSymbol(functionExpr.getRParen());
        this.generateFunctionExprReturnTypeRelation(functionExpr);
    }

    void generateFunctionExprReturnTypeRelation(FunctionExpr functionExpr) throws IOException {
        this.visitIfNotNull(functionExpr.getOptTypeRelation());
    }

    @Override
    public void visitClassDeclaration(ClassDeclaration classDeclaration) throws IOException {
        this.visitDeclarationAnnotationsAndModifiers(classDeclaration);
        this.out.writeSymbol(classDeclaration.getSymClass());
        classDeclaration.getIde().visit(this);
        this.visitIfNotNull(classDeclaration.getOptExtends());
        this.visitIfNotNull(classDeclaration.getOptImplements());
        classDeclaration.getBody().visit(this);
    }

    @Override
    public void visitNamespaceDeclaration(NamespaceDeclaration namespaceDeclaration) throws IOException {
        this.visitDeclarationAnnotationsAndModifiers(namespaceDeclaration);
        this.out.writeSymbol(namespaceDeclaration.getSymNamespace());
        this.visitIfNotNull(namespaceDeclaration.getOptInitializer());
        this.writeOptSymbol(namespaceDeclaration.getOptSymSemicolon());
    }

    @Override
    public void visitPackageDeclaration(PackageDeclaration packageDeclaration) throws IOException {
        this.out.writeSymbol(packageDeclaration.getSymPackage());
        this.visitIfNotNull(packageDeclaration.getIde());
    }

    @Override
    public void visitSuperConstructorCallStatement(SuperConstructorCallStatement superConstructorCallStatement) throws IOException {
        this.out.writeSymbol(superConstructorCallStatement.getSymbol());
        superConstructorCallStatement.getArgs().visit(this);
        this.writeOptSymbol(superConstructorCallStatement.getSymSemicolon());
    }

    @Override
    public void visitAnnotation(Annotation annotation) throws IOException {
        this.out.writeSymbol(annotation.getLeftBracket());
        annotation.getIde().visit(this);
        this.writeOptSymbol(annotation.getOptLeftParen());
        this.visitIfNotNull(annotation.getOptAnnotationParameters());
        this.writeOptSymbol(annotation.getOptRightParen());
        this.out.writeSymbol(annotation.getRightBracket());
    }

    @Override
    public void visitUseNamespaceDirective(UseNamespaceDirective useNamespaceDirective) throws IOException {
        this.out.writeSymbol(useNamespaceDirective.getUseKeyword());
        this.out.writeSymbol(useNamespaceDirective.getNamespaceKeyword());
        useNamespaceDirective.getNamespace().visit(this);
        this.out.writeSymbol(useNamespaceDirective.getSymSemicolon());
    }

    @Override
    public void visitImportDirective(ImportDirective importDirective) throws IOException {
        if (importDirective.isExplicit()) {
            this.out.writeSymbol(importDirective.getImportKeyword());
            importDirective.getIde().visit(this);
            this.out.writeSymbol(importDirective.getSymSemicolon());
        }
    }

    private static class VarCodeGenerator
    implements CodeGenerator {
        private final JooSymbol localErrorVar;
        private final JooSymbol errorVar;

        public VarCodeGenerator(JooSymbol localErrorVar, JooSymbol errorVar) {
            this.localErrorVar = localErrorVar;
            this.errorVar = errorVar;
        }

        @Override
        public void generate(JsWriter out, boolean first) throws IOException {
            out.writeToken("var");
            out.writeSymbolToken(this.localErrorVar);
            out.writeToken("=");
            out.writeSymbolToken(this.errorVar);
            out.writeToken(";");
        }
    }
}

