/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.types.ExpressionType;
import net.jangaroo.utils.AS3Type;

public class ApplyExpr
extends Expr {
    public static final String TYPE_CHECK_OBJECT_LITERAL_FUNCTION_NAME = "__typeCheckObjectLiteral__";
    private Expr fun;
    private ParenthesizedExpr<CommaSeparatedList<Expr>> args;
    private boolean insideNewExpr = false;
    private static final Set<String> COERCE_FUNCTION_NAMES = new HashSet<String>(Arrays.asList("Number", "String", "Boolean", "int", "uint", "Date", "Object", "Array", "RegExp", "XML"));
    private Scope scope;
    private Map<Expr, ClassDeclaration> argToPropertiesClass = new HashMap<Expr, ClassDeclaration>();

    public ApplyExpr(Expr fun, JooSymbol lParen, CommaSeparatedList<Expr> args, JooSymbol rParen) {
        this.fun = fun;
        this.args = new ParenthesizedExpr<CommaSeparatedList<Expr>>(lParen, args, rParen);
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.fun, this.args);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitApplyExpr(this);
    }

    public boolean isInsideNewExpr() {
        return this.insideNewExpr;
    }

    public void setInsideNewExpr(boolean insideNewExpr) {
        this.insideNewExpr = insideNewExpr;
    }

    @Override
    public void scope(Scope scope) {
        this.scope = scope;
        this.getFun().scope(scope);
        this.getArgs().scope(scope);
    }

    public boolean isTypeCast() {
        return this.getFun() instanceof IdeExpr && !this.isInsideNewExpr() && this.isNonCoercingType((IdeExpr)this.getFun()) && this.hasExactlyOneArgument();
    }

    public boolean isTypeCheckObjectLiteralFunctionCall() {
        return this.getFun() instanceof IdeExpr && TYPE_CHECK_OBJECT_LITERAL_FUNCTION_NAME.equals(((IdeExpr)this.getFun()).getIde().getQualifiedNameStr());
    }

    public boolean isAssert() {
        return this.getFun() instanceof IdeExpr && "assert".equals(((IdeExpr)this.getFun()).getIde().getQualifiedNameStr());
    }

    private boolean hasExactlyOneArgument() {
        CommaSeparatedList<Expr> expr;
        return this.getArgs() != null && (expr = this.getArgs().getExpr()) != null && expr.getHead() != null && expr.getTail() == null;
    }

    private boolean isNonCoercingType(IdeExpr fun) {
        return fun.getType() != null && fun.getType().getAS3Type() == AS3Type.CLASS && !ApplyExpr.isCoerceFunction(fun.getIde().getQualifiedNameStr());
    }

    public static boolean isCoerceFunction(String qualifiedName) {
        return COERCE_FUNCTION_NAMES.contains(qualifiedName);
    }

    @Override
    public void analyze(AstNode parentNode) {
        boolean isTypeCast;
        super.analyze(parentNode);
        this.getFun().analyze(this);
        if (this.getArgs() != null) {
            this.mapPropertiesClassReferences();
            this.getArgs().analyze(this);
        }
        if (isTypeCast = this.isTypeCast()) {
            this.scope.getCompilationUnit().addBuiltInIdentifierUsage("cast");
        } else if (this.isAssert()) {
            this.scope.getCompilationUnit().addBuiltInIdentifierUsage("assert");
        } else if (this.isTypeCheckObjectLiteralFunctionCall()) {
            this.scope.getCompilationUnit().addBuiltInIdentifierUsage("_");
            this.getArgs().getExpr().getHead().getType().getTypeParameter().markAsConfigTypeIfPossible();
        }
        ExpressionType type = this.getFun().getType();
        if (type != null && (type.getAS3Type() == AS3Type.FUNCTION || type.getAS3Type() == AS3Type.CLASS)) {
            ExpressionType classType = type.getTypeParameter();
            if (classType != null && isTypeCast && this.getArgs().getExpr().getHead() instanceof ObjectLiteral) {
                classType.markAsConfigTypeIfPossible();
            }
            this.setType(classType);
        }
    }

    public FunctionDeclaration resolveFunction() {
        IdeDeclaration declaration;
        DotExpr dotExpr;
        ExpressionType type;
        Expr fun = this.getFun();
        boolean isNew = false;
        if (fun instanceof NewExpr) {
            fun = ((NewExpr)fun).getApplyConstructor();
            isNew = true;
        }
        if (fun instanceof IdeExpr && (fun = ((IdeExpr)fun).getNormalizedExpr()) instanceof IdeExpr) {
            IdeDeclaration declaration2 = ((IdeExpr)fun).getIde().getDeclaration(false);
            if (isNew) {
                return declaration2 instanceof ClassDeclaration ? ((ClassDeclaration)declaration2).getConstructor() : null;
            }
            if (declaration2 instanceof FunctionDeclaration) {
                return (FunctionDeclaration)declaration2;
            }
        }
        if (fun instanceof DotExpr && (type = (dotExpr = (DotExpr)fun).getArg().getType()) != null && (declaration = type.resolvePropertyDeclaration(dotExpr.getIde().getName())) instanceof FunctionDeclaration) {
            return (FunctionDeclaration)declaration;
        }
        return null;
    }

    private void mapPropertiesClassReferences() {
        FunctionDeclaration functionDeclaration = this.resolveFunction();
        if (functionDeclaration != null) {
            Collection propertyClassReferenceParameterNames = functionDeclaration.getAnnotations("Parameter").stream().map(parameterAnnotation -> parameterAnnotation.getPropertiesByName()).filter(parameterProperties -> "PropertiesClass".equals(parameterProperties.get("coerceTo"))).map(parameterProperties -> (String)parameterProperties.get(null)).collect(Collectors.toList());
            Parameters params = functionDeclaration.getParams();
            for (CommaSeparatedList<Expr> args = this.args.getExpr(); params != null && args != null; params = params.getTail(), args = args.getTail()) {
                Expr arg;
                if (!propertyClassReferenceParameterNames.contains(((Parameter)params.getHead()).getName()) || !((arg = args.getHead()) instanceof LiteralExpr)) continue;
                String resourceBundleName = (String)((LiteralExpr)arg).getValue().getJooValue();
                String propertiesClassName = resourceBundleName + "_properties";
                CompilationUnit propertiesClass = this.scope.getCompiler().getCompilationUnit(propertiesClassName);
                if (propertiesClass == null) {
                    this.scope.getCompiler().getLog().error((FilePosition)arg.getSymbol(), String.format("Properties class '%s' corresponding to resource bundle '%s' not found.", propertiesClassName, resourceBundleName));
                    continue;
                }
                this.scope.getCompilationUnit().addDependency(propertiesClass, true);
                this.argToPropertiesClass.put(arg, (ClassDeclaration)propertiesClass.getPrimaryDeclaration());
            }
        }
    }

    public ClassDeclaration getPropertiesClass(Expr arg) {
        return this.argToPropertiesClass.get(arg);
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getFun().getSymbol();
    }

    public Expr getFun() {
        return this.fun;
    }

    public ParenthesizedExpr<CommaSeparatedList<Expr>> getArgs() {
        return this.args;
    }
}

