/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.types;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeWithTypeParam;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.utils.AS3Type;

public class ExpressionType {
    private Type type;
    private AS3Type as3Type;
    private TypeDeclaration declaration;
    private ExpressionType typeParameter;
    private boolean isConfigType;

    public ExpressionType(@Nonnull Type type) {
        this.type = type;
    }

    public ExpressionType(@Nonnull TypeDeclaration declaration) {
        this(declaration, null);
    }

    public ExpressionType(@Nonnull TypeDeclaration declaration, @Nullable ExpressionType typeParameter) {
        this.declaration = declaration;
        this.typeParameter = typeParameter;
    }

    public boolean isConfigType() {
        return this.isConfigType;
    }

    public void markAsConfigTypeIfPossible() {
        if (this.getDeclaration() instanceof ClassDeclaration && ((ClassDeclaration)this.getDeclaration()).hasConfigClass()) {
            this.isConfigType = true;
        }
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    public ExpressionType getEvalType() {
        return this;
    }

    @Nonnull
    public AS3Type getAS3Type() {
        if (this.as3Type == null) {
            String typeQName = this.getDeclaration().getQualifiedNameStr();
            this.as3Type = AS3Type.typeByName((String)typeQName);
            if (this.as3Type == null) {
                this.as3Type = AS3Type.OBJECT;
            }
        }
        return this.as3Type;
    }

    @Nonnull
    public TypeDeclaration getDeclaration() {
        if (this.declaration == null) {
            this.declaration = this.type.getDeclaration();
        }
        return this.declaration;
    }

    @Nullable
    public ExpressionType getTypeParameter() {
        if (this.typeParameter == null && this.type != null && this.type.getIde() instanceof IdeWithTypeParam) {
            this.typeParameter = new ExpressionType(((IdeWithTypeParam)this.type.getIde()).getType());
        }
        return this.typeParameter;
    }

    public boolean isObject() {
        return this.getAS3Type() == AS3Type.OBJECT && this.getDeclaration() instanceof ClassDeclaration && ((ClassDeclaration)this.getDeclaration()).isObject();
    }

    public boolean isArrayLike() {
        return this.getAS3Type() == AS3Type.ARRAY || this.getAS3Type() == AS3Type.VECTOR;
    }

    public IdeDeclaration resolvePropertyDeclaration(String memberName) {
        if (this.getAS3Type() == AS3Type.CLASS && this.getTypeParameter() != null) {
            return this.getTypeParameter().getDeclaration().getStaticMemberDeclaration(memberName);
        }
        return this.getDeclaration().resolvePropertyDeclaration(memberName);
    }

    public boolean isAssignableTo(@Nonnull ExpressionType toCheck) {
        AS3Type expectedAS3Type = toCheck.getAS3Type();
        if (AS3Type.ANY.equals((Object)this.getAS3Type()) || AS3Type.BOOLEAN.equals((Object)this.getAS3Type()) || AS3Type.ANY.equals((Object)expectedAS3Type) || AS3Type.BOOLEAN.equals((Object)expectedAS3Type) || toCheck.isObject()) {
            return true;
        }
        if (!this.getAS3Type().equals((Object)AS3Type.OBJECT) && this.getAS3Type().equals((Object)expectedAS3Type)) {
            return true;
        }
        if (ExpressionType.isNumber(expectedAS3Type) && ExpressionType.isNumber(this.getAS3Type())) {
            return true;
        }
        if (AS3Type.VECTOR.equals((Object)expectedAS3Type)) {
            return true;
        }
        if (!(toCheck.getDeclaration() instanceof ClassDeclaration) || !(this.getDeclaration() instanceof ClassDeclaration)) {
            return this.getAS3Type().equals((Object)expectedAS3Type);
        }
        ClassDeclaration currentDeclaration = (ClassDeclaration)this.getDeclaration();
        if (AS3Type.CLASS.equals((Object)this.getAS3Type()) && this.getTypeParameter() != null) {
            TypeDeclaration typeDeclaration = this.getTypeParameter().getDeclaration();
            if (typeDeclaration instanceof ClassDeclaration) {
                currentDeclaration = (ClassDeclaration)typeDeclaration;
            } else {
                return true;
            }
        }
        return currentDeclaration.isAssignableTo((ClassDeclaration)toCheck.getDeclaration());
    }

    public boolean equals(Object o) {
        TypeDeclaration declaration = this.getDeclaration();
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionType that = (ExpressionType)o;
        return declaration.equals(that.getDeclaration()) && (this.getTypeParameter() != null ? this.getTypeParameter().equals(that.getTypeParameter()) : that.typeParameter == null);
    }

    public int hashCode() {
        int result = this.getDeclaration().hashCode();
        result = 31 * result + (this.getTypeParameter() != null ? this.getTypeParameter().hashCode() : 0);
        return result;
    }

    public String toString() {
        String name = this.getDeclaration().getQualifiedNameStr();
        ExpressionType typeParameter = this.getTypeParameter();
        if (typeParameter != null) {
            name = name + "<" + typeParameter.toString() + ">";
        }
        return name;
    }

    public static boolean isNumber(AS3Type type) {
        return AS3Type.NUMBER.equals((Object)type) || AS3Type.INT.equals((Object)type) || AS3Type.UINT.equals((Object)type);
    }

    public static String toString(ExpressionType type) {
        return type == null ? "*" : type.toString();
    }
}

