/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.DocumentedModel;
import net.jangaroo.jooc.model.ModelVisitor;

public class AnnotationModel
extends DocumentedModel {
    private List<AnnotationPropertyModel> properties = new ArrayList<AnnotationPropertyModel>();

    public AnnotationModel() {
    }

    public AnnotationModel(String name) {
        super(name);
    }

    public AnnotationModel(String name, AnnotationPropertyModel ... properties) {
        super(name);
        this.properties = new ArrayList<AnnotationPropertyModel>(Arrays.asList(properties));
    }

    public List<AnnotationPropertyModel> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public Map<String, AnnotationPropertyModel> getPropertiesByName() {
        LinkedHashMap<String, AnnotationPropertyModel> result = new LinkedHashMap<String, AnnotationPropertyModel>();
        for (AnnotationPropertyModel property : this.properties) {
            result.put(property.getName(), property);
        }
        return Collections.unmodifiableMap(result);
    }

    public void setProperties(List<AnnotationPropertyModel> properties) {
        this.properties = properties;
    }

    public void addProperty(AnnotationPropertyModel annotationProperty) {
        this.properties.add(annotationProperty);
    }

    @Override
    public void visit(ModelVisitor visitor) {
        visitor.visitAnnotation(this);
    }
}

