/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.jangaroo.jooc.CompilationUnitRegistry;
import net.jangaroo.jooc.CompilationUnitResolver;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.TransitiveAstVisitor;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.ActionScriptCodeGeneratingModelVisitor;
import net.jangaroo.jooc.backend.ApiModelGenerator;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.EmbeddedAssetResolver;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.backend.JsModuleResolver;
import net.jangaroo.jooc.backend.TypeScriptCodeGenerator;
import net.jangaroo.jooc.backend.TypeScriptModuleResolver;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.JoocOptions;
import net.jangaroo.jooc.util.FilePosition;
import net.jangaroo.properties.PropcHelper;
import net.jangaroo.utils.CompilerUtils;
import org.apache.tools.ant.util.FileUtils;

public class SingleFileCompilationUnitSinkFactory
extends AbstractCompilationUnitSinkFactory {
    private final CompilationUnitRegistry compilationUnitRegistry;
    private final String suffix;
    private final String nativeSuffix;
    private final boolean generateApi;
    private final CompilationUnitResolver compilationUnitModelResolver;

    public SingleFileCompilationUnitSinkFactory(JoocOptions options, File destinationDir, boolean generateApi, String suffix, String nativeSuffix, CompilationUnitResolver compilationUnitModelResolver, CompilationUnitRegistry compilationUnitRegistry) {
        super(options, destinationDir);
        this.suffix = suffix;
        this.nativeSuffix = nativeSuffix;
        this.generateApi = generateApi;
        this.compilationUnitModelResolver = compilationUnitModelResolver;
        this.compilationUnitRegistry = compilationUnitRegistry;
    }

    private File getOutputFile(File sourceFile, IdeDeclaration primaryDeclaration) {
        String qName;
        File outputDirectory = this.getOutputDir();
        if (outputDirectory == null) {
            outputDirectory = sourceFile.getAbsoluteFile().getParentFile();
            return new File(outputDirectory, CompilerUtils.qNameFromFile((File)outputDirectory, (File)sourceFile) + this.suffix);
        }
        String string = qName = this.generateApi ? primaryDeclaration.getQualifiedNameStr() : primaryDeclaration.getExtNamespaceRelativeTargetQualifiedNameStr();
        if (!this.generateApi && !this.options.isMigrateToTypeScript() && qName.endsWith("_properties")) {
            Locale locale = PropcHelper.computeLocale(qName);
            File propertiesOutputDirectory = ((JoocConfiguration)this.options).getLocalizedOutputDirectory();
            if (propertiesOutputDirectory == null) {
                propertiesOutputDirectory = new File(((JoocConfiguration)this.options).getOutputDirectory().getParentFile(), "locale");
            }
            outputDirectory = new File(propertiesOutputDirectory, PropcHelper.localeOrDefaultLocaleString(locale));
            if (locale != null) {
                qName = PropcHelper.computeBaseClassName(qName);
            }
        }
        String suffix = this.nativeSuffix != null && (primaryDeclaration.isNative() || primaryDeclaration.getAnnotation("Native") != null) ? this.nativeSuffix : this.suffix;
        return CompilerUtils.fileFromQName((String)qName, (File)outputDirectory, (String)suffix);
    }

    @Override
    public CompilationUnitSink createSink(PackageDeclaration packageDeclaration, IdeDeclaration primaryDeclaration, File sourceFile, boolean verbose) {
        File outFile = this.getOutputFile(sourceFile, primaryDeclaration);
        this.createOutputDirs(outFile);
        return compilationUnit -> {
            block11: {
                if (verbose) {
                    System.out.println("writing file: '" + outFile.getAbsolutePath() + "'");
                }
                try {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8);
                    try {
                        if (this.generateApi) {
                            ApiModelGenerator apiModelGenerator = new ApiModelGenerator(SingleFileCompilationUnitSinkFactory.isExcludeClassByDefault(this.getOptions()));
                            apiModelGenerator.generateModel(compilationUnit).visit(new ActionScriptCodeGeneratingModelVisitor(writer));
                            break block11;
                        }
                        JsWriter out = new JsWriter(writer);
                        String codeSuffix = "";
                        try {
                            out.setOptions(this.getOptions());
                            compilationUnit.visit(new TransitiveAstVisitor(new EmbeddedAssetResolver(compilationUnit, this.compilationUnitRegistry)));
                            compilationUnit.visit(".js".equals(this.suffix) ? new JsCodeGenerator(out, this.compilationUnitModelResolver, new JsModuleResolver(this.compilationUnitModelResolver)) : new TypeScriptCodeGenerator(new TypeScriptModuleResolver(this.compilationUnitModelResolver), out, this.compilationUnitModelResolver));
                            if (this.options.isGenerateSourceMaps()) {
                                codeSuffix = this.generateSourceMap(out, outFile);
                            }
                        }
                        finally {
                            out.close(codeSuffix);
                        }
                        if (this.options.isGenerateSourceMaps()) {
                            FileUtils.getFileUtils().copyFile(sourceFile, new File(outFile.getParentFile(), sourceFile.getName()));
                        }
                    }
                    catch (IOException e) {
                        outFile.delete();
                        throw JangarooParser.error("error writing file: '" + outFile.getAbsolutePath() + "'", outFile, (Throwable)e);
                    }
                }
                catch (IOException e) {
                    throw JangarooParser.error("cannot open output file for writing: '" + outFile.getAbsolutePath() + "'", outFile, (Throwable)e);
                }
            }
            return outFile;
        };
    }

    private String generateSourceMap(JsWriter out, File outFile) throws IOException {
        SourceMapGenerator sourceMapGenerator = SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3);
        sourceMapGenerator.validate(true);
        for (JsWriter.SymbolToOutputFilePosition entry : out.getSourceMappings()) {
            String sourceFilename = entry.getSymbol().getFileName();
            sourceFilename = sourceFilename.substring(sourceFilename.lastIndexOf(File.separatorChar) + 1);
            sourceMapGenerator.addMapping(sourceFilename, entry.getSymbol().getText(), this.googleFilePosition(entry.getSourceFilePosition()), this.googleFilePosition(entry.getOutputFileStartPosition()), this.googleFilePosition(entry.getOutputFileEndPosition()));
        }
        String sourceMapFilename = outFile.getAbsolutePath() + ".map";
        try (FileWriter sourceMapWriter = new FileWriter(sourceMapFilename);){
            sourceMapGenerator.appendTo((Appendable)sourceMapWriter, outFile.getName());
        }
        return "//# sourceMappingURL=" + outFile.getName() + ".map";
    }

    private com.google.debugging.sourcemap.FilePosition googleFilePosition(FilePosition position) {
        return new com.google.debugging.sourcemap.FilePosition(position.getLine(), position.getColumn());
    }

    private static boolean isExcludeClassByDefault(JoocOptions options) {
        try {
            return options.isExcludeClassByDefault();
        }
        catch (IncompatibleClassChangeError e) {
            return false;
        }
    }
}

