/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.CompilationUnitResolver;
import net.jangaroo.jooc.Debug;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.SyntacticKeywords;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.ForInStatement;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.IdeWithTypeParam;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NamespaceDeclaration;
import net.jangaroo.jooc.ast.NamespacedIde;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.PropertyDeclaration;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.Typed;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.UseNamespaceDirective;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.ast.VectorLiteral;
import net.jangaroo.jooc.backend.CodeGeneratorBase;
import net.jangaroo.jooc.backend.EmbeddedAssetResolver;
import net.jangaroo.jooc.backend.JsModuleResolver;
import net.jangaroo.jooc.backend.ModuleResolverBase;
import net.jangaroo.jooc.config.DebugMode;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.json.JsonArray;
import net.jangaroo.jooc.json.JsonObject;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.jooc.types.ExpressionType;
import net.jangaroo.jooc.util.MessageFormat;
import net.jangaroo.properties.PropcHelper;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;

public class JsCodeGenerator
extends CodeGeneratorBase {
    private static final JooSymbol SYM_VAR = new JooSymbol(38, "var");
    private static final JooSymbol SYM_SEMICOLON = new JooSymbol(71, ";");
    private static final JooSymbol SYM_LBRACE = new JooSymbol(90, "{");
    private static final JooSymbol SYM_RBRACE = new JooSymbol(91, "}");
    public static final Set<String> PRIMITIVES = new HashSet<String>(4);
    public static final List<String> ANNOTATIONS_TO_TRIGGER_AT_RUNTIME = Arrays.asList("SWF", "ExtConfig");
    public static final String DEFAULT_ANNOTATION_PARAMETER_NAME = "";
    public static final String INIT_STATICS = "__initStatics__";
    private final JsModuleResolver jsModuleResolver;
    private boolean expressionMode = false;
    private Map<String, String> imports = new HashMap<String, String>();
    private ClassDefinitionBuilder primaryClassDefinitionBuilder = new ClassDefinitionBuilder();
    private int staticCodeCounter = 0;
    private ClassDefinitionBuilder secondaryClassDefinitionBuilder;
    private CompilationUnit compilationUnit;
    private String factory;
    private final MessageFormat $NAME_EQUALS_ARGUMENTS_SLICE_$INDEX = new MessageFormat("{0}=Array.prototype.slice.call(arguments{1,choice,0#|0<,{1}});");
    private final CodeGenerator ARGUMENT_TO_ARRAY_CODE_GENERATOR = new CodeGenerator(){

        @Override
        public void generate(JsWriter out, boolean first) throws IOException {
            JsCodeGenerator.this.generateToArrayCode("arguments", 0);
        }
    };
    private final MessageFormat IF_ARGUMENT_LENGTH_LTE_$N = new MessageFormat("if(arguments.length<={0})");
    private final MessageFormat SWITCH_$INDEX = new MessageFormat("switch({0,choice,0#arguments.length|0<Math.max(arguments.length,{0})})");
    private final MessageFormat CASE_$N = new MessageFormat("case {0}:");
    private final MessageFormat ASSIGN_DEFAULT_IF_PARAMETER_IS_UNDEFINED = new MessageFormat("if ({0} === void 0) '{' ");
    private static final CodeGenerator ALIAS_THIS_CODE_GENERATOR;

    public static boolean generatesCode(IdeDeclaration primaryDeclaration) {
        return primaryDeclaration.getAnnotation("Native") == null && !primaryDeclaration.isNative() && primaryDeclaration.getAnnotation("Mixin") == null;
    }

    private void generateToArrayCode(String paramName, int paramIndex) throws IOException {
        if (!"arguments".equals(paramName)) {
            this.out.writeToken("var");
        }
        this.out.writeToken(this.$NAME_EQUALS_ARGUMENTS_SLICE_$INDEX.format(paramName, paramIndex));
    }

    public JsCodeGenerator(JsWriter out, CompilationUnitResolver compilationUnitModelResolver, JsModuleResolver jsModuleResolver) {
        super(out, compilationUnitModelResolver);
        this.jsModuleResolver = jsModuleResolver;
    }

    private Map<String, PropertyDefinition> membersOrStaticMembers(Declaration memberDeclaration) {
        ClassDefinitionBuilder classDefinitionBuilder = this.getClassDefinitionBuilder(memberDeclaration);
        return memberDeclaration.isStatic() ? classDefinitionBuilder.staticMembers : classDefinitionBuilder.members;
    }

    private ClassDefinitionBuilder getClassDefinitionBuilder(Declaration memberDeclaration) {
        return memberDeclaration.getClassDeclaration() == null || memberDeclaration.getClassDeclaration().isPrimaryDeclaration() ? this.primaryClassDefinitionBuilder : this.secondaryClassDefinitionBuilder;
    }

    @Override
    String compilationUnitAccessCode(IdeDeclaration primaryDeclaration) {
        CompilationUnit otherUnit = primaryDeclaration.getCompilationUnit();
        if (otherUnit == this.compilationUnit) {
            return primaryDeclaration.getName();
        }
        primaryDeclaration = CompilationUnit.mapMixinInterface(otherUnit).getPrimaryDeclaration();
        String primaryDeclarationName = this.imports.get(primaryDeclaration.getQualifiedNameStr());
        Debug.assertTrue(primaryDeclarationName != null, "QName not found in imports: " + primaryDeclaration.getQualifiedNameStr());
        return primaryDeclarationName;
    }

    @Override
    public void visitDotExpr(DotExpr dotExpr) throws IOException {
        ExpressionType type;
        IdeDeclaration memberDeclaration = null;
        Expr arg = dotExpr.getArg();
        JooSymbol symDot = dotExpr.getOp();
        Ide ide = dotExpr.getIde();
        if (arg instanceof IdeExpr) {
            arg = ((IdeExpr)arg).getNormalizedExpr();
        }
        if ((type = arg.getType()) != null) {
            memberDeclaration = type.resolvePropertyDeclaration(ide.getName());
        }
        String memberName = ide.getName();
        if (memberDeclaration != null && memberDeclaration.isPrivateStatic()) {
            if (arg instanceof IdeExpr && arg.getSymbol().isVirtual()) {
                this.out.writeSymbolWhitespace(arg.getSymbol());
            } else {
                this.out.beginComment();
                arg.visit(this);
                this.out.writeSymbol(symDot);
                this.out.endComment();
            }
            memberName = memberName + "$static";
            if (memberDeclaration instanceof PropertyDeclaration || memberDeclaration instanceof FunctionDeclaration && ((FunctionDeclaration)memberDeclaration).isGetterOrSetter()) {
                memberName = "get$" + memberName + "()";
            }
            this.writeSymbolReplacement(ide.getIde(), memberName);
            return;
        }
        if (memberDeclaration != null) {
            Object nativeMemberName;
            Annotation nativeAnnotation = memberDeclaration.getAnnotation("Native");
            if (nativeAnnotation != null && (nativeMemberName = nativeAnnotation.getPropertiesByName().get(null)) instanceof String) {
                memberName = (String)nativeMemberName;
            }
            if (memberDeclaration.isPrivate()) {
                memberName = memberName + "$" + ide.getScope().getClassDeclaration().getQualifiedNameHash();
            }
        }
        String separatorToken = ".";
        String closingToken = DEFAULT_ANNOTATION_PARAMETER_NAME;
        if (ide.isBound()) {
            this.out.writeToken("AS3.bind(");
            separatorToken = ",";
            memberName = CompilerUtils.quote((String)memberName);
            closingToken = ")";
        } else if (memberDeclaration != null && !type.isConfigType() && !ide.isAssignmentLHS()) {
            TypedIdeDeclaration getter = this.findMemberWithBindableAnnotation(ide, MethodType.GET, memberDeclaration.getClassDeclaration());
            if (getter != null) {
                Expr normalizedArg = arg instanceof IdeExpr ? ((IdeExpr)arg).getNormalizedExpr() : arg;
                this.out.writeSymbolWhitespace(normalizedArg.getSymbol());
                this.out.writeToken("AS3.getBindable(");
                memberName = CompilerUtils.quote((String)getter.getName());
                separatorToken = ",";
                closingToken = ")";
                String bindableEvent = JsCodeGenerator.getBindableEventName(getter);
                if (bindableEvent != null && !"DUMMY".equals(bindableEvent)) {
                    closingToken = "," + CompilerUtils.quote((String)bindableEvent) + closingToken;
                }
            }
        } else if (memberName.startsWith("@")) {
            separatorToken = "[";
            memberName = CompilerUtils.quote((String)memberName);
            closingToken = "]";
        }
        arg.visit(this);
        this.writeSymbolReplacement(symDot, separatorToken);
        this.writeSymbolReplacement(ide.getIde(), memberName);
        if (!closingToken.isEmpty()) {
            this.out.writeToken(closingToken);
        }
    }

    @Override
    public void visitTypeRelation(TypeRelation typeRelation) throws IOException {
        this.out.beginCommentWriteSymbol(typeRelation.getSymRelation());
        typeRelation.getType().getIde().visit(this);
        this.out.endComment();
    }

    @Override
    public void visitExtends(Extends anExtends) throws IOException {
        this.out.writeSymbol(anExtends.getSymExtends());
        this.out.writeSymbol(anExtends.getSuperClass().getIde());
    }

    @Override
    public void visitCompilationUnit(CompilationUnit compilationUnit) throws IOException {
        IdeDeclaration primaryDeclaration = compilationUnit.getPrimaryDeclaration();
        boolean isClassDeclaration = primaryDeclaration instanceof ClassDeclaration;
        Object[] requires = this.collectDependencies(compilationUnit, isClassDeclaration ? Boolean.TRUE : null);
        Object[] uses = isClassDeclaration ? this.collectDependencies(compilationUnit, false) : new String[]{};
        PackageDeclaration packageDeclaration = compilationUnit.getPackageDeclaration();
        this.compilationUnit = compilationUnit;
        if (isClassDeclaration && JsCodeGenerator.isPropertiesClass(primaryDeclaration)) {
            this.renderPropertiesClass((ClassDeclaration)primaryDeclaration, (String[])uses);
            return;
        }
        this.out.beginComment();
        packageDeclaration.visit(this);
        this.out.writeSymbol(compilationUnit.getLBrace());
        this.visitAll(compilationUnit.getDirectives());
        this.out.endComment();
        primaryDeclaration.visit(this);
        this.out.beginComment();
        this.out.writeSymbol(compilationUnit.getRBrace());
        this.out.write("\n");
        this.out.write("\n============================================== Jangaroo part ==============================================");
        this.out.endComment();
        JsonObject classDefinition = this.createClassDefinition(primaryDeclaration, this.primaryClassDefinitionBuilder);
        if (requires.length > 0) {
            classDefinition.set("requires", new JsonArray(requires));
        }
        if (uses.length > 0) {
            classDefinition.set("uses", new JsonArray(uses));
        }
        this.out.write("\n    return " + classDefinition.toString(2, 4) + ";\n}");
        this.out.write(");\n");
    }

    private void renderPropertiesClass(ClassDeclaration classDeclaration, String[] uses) throws IOException {
        for (Annotation annotation : classDeclaration.getAnnotations()) {
            annotation.visit(this);
        }
        this.out.writeSymbolWhitespace(classDeclaration.getSymModifiers()[0]);
        this.out.write("Ext.define(");
        String propertiesClassName = classDeclaration.getTargetQualifiedNameStr();
        this.out.write(CompilerUtils.quote((String)propertiesClassName));
        this.out.write(", {");
        boolean isPropertiesSubclass = JsCodeGenerator.isPropertiesSubclass(classDeclaration);
        boolean startWithComma = false;
        if (isPropertiesSubclass) {
            this.out.write("\n  override: " + CompilerUtils.quote((String)PropcHelper.computeBaseClassName(propertiesClassName)));
            startWithComma = true;
        } else {
            String alternateClassName = JsCodeGenerator.getAlternateClassName(classDeclaration);
            if (alternateClassName != null) {
                this.out.write("\n  alternateClassName: " + CompilerUtils.quote((String)alternateClassName));
                startWithComma = true;
            }
        }
        if (uses.length > 0) {
            if (startWithComma) {
                this.out.write(",");
            } else {
                startWithComma = true;
            }
            this.out.write("\n  requires: " + new JsonArray(uses).toString(2, 2));
        }
        FunctionDeclaration constructorDeclaration = classDeclaration.getConstructor();
        this.renderPropertiesClassValues(this.getPropertiesClassAssignments(constructorDeclaration, true, false), true, !isPropertiesSubclass, startWithComma);
        List<AssignmentOpExpr> assignmentsWithReferences = this.getPropertiesClassAssignments(constructorDeclaration, false, true);
        if (!isPropertiesSubclass || !assignmentsWithReferences.isEmpty()) {
            this.out.write("\n}, function() {");
            if (!assignmentsWithReferences.isEmpty()) {
                this.out.write("\n  Ext.apply(this.prototype, {");
                this.renderPropertiesClassValues(assignmentsWithReferences, true, !isPropertiesSubclass, false);
                this.out.write("\n  });");
            }
            if (!isPropertiesSubclass) {
                this.out.write("\n  this.INSTANCE = new this();");
            }
        }
        this.out.write("\n});");
    }

    private JsonObject createClassDefinition(IdeDeclaration declaration, ClassDefinitionBuilder classDefinitionBuilder) throws IOException {
        JsonObject classDefinition;
        if (declaration instanceof ClassDeclaration && ((ClassDeclaration)declaration).isInterface()) {
            classDefinition = this.createInterfaceDefinition((ClassDeclaration)declaration);
        } else {
            if (declaration instanceof ClassDeclaration) {
                classDefinition = this.createClassDefinition((ClassDeclaration)declaration);
            } else {
                classDefinition = new JsonObject(new Object[0]);
                boolean isLazy = declaration.getAnnotation("Lazy") != null;
                classDefinition.set(isLazy ? "__lazyFactory__" : "__factory__", JsonObject.code(this.factory));
            }
            this.fillClassDefinition(classDefinition, classDefinitionBuilder);
        }
        return classDefinition;
    }

    private JsonObject createInterfaceDefinition(ClassDeclaration interfaceDeclaration) {
        JsonObject interfaceDefinition = new JsonObject(new Object[0]);
        this.addOptImplements(interfaceDeclaration, interfaceDefinition);
        return interfaceDefinition;
    }

    private void addOptImplements(ClassDeclaration classDeclaration, JsonObject classDefinition) {
        Implements optImplements = classDeclaration.getOptImplements();
        if (optImplements != null) {
            ArrayList<String> superInterfaces = new ArrayList<String>();
            for (CommaSeparatedList<Ide> superTypes = optImplements.getSuperTypes(); superTypes != null; superTypes = superTypes.getTail()) {
                IdeDeclaration superInterface = superTypes.getHead().getDeclaration(false);
                if (superInterface == null) {
                    System.err.println("ignoring unresolvable interface " + superTypes.getHead().getQualifiedNameStr());
                    continue;
                }
                CompilationUnit mixinCompilationUnit = CompilationUnit.mapMixinInterface(superInterface.getCompilationUnit());
                if (this.compilationUnit.equals(mixinCompilationUnit)) continue;
                superInterfaces.add(this.compilationUnitAccessCode(superInterface));
            }
            if (!superInterfaces.isEmpty()) {
                if (classDeclaration.isInterface() && superInterfaces.size() == 1) {
                    classDefinition.set("extend", superInterfaces.get(0));
                } else {
                    classDefinition.set("mixins", new JsonArray(superInterfaces.toArray()));
                }
            }
        }
    }

    private String[] collectDependencies(CompilationUnit compilationUnit, Boolean required) throws IOException {
        TreeSet<String> requires = new TreeSet<String>();
        Set<String> dependentCompilationUnits = required == null ? compilationUnit.getRuntimeDependencies() : compilationUnit.getRuntimeDependencies(required);
        Iterator iterator = dependentCompilationUnits.iterator();
        while (iterator.hasNext()) {
            String renamedName;
            Annotation renameAnnotation;
            String dependentCUId;
            String javaScriptName = dependentCUId = (String)iterator.next();
            String javaScriptNameToRequire = DEFAULT_ANNOTATION_PARAMETER_NAME;
            CompilationUnit dependentCompilationUnitModel = this.compilationUnitModelResolver.resolveCompilationUnit(dependentCUId);
            IdeDeclaration primaryDeclaration = dependentCompilationUnitModel.getPrimaryDeclaration();
            Annotation nativeAnnotation = primaryDeclaration.getAnnotation("Native");
            if (nativeAnnotation != null) {
                String javaScriptAlias = ModuleResolverBase.getNativeAnnotationValue(nativeAnnotation);
                if (javaScriptAlias != null) {
                    javaScriptName = javaScriptAlias;
                }
                javaScriptNameToRequire = this.jsModuleResolver.getNativeAnnotationRequireValue(nativeAnnotation);
            }
            if ((renameAnnotation = primaryDeclaration.getAnnotation("Rename")) != null && (renamedName = ModuleResolverBase.getNativeAnnotationValue(renameAnnotation)) != null) {
                javaScriptName = renamedName;
            }
            if (javaScriptNameToRequire != null) {
                requires.add(javaScriptNameToRequire.isEmpty() ? javaScriptName : javaScriptNameToRequire);
            }
            this.imports.put(dependentCUId, javaScriptName);
        }
        return requires.toArray(new String[requires.size()]);
    }

    private JsonObject createClassDefinition(ClassDeclaration classDeclaration) {
        JsonObject classDefinition = new JsonObject(new Object[0]);
        if (classDeclaration.notExtendsObject()) {
            ClassDeclaration superTypeDeclaration = classDeclaration.getSuperTypeDeclaration();
            classDefinition.set("extend", this.compilationUnitAccessCode(superTypeDeclaration));
        }
        this.addOptImplements(classDeclaration, classDefinition);
        String alternateClassName = JsCodeGenerator.getAlternateClassName(classDeclaration);
        if (alternateClassName != null) {
            classDefinition.set("alternateClassName", alternateClassName);
        }
        return classDefinition;
    }

    private static String getAlternateClassName(ClassDeclaration classDeclaration) {
        String alternateClassName = classDeclaration.getTargetQualifiedNameStrWithoutRename();
        return classDeclaration.getTargetQualifiedNameStr().equals(alternateClassName) ? null : alternateClassName;
    }

    private void fillClassDefinition(JsonObject classDefinition, ClassDefinitionBuilder classDefinitionBuilder) throws IOException {
        JsonObject staticMembers;
        JsonObject extPrivateMembers;
        if (!classDefinitionBuilder.metadata.isEmpty()) {
            classDefinition.set("metadata", classDefinitionBuilder.metadata);
        }
        if (!classDefinitionBuilder.mixinConfig.isEmpty()) {
            classDefinition.set("mixinConfig", classDefinitionBuilder.mixinConfig);
        }
        JsonObject members = this.convertMembers(classDefinitionBuilder.members, false);
        JsonObject bindables = this.convertBindables(classDefinitionBuilder.members);
        if (!bindables.isEmpty()) {
            members.set("config", bindables);
        }
        if (!(extPrivateMembers = this.convertMembers(classDefinitionBuilder.members, true)).isEmpty()) {
            members.set("privates", extPrivateMembers);
        }
        if (!members.isEmpty()) {
            classDefinition.add(members);
        }
        if (!(staticMembers = this.convertMembers(classDefinitionBuilder.staticMembers, false)).isEmpty() || classDefinitionBuilder.staticCode.length() > 0) {
            if (classDefinitionBuilder.staticCode.length() > 0) {
                String staticInitializer = String.format("function() {\n%s        }", classDefinitionBuilder.staticCode.toString());
                staticMembers.set(INIT_STATICS, JsonObject.code(staticInitializer));
            }
            classDefinition.set("statics", staticMembers);
        }
        JsonObject accessors = this.convertAccessors(classDefinitionBuilder.members);
        JsonObject staticAccessors = this.convertAccessors(classDefinitionBuilder.staticMembers);
        if (!staticAccessors.isEmpty()) {
            accessors.set("statics", staticAccessors);
        }
        if (!accessors.isEmpty()) {
            classDefinition.set("__accessors__", accessors);
        }
    }

    private JsonObject convertMembers(Map<String, PropertyDefinition> members, boolean extPrivate) {
        JsonObject membersDefinition = new JsonObject(new Object[0]);
        for (Map.Entry<String, PropertyDefinition> entry : members.entrySet()) {
            if (!entry.getValue().isValueOnly() || entry.getValue().bindable || entry.getValue().extPrivate != extPrivate) continue;
            membersDefinition.set(entry.getKey(), JsonObject.code(entry.getValue().value));
        }
        return membersDefinition;
    }

    private JsonObject convertBindables(Map<String, PropertyDefinition> members) {
        JsonObject bindables = new JsonObject(new Object[0]);
        for (Map.Entry<String, PropertyDefinition> entry : members.entrySet()) {
            PropertyDefinition member = entry.getValue();
            if (!member.bindable) continue;
            bindables.set(entry.getKey(), JsonObject.code(member.isValueOnly() ? member.value : "null"));
        }
        return bindables;
    }

    private JsonObject convertAccessors(Map<String, PropertyDefinition> members) {
        JsonObject accessors = new JsonObject(new Object[0]);
        for (Map.Entry<String, PropertyDefinition> entry : members.entrySet()) {
            if (entry.getValue().isValueOnly()) continue;
            accessors.set(entry.getKey(), entry.getValue().asJson());
        }
        return accessors;
    }

    @Override
    public void visitIde(Ide ide) throws IOException {
        this.out.writeSymbolWhitespace(ide.getIde());
        String ideText = ide.getIde().getText();
        if (!this.out.isWritingComment()) {
            if (this.expressionMode) {
                if (ide.isSuper()) {
                    ideText = this.getSuperClassPrototypeAccessCode();
                }
                if ("this".equals(ideText) && ide.isRewriteThis()) {
                    ideText = "_this";
                } else {
                    ideText = this.convertIdentifier(ideText);
                    IdeDeclaration ideDeclaration = ide.getDeclaration(false);
                    if (ideDeclaration != null) {
                        if (ideDeclaration.isPrimaryDeclaration()) {
                            ideText = this.compilationUnitAccessCode(ideDeclaration);
                        } else if (ideDeclaration.isPrivateStatic()) {
                            ideText = ideDeclaration instanceof FunctionDeclaration && ((FunctionDeclaration)ideDeclaration).isGetterOrSetter() ? "get$" + ideText + "$static()" : ideText + "$static";
                        }
                    }
                }
            } else {
                ideText = this.convertIdentifier(ideText);
            }
        }
        this.out.writeTokenForSymbol(ideText, ide.getSymbol());
    }

    private String convertIdentifier(String identifier) {
        return SyntacticKeywords.RESERVED_WORDS.contains(identifier) ? identifier + "_" : identifier;
    }

    @Override
    public void visitQualifiedIde(QualifiedIde qualifiedIde) throws IOException {
        if (this.out.isWritingComment()) {
            super.visitQualifiedIde(qualifiedIde);
        } else {
            this.out.writeSymbolWhitespace(qualifiedIde.getQualifier().getSymbol());
            IdeDeclaration ideDeclaration = qualifiedIde.getDeclaration();
            String compilationUnitAccessCode = this.compilationUnitAccessCode(ideDeclaration);
            String ideName = qualifiedIde.getName();
            if (!qualifiedIde.getScope().lookupDeclaration(new Ide(ideName), false).isPrimaryDeclaration()) {
                this.out.writeTokenForSymbol(qualifiedIde.getQualifiedNameStr(), qualifiedIde.getSymbol());
            } else {
                this.out.writeTokenForSymbol(compilationUnitAccessCode, qualifiedIde.getSymbol());
            }
        }
    }

    @Override
    public void visitIdeWithTypeParam(IdeWithTypeParam ideWithTypeParam) throws IOException {
        if (this.out.isWritingComment()) {
            this.out.writeSymbol(ideWithTypeParam.getOriginalIde());
        } else {
            this.visitIde(ideWithTypeParam);
        }
        this.out.beginComment();
        this.out.writeSymbol(ideWithTypeParam.getSymDotLt());
        ideWithTypeParam.getType().visit(this);
        this.out.writeSymbol(ideWithTypeParam.getSymGt());
        this.out.endComment();
    }

    @Override
    public void visitNamespacedIde(NamespacedIde namespacedIde) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(namespacedIde.getNamespace().getSymbol());
        this.out.writeSymbol(namespacedIde.getSymNamespaceSep());
        this.out.endComment();
        this.visitIde(namespacedIde);
    }

    @Override
    public void visitIdeExpression(IdeExpr ideExpr) throws IOException {
        this.visitInExpressionMode(ideExpr.getIde());
    }

    private void visitInExpressionMode(AstNode expr) throws IOException {
        boolean oldExpressionMode = this.expressionMode;
        this.expressionMode = !this.out.isWritingComment();
        try {
            expr.visit(this);
        }
        finally {
            this.expressionMode = oldExpressionMode;
        }
    }

    @Override
    public void visitAssignmentOpExpr(AssignmentOpExpr assignmentOpExpr) throws IOException {
        Expr leftHandSide = assignmentOpExpr.getArg1();
        if (assignmentOpExpr.getOp().sym == 86 || assignmentOpExpr.getOp().sym == 87) {
            leftHandSide.visit(this);
            this.writeSymbolReplacement(assignmentOpExpr.getOp(), "=");
            JoocConfiguration options = (JoocConfiguration)this.out.getOptions();
            DebugMode mode = options.getDebugMode();
            options.setDebugMode(null);
            leftHandSide.visit(this);
            options.setDebugMode(mode);
            this.out.writeToken(assignmentOpExpr.getOp().sym == 86 ? "&&" : "||");
            this.out.writeToken("(");
            assignmentOpExpr.getArg2().visit(this);
            this.out.writeToken(")");
        } else {
            if (leftHandSide instanceof IdeExpr) {
                leftHandSide = ((IdeExpr)leftHandSide).getNormalizedExpr();
            }
            if (leftHandSide instanceof DotExpr) {
                DotExpr dotExpr = (DotExpr)leftHandSide;
                Ide ide = dotExpr.getIde();
                ExpressionType type = dotExpr.getArg().getType();
                if (type != null) {
                    String setter;
                    IdeDeclaration ideDeclaration = type.resolvePropertyDeclaration(ide.getName());
                    if (ideDeclaration != null && ideDeclaration.isPrivateStatic() && (ideDeclaration instanceof PropertyDeclaration || ideDeclaration instanceof FunctionDeclaration && ((FunctionDeclaration)ideDeclaration).isGetterOrSetter())) {
                        this.writeSymbolReplacement(leftHandSide.getSymbol(), "set$" + ide.getName() + "$static");
                        this.writeSymbolReplacement(assignmentOpExpr.getOp(), "(");
                        assignmentOpExpr.getArg2().visit(this);
                        this.out.writeToken(")");
                        return;
                    }
                    if (!type.isConfigType() && (setter = this.resolveBindable(dotExpr, MethodType.SET)) != null) {
                        Expr dotExprArg = dotExpr.getArg();
                        this.out.writeSymbolWhitespace(dotExprArg.getSymbol());
                        this.out.write("AS3.setBindable(");
                        this.visitInExpressionMode(dotExprArg);
                        this.writeSymbolReplacement(dotExpr.getOp(), ",");
                        this.out.write(CompilerUtils.quote((String)setter));
                        this.writeSymbolReplacement(assignmentOpExpr.getOp(), ",");
                        assignmentOpExpr.getArg2().visit(this);
                        this.out.writeToken(")");
                        return;
                    }
                }
            }
            this.visitBinaryOpExpr(assignmentOpExpr);
        }
    }

    private String resolveBindable(DotExpr dotExpr, MethodType methodType) throws IOException {
        TypeDeclaration typeDeclaration;
        TypeRelation typeRelation;
        ExpressionType lhsType = dotExpr.getArg().getType();
        if (lhsType != null && lhsType.getAS3Type() == AS3Type.OBJECT) {
            TypedIdeDeclaration member = this.findMemberWithBindableAnnotation(dotExpr.getIde(), methodType, lhsType.getDeclaration());
            return member == null ? null : member.getName();
        }
        if (lhsType instanceof Typed && (typeRelation = ((Typed)((Object)lhsType)).getOptTypeRelation()) != null && (typeDeclaration = typeRelation.getType().resolveDeclaration()) instanceof ClassDeclaration) {
            return this.resolveBindable(dotExpr.getIde(), methodType, (ClassDeclaration)typeDeclaration);
        }
        return null;
    }

    private String resolveBindable(Ide qIde, MethodType methodType, ClassDeclaration typeDeclaration) throws IOException {
        TypedIdeDeclaration member = this.findMemberWithBindableAnnotation(qIde, methodType, typeDeclaration);
        return member == null ? null : JsCodeGenerator.getBindablePropertyName(methodType, member);
    }

    private static String getBindableEventName(TypedIdeDeclaration member) {
        Object eventAnnotation = JsCodeGenerator.getBindablePropertiesByName(member).get("event");
        return eventAnnotation instanceof String ? (String)eventAnnotation : null;
    }

    @Override
    public void visitParameters(Parameters parameters) throws IOException {
        this.visitIfNotNull((AstNode)parameters.getHead());
        if (parameters.getSymComma() != null) {
            if (((Parameter)parameters.getTail().getHead()).isRest()) {
                this.out.beginCommentWriteSymbol(parameters.getSymComma());
                parameters.getTail().visit(this);
                this.out.endComment();
            } else {
                this.out.writeSymbol(parameters.getSymComma());
                parameters.getTail().visit(this);
            }
        }
    }

    @Override
    public void visitFunctionExpr(FunctionExpr functionExpr) throws IOException {
        this.out.writeSymbol(functionExpr.getSymFunction());
        if (functionExpr.getIde() != null) {
            this.out.writeSymbol(functionExpr.getIde().getIde());
        }
        this.handleParameters(functionExpr);
        this.generateFunTailCode(functionExpr);
    }

    public void handleParameters(FunctionExpr functionExpr) throws IOException {
        Parameters params = functionExpr.getParams();
        if (functionExpr.hasBody()) {
            if (functionExpr.isArgumentsUsedAsArray()) {
                this.addBlockStartCodeGenerator(functionExpr.getBody(), this.ARGUMENT_TO_ARRAY_CODE_GENERATOR);
            }
            if (params != null) {
                JoocConfiguration config = ((Jooc)((Parameter)params.getHead()).getIde().getScope().getCompiler()).getConfig();
                this.addBlockStartCodeGenerator(functionExpr.getBody(), config.isUseEcmaParameterInitializerSemantics() ? this.getEcmaParameterInitializerCodeGenerator(params) : this.getParameterInitializerCodeGenerator(params));
            }
        }
    }

    public void generateFunTailCode(FunctionExpr functionExpr) throws IOException {
        this.generateFunctionExprSignature(functionExpr);
        if (functionExpr.hasBody()) {
            functionExpr.getBody().visit(this);
        }
    }

    public CodeGenerator getParameterInitializerCodeGenerator(final Parameters params) {
        return new CodeGenerator(){

            @Override
            public void generate(JsWriter out, boolean first) throws IOException {
                HashMap<Integer, Parameter> paramByIndex = new HashMap<Integer, Parameter>();
                int paramIndex = 0;
                for (Parameters parameters = params; parameters != null; parameters = parameters.getTail()) {
                    Parameter param = (Parameter)parameters.getHead();
                    if (param.hasInitializer()) {
                        paramByIndex.put(paramIndex, param);
                    }
                    ++paramIndex;
                }
                JsCodeGenerator.this.generateParameterInitializers(out, paramByIndex);
                JsCodeGenerator.this.generateRestParamCode(params);
            }
        };
    }

    public CodeGenerator getEcmaParameterInitializerCodeGenerator(final Parameters params) {
        return new CodeGenerator(){

            @Override
            public void generate(JsWriter out, boolean first) throws IOException {
                for (Parameters parameters = params; parameters != null; parameters = parameters.getTail()) {
                    Parameter param = (Parameter)parameters.getHead();
                    if (!param.hasInitializer()) continue;
                    out.write(JsCodeGenerator.this.ASSIGN_DEFAULT_IF_PARAMETER_IS_UNDEFINED.format(param.getName()));
                    JsCodeGenerator.this.generateBodyInitializerCode(param);
                    out.write("}");
                }
                JsCodeGenerator.this.generateRestParamCode(params);
            }
        };
    }

    private void generateParameterInitializers(JsWriter out, Map<Integer, Parameter> paramByIndex) throws IOException {
        Iterator<Map.Entry<Integer, Parameter>> paramByIndexIterator = paramByIndex.entrySet().iterator();
        if (paramByIndexIterator.hasNext()) {
            Map.Entry<Integer, Parameter> indexAndParam = paramByIndexIterator.next();
            Integer firstParamIndex = indexAndParam.getKey();
            if (!paramByIndexIterator.hasNext()) {
                out.write(this.IF_ARGUMENT_LENGTH_LTE_$N.format(firstParamIndex));
                this.generateBodyInitializerCode(indexAndParam.getValue());
            } else {
                out.write(this.SWITCH_$INDEX.format(firstParamIndex));
                out.write("{");
                while (true) {
                    out.write(this.CASE_$N.format(indexAndParam.getKey()));
                    this.generateBodyInitializerCode(indexAndParam.getValue());
                    if (!paramByIndexIterator.hasNext()) break;
                    indexAndParam = paramByIndexIterator.next();
                }
                out.write("}");
            }
        }
    }

    public void generateRestParamCode(Parameters params) throws IOException {
        if (params != null) {
            String lastParamName;
            int lastParamIndex = 0;
            Parameters parameters = params;
            while (parameters.getTail() != null) {
                ++lastParamIndex;
                parameters = parameters.getTail();
            }
            Parameter lastParam = (Parameter)parameters.getHead();
            if (lastParam.isRest() && (lastParamName = lastParam.getName()) != null && (!lastParamName.equals("arguments") || lastParamIndex != 0)) {
                this.generateToArrayCode(lastParamName, lastParamIndex);
            }
        }
    }

    public void generateBodyInitializerCode(Parameter param) throws IOException {
        this.out.setSuppressWhitespace(true);
        try {
            this.out.writeToken(param.getName());
            this.out.writeSymbol(param.getOptInitializer().getSymEq());
            param.getOptInitializer().getValue().visit(this);
            this.out.write(";");
        }
        finally {
            this.out.setSuppressWhitespace(false);
        }
    }

    @Override
    public void visitVectorLiteral(VectorLiteral vectorLiteral) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(vectorLiteral.getSymNew());
        this.out.writeSymbol(vectorLiteral.getSymLt());
        vectorLiteral.getVectorType().visit(this);
        this.out.writeSymbol(vectorLiteral.getSymGt());
        this.out.endComment();
        vectorLiteral.getArrayLiteral().visit(this);
    }

    @Override
    protected void handleExmlAppendPrepend(ObjectField objectField, DotExpr exmlAppendOrPrepend) throws IOException {
        JooSymbol propertySymbol = objectField.getLabel().getSymbol();
        this.out.writeTokenForSymbol(propertySymbol.getText() + "$at", propertySymbol);
        this.out.write(":");
        exmlAppendOrPrepend.getArg().visit(this);
        this.out.writeSymbol(exmlAppendOrPrepend.getOp());
        JooSymbol appendOrPrependSymbol = exmlAppendOrPrepend.getIde().getSymbol();
        this.out.writeTokenForSymbol(appendOrPrependSymbol.getText().toUpperCase(), appendOrPrependSymbol);
        this.out.write(", ");
        objectField.getLabel().visit(this);
        this.out.writeSymbol(objectField.getSymColon());
        ((ApplyExpr)objectField.getValue()).getArgs().visit(this);
    }

    @Override
    public void visitApplyExpr(ApplyExpr applyExpr) throws IOException {
        if (applyExpr.getArgs() != null && applyExpr.getFun() instanceof IdeExpr) {
            Ide funIde = ((IdeExpr)applyExpr.getFun()).getIde();
            JooSymbol lParen = applyExpr.getArgs().getLParen();
            CommaSeparatedList<Expr> arguments = applyExpr.getArgs().getExpr();
            if (applyExpr.isAssert()) {
                this.writeSymbolReplacement(funIde.getSymbol(), this.builtInIdentifierCode("assert"));
                JooSymbol symKeyword = applyExpr.getFun().getSymbol();
                this.out.writeSymbol(lParen);
                arguments.visit(this);
                this.out.writeToken(", ");
                this.out.writeString(new File(symKeyword.getFileName()).getName());
                this.out.writeToken(", ");
                this.out.writeInt(symKeyword.getLine());
                this.out.write(", ");
                this.out.writeInt(symKeyword.getColumn());
                this.out.writeSymbol(applyExpr.getArgs().getRParen());
                return;
            }
            if (this.isAddEventListenerMethod(funIde)) {
                this.out.writeSymbolWhitespace(funIde.getSymbol());
                this.out.writeToken("AS3.");
                this.out.writeSymbol(funIde.getIde());
                this.out.writeSymbol(lParen, false);
                funIde.getQualifier().visit(this);
                this.writeSymbolReplacement(((QualifiedIde)funIde).getSymDot(), ",");
                this.out.writeSymbolWhitespace(lParen);
                Expr eventConstant = arguments.getHead();
                if (!(eventConstant instanceof IdeExpr)) {
                    throw Jooc.error(eventConstant, String.format("'%s' must be used with event constant.", "addEventListener"));
                }
                Ide eventConstantIde = ((IdeExpr)eventConstant).getIde();
                if (eventConstantIde.getQualifier() == null) {
                    throw Jooc.error(eventConstant, String.format("'%s' must be used with event constant from event class.", "addEventListener"));
                }
                this.visitInExpressionMode(eventConstantIde.getQualifier());
                this.writeSymbolReplacement(((QualifiedIde)eventConstantIde).getSymDot(), ",");
                this.out.writeToken("\"");
                this.out.writeSymbol(eventConstantIde.getIde());
                this.out.writeToken("\"");
                this.out.writeSymbol(arguments.getSymComma());
                arguments.getTail().visit(this);
                this.out.writeSymbol(applyExpr.getArgs().getRParen());
                return;
            }
        }
        this.generateFunJsCode(applyExpr);
    }

    private boolean isAddEventListenerMethod(Ide funIde) {
        CompilationUnit type;
        IdeDeclaration qualifierDeclaration;
        if ("addEventListener".equals(funIde.getName()) && (qualifierDeclaration = funIde.getQualifier().resolveDeclaration()) instanceof ClassDeclaration && (type = this.compilationUnitModelResolver.resolveCompilationUnit(qualifierDeclaration.getQualifiedNameStr())) != null && type.getPrimaryDeclaration() != null) {
            return this.compilationUnitModelResolver.implementsInterface(type, "ext.mixin.IObservable");
        }
        return false;
    }

    private void generateFunJsCode(ApplyExpr applyExpr) throws IOException {
        ParenthesizedExpr<CommaSeparatedList<Expr>> args = applyExpr.getArgs();
        if (applyExpr.isTypeCast()) {
            this.out.writeSymbolWhitespace(applyExpr.getFun().getSymbol());
            this.out.writeToken("AS3.cast");
            this.out.writeSymbol(args.getLParen());
            applyExpr.getFun().visit(this);
            this.out.writeToken(",");
            args.getExpr().getHead().visit(this);
            this.out.writeSymbol(args.getRParen());
        } else if (applyExpr.isTypeCheckObjectLiteralFunctionCall()) {
            args.getExpr().getTail().getHead().visit(this);
        } else {
            applyExpr.getFun().visit(this);
            if (args != null && applyExpr.getFun() instanceof IdeExpr && ((IdeExpr)applyExpr.getFun()).getIde().isQualifiedBySuper()) {
                this.generateSuperCallParameters(args);
            } else {
                this.visitApplyExprArguments(applyExpr);
            }
        }
    }

    @Override
    public void visitClassBody(ClassBody classBody) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(classBody.getLBrace());
        this.out.endComment();
        this.visitClassBodyDirectives(classBody.getDirectives());
        this.out.beginComment();
        this.out.writeSymbol(classBody.getRBrace());
        this.out.endComment();
    }

    @Override
    void generateStaticInitializer(List<Directive> directives) throws IOException {
        String staticFunctionName = "static$" + this.staticCodeCounter++;
        this.out.writeToken(String.format("function %s(){", staticFunctionName));
        for (Directive directive : directives) {
            directive.visit(this);
        }
        this.out.writeToken("}");
        this.primaryClassDefinitionBuilder.staticCode.append("          ").append(staticFunctionName).append("();\n");
    }

    @Override
    protected String builtInIdentifierCode(String builtInIdentifier) {
        return "AS3." + builtInIdentifier;
    }

    @Override
    public void visitForInStatement(final ForInStatement forInStatement) throws IOException {
        boolean isForEach;
        boolean iterateArrayMode;
        final Ide exprAuxIde = forInStatement.getExprAuxIde();
        ExpressionType exprType = forInStatement.getExpr().getType();
        boolean bl = iterateArrayMode = exprType != null && exprType.isArrayLike();
        if (exprAuxIde != null && !iterateArrayMode) {
            new SemicolonTerminatedStatement(new VariableDeclaration(SYM_VAR, exprAuxIde, null, null), SYM_SEMICOLON).visit(this);
        }
        this.out.writeSymbol(forInStatement.getSymKeyword());
        boolean bl2 = isForEach = forInStatement.getSymEach() != null;
        if (isForEach) {
            this.out.beginComment();
            this.out.writeSymbol(forInStatement.getSymEach());
            this.out.endComment();
        }
        this.out.writeSymbol(forInStatement.getLParen());
        if (isForEach || iterateArrayMode) {
            new VariableDeclaration(SYM_VAR, forInStatement.getAuxIde(), null, null).visit(this);
        } else if (forInStatement.getDecl() != null) {
            forInStatement.getDecl().visit(this);
        } else {
            forInStatement.getLValue().visit(this);
        }
        if (iterateArrayMode) {
            String indexVarName = forInStatement.getAuxIde().getName();
            this.out.write("=0");
            if (exprAuxIde != null) {
                this.out.write(",");
                this.out.writeToken(exprAuxIde.getName());
                this.out.writeToken("=");
                this.out.beginComment();
                this.out.writeSymbol(forInStatement.getSymIn());
                this.out.endComment();
                forInStatement.getExpr().visit(this);
            }
            this.out.write(";");
            this.out.write(indexVarName);
            this.out.write("<");
            if (exprAuxIde != null) {
                this.out.writeToken(exprAuxIde.getName());
            } else {
                this.out.beginComment();
                this.out.writeSymbol(forInStatement.getSymIn());
                this.out.endComment();
                forInStatement.getExpr().visit(this);
            }
            this.out.write(".length;");
            this.out.write("++" + indexVarName);
        } else {
            this.out.writeSymbol(forInStatement.getSymIn());
            if (exprAuxIde != null) {
                this.out.writeToken(exprAuxIde.getName());
                this.out.writeToken("=");
            }
            forInStatement.getExpr().visit(this);
        }
        this.out.writeSymbol(forInStatement.getRParen());
        if (isForEach || iterateArrayMode) {
            if (!(forInStatement.getBody() instanceof BlockStatement)) {
                forInStatement.setBody(new BlockStatement(SYM_LBRACE, Arrays.asList(forInStatement.getBody()), SYM_RBRACE));
            }
            this.addBlockStartCodeGenerator((BlockStatement)forInStatement.getBody(), new CodeGenerator(){

                @Override
                public void generate(JsWriter out, boolean first) throws IOException {
                    if (forInStatement.getDecl() != null) {
                        forInStatement.getDecl().visit(JsCodeGenerator.this);
                    } else {
                        forInStatement.getLValue().visit(JsCodeGenerator.this);
                    }
                    out.writeToken("=");
                    if (!isForEach) {
                        out.write("String(" + forInStatement.getAuxIde().getName() + ")");
                    } else {
                        if (exprAuxIde == null) {
                            forInStatement.getExpr().visit(JsCodeGenerator.this);
                        } else {
                            out.write(exprAuxIde.getName());
                        }
                        out.write("[" + forInStatement.getAuxIde().getName() + "]");
                    }
                    out.write(";");
                }
            });
        }
        forInStatement.getBody().visit(this);
    }

    @Override
    public void visitParameter(Parameter parameter) throws IOException {
        Debug.assertTrue(parameter.getModifiers() == 0, "Parameters must not have any modifiers");
        if (parameter.isRest()) {
            this.out.beginCommentWriteSymbol(parameter.getOptSymRest());
            parameter.getIde().visit(this);
            this.out.endComment();
        } else {
            parameter.getIde().visit(this);
        }
        this.visitParameterTypeRelation(parameter);
        if (parameter.getOptInitializer() != null) {
            this.out.beginComment();
            parameter.getOptInitializer().visit(this);
            this.out.endComment();
        }
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration variableDeclaration) throws IOException {
        if (variableDeclaration.hasPreviousVariableDeclaration()) {
            Debug.assertTrue(variableDeclaration.getOptSymConstOrVar() != null && variableDeclaration.getOptSymConstOrVar().sym == 72, "Additional variable declarations must start with a COMMA.");
        }
        this.visitAll(variableDeclaration.getAnnotations());
        this.writeExtDefineCodePrefix(variableDeclaration);
        List<Metadata> currentMetadata = this.buildMetadata(variableDeclaration);
        if ((variableDeclaration.isClassMember() || variableDeclaration.isPrimaryDeclaration()) && !variableDeclaration.isPrivateStatic()) {
            if (!variableDeclaration.isPrimaryDeclaration() && !currentMetadata.isEmpty()) {
                this.getClassDefinitionBuilder(variableDeclaration).storeCurrentMetadata(variableDeclaration.getIde().getName() + (variableDeclaration.isPrivate() ? "$" + variableDeclaration.getClassDeclaration().getQualifiedNameHash() : DEFAULT_ANNOTATION_PARAMETER_NAME), currentMetadata);
            }
            this.out.beginComment();
            this.writeModifiers(variableDeclaration);
            this.writeOptSymbol(variableDeclaration.getOptSymConstOrVar());
            variableDeclaration.getIde().visit(this);
            this.visitIfNotNull(variableDeclaration.getOptTypeRelation());
            if (this.mustInitializeInStaticCode(variableDeclaration)) {
                this.out.endComment();
                this.generateFieldInitializerCode(variableDeclaration);
            } else {
                this.visitIfNotNull(variableDeclaration.getOptInitializer());
                this.out.endComment();
            }
            this.registerField(variableDeclaration, currentMetadata);
            this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
            this.generateFieldEndCode(variableDeclaration);
        } else {
            if (variableDeclaration.hasPreviousVariableDeclaration()) {
                this.writeOptSymbol(variableDeclaration.getOptSymConstOrVar());
            } else {
                this.generateVarStartCode(variableDeclaration);
            }
            this.visitInExpressionMode(variableDeclaration.getIde());
            this.visitIfNotNull(variableDeclaration.getOptTypeRelation());
            Initializer optInitializer = variableDeclaration.getOptInitializer();
            if (optInitializer == null) {
                if (variableDeclaration.isPrimaryDeclaration() || variableDeclaration.isPrivateStatic()) {
                    String value = this.getValueFromEmbedMetadata(currentMetadata);
                    if (value == null) {
                        TypeRelation typeRelation = variableDeclaration.getOptTypeRelation();
                        value = VariableDeclaration.getDefaultValue(typeRelation);
                    }
                    if (value != null) {
                        this.out.write("=" + value);
                    }
                }
            } else {
                if (variableDeclaration.isPrivateStatic() && this.mustInitializeInStaticCode(variableDeclaration)) {
                    this.out.writeToken(";");
                    this.generateFieldInitializerCode(variableDeclaration);
                    this.registerField(variableDeclaration, currentMetadata);
                    this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
                    this.writeOptSymbolWhitespace(variableDeclaration.getOptSymSemicolon());
                    return;
                }
                optInitializer.visit(this);
            }
            this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
            this.writeOptSymbol(variableDeclaration.getOptSymSemicolon());
        }
    }

    private String getValueFromEmbedMetadata(List<Metadata> currentMetadata) {
        Metadata embedMetadata = Metadata.find(currentMetadata, "Embed");
        if (embedMetadata != null) {
            String source = (String)embedMetadata.getArgumentValue("source");
            String assetType = EmbeddedAssetResolver.guessAssetType(source);
            int index = this.compilationUnit.getResourceDependencies().indexOf(assetType + "!" + source);
            String assetFactory = "new String";
            if ("image".equals(assetType)) {
                assetFactory = this.imports.get("flash.display.Bitmap") + ".fromImg";
            }
            return String.format("function(){return %s($resource_%d)}", assetFactory, index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerField(VariableDeclaration variableDeclaration, List<Metadata> currentMetadata) {
        String variableName = variableDeclaration.getName();
        boolean isBindable = variableDeclaration.isBindable();
        String value = null;
        if (this.mustInitializeInStaticCode(variableDeclaration)) {
            if (variableDeclaration.isStatic()) {
                this.primaryClassDefinitionBuilder.staticCode.append("          ").append(variableName).append("$static_();\n");
            }
            if (isBindable || variableDeclaration.isStatic() && !variableDeclaration.isPrivate()) {
                value = "undefined";
            }
        } else {
            if (variableDeclaration.getOptInitializer() != null) {
                Expr initialValue = variableDeclaration.getOptInitializer().getValue();
                JsWriter originalOut = this.out;
                StringWriter initialValueWriter = new StringWriter();
                this.out = new JsWriter(initialValueWriter);
                this.out.setOptions(originalOut.getOptions());
                try {
                    initialValue.visit(this);
                }
                catch (IOException iOException) {
                }
                finally {
                    this.out = originalOut;
                }
                value = initialValueWriter.toString().trim();
            } else {
                value = this.getValueFromEmbedMetadata(currentMetadata);
                if (value == null) {
                    TypeRelation typeRelation = variableDeclaration.getOptTypeRelation();
                    value = VariableDeclaration.getDefaultValue(typeRelation);
                }
            }
            if (variableDeclaration.isPrivate() && !variableDeclaration.isStatic()) {
                variableName = variableName + "$" + ((ClassDeclaration)this.compilationUnit.getPrimaryDeclaration()).getQualifiedNameHash();
            }
        }
        if (variableDeclaration.isPrimaryDeclaration()) {
            this.factory = value == null ? variableName + "_" : String.format("function() {\n        return(%s);\n      }", value);
            return;
        }
        if (value != null) {
            if (variableDeclaration.isPublic() && variableDeclaration.isStatic() && variableDeclaration.isConst() && "xtype".equals(variableDeclaration.getName()) && variableDeclaration.getOptInitializer() != null && variableDeclaration.getOptInitializer().getValue() instanceof LiteralExpr) {
                this.getClassDefinitionBuilder((Declaration)variableDeclaration).members.put("alias", new PropertyDefinition(CompilerUtils.quote((String)("widget." + CompilerUtils.unquote((String)value)))));
            } else {
                this.membersOrStaticMembers(variableDeclaration).put(variableName, new PropertyDefinition(value, !variableDeclaration.isConst(), isBindable));
            }
        }
    }

    protected void generateVarStartCode(VariableDeclaration variableDeclaration) throws IOException {
        this.out.beginComment();
        this.writeModifiers(variableDeclaration);
        this.out.endComment();
        if (variableDeclaration.getOptSymConstOrVar() != null) {
            if (variableDeclaration.isConst()) {
                this.out.beginCommentWriteSymbol(variableDeclaration.getOptSymConstOrVar());
                this.out.endComment();
                this.out.writeToken("var");
            } else {
                this.out.writeSymbol(variableDeclaration.getOptSymConstOrVar());
            }
        }
    }

    protected void generateFieldInitializerCode(VariableDeclaration variableDeclaration) throws IOException {
        Initializer initializer = variableDeclaration.getOptInitializer();
        this.out.beginComment();
        this.out.writeSymbol(initializer.getSymEq());
        this.out.endComment();
        String variableName = variableDeclaration.getName();
        this.out.writeToken("function");
        this.out.writeToken(variableName + (variableDeclaration.isStatic() ? "$static" : DEFAULT_ANNOTATION_PARAMETER_NAME) + "_");
        this.out.writeToken("(){");
        if (variableDeclaration.isPrivateStatic()) {
            this.out.write(variableName + "$static=(");
            initializer.getValue().visit(this);
        } else {
            String target = variableDeclaration.isStatic() ? variableDeclaration.getClassDeclaration().getName() : "this";
            String slotName = variableName + (variableDeclaration.isPrivate() ? "$" + variableDeclaration.getClassDeclaration().getQualifiedNameHash() : DEFAULT_ANNOTATION_PARAMETER_NAME);
            if (variableDeclaration.isPrimaryDeclaration()) {
                this.out.writeToken("return");
            } else {
                this.out.write(target + "." + slotName + "=");
            }
            this.out.writeToken("(");
            initializer.getValue().visit(this);
        }
        this.out.writeToken(");}");
    }

    private boolean mustInitializeInStaticCode(VariableDeclaration variableDeclaration) {
        return variableDeclaration.getOptInitializer() != null && !variableDeclaration.getOptInitializer().getValue().isRuntimeConstant();
    }

    protected void generateFieldEndCode(VariableDeclaration variableDeclaration) throws IOException {
        if (!variableDeclaration.hasPreviousVariableDeclaration()) {
            Debug.assertTrue(variableDeclaration.getOptSymSemicolon() != null, "optSymSemicolon != null");
            this.out.beginComment();
            this.out.writeSymbol(variableDeclaration.getOptSymSemicolon());
            this.out.endComment();
        }
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) throws IOException {
        this.visitAll(functionDeclaration.getAnnotations());
        boolean isPrimaryDeclaration = functionDeclaration.equals(this.compilationUnit.getPrimaryDeclaration());
        assert (functionDeclaration.isClassMember() || !functionDeclaration.isNative() && !functionDeclaration.isAbstract());
        if (isPrimaryDeclaration) {
            this.writeExtDefineCodePrefix(functionDeclaration);
            this.factory = "function() {\n        return " + functionDeclaration.getName() + ";\n      }";
        }
        this.handleParameters(functionDeclaration.getFun());
        if (functionDeclaration.isClassMember() && functionDeclaration.isThisAliased(false)) {
            this.addBlockStartCodeGenerator(functionDeclaration.getBody(), ALIAS_THIS_CODE_GENERATOR);
        }
        if (functionDeclaration.isConstructor() && !functionDeclaration.containsSuperConstructorCall() && functionDeclaration.hasBody() && JsCodeGenerator.needsSuperCallCodeGenerator(functionDeclaration.getClassDeclaration())) {
            this.addBlockStartCodeGenerator(functionDeclaration.getBody(), new SuperCallCodeGenerator(functionDeclaration.getClassDeclaration()));
        }
        if (!functionDeclaration.isClassMember() && !isPrimaryDeclaration) {
            functionDeclaration.getFun().visit(this);
        } else {
            String functionName;
            JooSymbol functionSymbol = functionDeclaration.getIde().getSymbol();
            String methodName = functionName = this.convertIdentifier(functionSymbol.getText());
            List<Metadata> currentMetadata = this.buildMetadata(functionDeclaration);
            if (!isPrimaryDeclaration && !currentMetadata.isEmpty()) {
                this.getClassDefinitionBuilder(functionDeclaration).storeCurrentMetadata(functionName, currentMetadata);
            }
            this.out.beginComment();
            this.writeModifiers(functionDeclaration);
            Map<String, PropertyDefinition> members = this.membersOrStaticMembers(functionDeclaration);
            if (functionDeclaration.isAbstract() || functionDeclaration.isNative()) {
                this.out.writeSymbol(functionDeclaration.getFun().getFunSymbol());
                this.writeOptSymbol(functionDeclaration.getSymGetOrSet());
                functionDeclaration.getIde().visit(this);
                this.generateFunctionExprSignature(functionDeclaration.getFun());
                this.writeOptSymbol(functionDeclaration.getOptSymSemicolon());
                this.out.endComment();
            } else {
                this.out.endComment();
                this.out.writeSymbol(functionDeclaration.getFun().getFunSymbol());
                boolean isAccessor = functionDeclaration.isGetterOrSetter();
                if (isAccessor) {
                    Metadata bindableAnnotation = Metadata.find(currentMetadata, "Bindable");
                    if (bindableAnnotation != null) {
                        String accessorPrefix = functionDeclaration.getSymGetOrSet().getText();
                        String accessorName = (String)bindableAnnotation.getArgumentValue(DEFAULT_ANNOTATION_PARAMETER_NAME);
                        members.put(functionName, new PropertyDefinition("undefined", true, true));
                        methodName = accessorName != null ? accessorName : accessorPrefix + MxmlUtils.capitalize(functionName);
                        functionName = accessorPrefix + "$" + functionName;
                        isAccessor = false;
                    }
                } else if (functionDeclaration.isConstructor()) {
                    functionName = functionName + "$";
                }
                String overriddenMethodName = null;
                PropertyDefinition overriddenPropertyDefinition = null;
                if (functionDeclaration.isPrivate() && !functionDeclaration.isStatic()) {
                    String privateMethodName = methodName + "$" + functionDeclaration.getClassDeclaration().getQualifiedNameHash();
                    if (functionDeclaration.isOverride()) {
                        overriddenMethodName = privateMethodName;
                        this.getClassDefinitionBuilder((Declaration)functionDeclaration).super$Used = true;
                    } else {
                        methodName = privateMethodName;
                    }
                } else if (functionDeclaration.isStatic()) {
                    functionName = functionName + "$static";
                }
                if (isAccessor) {
                    this.out.writeSymbolWhitespace(functionDeclaration.getIde().getSymbol());
                    this.out.writeSymbolWhitespace(functionDeclaration.getSymGetOrSet());
                    String accessorPrefix = functionDeclaration.getSymGetOrSet().getText() + "$";
                    String accessorName = accessorPrefix + functionName;
                    this.out.writeToken(accessorName);
                    if (!functionDeclaration.isPrivateStatic()) {
                        PropertyDefinition accessorDefinition = members.get(methodName);
                        if (accessorDefinition == null) {
                            accessorDefinition = new PropertyDefinition();
                            members.put(methodName, accessorDefinition);
                        }
                        if (functionDeclaration.isGetter()) {
                            accessorDefinition.get = accessorName;
                            if (functionDeclaration.isOverride() && accessorDefinition.set == null) {
                                accessorDefinition.set = "super$.__lookupSetter__('" + methodName + "')";
                            }
                        } else {
                            accessorDefinition.set = accessorName;
                            if (functionDeclaration.isOverride() && accessorDefinition.get == null) {
                                accessorDefinition.get = "super$.__lookupGetter__('" + methodName + "')";
                            }
                        }
                        if (overriddenMethodName != null) {
                            overriddenPropertyDefinition = new PropertyDefinition();
                            overriddenPropertyDefinition.get = "super$.__lookupGetter__('" + methodName + "')";
                            overriddenPropertyDefinition.set = "super$.__lookupSetter__('" + methodName + "')";
                        }
                    }
                } else {
                    this.writeSymbolReplacement(functionSymbol, functionName);
                    if (!functionDeclaration.isPrimaryDeclaration() && !functionDeclaration.isPrivateStatic()) {
                        members.put(functionDeclaration.isConstructor() ? "constructor" : methodName, new PropertyDefinition(functionName, functionDeclaration.getAnnotation("ExtPrivate") != null));
                        if (overriddenMethodName != null) {
                            overriddenPropertyDefinition = new PropertyDefinition("super$." + methodName);
                        }
                    }
                }
                if (overriddenMethodName != null) {
                    members.put(overriddenMethodName, overriddenPropertyDefinition);
                }
                this.generateFunTailCode(functionDeclaration.getFun());
            }
            this.processMixinAnnotations(functionDeclaration, functionName, methodName);
        }
    }

    private void processMixinAnnotations(FunctionDeclaration functionDeclaration, String functionName, String jsMethodName) {
        for (Annotation annotation : functionDeclaration.getAnnotations("MixinHook")) {
            Map<String, Object> propertiesByName = annotation.getPropertiesByName();
            for (Map.Entry<String, Object> propertyWithValues : propertiesByName.entrySet()) {
                String mixinHookType = propertyWithValues.getKey();
                if (mixinHookType == null) {
                    mixinHookType = "on";
                }
                if (Jooc.MIXIN_HOOK_ANNOTATION_ATTRIBUTE_NAMES.contains(mixinHookType)) {
                    Object value;
                    JsonObject mixinConfig = this.getClassDefinitionBuilder((Declaration)functionDeclaration).mixinConfig;
                    if ("extended".equals(mixinHookType)) {
                        mixinConfig.set(mixinHookType, JsonObject.code(functionName));
                        continue;
                    }
                    JsonObject mixinKeyConfig = (JsonObject)mixinConfig.get(mixinHookType);
                    if (mixinKeyConfig == null) {
                        mixinKeyConfig = new JsonObject(new Object[0]);
                        mixinConfig.set(mixinHookType, mixinKeyConfig);
                    }
                    if ((value = propertyWithValues.getValue()) instanceof String) {
                        mixinKeyConfig.set((String)value, jsMethodName);
                        continue;
                    }
                    if (!(value instanceof List)) continue;
                    List values = (List)value;
                    for (String item : values) {
                        mixinKeyConfig.set(item, jsMethodName);
                    }
                    continue;
                }
                throw Jooc.error(annotation, "Invalid [MixinHook] attribute '" + mixinHookType + "'.");
            }
        }
    }

    @Override
    public void visitClassDeclaration(ClassDeclaration classDeclaration) throws IOException {
        this.visitAll(classDeclaration.getAnnotations());
        this.writeExtDefineCodePrefix(classDeclaration);
        List<Metadata> currentMetadata = this.buildMetadata(classDeclaration);
        ClassDefinitionBuilder classDefinitionBuilder = classDeclaration.isPrimaryDeclaration() ? this.primaryClassDefinitionBuilder : (this.secondaryClassDefinitionBuilder = new ClassDefinitionBuilder());
        classDefinitionBuilder.storeCurrentMetadata(DEFAULT_ANNOTATION_PARAMETER_NAME, currentMetadata);
        this.out.beginComment();
        this.writeModifiers(classDeclaration);
        this.out.writeSymbol(classDeclaration.getSymClass());
        classDeclaration.getIde().visit(this);
        this.visitIfNotNull(classDeclaration.getOptExtends());
        this.visitIfNotNull(classDeclaration.getOptImplements());
        this.out.endComment();
        classDeclaration.getBody().visit(this);
        for (IdeDeclaration secondaryDeclaration : classDeclaration.getSecondaryDeclarations()) {
            String secondaryDeclarationName = secondaryDeclaration.getName();
            secondaryDeclaration.visit(this);
            JsonObject secondaryClassDefinition = this.createClassDefinition(secondaryDeclaration, this.secondaryClassDefinitionBuilder);
            this.out.write(new MessageFormat("var {0}$static = Ext.define(null, ").format(secondaryDeclarationName));
            this.out.write(secondaryClassDefinition.toString(-1, -1));
            this.out.write(");");
        }
        if (!classDeclaration.isInterface() && classDeclaration.getConstructor() == null && JsCodeGenerator.needsSuperCallCodeGenerator(classDeclaration)) {
            String constructorName = classDeclaration.getName() + "$";
            this.out.write("function " + constructorName + "() {");
            new SuperCallCodeGenerator(classDeclaration).generate(this.out, true);
            this.out.write("}");
            classDefinitionBuilder.members.put("constructor", new PropertyDefinition(constructorName));
        }
    }

    private void writeExtDefineCodePrefix(IdeDeclaration declaration) throws IOException {
        if (declaration.isPrimaryDeclaration()) {
            this.out.writeSymbolWhitespace(declaration.getSymbol());
            this.out.write("Ext.define(");
            this.out.write(CompilerUtils.quote((String)declaration.getTargetQualifiedNameStr()));
            this.out.write(", function(" + declaration.getName() + ") {");
        }
    }

    private List<Metadata> buildMetadata(Declaration declaration) {
        LinkedList<Metadata> metadata = new LinkedList<Metadata>();
        for (Annotation annotation : declaration.getAnnotations()) {
            Metadata m = new Metadata(annotation.getIde().getName());
            m.args = this.buildMetadataArgs(annotation);
            metadata.add(m);
        }
        return metadata;
    }

    private List<MetadataArgument> buildMetadataArgs(Annotation annotation) {
        CommaSeparatedList<AnnotationParameter> annotationParameters = annotation.getOptAnnotationParameters();
        if (annotationParameters == null) {
            return Collections.emptyList();
        }
        LinkedList<MetadataArgument> args = new LinkedList<MetadataArgument>();
        while (annotationParameters != null) {
            Object value;
            String name;
            AnnotationParameter annotationParameter = annotationParameters.getHead();
            Ide optName = annotationParameter.getOptName();
            AstNode optValue = annotationParameter.getValue();
            String string = name = optName == null ? DEFAULT_ANNOTATION_PARAMETER_NAME : optName.getName();
            if (optValue instanceof LiteralExpr) {
                value = ((LiteralExpr)optValue).getValue().getJooValue();
            } else if (optValue instanceof Ide) {
                IdeDeclaration ideDeclaration = ((Ide)optValue).getDeclaration();
                value = JsonObject.code(this.compilationUnitAccessCode(ideDeclaration));
            } else {
                value = null;
            }
            args.add(new MetadataArgument(name, value));
            annotationParameters = annotationParameters.getTail();
        }
        return args;
    }

    public static boolean needsSuperCallCodeGenerator(ClassDeclaration classDeclaration) {
        return classDeclaration.notExtendsObject() || !classDeclaration.getFieldsWithInitializer().isEmpty();
    }

    @Override
    public void visitNamespaceDeclaration(NamespaceDeclaration namespaceDeclaration) throws IOException {
        this.visitAll(namespaceDeclaration.getAnnotations());
        if (namespaceDeclaration.isPrimaryDeclaration()) {
            this.writeExtDefineCodePrefix(namespaceDeclaration);
        }
        this.out.beginString();
        this.writeModifiers(namespaceDeclaration);
        this.out.writeSymbol(namespaceDeclaration.getSymNamespace());
        namespaceDeclaration.getIde().visit(this);
        this.out.endString();
        this.out.writeSymbolWhitespace(namespaceDeclaration.getOptInitializer().getSymEq());
        this.out.writeToken(",");
        namespaceDeclaration.getOptInitializer().getValue().visit(this);
        this.writeSymbolReplacement(namespaceDeclaration.getOptSymSemicolon(), ",[]");
        if (namespaceDeclaration.isPrimaryDeclaration()) {
            this.factory = namespaceDeclaration.getName();
        }
    }

    @Override
    public void visitPackageDeclaration(PackageDeclaration packageDeclaration) throws IOException {
        this.out.beginComment();
        super.visitPackageDeclaration(packageDeclaration);
        this.out.endComment();
    }

    @Override
    public void visitSuperConstructorCallStatement(SuperConstructorCallStatement superConstructorCallStatement) throws IOException {
        ClassDeclaration classDeclaration = superConstructorCallStatement.getClassDeclaration();
        if (classDeclaration.notExtendsObject() || !classDeclaration.getFieldsWithInitializer().isEmpty()) {
            this.out.writeSymbolWhitespace(superConstructorCallStatement.getSymbol());
            this.generateSuperConstructorCallCode(classDeclaration, superConstructorCallStatement.getArgs());
        } else {
            this.out.beginComment();
            this.out.writeSymbol(superConstructorCallStatement.getSymbol());
            this.visitIfNotNull(superConstructorCallStatement.getArgs());
            this.out.endComment();
        }
        this.out.writeSymbol(superConstructorCallStatement.getSymSemicolon());
    }

    private void generateSuperConstructorCallCode(ClassDeclaration classDeclaration, ParenthesizedExpr<CommaSeparatedList<Expr>> args) throws IOException {
        ClassDefinitionBuilder classDefinitionBuilder;
        String superWithLevel = "super$" + classDeclaration.getQualifiedNameHash();
        this.out.write("this." + superWithLevel);
        if (args == null) {
            this.out.writeToken("()");
        } else {
            args.visit(this);
        }
        List<String> callSuperCode = new ArrayList<String>();
        callSuperCode.add("function() {\n");
        if (classDeclaration.notExtendsObject()) {
            callSuperCode.add("        " + this.getSuperClassPrototypeAccessCode() + ".constructor.apply(this, arguments);\n");
        }
        for (VariableDeclaration field : classDeclaration.getFieldsWithInitializer()) {
            callSuperCode.add("        " + field.getName() + "_.call(this);\n");
        }
        callSuperCode.add("      }");
        if (classDeclaration.isPrimaryDeclaration()) {
            classDefinitionBuilder = this.primaryClassDefinitionBuilder;
        } else {
            classDefinitionBuilder = this.secondaryClassDefinitionBuilder;
            callSuperCode = callSuperCode.stream().map(String::trim).collect(Collectors.toList());
        }
        classDefinitionBuilder.members.put(superWithLevel, new PropertyDefinition(String.join((CharSequence)DEFAULT_ANNOTATION_PARAMETER_NAME, callSuperCode)));
    }

    private String getSuperClassPrototypeAccessCode() {
        return this.compilationUnitAccessCode(((ClassDeclaration)this.compilationUnit.getPrimaryDeclaration()).getSuperTypeDeclaration()) + ".prototype";
    }

    private void generateSuperCallParameters(ParenthesizedExpr<CommaSeparatedList<Expr>> args) throws IOException {
        this.out.writeToken(".call");
        if (args == null) {
            this.out.writeToken("(this)");
        } else {
            this.out.writeSymbolToken(args.getLParen());
            this.out.writeToken("this");
            this.out.writeSymbolWhitespace(args.getLParen());
            CommaSeparatedList<Expr> parameters = args.getExpr();
            if (parameters != null && parameters.getHead() != null) {
                this.out.writeToken(",");
                parameters.visit(this);
            }
            this.out.writeSymbol(args.getRParen());
        }
    }

    @Override
    public void visitAnnotation(Annotation annotation) throws IOException {
        this.out.beginComment();
        super.visitAnnotation(annotation);
        this.out.endComment();
    }

    @Override
    public void visitUseNamespaceDirective(UseNamespaceDirective useNamespaceDirective) throws IOException {
        this.out.beginComment();
        super.visitUseNamespaceDirective(useNamespaceDirective);
        this.out.endComment();
    }

    @Override
    public void visitImportDirective(ImportDirective importDirective) throws IOException {
        this.out.beginComment();
        super.visitImportDirective(importDirective);
        this.out.endComment();
    }

    static {
        PRIMITIVES.add("Boolean");
        PRIMITIVES.add("String");
        PRIMITIVES.add("Number");
        PRIMITIVES.add("int");
        PRIMITIVES.add("uint");
        PRIMITIVES.add("Object");
        PRIMITIVES.add("RegExp");
        PRIMITIVES.add("Date");
        PRIMITIVES.add("Array");
        PRIMITIVES.add("Error");
        PRIMITIVES.add("Vector");
        PRIMITIVES.add("Class");
        PRIMITIVES.add("Function");
        PRIMITIVES.add("XML");
        ALIAS_THIS_CODE_GENERATOR = (out, first) -> out.write("var _this=this;");
    }

    private static class ClassDefinitionBuilder {
        JsonObject metadata = new JsonObject(new Object[0]);
        JsonObject mixinConfig = new JsonObject(new Object[0]);
        Map<String, PropertyDefinition> members = new LinkedHashMap<String, PropertyDefinition>();
        Map<String, PropertyDefinition> staticMembers = new LinkedHashMap<String, PropertyDefinition>();
        StringBuilder staticCode = new StringBuilder();
        boolean super$Used = false;

        private ClassDefinitionBuilder() {
        }

        void storeCurrentMetadata(String memberName, List<Metadata> currentMetadata) {
            Object memberMetadata = this.metadata.get(memberName);
            List<Object> allMetadata = memberMetadata instanceof JsonArray ? ((JsonArray)memberMetadata).getItems() : new LinkedList();
            allMetadata.addAll(this.compress(currentMetadata));
            if (!allMetadata.isEmpty()) {
                this.metadata.set(memberName, new JsonArray(allMetadata.toArray()));
            }
        }

        public List<Object> compress(List<Metadata> metadataList) {
            ArrayList<Object> compressedMetadataList = new ArrayList<Object>();
            for (Metadata metadata : metadataList) {
                if (Jooc.ANNOTATIONS_FOR_COMPILER_ONLY.contains(metadata.name)) continue;
                compressedMetadataList.add(metadata.name);
                if (metadata.args.isEmpty()) continue;
                ArrayList<Object> argNameValues = new ArrayList<Object>();
                for (MetadataArgument metadataArgument : metadata.args) {
                    argNameValues.add(metadataArgument.name);
                    argNameValues.add(metadataArgument.value);
                }
                compressedMetadataList.add(new JsonArray(argNameValues.toArray()));
            }
            return compressedMetadataList;
        }
    }

    private static class MetadataArgument {
        String name;
        Object value;

        private MetadataArgument(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class Metadata {
        String name;
        List<MetadataArgument> args = new ArrayList<MetadataArgument>();

        static Metadata find(List<Metadata> metadataList, String name) {
            for (Metadata metadata : metadataList) {
                if (!metadata.name.equals(name)) continue;
                return metadata;
            }
            return null;
        }

        private Metadata(String name) {
            this.name = name;
        }

        public Object getArgumentValue(String argumentName) {
            for (MetadataArgument arg : this.args) {
                if (!arg.name.equals(argumentName)) continue;
                return arg.value;
            }
            return null;
        }
    }

    private static class PropertyDefinition {
        String value;
        boolean writable;
        boolean configurable;
        String get;
        String set;
        boolean bindable;
        boolean extPrivate;

        private PropertyDefinition() {
        }

        private PropertyDefinition(String value) {
            this.value = value;
        }

        private PropertyDefinition(String value, boolean extPrivate) {
            this.value = value;
            this.extPrivate = extPrivate;
        }

        private PropertyDefinition(String value, boolean writable, boolean bindable) {
            this.value = value;
            this.writable = writable;
            this.bindable = bindable;
        }

        JsonObject asJson() {
            JsonObject result = new JsonObject(new Object[0]);
            if (this.value != null) {
                result.set("value", JsonObject.code(this.value));
            }
            if (this.get != null) {
                result.set("get", JsonObject.code(this.get));
            }
            if (this.set != null) {
                result.set("set", JsonObject.code(this.set));
            }
            if (this.writable) {
                result.set("writable", true);
            }
            if (this.configurable) {
                result.set("configurable", true);
            }
            return result;
        }

        Object asAbbreviatedJson() {
            if (this.isValueOnly()) {
                return JsonObject.code(this.value);
            }
            return this.asJson();
        }

        boolean isValueOnly() {
            return this.get == null && this.set == null;
        }
    }

    private class SuperCallCodeGenerator
    implements CodeGenerator {
        private ClassDeclaration classDeclaration;

        public SuperCallCodeGenerator(ClassDeclaration classDeclaration) {
            this.classDeclaration = classDeclaration;
        }

        @Override
        public void generate(JsWriter out, boolean first) throws IOException {
            JsCodeGenerator.this.generateSuperConstructorCallCode(this.classDeclaration, null);
            out.writeToken(";");
        }
    }
}

