/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeWithTypeParam;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.TypeDeclaration;

public class Type
extends NodeImplBase {
    private Ide ide;

    public Type(Ide ide) {
        this.ide = ide;
    }

    public Type(JooSymbol symIde) {
        this(new Ide(symIde));
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.ide);
    }

    public Ide getIde() {
        return this.ide;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitType(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getIde().scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        Ide ide = this.getIde();
        ide.analyze(this);
        if (ide instanceof IdeWithTypeParam) {
            ((IdeWithTypeParam)ide).getType().analyze(this);
        } else {
            IdeDeclaration declaration = ide.getDeclaration();
            JangarooParser compiler = ide.getScope().getCompiler();
            if (!(declaration instanceof TypeDeclaration)) {
                compiler.getLog().error((FilePosition)ide.getSymbol(), "Type was not found or was not a compile-time constant: " + ide.getSymbol().getText());
            }
            ide.addExternalUsage(null);
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getIde().getSymbol();
    }

    @Nonnull
    public TypeDeclaration getDeclaration() {
        return this.getDeclaration(true);
    }

    public TypeDeclaration resolveDeclaration() {
        return this.getDeclaration(false);
    }

    public TypeDeclaration getDeclaration(boolean errorIfUndeclared) {
        IdeDeclaration declaration = this.getIde().getDeclaration(errorIfUndeclared);
        return declaration instanceof TypeDeclaration ? (TypeDeclaration)declaration : null;
    }
}

