/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.regex.Pattern;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.AsExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BinaryOpExpr;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.KeywordStatement;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.VariableDeclaration;

public class Ide
extends NodeImplBase {
    private static final Pattern IDE_PATTERN = Pattern.compile("[a-zA-Z$_@]([a-zA-Z0-9$_@])*");
    public static final String THIS = "this";
    private JooSymbol ide;
    private IdeDeclaration declaration;
    private Scope scope;
    private Ide qualified;
    private boolean bound;
    private boolean rewriteThis;
    private static final IdeDeclaration NULL_DECL = new VariableDeclaration(null, null, null, null);

    public Ide(String ide) {
        this(new JooSymbol(ide));
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitIde(this);
    }

    public Ide(JooSymbol ide) {
        this.setIde(ide);
    }

    public Scope getScope() {
        return this.scope;
    }

    public JooSymbol getIde() {
        return this.ide;
    }

    public boolean isThis() {
        return THIS.equals(this.getIde().getText());
    }

    private boolean needsThisAtRuntime() {
        if (this.isSuper()) {
            return true;
        }
        if (!this.isQualified() && this.isDeclared()) {
            IdeDeclaration decl = this.getDeclaration();
            return decl.isClassMember() && !decl.isStatic();
        }
        return false;
    }

    public boolean isSuper() {
        return "super".equals(this.getIde().getText());
    }

    @Override
    public void scope(Scope scope) {
        if (this.scope == null) {
            this.scope = scope;
        }
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public String getQualifiedNameStr() {
        return this.getName();
    }

    public String getName() {
        return this.getIde().getText();
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getIde();
    }

    private boolean isQualifier() {
        return this.qualified != null;
    }

    public void setQualified(Ide qualifier) {
        this.qualified = qualifier;
    }

    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    public Ide getQualified() {
        return this.qualified;
    }

    public Ide getQualifier() {
        return null;
    }

    public boolean isQualifiedByThis() {
        return this.getQualifier() != null && this.getQualifier().isThis();
    }

    public boolean isQualifiedBySuper() {
        DotExpr dotExpr;
        AstNode parentNode = this.getParentNode();
        if (parentNode instanceof DotExpr && (dotExpr = (DotExpr)parentNode).getIde() == this) {
            return dotExpr.getArg() instanceof IdeExpr && ((IdeExpr)dotExpr.getArg()).getIde().isSuper();
        }
        return false;
    }

    public boolean addExternalUsage(Boolean required) {
        IdeDeclaration decl = this.getDeclaration(false);
        if (decl != null && (decl.isPrimaryDeclaration() || decl.isClassMember() && decl.isStatic())) {
            Scope scope = this.getScope();
            CompilationUnit currentUnit = scope.getCompilationUnit();
            CompilationUnit compilationUnit = decl.getIde().getScope().getCompilationUnit();
            currentUnit.addDependency(compilationUnit, required);
            return true;
        }
        return false;
    }

    public void addPublicApiDependency() {
        IdeDeclaration decl = this.getDeclaration(false);
        if (decl != null && decl.isPrimaryDeclaration()) {
            CompilationUnit currentUnit = this.getScope().getCompilationUnit();
            CompilationUnit compilationUnit = decl.getIde().getScope().getCompilationUnit();
            currentUnit.addPublicApiDependency(compilationUnit);
        } else if (this.isQualified()) {
            this.getQualifier().addPublicApiDependency();
        }
    }

    void setDeclaration(IdeDeclaration declaration) {
        this.declaration = declaration;
    }

    public IdeDeclaration resolveDeclaration() {
        IdeDeclaration decl = this.getDeclaration(false);
        return decl == null ? null : decl.resolveDeclaration();
    }

    public IdeDeclaration getDeclaration() {
        return this.getDeclaration(true);
    }

    public IdeDeclaration getDeclaration(boolean errorIfUndeclared) {
        IdeDeclaration result;
        if (this.declaration == null) {
            this.declaration = this.lookupDeclaration(errorIfUndeclared);
            if (this.declaration != null && this.declaration.getClassDeclaration() != this.getScope().getClassDeclaration()) {
                if (this.declaration.isPrivate()) {
                    this.declaration = null;
                } else if (this.declaration.isProtected() && !this.getScope().getClassDeclaration().isSubclassOf(this.declaration.getClassDeclaration())) {
                    this.declaration = null;
                }
            }
            if (this.declaration == null) {
                this.declaration = NULL_DECL;
            } else if (this.declaration.getClassDeclaration() != this.getScope().getClassDeclaration()) {
                if (this.declaration.isPrivate()) {
                    throw new CompilerError(this.getSymbol(), "private member access");
                }
                if (this.declaration.isProtected() && !this.getScope().getClassDeclaration().isSubclassOf(this.declaration.getClassDeclaration())) {
                    throw new CompilerError(this.getSymbol(), "protected member access of non-superclass");
                }
            }
        }
        IdeDeclaration ideDeclaration = result = this.declaration == NULL_DECL ? null : this.declaration;
        if (result == null && errorIfUndeclared) {
            throw JangarooParser.error(this.getIde(), "undeclared identifier '" + this.getName() + "'");
        }
        return result;
    }

    private IdeDeclaration lookupDeclaration(boolean errorIfUndeclared) {
        IdeDeclaration ideDeclaration = null;
        try {
            ideDeclaration = this.getScope().lookupDeclaration(this);
        }
        catch (CompilerError e) {
            if (errorIfUndeclared) {
                throw e;
            }
            JangarooParser.warning(this.getSymbol(), e.getMessage());
        }
        return ideDeclaration;
    }

    public Ide qualify(JooSymbol symQualifier, JooSymbol symDot) {
        return new QualifiedIde(new Ide(symQualifier), symDot, this.getIde());
    }

    public void analyzeAsExpr(AstNode exprParent, Expr parentExpr) {
        IdeDeclaration memberDeclaration;
        FunctionExpr currentFunction;
        FunctionExpr funExpr = this.scope.getFunctionExpr();
        if (funExpr != null) {
            boolean isInConstructor;
            boolean bl = isInConstructor = funExpr.getFunctionDeclaration() != null && funExpr.getFunctionDeclaration().isConstructor();
            if (this.isThis() && !this.isRewriteThis()) {
                funExpr.notifyExplicitThisUsed();
                if (isInConstructor) {
                    this.notifyInstanceThisUsed();
                }
            }
            if (this.needsThisAtRuntime()) {
                this.setRewriteThis(funExpr.notifyThisUsed(this.scope));
                if (!this.isSuper() && isInConstructor) {
                    this.notifyInstanceThisUsed();
                }
            }
        }
        if (this.isSuper()) {
            FunctionDeclaration currentMethod = this.getScope().getMethodDeclaration();
            if (currentMethod == null) {
                throw JangarooParser.error(this.getIde(), "use of super is only allowed within non-static methods");
            }
            if (currentMethod.isStatic()) {
                throw JangarooParser.error(this.getIde(), "use of super inside static method");
            }
            currentFunction = this.getScope().getFunctionExpr();
            if (currentFunction.getFunctionDeclaration() != currentMethod) {
                throw JangarooParser.error(this.getIde(), "super calls might only be used within instance methods, not in local functions");
            }
        }
        if (this.isBoundMethodCandidate(exprParent, parentExpr) && (memberDeclaration = this.getMemberDeclaration()) != null && memberDeclaration.isMethod() && !((FunctionDeclaration)memberDeclaration).isGetterOrSetter() && !memberDeclaration.isStatic()) {
            this.setBound(true);
        }
        if (this.scope != null) {
            IdeDeclaration decl;
            this.usageInExpr(exprParent);
            if (!this.isThis() && !this.isQualified() && (decl = this.getDeclaration(false)) instanceof Parameter && (currentFunction = this.scope.getFunctionExpr()) != null && currentFunction.isMyArguments((Parameter)decl)) {
                currentFunction.notifyArgumentsUsed((!this.isQualifier() || exprParent instanceof ApplyExpr) && !(exprParent instanceof ArrayIndexExpr));
            }
        }
    }

    private void usageInExpr(AstNode exprParent) {
        FunctionDeclaration methodDeclaration;
        FunctionExpr funExpr;
        if (this.isThis() && !this.isRewriteThis() && (funExpr = this.getScope().getFunctionExpr()) != null && funExpr.getFunctionDeclaration() == null && (methodDeclaration = this.getScope().getMethodDeclaration()) != null && !methodDeclaration.isStatic() && !this.isArgumentOfTypeCast(exprParent)) {
            JangarooParser.warning(this.getSymbol(), "'this' may be unbound and is untyped in functions, even inside methods. Consider removing 'this.' (members are in scope!) or refactoring inner function to method.");
        }
        this.addExternalUsage(false);
    }

    private boolean isArgumentOfTypeCast(AstNode parentNode) {
        if (parentNode instanceof CommaSeparatedList) {
            AstNode argumentsCandidate = parentNode.getParentNode();
            if (argumentsCandidate instanceof ParenthesizedExpr) {
                AstNode typeCastCandidate = argumentsCandidate.getParentNode();
                return typeCastCandidate instanceof ApplyExpr && ((ApplyExpr)typeCastCandidate).isTypeCast();
            }
        } else if (parentNode instanceof AsExpr) {
            return ((AsExpr)parentNode).getArg1() == this.getParentNode();
        }
        return false;
    }

    public boolean isAssignmentLHS() {
        AstNode containingExpr;
        AstNode parentNode = this.getParentNode();
        if ((parentNode instanceof IdeExpr || parentNode instanceof DotExpr && ((DotExpr)parentNode).getIde() == this) && (containingExpr = parentNode.getParentNode()) instanceof AssignmentOpExpr) {
            Expr arg1 = ((AssignmentOpExpr)containingExpr).getArg1();
            if (arg1 instanceof IdeExpr) {
                arg1 = ((IdeExpr)arg1).getNormalizedExpr();
            }
            return arg1 == parentNode;
        }
        return false;
    }

    public IdeDeclaration getMemberDeclaration() {
        IdeDeclaration ideDeclaration = this.getDeclaration(false);
        if (ideDeclaration != null && ideDeclaration.isClassMember()) {
            return ideDeclaration;
        }
        return ideDeclaration;
    }

    boolean isDeclared() {
        return this.getDeclaration(false) != null;
    }

    private boolean isBoundMethodCandidate(AstNode exprParent, Expr parentExpr) {
        return exprParent instanceof ParenthesizedExpr && !(exprParent.getParentNode() instanceof KeywordStatement) || exprParent instanceof CommaSeparatedList || exprParent instanceof Initializer || exprParent instanceof AsExpr || exprParent instanceof BinaryOpExpr && exprParent.getClass().equals(BinaryOpExpr.class) || exprParent instanceof ObjectField || exprParent instanceof ReturnStatement || exprParent instanceof AssignmentOpExpr && ((AssignmentOpExpr)exprParent).getArg2() == parentExpr;
    }

    public String toString() {
        return this.getQualifiedNameStr();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ide ide1 = (Ide)o;
        return !(this.getIde() == null ? ide1.getIde() != null : !this.getIde().getText().equals(ide1.getIde().getText()));
    }

    public int hashCode() {
        int result = this.getIde() != null ? ((Object)((Object)this.getIde())).hashCode() : 0;
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }

    public void setIde(JooSymbol ide) {
        this.ide = ide;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
        if (bound) {
            this.scope.getCompilationUnit().addBuiltInIdentifierUsage("bind");
        }
    }

    public boolean isRewriteThis() {
        return this.rewriteThis;
    }

    void setRewriteThis(boolean rewriteThis) {
        this.rewriteThis = rewriteThis;
    }

    public static boolean isValidIdentifier(String identifier) {
        return IDE_PATTERN.matcher(identifier).matches();
    }

    public static void verifyIdentifier(String identifier, JooSymbol source) {
        if (!Ide.isValidIdentifier(identifier)) {
            throw JangarooParser.error(source, "invalid action script identifier");
        }
    }
}

