/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationsAndModifiers;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.types.ExpressionType;

public abstract class IdeDeclaration
extends Declaration {
    private static final Pattern PRIVATE_MEMBER_NAME = Pattern.compile("[^$]\\$[0-9]+$");
    private Ide ide;
    private ExpressionType type;
    private Set<IdeExpr> usages = new HashSet<IdeExpr>();

    protected IdeDeclaration(AnnotationsAndModifiers am, Ide ide) {
        super(am.getAnnotations(), IdeDeclaration.toSymbolArray(am.getModifiers()));
        this.setIde(ide);
        if (ide != null && PRIVATE_MEMBER_NAME.matcher(ide.getName()).matches()) {
            JangarooParser.warning(ide.getSymbol(), "Jangaroo identifier must not be an ActionScript identifier postfixed with a dollar sign ('$') followed by a number.");
        }
    }

    protected IdeDeclaration(Ide ide) {
        this(new AnnotationsAndModifiers(null, null), ide);
    }

    protected static JooSymbol[] toSymbolArray(List symbols) {
        return symbols.toArray(new JooSymbol[symbols.size()]);
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.ide);
    }

    public Ide getIde() {
        return this.ide;
    }

    @Override
    public JooSymbol getSymbol() {
        JooSymbol symbol = super.getSymbol();
        return symbol != null ? symbol : this.getDeclarationSymbol();
    }

    public JooSymbol getDeclarationSymbol() {
        return this.getIde().getSymbol();
    }

    public String getName() {
        return this.getIde() == null ? "" : this.getIde().getName();
    }

    public String[] getQualifiedName() {
        AstNode parentDeclaration = this.getParentDeclaration();
        if (!(parentDeclaration instanceof IdeDeclaration)) {
            return this.getIde() == null ? new String[]{} : this.getIde().getQualifiedName();
        }
        String[] prefixName = ((IdeDeclaration)parentDeclaration).getQualifiedName();
        String[] result = new String[prefixName.length + 1];
        System.arraycopy(prefixName, 0, result, 0, prefixName.length);
        result[prefixName.length] = this.getIde().getName();
        return result;
    }

    public String getTargetQualifiedNameStr() {
        Annotation nativeAnnotation = this.getAnnotation("Native");
        String targetName = null;
        boolean require = true;
        if (nativeAnnotation != null) {
            targetName = (String)nativeAnnotation.getPropertiesByName().get(null);
            if (!nativeAnnotation.getPropertiesByName().containsKey("require")) {
                require = false;
            }
        } else {
            Annotation renameAnnotation = this.getAnnotation("Rename");
            if (renameAnnotation != null) {
                targetName = (String)renameAnnotation.getPropertiesByName().get(null);
            }
        }
        if (targetName == null || targetName.isEmpty()) {
            targetName = this.getQualifiedNameStr();
        }
        return targetName;
    }

    public String getExtNamespaceRelativeTargetQualifiedNameStr() {
        String targetName = this.getTargetQualifiedNameStr();
        InputSource inputSource = this.getCompilationUnit().getInputSource();
        String extNamespace = inputSource.getExtNamespace();
        if (extNamespace != null && !extNamespace.isEmpty()) {
            if (targetName.equals(extNamespace)) {
                targetName = "";
            } else {
                if (!targetName.startsWith(extNamespace + ".")) {
                    throw JangarooParser.error("Source file fully-qualified name " + targetName + " does not start with configured extNamespace " + extNamespace);
                }
                targetName = targetName.substring(extNamespace.length() + 1);
            }
        }
        return targetName;
    }

    public String getQualifiedNameStr() {
        return QualifiedIde.constructQualifiedNameStr(this.getQualifiedName(), ".");
    }

    public ExpressionType getType() {
        return this.type;
    }

    void setType(ExpressionType type) {
        this.type = type;
    }

    @Override
    public void scope(Scope scope) {
        super.scope(scope);
        if (this.getIde() != null) {
            this.getIde().scope(scope);
            IdeDeclaration oldNode = scope.declareIde(this);
            if (oldNode != null) {
                this.handleDuplicateDeclaration(scope, oldNode);
            }
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.ide != null) {
            this.ide.analyze(this);
        }
    }

    void addUsage(IdeExpr usage) {
        if (!this.isPrimaryDeclaration() && !this.isClassMember()) {
            this.usages.add(usage);
        }
    }

    public Set<IdeExpr> getUsages() {
        return Collections.unmodifiableSet(this.usages);
    }

    public void handleDuplicateDeclaration(Scope scope, AstNode oldNode) {
        String msg = "Duplicate declaration of identifier '" + this.getName() + "'";
        if (!this.allowDuplicates(scope)) {
            throw JangarooParser.error(this.getSymbol(), msg);
        }
        JangarooParser.warning(this.getSymbol(), msg);
    }

    boolean allowDuplicates(Scope scope) {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public IdeDeclaration resolveDeclaration() {
        return null;
    }

    public String toString() {
        return this.getQualifiedNameStr();
    }

    public boolean isPrimaryDeclaration() {
        return this.getIde() != null && this.getIde().getScope() != null && this.getIde().getScope().getCompilationUnit() != null && this == this.getIde().getScope().getCompilationUnit().getPrimaryDeclaration();
    }

    public boolean isDeclaringCompileTimeConstant() {
        return false;
    }

    public void setIde(Ide ide) {
        this.ide = ide;
    }

    public PackageDeclaration getPackageDeclaration() {
        AstNode parentDeclaration = this.getParentDeclaration();
        return parentDeclaration instanceof IdeDeclaration ? ((IdeDeclaration)parentDeclaration).getPackageDeclaration() : null;
    }
}

