/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.OpExpr;
import net.jangaroo.utils.AS3Type;

public class BinaryOpExpr
extends OpExpr {
    private Expr arg1;
    private Expr arg2;

    public BinaryOpExpr(Expr arg1, JooSymbol op, Expr arg2) {
        super(op);
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.arg1, this.arg2);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitBinaryOpExpr(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getArg1().scope(scope);
        this.getArg2().scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.getArg1().analyze(this);
        this.getArg2().analyze(this);
        if (this.getOp().sym == 45) {
            if (this.getArg1().isOfAS3Type(AS3Type.STRING)) {
                this.setType(this.getArg1().getType());
            } else if (this.getArg2().isOfAS3Type(AS3Type.STRING)) {
                this.setType(this.getArg2().getType());
            }
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getArg1().getSymbol();
    }

    @Override
    public boolean isRuntimeConstant() {
        return this.getArg1().isRuntimeConstant() && this.getArg2().isRuntimeConstant();
    }

    @Override
    public boolean isCompileTimeConstant() {
        return this.getArg1().isCompileTimeConstant() && this.getArg2().isCompileTimeConstant();
    }

    @Override
    public boolean isStandAloneConstant() {
        return this.getArg1().isStandAloneConstant() && this.getArg2().isStandAloneConstant();
    }

    public Expr getArg1() {
        return this.arg1;
    }

    public Expr getArg2() {
        return this.arg2;
    }
}

