/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.util;

import java.io.IOException;
import java.io.Writer;

public class PositionTrackingWriter
extends Writer {
    private Writer delegate;
    private int line = 1;
    private int column = 1;

    public PositionTrackingWriter(Writer delegate) {
        super((Object)delegate);
        this.delegate = delegate;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.delegate.write(cbuf, off, len);
        for (int i = off; i < off + len; ++i) {
            char c = cbuf[i];
            if (c == '\n') {
                ++this.line;
                this.column = 1;
                continue;
            }
            ++this.column;
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

