/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.types;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.types.ExpressionType;

public class FunctionSignature
extends ExpressionType {
    private final MethodType methodType;
    private final int minArgumentCount;
    private final boolean hasRest;
    private final List<ExpressionType> parameterTypes;

    public FunctionSignature(@Nonnull TypeDeclaration functionType, MethodType methodType, int minArgumentCount, boolean hasRest, List<ExpressionType> parameterTypes, ExpressionType returnType) {
        super(functionType, returnType);
        this.methodType = methodType;
        this.minArgumentCount = minArgumentCount;
        this.hasRest = hasRest;
        this.parameterTypes = parameterTypes;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public int getMinArgumentCount() {
        return this.minArgumentCount;
    }

    public boolean hasRest() {
        return this.hasRest;
    }

    public List<ExpressionType> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public ExpressionType getEvalType() {
        return this.methodType == MethodType.SET ? this.parameterTypes.get(0) : (this.methodType == MethodType.GET ? this.getTypeParameter() : this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionSignature that = (FunctionSignature)o;
        return this.methodType == that.methodType && this.minArgumentCount == that.minArgumentCount && this.hasRest == that.hasRest && this.parameterTypes.equals(that.parameterTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.methodType, this.minArgumentCount, this.hasRest, this.parameterTypes});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.methodType != null) {
            sb.append(this.methodType.name().toLowerCase());
        }
        sb.append("(");
        boolean isFirst = true;
        for (ExpressionType parameterType : this.parameterTypes) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(FunctionSignature.toString(parameterType));
        }
        sb.append("):");
        sb.append(FunctionSignature.toString(this.getTypeParameter()));
        return sb.toString();
    }
}

