/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.jangaroo.jooc.mxml.ComponentPackageModel;

public class MxmlComponentRegistry {
    private Map<String, ComponentPackageModel> registry = new HashMap<String, ComponentPackageModel>();
    private Map<String, List<QName>> qNamesByClassName = new HashMap<String, List<QName>>();

    public void registerElement(String namespace, String localName, String classQName) {
        ComponentPackageModel componentPackageModel = this.registry.get(namespace);
        if (componentPackageModel == null) {
            componentPackageModel = new ComponentPackageModel(namespace);
            this.registry.put(namespace, componentPackageModel);
        }
        componentPackageModel.addElementToClassNameMapping(localName, classQName);
        List<QName> qNames = this.qNamesByClassName.get(classQName);
        if (qNames == null) {
            qNames = new ArrayList<QName>();
            this.qNamesByClassName.put(classQName, qNames);
        }
        qNames.add(new QName(namespace, localName));
    }

    public String getClassName(String namespace, String localName) {
        ComponentPackageModel componentPackageModel = this.registry.get(namespace);
        return componentPackageModel != null ? componentPackageModel.getClassName(localName) : null;
    }

    public void add(ComponentPackageModel componentPackageModel) {
        String namespace = componentPackageModel.getNamespace();
        for (Map.Entry<String, String> entry : componentPackageModel.entrySet()) {
            this.registerElement(namespace, entry.getKey(), entry.getValue());
        }
    }

    public Collection<ComponentPackageModel> getComponentPackageModels() {
        return this.registry.values();
    }

    public ComponentPackageModel getComponentPackageModel(String namespace) {
        return this.registry.get(namespace);
    }

    public List<QName> getQNamesByClassName(String className) {
        return this.qNamesByClassName.get(className);
    }
}

