/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.util.List;
import net.jangaroo.jooc.AbstractScope;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationsAndModifiers;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.Typed;
import net.jangaroo.jooc.types.ExpressionType;

public abstract class TypedIdeDeclaration
extends IdeDeclaration
implements Typed {
    private Ide namespace;
    private TypeRelation optTypeRelation;
    private Scope scope;

    TypedIdeDeclaration(AnnotationsAndModifiers am, Ide ide, TypeRelation optTypeRelation) {
        super(am, ide);
        this.namespace = this.findNamespace(am.getModifiers());
        this.optTypeRelation = optTypeRelation;
    }

    private Ide findNamespace(List<JooSymbol> modifiers) {
        for (JooSymbol modifier : modifiers) {
            if (this.getModifierFlag(modifier) != 512) continue;
            return new Ide(modifier);
        }
        return null;
    }

    public Ide getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isPublicApi() {
        return super.isPublicApi() || this.getNamespace() != null;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.optTypeRelation);
    }

    @Override
    public void scope(Scope scope) {
        this.scope = scope;
        if (this.namespace != null) {
            this.namespace.scope(scope);
        }
        if (this.getOptTypeRelation() != null) {
            this.getOptTypeRelation().scope(scope);
        }
        ClassDeclaration classDeclaration = scope.getClassDeclaration();
        super.scope(scope);
        if (this.isClassMember() && classDeclaration != null) {
            classDeclaration.registerMember(this);
        }
    }

    void addPublicApiDependencyOn(TypeRelation optTypeRelation) {
        if (optTypeRelation != null) {
            optTypeRelation.getType().getIde().addPublicApiDependency();
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.namespace != null) {
            this.namespace.analyze(this);
        }
        if (this.isPublicApi()) {
            if (this.namespace != null) {
                this.namespace.addPublicApiDependency();
            }
            this.addPublicApiDependencyOn(this.optTypeRelation);
        }
        if (this.optTypeRelation != null) {
            CompilationUnit arrayElementTypeCompilationUnit;
            TypeDeclaration arrayElementTypeInSuperTypes;
            this.optTypeRelation.analyze(this);
            if (this.isClassMember() && !this.isStatic() && this.getAnnotation("ArrayElementType") == null && "Array".equals(this.optTypeRelation.getType().getDeclaration().getQualifiedNameStr()) && (arrayElementTypeInSuperTypes = AbstractScope.findArrayElementTypeInSuperTypes(this)) != null && (arrayElementTypeCompilationUnit = arrayElementTypeInSuperTypes.getCompilationUnit()) != null) {
                this.scope.getCompilationUnit().addDependency(arrayElementTypeCompilationUnit, false);
            }
        }
        if (this.isBindable() && this.getClassDeclaration().isJavaScriptObject()) {
            this.scope.getCompiler().getLog().error((FilePosition)this.getSymbol(), "Members of a class inheriting from joo.JavaScriptObject must not be [Bindable].");
        }
    }

    @Override
    public ExpressionType getType() {
        ExpressionType type = super.getType();
        if (type == null && this.scope != null) {
            type = this.scope.getExpressionType(this);
            this.setType(type);
        }
        return type;
    }

    @Override
    boolean allowDuplicates(Scope scope) {
        return scope.getClassDeclaration() == null || super.allowDuplicates(scope);
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        return this.getOptTypeRelation() == null ? null : this.getOptTypeRelation().getType().resolveDeclaration();
    }

    @Override
    public TypeRelation getOptTypeRelation() {
        return this.optTypeRelation;
    }

    public boolean isMixinMemberRedeclaration() {
        Implements optImplements;
        if (this.isClassMember() && (this.getClassDeclaration() == null || !this.getClassDeclaration().isInterface() && this.getClassDeclaration().getAnnotation("Native") == null) && this.isNative() && !this.isPrivate() && !this.isStatic() && (optImplements = this.getClassDeclaration().getOptImplements()) != null) {
            String name = this.getIde().getName();
            String myQualifiedName = this.getClassDeclaration().getQualifiedNameStr();
            for (CommaSeparatedList<Ide> mixinCandidates = optImplements.getSuperTypes(); mixinCandidates != null; mixinCandidates = mixinCandidates.getTail()) {
                ClassDeclaration mixinCandidate = (ClassDeclaration)this.getIde().getScope().lookupDeclaration(mixinCandidates.getHead());
                Annotation mixinAnnotation = mixinCandidate.getAnnotation("Mixin");
                if (mixinAnnotation == null || myQualifiedName.equals(mixinAnnotation.getPropertiesByName().get(null)) || mixinCandidate.getMemberDeclaration(name) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExtConfigOrBindable() {
        return this.isBindable() || this.isExtConfig();
    }

    public boolean isExtConfig() {
        return this.getClassDeclaration() != null && this.getClassDeclaration().hasConfigClass() && this.isPublic() && this.isWritable() && !this.isStatic() && !this.isBindable();
    }

    public boolean isBindable() {
        return this.getAnnotation("Bindable") != null;
    }
}

