/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.utils.AS3Type;

public class LiteralExpr
extends Expr {
    private JooSymbol value;
    private Scope scope;

    public LiteralExpr(JooSymbol value) {
        this.value = value;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitLiteralExpr(this);
    }

    @Override
    public void scope(Scope scope) {
        this.scope = scope;
    }

    private AS3Type getLiteralType() {
        switch (this.getValue().sym) {
            case 95: {
                return AS3Type.INT;
            }
            case 96: {
                return AS3Type.NUMBER;
            }
            case 98: {
                return AS3Type.STRING;
            }
            case 97: {
                return AS3Type.BOOLEAN;
            }
            case 101: {
                return AS3Type.REG_EXP;
            }
            case 100: {
                return AS3Type.ANY;
            }
        }
        throw new IllegalStateException("Encountered LiteralExpr with sym " + (Object)((Object)this.getValue()));
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.setType(this.scope.getExpressionType(this.getLiteralType()));
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getValue();
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public boolean isCompileTimeConstant() {
        return true;
    }

    public JooSymbol getValue() {
        return this.value;
    }

    public LiteralExpr withStringValue(String newValue) {
        String quote = this.value.getJooValue() instanceof String ? this.value.getText().substring(0, 1) : "\"";
        LiteralExpr literalExpr = new LiteralExpr(new JooSymbol(this.value.sym, this.value.getFileName(), this.value.getLine(), this.value.getColumn(), this.value.getWhitespace(), quote + newValue + quote, newValue));
        literalExpr.scope(this.scope);
        return literalExpr;
    }
}

