/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationsAndModifiers;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.PropertyDeclaration;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.utils.AS3Type;

public class ClassDeclaration
extends TypeDeclaration {
    private static final String OBJECT_CLASSNAME = "Object";
    private JooSymbol symClass;
    private Extends optExtends;
    private Map<String, TypedIdeDeclaration> members = new LinkedHashMap<String, TypedIdeDeclaration>();
    private Map<String, TypedIdeDeclaration> staticMembers = new LinkedHashMap<String, TypedIdeDeclaration>();
    private ClassBody body;
    private FunctionDeclaration constructor = null;
    private Type thisType;
    private Type superType;
    private List<VariableDeclaration> fieldsWithInitializer = new ArrayList<VariableDeclaration>();
    private List<IdeDeclaration> secondaryDeclarations = Collections.emptyList();
    private String qualifiedNameHash;
    private List<ClassDeclaration> assignableClasses;
    private Implements optImplements;
    private Scope scope;
    private static final String BASE_64_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_$";

    public ClassDeclaration(AnnotationsAndModifiers am, JooSymbol cls, Ide ide, Extends ext, Implements impl, ClassBody body) {
        super(am, ide);
        this.symClass = cls;
        this.optExtends = ext;
        this.optImplements = impl;
        this.body = body;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.optExtends, this.optImplements, this.body);
    }

    @Override
    public JooSymbol getDeclarationSymbol() {
        return this.getSymClass();
    }

    public FunctionDeclaration getConstructor() {
        return this.constructor;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitClassDeclaration(this);
    }

    @Override
    protected int getAllowedModifiers() {
        return 895;
    }

    public boolean isInterface() {
        return "interface".equals(this.getSymClass().getText());
    }

    @Override
    public boolean isAbstract() {
        return this.isInterface() || super.isAbstract();
    }

    @Override
    public boolean isStatic() {
        return super.isStatic() || !this.isPrimaryDeclaration();
    }

    @Override
    public boolean isClassMember() {
        return super.isClassMember() || !this.isPrimaryDeclaration();
    }

    @Override
    public boolean isPrivate() {
        return super.isPrivate() || !this.isPrimaryDeclaration();
    }

    @Override
    public String getName() {
        return this.getIde().getName();
    }

    public void setConstructor(FunctionDeclaration methodDeclaration) {
        if (this.constructor != null) {
            throw JangarooParser.error(methodDeclaration, "Only one constructor allowed per class");
        }
        this.constructor = methodDeclaration;
    }

    public JooSymbol getSymClass() {
        return this.symClass;
    }

    public Extends getOptExtends() {
        return this.optExtends;
    }

    public Implements getOptImplements() {
        return this.optImplements;
    }

    public List<VariableDeclaration> getFieldsWithInitializer() {
        return this.fieldsWithInitializer;
    }

    public ClassBody getBody() {
        return this.body;
    }

    public List<IdeDeclaration> getSecondaryDeclarations() {
        return this.secondaryDeclarations;
    }

    public Map<String, TypedIdeDeclaration> getStaticMembers() {
        return this.staticMembers;
    }

    @Override
    public void scope(Scope scope) {
        this.scope = scope;
        super.scope(scope);
        this.thisType = new Type(new Ide(this.getIde().getSymbol()));
        this.fixDefaultSuperClass();
        this.superType = this.isInterface() || ClassDeclaration.isObject(this.getQualifiedNameStr()) ? null : new Type(this.getOptExtends() == null ? new Ide(OBJECT_CLASSNAME) : this.getOptExtends().getSuperClass());
        this.thisType.scope(scope);
        if (this.superType != null) {
            this.superType.scope(scope);
        }
        if (this.getOptImplements() != null) {
            this.getOptImplements().scope(scope);
        }
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            @Override
            public void run(final Scope staticScope) {
                ClassDeclaration.this.withNewDeclarationScope(ClassDeclaration.this, staticScope, new NodeImplBase.Scoped(){

                    @Override
                    public void run(Scope instanceScope) {
                        VariableDeclaration thisDeclaration = new VariableDeclaration(new JooSymbol("var"), new Ide("this"), new TypeRelation(null, ClassDeclaration.this.getThisType()));
                        thisDeclaration.scope(instanceScope);
                        if (instanceScope instanceof DeclarationScope) {
                            ((DeclarationScope)instanceScope).setIsInstanceScope(true);
                        }
                        ClassDeclaration.this.body.scope(staticScope, instanceScope);
                    }
                });
                for (IdeDeclaration secondaryDeclaration : ClassDeclaration.this.secondaryDeclarations) {
                    secondaryDeclaration.scope(staticScope);
                }
            }
        });
    }

    private void fixDefaultSuperClass() {
        if (this.optExtends == null && this.optImplements != null && "Plugin".equals(this.optImplements.getSuperTypes().getHead().getName())) {
            QualifiedIde extDotBase = new QualifiedIde(new Ide("ext"), new JooSymbol("."), new JooSymbol("Base"));
            new ImportDirective(null, (Ide)extDotBase, null).scope(this.scope.getParentScope());
            JooSymbol extendsSymbol = new JooSymbol(13, "<generated>", -1, -1, " ", "extends");
            this.optExtends = new Extends(extendsSymbol, extDotBase);
        }
    }

    @Override
    public void handleDuplicateDeclaration(Scope scope, AstNode oldNode) {
        if (!(oldNode instanceof ImportDirective)) {
            super.handleDuplicateDeclaration(scope, oldNode);
        }
    }

    public boolean implementsMoreThanOneInterface() {
        return this.getAnnotation("Native") == null && this.getOptImplements() != null && (!this.isInterface() && !this.isMixin() || this.getOptImplements().getSuperTypes().getTail() != null);
    }

    @Override
    public void analyze(AstNode parentNode) {
        this.analyzeSymModifiers();
        super.analyze(parentNode);
        if (this.getOptExtends() != null) {
            this.getOptExtends().analyze(this);
        } else if (this.superType != null) {
            new Extends(null, this.superType.getIde()).analyze(this);
        }
        if (this.getOptImplements() != null) {
            this.getOptImplements().analyze(this);
        }
        if (this.implementsMoreThanOneInterface()) {
            this.scope.getCompilationUnit().addBuiltInIdentifierUsage("mixin");
        }
        this.body.analyze(this);
        for (IdeDeclaration secondaryDeclaration : this.secondaryDeclarations) {
            secondaryDeclaration.analyze(this);
        }
    }

    private void analyzeSymModifiers() {
        if (this.isInterface()) {
            block3: for (JooSymbol symModifier : this.getSymModifiers()) {
                switch (symModifier.sym) {
                    case 23: 
                    case 29: {
                        continue block3;
                    }
                    default: {
                        throw JangarooParser.error(symModifier, "illegal modifier: " + symModifier.getText());
                    }
                }
            }
        }
    }

    public void registerMember(TypedIdeDeclaration memberDeclaration) {
        String name = memberDeclaration.getName();
        if (name.length() != 0) {
            FunctionDeclaration previousFunctionDeclaration;
            Map<String, TypedIdeDeclaration> targetMembers = memberDeclaration.isStatic() ? this.staticMembers : this.members;
            TypedIdeDeclaration previousDeclaration = targetMembers.get(name);
            if (previousDeclaration instanceof FunctionDeclaration && (previousFunctionDeclaration = (FunctionDeclaration)previousDeclaration).isGetterOrSetter() && (memberDeclaration = PropertyDeclaration.addDeclaration(previousFunctionDeclaration, memberDeclaration)) == null) {
                return;
            }
            targetMembers.put(name, memberDeclaration);
        }
    }

    @Override
    public TypedIdeDeclaration getMemberDeclaration(String memberName) {
        return this.members.get(memberName);
    }

    public Collection<TypedIdeDeclaration> getMembers() {
        return this.members.values();
    }

    public Collection<FunctionDeclaration> getMethods() {
        return FluentIterable.from(this.members.values()).transformAndConcat((Function)new Function<TypedIdeDeclaration, Iterable<FunctionDeclaration>>(){

            @Nullable
            public Iterable<FunctionDeclaration> apply(@Nullable TypedIdeDeclaration typedIdeDeclaration) {
                return typedIdeDeclaration instanceof FunctionDeclaration ? Collections.singleton((FunctionDeclaration)typedIdeDeclaration) : (typedIdeDeclaration instanceof PropertyDeclaration ? ((PropertyDeclaration)typedIdeDeclaration).getMethods() : Collections.emptyList());
            }
        }).toList();
    }

    @Override
    public TypedIdeDeclaration getStaticMemberDeclaration(String memberName) {
        return this.staticMembers.get(memberName);
    }

    public boolean isMixin() {
        if (this.isInterface()) {
            return this.getAnnotation("Mixin") != null;
        }
        return this.getMyMixinInterface() != null;
    }

    public ClassDeclaration getMyMixinInterface() {
        if (!this.isInterface() && this.getOptImplements() != null) {
            String myQualifiedName = this.getQualifiedNameStr();
            for (CommaSeparatedList<Ide> interfaces = this.getOptImplements().getSuperTypes(); interfaces != null; interfaces = interfaces.getTail()) {
                Ide oneInterface = interfaces.getHead();
                ClassDeclaration interfaceDeclaration = (ClassDeclaration)oneInterface.getScope().lookupDeclaration(oneInterface);
                Annotation mixinAnnotation = interfaceDeclaration.getAnnotation("Mixin");
                if (mixinAnnotation == null || !myQualifiedName.equals(mixinAnnotation.getPropertiesByName().get(null))) continue;
                return interfaceDeclaration;
            }
        }
        return null;
    }

    public ClassDeclaration getConfigClassDeclaration() {
        if ("ext.Base".equals(this.getQualifiedNameStr()) || this.isMixin()) {
            return this;
        }
        FunctionDeclaration constructor = this.getConstructor();
        if (constructor != null) {
            for (Parameters params = constructor.getParams(); params != null; params = params.getTail()) {
                TypeDeclaration declaration;
                Parameter param = (Parameter)params.getHead();
                if (!"config".equals(param.getName()) || param.getOptTypeRelation() == null || !this.equals(declaration = param.getOptTypeRelation().getType().getDeclaration()) && !this.equals(declaration.getSuperTypeDeclaration())) continue;
                return (ClassDeclaration)declaration;
            }
        }
        return null;
    }

    public boolean hasConfigClass() {
        return this.getConfigClassDeclaration() != null;
    }

    public boolean isSubclassOf(ClassDeclaration classDeclaration) {
        ClassDeclaration superTypeDeclaration = this.getSuperTypeDeclaration();
        return superTypeDeclaration != null && (superTypeDeclaration == classDeclaration || superTypeDeclaration.isSubclassOf(classDeclaration));
    }

    public boolean isJavaScriptObject() {
        for (ClassDeclaration classDeclaration = this; classDeclaration != null; classDeclaration = classDeclaration.getSuperTypeDeclaration()) {
            if (!"joo.JavaScriptObject".equals(classDeclaration.getQualifiedNameStr())) continue;
            return true;
        }
        return false;
    }

    public Type getThisType() {
        return this.thisType;
    }

    public Type getSuperType() {
        return this.superType;
    }

    public void setSecondaryDeclarations(List<IdeDeclaration> secondaryDeclarations) {
        this.secondaryDeclarations = secondaryDeclarations;
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        return null;
    }

    @Override
    public IdeDeclaration resolvePropertyDeclaration(String ide, boolean isStatic) {
        TypedIdeDeclaration declaration = null;
        FunctionDeclaration getterOrSetter = null;
        this.ensureAssignableClasses();
        for (ClassDeclaration classDecl : this.assignableClasses) {
            TypedIdeDeclaration typedIdeDeclaration = declaration = isStatic ? classDecl.getStaticMemberDeclaration(ide) : classDecl.getMemberDeclaration(ide);
            if (getterOrSetter == null) {
                if (declaration instanceof FunctionDeclaration && ((FunctionDeclaration)declaration).isGetterOrSetter()) {
                    getterOrSetter = (FunctionDeclaration)declaration;
                    declaration = null;
                }
            } else if (declaration != null) {
                declaration = PropertyDeclaration.addDeclaration(getterOrSetter, declaration);
            }
            if (declaration == null) continue;
            return declaration;
        }
        return getterOrSetter;
    }

    private void resolveAssignablesDeclaration1(ClassDeclaration classDecl, List<ClassDeclaration> result, Deque<ClassDeclaration> chain) {
        if (result.contains(classDecl)) {
            return;
        }
        result.add(classDecl);
        int chainSize = chain.size();
        chain.add(classDecl);
        IdeDeclaration superTypeDeclaration = null;
        if (!classDecl.isInterface()) {
            if (classDecl.getSuperType() != null) {
                superTypeDeclaration = classDecl.getSuperType().getIde().getDeclaration(false);
            }
        } else if (classDecl.getOptImplements() == null) {
            superTypeDeclaration = classDecl.getIde().getScope().getExpressionType(AS3Type.OBJECT).getDeclaration();
        }
        if (superTypeDeclaration != null) {
            this.resolveAssignablesInSuper(result, chain, superTypeDeclaration);
        }
        if (classDecl.getOptImplements() != null) {
            for (CommaSeparatedList<Ide> implemented = classDecl.getOptImplements().getSuperTypes(); implemented != null; implemented = implemented.getTail()) {
                this.resolveAssignablesInSuper(result, chain, implemented.getHead().getDeclaration(false));
            }
        }
        chain.removeLast();
        assert (chainSize == chain.size());
    }

    private void resolveAssignablesInSuper(List<ClassDeclaration> visited, Deque<ClassDeclaration> chain, IdeDeclaration superClassDecl) {
        if (superClassDecl != null) {
            if (!(superClassDecl instanceof ClassDeclaration)) {
                throw new CompilerError(superClassDecl.getSymbol(), "expected class identifier");
            }
            this.resolveAssignablesDeclaration1((ClassDeclaration)superClassDecl, visited, chain);
        }
    }

    public boolean isAssignableTo(ClassDeclaration classToCheck) {
        this.ensureAssignableClasses();
        boolean result = this.getQualifiedNameStr().equals(classToCheck.getQualifiedNameStr());
        Iterator<ClassDeclaration> iterator = this.assignableClasses.iterator();
        while (!result && iterator.hasNext()) {
            result = iterator.next().getQualifiedNameStr().equals(classToCheck.getQualifiedNameStr());
        }
        return result;
    }

    private void ensureAssignableClasses() {
        if (this.assignableClasses == null) {
            this.assignableClasses = new ArrayList<ClassDeclaration>();
            this.resolveAssignablesDeclaration1(this, this.assignableClasses, new LinkedList<ClassDeclaration>());
        }
    }

    public boolean notExtendsObject() {
        return this.superType != null && !ClassDeclaration.isObject(this.superType.getIde().getQualifiedNameStr());
    }

    public String getQualifiedNameHash() {
        if (this.qualifiedNameHash == null) {
            this.qualifiedNameHash = this.computeQualifiedNameHash();
        }
        return this.qualifiedNameHash;
    }

    private static String base64Char(int n) {
        int i = n & 0x3F;
        return BASE_64_CHARS.substring(i, i + 1);
    }

    private String computeQualifiedNameHash() {
        int hashCode = this.getTargetQualifiedNameStr().hashCode();
        return ClassDeclaration.base64Char(hashCode >>> 18) + ClassDeclaration.base64Char(hashCode >>> 12) + ClassDeclaration.base64Char(hashCode >>> 6) + ClassDeclaration.base64Char(hashCode);
    }

    @Override
    public ClassDeclaration getSuperTypeDeclaration() {
        return this.superType == null ? null : (ClassDeclaration)this.superType.getDeclaration();
    }

    public List<ClassDeclaration> getSuperTypeDeclarations() {
        Implements optImplements;
        ArrayList<ClassDeclaration> superTypeDeclarations = new ArrayList<ClassDeclaration>();
        if (this.getSuperTypeDeclaration() != null) {
            superTypeDeclarations.add(this.getSuperTypeDeclaration());
        }
        if ((optImplements = this.getOptImplements()) != null) {
            for (CommaSeparatedList<Ide> superTypes = optImplements.getSuperTypes(); superTypes != null; superTypes = superTypes.getTail()) {
                superTypeDeclarations.add((ClassDeclaration)this.getIde().getScope().lookupDeclaration(superTypes.getHead()));
            }
        }
        return superTypeDeclarations;
    }

    public void addFieldWithInitializer(VariableDeclaration fieldDeclaration) {
        this.fieldsWithInitializer.add(fieldDeclaration);
    }

    private static boolean isObject(String fullyQualifiedName) {
        return OBJECT_CLASSNAME.equals(fullyQualifiedName);
    }

    public boolean isObject() {
        return ClassDeclaration.isObject(this.getQualifiedNameStr());
    }
}

