/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.util.ArrayList;
import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.LabeledStatement;
import net.jangaroo.jooc.ast.LoopStatement;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.Statement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.Typed;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.types.ExpressionType;
import net.jangaroo.jooc.types.FunctionSignature;
import net.jangaroo.utils.AS3Type;

public abstract class AbstractScope
implements Scope {
    private Scope parent;

    public AbstractScope(Scope parent) {
        this.parent = parent;
    }

    @Override
    public Scope getParentScope() {
        return this.parent;
    }

    @Override
    public void addImport(ImportDirective importDirective) {
        this.mustBeInsideValueScope();
        this.parent.addImport(importDirective);
    }

    @Override
    public AstNode getDefiningNode() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getDefiningNode();
    }

    @Override
    public IdeDeclaration declareIde(IdeDeclaration decl) {
        this.mustBeInsideValueScope();
        return this.parent.declareIde(decl);
    }

    private void mustBeInsideValueScope() {
        if (this.parent == null) {
            throw new UnsupportedOperationException("this scope must be wrapped by a ValueScope");
        }
    }

    @Override
    public LabeledStatement lookupLabel(Ide ide) {
        if (this.parent == null) {
            throw JangarooParser.error(ide, "undeclared label '" + ide.getName() + "'");
        }
        return this.parent.lookupLabel(ide);
    }

    @Override
    public IdeDeclaration lookupDeclaration(Ide ide) {
        return this.lookupDeclaration(ide, true);
    }

    @Override
    public IdeDeclaration lookupDeclaration(Ide ide, boolean failOnAmbigousImport) {
        return this.parent == null ? null : this.parent.lookupDeclaration(ide, failOnAmbigousImport);
    }

    @Override
    public boolean isDeclared(Ide ide) {
        return this.parent != null && this.getParentScope().isDeclared(ide);
    }

    @Override
    public Ide findFreeAuxVar(String preferredName) {
        return this.parent == null ? null : this.parent.findFreeAuxVar(preferredName);
    }

    @Override
    public Ide createAuxVar(String preferredName) {
        return this.parent.createAuxVar(null);
    }

    @Override
    public LoopStatement getCurrentLoop() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCurrentLoop();
    }

    @Override
    public Statement getCurrentLoopOrSwitch() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCurrentLoopOrSwitch();
    }

    @Override
    public CompilationUnit getCompilationUnit() {
        return this.parent == null ? null : this.parent.getCompilationUnit();
    }

    @Override
    public PackageDeclaration getPackageDeclaration() {
        return this.parent == null ? null : this.parent.getPackageDeclaration();
    }

    @Override
    public ClassDeclaration getClassDeclaration() {
        return this.parent == null ? null : this.parent.getClassDeclaration();
    }

    @Override
    public DeclarationScope getPackageDeclarationScope() {
        return this.parent == null ? null : this.parent.getPackageDeclarationScope();
    }

    @Override
    public JangarooParser getCompiler() {
        return this.parent.getCompiler();
    }

    @Override
    public ClassDeclaration getClassDeclaration(String qname) {
        CompilationUnit compilationUnit = this.getCompiler().getCompilationUnit(qname);
        if (compilationUnit == null) {
            return null;
        }
        IdeDeclaration declaration = compilationUnit.getPrimaryDeclaration();
        return declaration instanceof ClassDeclaration ? (ClassDeclaration)declaration : null;
    }

    @Override
    public ExpressionType getExpressionType(AS3Type as3Type) {
        return this.getExpressionType(as3Type, null);
    }

    private ExpressionType getExpressionType(AS3Type as3Type, ExpressionType typeParameter) {
        return AS3Type.VOID.equals((Object)as3Type) || AS3Type.ANY.equals((Object)as3Type) ? null : new ExpressionType(this.getClassDeclaration(as3Type.name), typeParameter);
    }

    @Override
    public FunctionSignature getFunctionSignature(MethodType methodType, Parameters params, ExpressionType returnType) {
        ArrayList<ExpressionType> parameterTypes = new ArrayList<ExpressionType>();
        int minArgumentCount = 0;
        boolean hasRest = false;
        boolean optionalEncountered = false;
        for (Parameters current = params; current != null; current = current.getTail()) {
            Parameter parameter = (Parameter)current.getHead();
            if (hasRest) {
                this.getCompiler().getLog().error((FilePosition)parameter.getSymbol(), "rest (...) parameter may not be followed by more parameters.");
                break;
            }
            if (parameter.isRest()) {
                hasRest = true;
                continue;
            }
            parameterTypes.add(this.getExpressionType(parameter.getOptTypeRelation()));
            if (parameter.getOptInitializer() != null) {
                optionalEncountered = true;
                continue;
            }
            if (optionalEncountered) {
                this.getCompiler().getLog().error((FilePosition)parameter.getSymbol(), "all parameters following an optional parameter must also be optional.");
                continue;
            }
            ++minArgumentCount;
        }
        return new FunctionSignature(this.getClassDeclaration(AS3Type.FUNCTION.name), methodType, minArgumentCount, hasRest, parameterTypes, returnType);
    }

    @Override
    public ExpressionType getExpressionType(TypeRelation typeRelation) {
        return typeRelation == null || typeRelation.getType() == null ? null : this.getExpressionType(typeRelation.getType());
    }

    @Override
    public ExpressionType getExpressionType(IdeDeclaration declaration) {
        if (declaration instanceof TypeDeclaration) {
            return this.getExpressionType(AS3Type.CLASS, new ExpressionType((TypeDeclaration)declaration));
        }
        ExpressionType expressionType = null;
        if (declaration instanceof Typed) {
            TypeDeclaration typeDeclaration;
            TypeRelation typeRelation = ((Typed)((Object)declaration)).getOptTypeRelation();
            if (typeRelation != null && (expressionType = this.getExpressionType(typeRelation.getType())) != null && expressionType.getAS3Type() == AS3Type.ARRAY && (typeDeclaration = AbstractScope.findArrayElementType(declaration)) != null) {
                expressionType = new ExpressionType(typeRelation.getType().getDeclaration(), new ExpressionType(typeDeclaration));
            }
            ExpressionType ideType = expressionType;
            if (declaration instanceof FunctionDeclaration) {
                FunctionDeclaration functionDeclaration = (FunctionDeclaration)declaration;
                FunctionSignature functionSignature = this.getFunctionSignature(functionDeclaration.getMethodType(), functionDeclaration.getParams(), expressionType);
                expressionType = functionSignature;
                if (functionDeclaration.isSetter()) {
                    ideType = functionSignature.getParameterTypes().get(0);
                }
            }
            if (ideType != null && (declaration instanceof VariableDeclaration && this.hasInitializerWithConfigType((VariableDeclaration)declaration) || "config".equals(declaration.getIde().getName()))) {
                ideType.markAsConfigTypeIfPossible();
            }
        }
        return expressionType;
    }

    private boolean hasInitializerWithConfigType(VariableDeclaration declaration) {
        return declaration.getOptInitializer() != null && declaration.getOptInitializer().getValue().getType() != null && declaration.getOptInitializer().getValue().getType().isConfigType();
    }

    private ExpressionType getExpressionType(Type type) {
        return type != null ? new ExpressionType(type) : null;
    }

    private static TypeDeclaration findArrayElementType(IdeDeclaration declaration) {
        Annotation annotation = declaration.getAnnotation("ArrayElementType");
        Ide declarationIde = declaration.getIde();
        if (annotation == null) {
            if (declaration.isClassMember() && !declaration.isStatic() && declarationIde != null) {
                return AbstractScope.findArrayElementTypeInSuperTypes(declaration);
            }
        } else {
            JangarooParser compiler = declarationIde.getScope().getCompiler();
            CommaSeparatedList<AnnotationParameter> annotationParameters = annotation.getOptAnnotationParameters();
            if (annotationParameters == null) {
                compiler.getLog().error((FilePosition)declaration.getSymbol(), "[ArrayElementType] must provide a class reference.");
            } else {
                AnnotationParameter firstParameter = annotationParameters.getHead();
                Object elementType = firstParameter.getValue().getSymbol().getJooValue();
                if (elementType instanceof String) {
                    CompilationUnit compilationUnit = compiler.getCompilationUnit((String)elementType);
                    if (compilationUnit == null) {
                        compiler.getLog().error((FilePosition)firstParameter.getSymbol(), String.format("[ArrayElementType] class reference '%s' not found.", elementType));
                    } else {
                        IdeDeclaration primaryDeclaration = compilationUnit.getPrimaryDeclaration();
                        if (!(primaryDeclaration instanceof TypeDeclaration)) {
                            compiler.getLog().error((FilePosition)firstParameter.getSymbol(), String.format("[ArrayElementType] references '%s', which is not a class.", elementType));
                        } else {
                            return (TypeDeclaration)primaryDeclaration;
                        }
                    }
                }
            }
        }
        return null;
    }

    public static TypeDeclaration findArrayElementTypeInSuperTypes(IdeDeclaration declaration) {
        ClassDeclaration classDeclaration = declaration.getClassDeclaration();
        return classDeclaration != null ? AbstractScope.findArrayElementTypeInSuperTypes(declaration.getIde(), classDeclaration) : null;
    }

    private static TypeDeclaration findArrayElementTypeInSuperTypes(Ide declarationIde, ClassDeclaration classDeclaration) {
        String memberName = declarationIde.getName();
        for (ClassDeclaration superTypeDeclaration : classDeclaration.getSuperTypeDeclarations()) {
            TypeDeclaration superArrayElementType;
            TypedIdeDeclaration superDeclaration = superTypeDeclaration.getMemberDeclaration(memberName);
            if (superDeclaration != null && !superDeclaration.isPrivate() && (superArrayElementType = AbstractScope.findArrayElementType(superDeclaration)) != null) {
                return superArrayElementType;
            }
            superArrayElementType = AbstractScope.findArrayElementTypeInSuperTypes(declarationIde, superTypeDeclaration);
            if (superArrayElementType == null) continue;
            return superArrayElementType;
        }
        return null;
    }

    @Override
    public FunctionDeclaration getMethodDeclaration() {
        return this.parent == null ? null : this.parent.getMethodDeclaration();
    }

    @Override
    public FunctionExpr getFunctionExpr() {
        return this.parent == null ? null : this.parent.getFunctionExpr();
    }

    @Override
    public boolean isPackage(String fullyQualifiedName) {
        return this.parent != null && this.parent.isPackage(fullyQualifiedName);
    }
}

