/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.jooc.input.ZipEntryInputSource;
import net.jangaroo.jooc.input.ZipFileInputSource;

public class DependencyWarningsManager {
    private final List<DependencyWarning> dependencyWarnings = new ArrayList<DependencyWarning>();
    private final Map<String, Boolean> compileDependencies = new HashMap<String, Boolean>();

    public void loadInputSource(InputSource inputSource) {
        this.getCompileDependencies((PathInputSource)inputSource);
    }

    private void getCompileDependencies(PathInputSource classPathInputSource) {
        for (InputSource child : classPathInputSource.getChildren("")) {
            String key;
            if (!child.isInCompilePath() || (key = this.convertInputSourceToDependency(child)) == null) continue;
            this.compileDependencies.putIfAbsent(key, false);
        }
    }

    public String convertInputSourceToDependency(InputSource inputSource) {
        ZipFile zipFile;
        if (inputSource instanceof ZipFileInputSource) {
            zipFile = ((ZipFileInputSource)inputSource).getZipFile();
        } else if (inputSource instanceof ZipEntryInputSource) {
            zipFile = ((ZipEntryInputSource)inputSource).getZipFileInputSource().getZipFile();
        } else {
            return inputSource.getPath();
        }
        return this.handleZipFile(zipFile);
    }

    private String handleZipFile(ZipFile zipFile) {
        CompileDependency compileDependency = new CompileDependency();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ZipEntry zipEntry = null;
        while (entries.hasMoreElements()) {
            ZipEntry nextElement = entries.nextElement();
            if (!nextElement.getName().contains("META-INF/maven") || !nextElement.getName().contains("pom.properties")) continue;
            zipEntry = nextElement;
        }
        if (zipEntry != null) {
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while (bufferedReader.ready()) {
                    String line = bufferedReader.readLine();
                    this.setCompileDependency(compileDependency, line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return compileDependency.createString();
    }

    private void setCompileDependency(CompileDependency dependency, String line) {
        if (line.contains("artifactId")) {
            dependency.setArtifactId(line.replace("artifactId=", ""));
        } else if (line.contains("groupId")) {
            dependency.setGroupId(line.replace("groupId=", ""));
        } else if (line.contains("version")) {
            dependency.setVersion(line.replace("version=", ""));
        }
    }

    public void addDependencyWarning(String compileDependency, String usageName) {
        Optional<DependencyWarning> warning = this.dependencyWarnings.stream().filter(dependencyWarning -> dependencyWarning.matches(compileDependency)).findFirst();
        if (warning.isPresent()) {
            warning.get().addUsage(usageName);
        } else {
            this.dependencyWarnings.add(new DependencyWarning(compileDependency, usageName));
        }
    }

    public void updateUsedCompileDependencies(List<String> usedCompileDependencies) {
        for (String usedCompileDependency : usedCompileDependencies) {
            if (this.compileDependencies.containsKey(usedCompileDependency)) {
                this.compileDependencies.put(usedCompileDependency, true);
                continue;
            }
            if (this.compileDependencies.keySet().stream().anyMatch(usedCompileDependency::contains)) {
                this.compileDependencies.keySet().stream().filter(usedCompileDependency::contains).findFirst().ifPresent(dependency -> this.compileDependencies.put((String)dependency, true));
                continue;
            }
            this.compileDependencies.put(usedCompileDependency, true);
        }
    }

    public List<DependencyWarning> getDependencyWarnings() {
        return this.dependencyWarnings;
    }

    public List<String> getUnusedDeclaredDependencies() {
        return this.compileDependencies.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static class DependencyWarning {
        private final String dependency;
        private final Set<String> usages;

        public DependencyWarning(String dependency, String usage) {
            this.dependency = dependency;
            this.usages = new HashSet<String>();
            this.usages.add(usage);
        }

        public List<String> createUsedUndeclaredDependencyWarning(boolean isTestCompile) {
            CompileDependency compileDependency = new CompileDependency(this.dependency);
            if (compileDependency.getArtifactId() == null || compileDependency.getGroupId() == null || compileDependency.getVersion() == null) {
                return Collections.singletonList(this.dependency);
            }
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("<dependency>");
            lines.add(String.format("  <groupId>%s</groupId>", compileDependency.getGroupId()));
            lines.add(String.format("  <artifactId>%s</artifactId>", compileDependency.getArtifactId()));
            lines.add(String.format("  <version>%s</version>", compileDependency.getVersion()));
            lines.add("  <type>swc</type>");
            if (isTestCompile) {
                lines.add("  <scope>test</scope>");
            }
            lines.add("</dependency>");
            return lines;
        }

        public String getDependency() {
            return this.dependency;
        }

        public Set<String> getUsages() {
            return this.usages;
        }

        public boolean matches(String dependency) {
            return this.dependency.equals(dependency);
        }

        public void addUsage(String usage) {
            this.usages.add(usage);
        }
    }

    public static class CompileDependency {
        private String artifactId;
        private String groupId;
        private String version;

        public CompileDependency() {
        }

        public CompileDependency(String dependency) {
            String[] firstSplit = dependency.split("__");
            if (firstSplit.length == 2) {
                this.setGroupId(firstSplit[0]);
                String[] finalSplit = firstSplit[1].split(":");
                if (finalSplit.length == 2) {
                    this.setArtifactId(finalSplit[0]);
                    this.setVersion(finalSplit[1]);
                }
            }
        }

        public boolean matches(CompileDependency anotherDependency) {
            return this.artifactId.equals(anotherDependency.getGroupId()) && this.groupId.equals(anotherDependency.getArtifactId()) && this.version.equals(anotherDependency.getVersion());
        }

        public String createString() {
            return this.groupId + "__" + this.artifactId + ":" + this.version;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

