/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.ZipFileInputSource;

public class ZipEntryInputSource
implements InputSource {
    private ZipFileInputSource zipFileInputSource;
    private ZipEntry zipEntry;
    private String name;
    private String relativePath;

    public ZipEntryInputSource(ZipFileInputSource zipFileInputSource, ZipEntry zipEntry, String relativePath) {
        this.zipFileInputSource = zipFileInputSource;
        this.zipEntry = zipEntry;
        this.relativePath = relativePath;
        this.name = zipEntry.getName();
        int lastSlash = this.name.lastIndexOf(47);
        if (lastSlash >= 0) {
            this.name = this.name.substring(lastSlash + 1);
        }
    }

    @Override
    public boolean isInSourcePath() {
        return this.zipFileInputSource.isInSourcePath();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.zipFileInputSource.getPath() + "!" + this.zipEntry.getName();
    }

    @Override
    public InputSource getParent() {
        String path = this.getPath();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            return null;
        }
        String parentPath = path.substring(0, lastSlash);
        return this.zipFileInputSource.getChild(parentPath);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.zipFileInputSource.getZipFile().getInputStream(this.zipEntry);
    }

    @Override
    public boolean isDirectory() {
        return this.zipEntry.isDirectory();
    }

    public List<InputSource> list() {
        return this.zipFileInputSource.list(this);
    }

    @Override
    public InputSource getChild(String path) {
        if (path.startsWith("../")) {
            return this.getParent().getChild(path.substring(3));
        }
        String p = this.getRelativePath();
        if (!p.isEmpty()) {
            p = p + '/';
        }
        p = p + path;
        return this.zipFileInputSource.getChild(p);
    }

    @Override
    public List<InputSource> getChildren(String path) {
        return Collections.emptyList();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public void close() throws IOException {
        this.zipFileInputSource.close();
    }

    @Override
    public char getFileSeparatorChar() {
        return '/';
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipEntryInputSource that = (ZipEntryInputSource)o;
        if (!this.zipFileInputSource.equals(that.zipFileInputSource)) {
            return false;
        }
        return this.relativePath.equals(that.relativePath);
    }

    public int hashCode() {
        int result = this.zipFileInputSource.hashCode();
        result = 31 * result + this.relativePath.hashCode();
        return result;
    }
}

