/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.CompilationUnitRegistry;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitorBase;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.utils.CompilerUtils;

class EmbeddedAssetResolver
extends AstVisitorBase {
    private static final Collection<String> IMAGE_EXTENSIONS = Arrays.asList("png", "gif", "bmp", "jpg", "jpeg");
    private final CompilationUnit unit;
    private final CompilationUnitRegistry compilationUnitRegistry;

    EmbeddedAssetResolver(@Nonnull CompilationUnit unit, CompilationUnitRegistry compilationUnitRegistry) {
        this.unit = unit;
        this.compilationUnitRegistry = compilationUnitRegistry;
    }

    static String guessAssetType(String path) {
        String extension = CompilerUtils.extension((String)path);
        String assetType = "text";
        if (IMAGE_EXTENSIONS.contains(extension)) {
            assetType = "image";
        }
        return assetType;
    }

    @Override
    public void visitAnnotationParameter(AnnotationParameter annotationParameter) throws IOException {
        Annotation parentAnnotation;
        String metaName;
        AstNode value = annotationParameter.getValue();
        if (value != null && "Embed".equals(metaName = (parentAnnotation = annotationParameter.getParentAnnotation()).getMetaName()) && annotationParameter.getOptName() != null && "source".equals(annotationParameter.getOptName().getName())) {
            String path;
            JooSymbol valueSymbol = value.getSymbol();
            if (valueSymbol.sym != 98) {
                throw new CompilerError(valueSymbol, "The source parameter of an [Embed] annotation must be a string literal");
            }
            String text = valueSymbol.getText();
            String quote = text.substring(0, 1);
            String source = (String)valueSymbol.getJooValue();
            String string = path = source.startsWith("/") || source.startsWith("\\") ? source : new File(this.unit.getInputSource().getParent().getRelativePath(), source).getPath().replace('\\', '/');
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String assetType = EmbeddedAssetResolver.guessAssetType(path);
            this.unit.getResourceDependencies().add(assetType + "!" + path);
            if ("image".equals(assetType)) {
                this.unit.addDependency(this.compilationUnitRegistry.getCompilationUnit("flash.display.Bitmap"), false);
            }
            String absoluteSource = path;
            annotationParameter.setValue(new LiteralExpr(new JooSymbol(valueSymbol.sym, valueSymbol.getFileName(), valueSymbol.getLine(), valueSymbol.getColumn(), valueSymbol.getWhitespace(), quote + absoluteSource + quote, absoluteSource)));
        }
    }
}

