/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.KeywordStatement;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.TryStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;

public class Catch
extends KeywordStatement {
    private JooSymbol lParen;
    private Parameter param;
    private JooSymbol rParen;
    private BlockStatement block;
    private TryStatement parentNode;

    public Catch(JooSymbol symCatch, JooSymbol lParen, Parameter param, JooSymbol rParen, BlockStatement block) {
        super(symCatch);
        this.lParen = lParen;
        this.param = param;
        this.rParen = rParen;
        this.block = block;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.param, this.block);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitCatch(this);
    }

    public TryStatement getParentTryStatement() {
        return this.parentNode;
    }

    public JooSymbol getLParen() {
        return this.lParen;
    }

    public Parameter getParam() {
        return this.param;
    }

    public JooSymbol getRParen() {
        return this.rParen;
    }

    public BlockStatement getBlock() {
        return this.block;
    }

    public boolean hasCondition() {
        TypeRelation typeRelation = this.param.getOptTypeRelation();
        return typeRelation != null && typeRelation.getType().getSymbol().sym != 50;
    }

    @Override
    public void scope(Scope scope) {
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            @Override
            public void run(Scope scope) {
                Catch.this.param.scope(scope);
                Catch.this.block.scope(scope);
            }
        });
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (!(parentNode instanceof TryStatement)) {
            throw new IllegalArgumentException("the parent node of a catch block must be a try statement, but is " + parentNode);
        }
        this.parentNode = (TryStatement)parentNode;
        this.param.analyze(this);
        TypeRelation typeRelation = this.param.getOptTypeRelation();
        if (typeRelation != null) {
            Type type = typeRelation.getType();
            type.getIde().addExternalUsage(false);
        }
        this.block.analyze(this);
    }
}

