/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jangaroo.jooc.json.JsonObject;
import net.jangaroo.properties.model.Property;
import net.jangaroo.properties.model.ResourceBundleClass;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;

public class PropertiesClass {
    private static final Pattern RESOURCE_REFERENCE_PATTERN = Pattern.compile("^\\s*Resource\\s*\\(\\s*(key|bundle)\\s*=\\s*['\"]([^'\"]*)['\"]\\s*,\\s*(key|bundle)\\s*=\\s*['\"]([^'\"]*)['\"]\\s*\\)\\s*$");
    private static final String AS3_ANNOTATION_PATTERN = "(^|\\n)\\s*\\*\\s*(\\[[^]]*])";
    private static final String AS3_ANNOTATION_REPLACEMENT = "$1*/ $2 /*";
    private ResourceBundleClass resourceBundle;
    private Locale locale;
    private PropertiesConfiguration properties;

    public PropertiesClass(ResourceBundleClass resourceBundle, Locale locale, PropertiesConfiguration properties) {
        this.resourceBundle = resourceBundle;
        this.locale = locale;
        this.properties = properties;
    }

    public ResourceBundleClass getResourceBundle() {
        return this.resourceBundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getComment() {
        return this.adjustComment(this.properties.getLayout().getCanonicalHeaderComment(true));
    }

    public String getAs3Comment() {
        String comment = this.getComment();
        if (comment == null) {
            return null;
        }
        return comment.replaceAll(AS3_ANNOTATION_PATTERN, AS3_ANNOTATION_REPLACEMENT);
    }

    public List<Property> getProps() {
        return this.getProps(true, true);
    }

    private List<Property> getProps(boolean includeStrings, boolean includeReferences) {
        PropertiesConfigurationLayout layout = this.properties.getLayout();
        ArrayList<Property> props = new ArrayList<Property>();
        Iterator keys = this.properties.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = this.properties.getString(key);
            Matcher matcher = RESOURCE_REFERENCE_PATTERN.matcher(value);
            boolean valueIsResourceReference = matcher.find();
            if (valueIsResourceReference && includeReferences) {
                boolean bundleFirst = "bundle".equals(matcher.group(1));
                String referenceBundleKey = matcher.group(!bundleFirst ? 2 : 4);
                String referenceBundleFullClassName = matcher.group(bundleFirst ? 2 : 4);
                value = referenceBundleFullClassName + "_properties" + ".INSTANCE";
                value = JsonObject.isIdentifier(referenceBundleKey) ? value + "." + referenceBundleKey : value + "[\"" + referenceBundleKey + "\"]";
            }
            if (!(valueIsResourceReference ? includeReferences : includeStrings)) continue;
            props.add(new Property(this.adjustComment(layout.getCanonicalComment(key, true)), key, JsonObject.isIdentifier(key), value));
        }
        return props;
    }

    public List<Property> getStringProps() {
        return this.getProps(true, false);
    }

    public List<Property> getReferenceProps() {
        return this.getProps(false, true);
    }

    private String adjustComment(String comment) {
        if (comment == null) {
            return null;
        }
        return comment.replaceAll("(^|\\n)#", "$1 *").replaceAll("(^|\\n)#", "$1 *");
    }

    public Set<String> getImports() {
        HashSet<String> result = new HashSet<String>();
        Iterator keys = this.properties.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = this.properties.getString(key);
            Matcher matcher = RESOURCE_REFERENCE_PATTERN.matcher(value);
            if (!matcher.find()) continue;
            String bundle = "bundle".equals(matcher.group(1)) ? matcher.group(2) : matcher.group(4);
            String referenceBundleFullClassName = bundle + "_properties";
            result.add(referenceBundleFullClassName);
        }
        return result;
    }
}

