/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jangaroo.jooc.input.DirectoryInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.utils.BOMStripperInputStream;
import net.jangaroo.utils.CompilerUtils;

public class FileInputSource
extends DirectoryInputSource {
    private File sourceDir;
    private File file;
    private List<InputSource> children;

    public FileInputSource(File sourceDir, File file, boolean inSourcePath) {
        super(inSourcePath);
        this.sourceDir = sourceDir;
        this.file = file;
    }

    public FileInputSource(File file, boolean inSourcePath) {
        this(file, file, inSourcePath);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.isDirectory() ? super.getInputStream() : new BOMStripperInputStream((InputStream)new FileInputStream(this.file));
    }

    @Override
    public String getRelativePath() {
        try {
            return this.sourceDir == null ? this.file.getCanonicalPath() : (this.sourceDir.equals(this.file) ? "" : this.file.getCanonicalPath().substring(this.sourceDir.getCanonicalPath().length() + 1));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void close() {
    }

    public File getFile() {
        return this.file;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    @Override
    public char getFileSeparatorChar() {
        return File.separatorChar;
    }

    @Override
    public InputSource getParent() {
        return new FileInputSource(this.sourceDir, this.file.getParentFile(), this.isInSourcePath());
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public List<InputSource> list() {
        if (!this.isDirectory()) {
            throw new UnsupportedOperationException("list() not supported for non-directory input sources");
        }
        if (this.children == null) {
            this.children = new ArrayList<InputSource>();
            Object[] childFiles = this.file.listFiles();
            assert (childFiles != null);
            Arrays.sort(childFiles);
            for (Object childFile : childFiles) {
                this.children.add(new FileInputSource(this.sourceDir, (File)childFile, this.isInSourcePath()));
            }
        }
        return this.children;
    }

    @Override
    public FileInputSource getChild(String path) {
        if (path.length() == 0) {
            return this;
        }
        File sourceFile = new File(this.file, path);
        if (sourceFile.exists()) {
            String realPath;
            String string = realPath = this.file == null ? sourceFile.getPath() : CompilerUtils.getRelativePath((File)this.file, (File)sourceFile, (boolean)false);
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
                realPath = realPath.replace(File.separatorChar, '/');
            }
            if (path.equals(realPath)) {
                return new FileInputSource(this.sourceDir, sourceFile, this.isInSourcePath());
            }
        }
        return null;
    }

    @Override
    public List<InputSource> getChildren(String path) {
        FileInputSource child = this.isDirectory() ? this.getChild(path) : null;
        return child == null ? Collections.emptyList() : Collections.singletonList(child);
    }

    public String toString() {
        return this.file.getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileInputSource that = (FileInputSource)o;
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

