/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NamespaceDeclaration;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;

public class CompilationUnit
extends NodeImplBase {
    protected PackageDeclaration packageDeclaration;
    private JooSymbol lBrace;
    private List<Directive> directives;
    protected IdeDeclaration primaryDeclaration;
    private JooSymbol rBrace;
    private Map<String, Boolean> dependencies = new LinkedHashMap<String, Boolean>();
    private Set<String> dependenciesInModule = new LinkedHashSet<String>();
    private List<String> resourceDependencies = new ArrayList<String>();
    private Set<String> publicApiDependencies = new LinkedHashSet<String>();
    private Map<String, Boolean> usesDependencies = new LinkedHashMap<String, Boolean>();
    private Scope scope;
    private Map<String, String> auxVarsByPackage = new LinkedHashMap<String, String>();

    public CompilationUnit(PackageDeclaration packageDeclaration, JooSymbol lBrace, List<Directive> directives, IdeDeclaration primaryDeclaration, JooSymbol rBrace, List<IdeDeclaration> secondaryDeclarations) {
        this.packageDeclaration = packageDeclaration;
        this.lBrace = lBrace;
        this.directives = directives;
        this.primaryDeclaration = primaryDeclaration;
        if (primaryDeclaration instanceof ClassDeclaration) {
            ((ClassDeclaration)primaryDeclaration).setSecondaryDeclarations(secondaryDeclarations);
        }
        this.rBrace = rBrace;
    }

    public String getQualifiedNameStr() {
        return CompilerUtils.qName((String)this.getPackageDeclaration().getQualifiedNameStr(), (String)this.getPrimaryDeclaration().getName());
    }

    public boolean isClass() {
        return this.getPrimaryDeclaration() instanceof ClassDeclaration;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        ArrayList<AstNode> result = new ArrayList<AstNode>(this.makeChildren(super.getChildren(), this.packageDeclaration, this.directives, this.primaryDeclaration));
        if (this.primaryDeclaration instanceof ClassDeclaration) {
            result.addAll(((ClassDeclaration)this.primaryDeclaration).getSecondaryDeclarations());
        }
        return result;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitCompilationUnit(this);
    }

    private void addStarImport(Ide packageIde) {
        ImportDirective importDirective = new ImportDirective(packageIde, AS3Type.ANY.toString());
        this.directives.add(0, importDirective);
    }

    @Override
    public void scope(Scope scope) {
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            @Override
            public void run(Scope scope) {
                Ide packageIde = CompilationUnit.this.packageDeclaration.getIde();
                CompilationUnit.this.packageDeclaration.scope(scope);
                if (packageIde != null) {
                    CompilationUnit.this.addStarImport(packageIde);
                }
                CompilationUnit.this.addStarImport(null);
                for (AstNode astNode : CompilationUnit.this.getDirectives()) {
                    astNode.scope(scope);
                }
                CompilationUnit.this.withNewDeclarationScope(CompilationUnit.this.packageDeclaration, scope, new NodeImplBase.Scoped(){

                    @Override
                    public void run(Scope scope) {
                        CompilationUnit.this.scope = scope;
                        CompilationUnit.this.primaryDeclaration.scope(scope);
                    }
                });
            }
        });
    }

    public PackageDeclaration getPackageDeclaration() {
        return this.packageDeclaration;
    }

    public IdeDeclaration getPrimaryDeclaration() {
        return this.primaryDeclaration;
    }

    public JooSymbol getLBrace() {
        return this.lBrace;
    }

    public JooSymbol getRBrace() {
        return this.rBrace;
    }

    public List<String> getResourceDependencies() {
        return this.resourceDependencies;
    }

    public Set<String> getPublicApiDependencies() {
        return this.publicApiDependencies;
    }

    public Set<String> getTransitiveDependencies() {
        HashSet<String> transitiveDependencies = new HashSet<String>(this.dependencies.keySet());
        transitiveDependencies.addAll(this.usesDependencies.keySet());
        return transitiveDependencies;
    }

    public Set<String> getDependencies() {
        return this.dependencies.keySet();
    }

    public boolean isRequiredDependency(String qName) {
        return Boolean.TRUE.equals(this.usesDependencies.get(qName));
    }

    public Set<String> getDependenciesInModule() {
        return this.dependenciesInModule;
    }

    public InputSource getInputSource() {
        return this.scope.getCompiler().getInputSource(this);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.packageDeclaration.analyze(this);
        this.analyze(this.packageDeclaration, this.directives);
        this.primaryDeclaration.analyze(this);
    }

    public List<Annotation> getAnnotations() {
        return this.getPrimaryDeclaration().getAnnotations();
    }

    @Override
    public JooSymbol getSymbol() {
        return this.packageDeclaration.getSymbol();
    }

    public CompilationUnit mapMixinInterface(CompilationUnit compilationUnit) {
        Iterator<String> mixinClassNames;
        Annotation mixinAnnotation;
        if (compilationUnit != null && compilationUnit.getPrimaryDeclaration() instanceof ClassDeclaration && ((ClassDeclaration)compilationUnit.getPrimaryDeclaration()).isInterface() && (mixinAnnotation = compilationUnit.getPrimaryDeclaration().getAnnotation("Mixin")) != null && (mixinClassNames = this.getAnnotationDefaultParameterStringValues(mixinAnnotation).iterator()).hasNext()) {
            String mixinClassName = mixinClassNames.next();
            CompilationUnit mixinCompilationUnit = this.scope.getCompiler().getCompilationUnit(mixinClassName);
            if (mixinCompilationUnit == null) {
                throw Jooc.error(compilationUnit, "Mixin annotation refers to unresolvable class '" + mixinClassName + "'.");
            }
            return mixinCompilationUnit;
        }
        return compilationUnit;
    }

    public void addDependency(CompilationUnit otherUnit, boolean required) {
        if ((otherUnit = this.mapMixinInterface(otherUnit)) != null && otherUnit != this) {
            String qName = otherUnit.getPrimaryDeclaration().getQualifiedNameStr();
            boolean alreadyRequired = Boolean.TRUE.equals(this.usesDependencies.get(qName));
            boolean inModule = otherUnit.isInSourcePath();
            this.usesDependencies.put(qName, required || alreadyRequired || !inModule);
            if (Boolean.TRUE.equals(this.usesDependencies.get(qName))) {
                this.dependencies.put(qName, true);
            }
            if (inModule) {
                this.dependenciesInModule.add(qName);
            }
        }
    }

    private List<String> getAnnotationDefaultParameterStringValues(Annotation annotation) {
        ArrayList<String> values = new ArrayList<String>();
        for (CommaSeparatedList<AnnotationParameter> current = annotation.getOptAnnotationParameters(); current != null; current = current.getTail()) {
            LiteralExpr literal;
            Object jooValue;
            AstNode value;
            AnnotationParameter head = current.getHead();
            if (head.getOptName() != null || !((value = head.getValue()) instanceof LiteralExpr) || !((jooValue = (literal = (LiteralExpr)value).getSymbol().getJooValue()) instanceof String)) continue;
            values.add((String)jooValue);
        }
        return values;
    }

    public void addPublicApiDependency(CompilationUnit otherUnit) {
        String qname;
        IdeDeclaration otherUnitPrimaryDeclaration;
        if (otherUnit != null && otherUnit != this && ((otherUnitPrimaryDeclaration = otherUnit.getPrimaryDeclaration()) instanceof ClassDeclaration || otherUnitPrimaryDeclaration instanceof NamespaceDeclaration) && (qname = otherUnitPrimaryDeclaration.getQualifiedNameStr()).indexOf(46) != -1) {
            this.publicApiDependencies.add(qname);
        }
    }

    public String toString() {
        return "CompilationUnit{packageDeclaration=" + this.packageDeclaration + ", primaryDeclaration=" + this.primaryDeclaration + '}';
    }

    public boolean isInSourcePath() {
        return this.getInputSource().isInSourcePath();
    }
}

