/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.mxml.ast.XmlAttribute;
import net.jangaroo.jooc.mxml.ast.XmlTag;

public class XmlElement
extends NodeImplBase {
    private final List<XmlElement> elements = new LinkedList<XmlElement>();
    private final XmlTag openingMxmlTag;
    private final List children;
    private final XmlTag closingMxmlTag;
    private XmlElement parent;

    public XmlElement(@Nonnull XmlTag openingMxmlTag, @Nullable List children, @Nullable XmlTag closingMxmlTag) {
        this.openingMxmlTag = openingMxmlTag;
        this.children = children != null ? children : Collections.emptyList();
        this.closingMxmlTag = closingMxmlTag;
        this.initChildren();
        openingMxmlTag.setElement(this);
    }

    private void initChildren() {
        for (Object child : this.children) {
            if (!(child instanceof XmlElement)) continue;
            XmlElement xmlElement = (XmlElement)child;
            this.elements.add(xmlElement);
            xmlElement.parent = this;
        }
    }

    public String getName() {
        return this.openingMxmlTag.getLocalName();
    }

    public String getPrefix() {
        return this.openingMxmlTag.getPrefix();
    }

    @Override
    public JooSymbol getSymbol() {
        return this.openingMxmlTag.getSymbol();
    }

    @Override
    public List<? extends AstNode> getChildren() {
        Iterable filter = Iterables.filter((Iterable)this.children, AstNode.class);
        return Lists.newLinkedList((Iterable)filter);
    }

    List<JooSymbol> getTextNodes() {
        return Lists.newLinkedList((Iterable)Iterables.filter((Iterable)this.children, JooSymbol.class));
    }

    public List<XmlElement> getElements() {
        return this.elements;
    }

    @Override
    public void scope(Scope scope) {
    }

    @Override
    public void analyze(AstNode parentNode) {
    }

    @Override
    public AstNode getParentNode() {
        return null;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.openingMxmlTag);
        if (null != this.children) {
            for (Object child : this.children) {
                if (child instanceof JooSymbol) {
                    child = ((JooSymbol)((Object)child)).getSourceCode();
                }
                builder.append(child);
            }
        }
        if (null != this.closingMxmlTag) {
            builder.append(this.closingMxmlTag);
        }
        return builder.toString();
    }

    public List<XmlAttribute> getAttributes() {
        return this.openingMxmlTag.getAttributes();
    }

    @Nullable
    XmlAttribute getAttribute(String name) {
        return this.openingMxmlTag.getAttribute(name);
    }

    public String getLocalName() {
        return this.openingMxmlTag.getLocalName();
    }

    public String getNamespaceURI() {
        return this.getNamespaceUri(this.getPrefix());
    }

    String getNamespaceUri(@Nullable String prefix) {
        String localResult = this.openingMxmlTag.getNamespaceUri(prefix);
        if (null != localResult) {
            return localResult;
        }
        if (null != this.parent) {
            return this.parent.getNamespaceUri(prefix);
        }
        return null;
    }

    String getAttributeNS(String namespaceUri, String localName) {
        XmlAttribute attribute = this.openingMxmlTag.getAttribute(namespaceUri, localName);
        return null != attribute ? (String)attribute.getValue().getJooValue() : "";
    }
}

