/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.QualifiedIde;

public class NamespacedIde
extends Ide {
    private Ide namespace;
    private JooSymbol symNamespaceSep;
    private String qualifiedNameStr;

    public NamespacedIde(JooSymbol namespace, JooSymbol symNamespaceSep, JooSymbol symIde) {
        super(symIde);
        this.namespace = new Ide(namespace);
        this.symNamespaceSep = symNamespaceSep;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitNamespacedIde(this);
    }

    @Override
    public void analyze(AstNode parentNode) {
        if (this.namespace.getIde().sym == 99) {
            JangarooParser.warning(this.namespace.getSymbol(), "namespaces are not yet implemented, ignoring namespace " + this.namespace.getQualifiedNameStr());
        }
        super.analyze(parentNode);
    }

    @Override
    public String[] getQualifiedName() {
        return new String[]{this.namespace.getQualifiedNameStr(), this.getIde().getText()};
    }

    @Override
    public String getQualifiedNameStr() {
        if (null == this.qualifiedNameStr) {
            this.qualifiedNameStr = QualifiedIde.constructQualifiedNameStr(this.getQualifiedName(), "::");
        }
        return this.qualifiedNameStr;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.namespace.getSymbol();
    }

    public Ide getNamespace() {
        return this.namespace;
    }

    public JooSymbol getSymNamespaceSep() {
        return this.symNamespaceSep;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespacedIde that = (NamespacedIde)o;
        return this.namespace.getQualifiedNameStr().equals(that.namespace.getQualifiedNameStr());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.namespace.getQualifiedNameStr().hashCode();
        return result;
    }
}

