/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.input;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.jangaroo.jooc.input.DirectoryInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.ZipEntryInputSource;

public class ZipFileInputSource
extends DirectoryInputSource {
    private File file;
    private ZipFile zipFile;
    private String[] rootDirs;
    private Map<String, ZipEntryInputSource> entries = new LinkedHashMap<String, ZipEntryInputSource>();
    private Multimap<String, ZipEntryInputSource> entriesByParent = HashMultimap.create();

    public ZipFileInputSource(File file, String[] rootDirs, boolean inSourcePath) throws IOException {
        super(inSourcePath);
        this.file = file;
        this.zipFile = new ZipFile(file);
        this.rootDirs = (String[])rootDirs.clone();
        Enumeration<? extends ZipEntry> zipEntryEnum = this.zipFile.entries();
        while (zipEntryEnum.hasMoreElements()) {
            ZipEntry entry = zipEntryEnum.nextElement();
            String relativePath = this.getRelativePath(entry.getName());
            if (relativePath == null || this.entries.containsKey(relativePath)) continue;
            ZipEntryInputSource zipEntryInputSource = new ZipEntryInputSource(this, entry, relativePath);
            this.entries.put(relativePath, zipEntryInputSource);
            int slashPos = relativePath.lastIndexOf(47);
            String parent = relativePath.substring(0, slashPos + 1);
            this.entriesByParent.put((Object)this.removeTrailingSlash(parent), (Object)zipEntryInputSource);
        }
    }

    private String getRelativePath(String name) {
        String foundRoot = null;
        for (String rootDir : this.rootDirs) {
            if (!name.startsWith(rootDir) || foundRoot != null && foundRoot.length() >= rootDir.length()) continue;
            foundRoot = rootDir;
        }
        if (foundRoot == null) {
            return null;
        }
        String strippedName = name.substring(foundRoot.length());
        return this.removeTrailingSlash(strippedName);
    }

    private String removeTrailingSlash(String strippedName) {
        return strippedName.endsWith("/") ? strippedName.substring(0, strippedName.length() - 1) : strippedName;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getRelativePath() {
        return "";
    }

    public List<InputSource> list() {
        return this.list("");
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    @Override
    public char getFileSeparatorChar() {
        return '/';
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public InputSource getChild(String path) {
        return this.entries.get(path);
    }

    @Override
    public List<InputSource> getChildren(String path) {
        InputSource child = this.getChild(path);
        return child == null ? Collections.emptyList() : Collections.singletonList(child);
    }

    List<InputSource> list(ZipEntryInputSource dir) {
        if (!dir.isDirectory()) {
            throw new UnsupportedOperationException("list() is not supported for non-directory input sources");
        }
        return this.list(dir.getRelativePath());
    }

    private List<InputSource> list(String relativePath) {
        Collection zipEntryInputSources = this.entriesByParent.get((Object)this.removeTrailingSlash(relativePath));
        return zipEntryInputSources == null ? Collections.emptyList() : new ArrayList(zipEntryInputSources);
    }

    public String toString() {
        return this.zipFile.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipFileInputSource that = (ZipFileInputSource)o;
        if (!this.file.equals(that.file)) {
            return false;
        }
        return Arrays.equals(this.rootDirs, that.rootDirs);
    }

    public int hashCode() {
        int result = this.file.hashCode();
        result = 31 * result + Arrays.hashCode(this.rootDirs);
        return result;
    }
}

