/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstVisitorBase;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.types.ExpressionType;
import net.jangaroo.utils.AS3Type;

public class TypeChecker
extends AstVisitorBase {
    static final String ASSIGNED_EXPRESSION_ERROR_MESSAGE = "Assigned expression type %s is not assignable to type %s";
    static final String VARIABLE_DECLARATION_ERROR_MESSAGE = "Initializer type %s is not assignable to variable type %s";
    private CompileLog log;

    TypeChecker(CompileLog log) {
        this.log = log;
    }

    @Override
    public void visitAssignmentOpExpr(AssignmentOpExpr assignmentOpExpr) throws IOException {
        long opSym = assignmentOpExpr.getOp().sym;
        if (opSym == 77L) {
            return;
        }
        if (opSym == 78L || opSym == 75L || opSym == 74L) {
            return;
        }
        ExpressionType expected = assignmentOpExpr.getArg1().getType();
        this.validateTypes(assignmentOpExpr.getArg2().getSymbol(), expected, assignmentOpExpr.getArg2(), false);
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration variableDeclaration) throws IOException {
        if (variableDeclaration == null || variableDeclaration.getOptInitializer() == null) {
            return;
        }
        Expr actualExpression = variableDeclaration.getOptInitializer().getValue();
        ExpressionType expected = variableDeclaration.getIde().getScope().getExpressionType(variableDeclaration);
        this.validateTypes(actualExpression.getSymbol(), expected, actualExpression, true);
    }

    private void validateTypes(@Nonnull JooSymbol symbol, @Nullable ExpressionType expectedType, @Nonnull Expr actualExpression, boolean isDeclaration) {
        if (expectedType == null || AS3Type.ANY.equals((Object)expectedType.getAS3Type()) || AS3Type.BOOLEAN.equals((Object)expectedType.getAS3Type())) {
            return;
        }
        TypeDeclaration expectedTypeDeclaration = expectedType.getDeclaration();
        if (actualExpression.getType() == null) {
            if (expectedTypeDeclaration instanceof ClassDeclaration && !((ClassDeclaration)expectedTypeDeclaration).isObject()) {
                this.validateSimpleTypes(symbol, expectedType, actualExpression, isDeclaration);
            }
            return;
        }
        if (!actualExpression.getType().isAssignableTo(expectedType)) {
            this.logException(symbol, expectedTypeDeclaration.getQualifiedNameStr(), actualExpression.getType().getDeclaration().getQualifiedNameStr(), isDeclaration);
        }
    }

    private void validateSimpleTypes(JooSymbol symbol, ExpressionType expectedType, Expr actualExpression, boolean isDeclaration) {
        if (actualExpression.getSymbol().sym == 95 && !ExpressionType.isNumber(expectedType.getAS3Type())) {
            this.logException(symbol, expectedType, AS3Type.INT, isDeclaration);
        } else if (actualExpression.getSymbol().sym == 98 && !AS3Type.STRING.equals((Object)expectedType.getAS3Type())) {
            this.logException(symbol, expectedType, AS3Type.STRING, isDeclaration);
        }
    }

    private void logException(JooSymbol jooSymbol, ExpressionType expectedType, AS3Type actualType, boolean declaration) {
        String actualTypeString = actualType == null ? null : actualType.name;
        String expectedTypeString = expectedType == null ? null : expectedType.getDeclaration().getQualifiedNameStr();
        this.logException(jooSymbol, expectedTypeString, actualTypeString, declaration);
    }

    private void logException(JooSymbol jooSymbol, String expectedType, String actualType, boolean declaration) {
        String logMessage = declaration ? VARIABLE_DECLARATION_ERROR_MESSAGE : ASSIGNED_EXPRESSION_ERROR_MESSAGE;
        this.log.error((FilePosition)jooSymbol, String.format(logMessage, actualType, expectedType));
    }
}

