/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.mxml.MxmlParserHelper;
import net.jangaroo.jooc.mxml.ast.ClassDeclarationBuilder;
import net.jangaroo.jooc.mxml.ast.CompilationUnitUtils;
import net.jangaroo.jooc.mxml.ast.IsInitMethod;
import net.jangaroo.jooc.mxml.ast.IsNativeConstructor;
import net.jangaroo.jooc.mxml.ast.MxmlAstUtils;
import net.jangaroo.jooc.mxml.ast.MxmlToModelParser;
import net.jangaroo.jooc.mxml.ast.RootElementProcessor;
import net.jangaroo.jooc.mxml.ast.XmlElement;
import net.jangaroo.jooc.mxml.ast.XmlHeader;
import net.jangaroo.jooc.mxml.ast.XmlTag;
import net.jangaroo.utils.CompilerUtils;

public class MxmlCompilationUnit
extends CompilationUnit {
    static final String DEFAULTS = "defaults";
    static final String NET_JANGAROO_EXT_EXML = "net.jangaroo.ext.Exml";
    static final String APPLY = "apply";
    private final RootElementProcessor rootElementProcessor = new RootElementProcessor();
    private final IsNativeConstructor isNativeConstructor = new IsNativeConstructor(this);
    private final IsInitMethod isInitMethod = new IsInitMethod();
    private final Collection<String> importedSymbols = new HashSet<String>();
    private final InputSource source;
    private final XmlHeader optXmlHeader;
    private final XmlElement rootNode;
    private final MxmlParserHelper mxmlParserHelper;
    private final List<Directive> constructorBodyDirectives = new LinkedList<Directive>();
    private final List<Directive> classBodyDirectives = new LinkedList<Directive>();
    private final String classQName;
    private FunctionDeclaration initMethod;
    private Parameter constructorParam;
    private Scope constructorScope;
    private MxmlToModelParser mxmlToModelParser;
    private final Map<String, VariableDeclaration> classVariablesByName = new LinkedHashMap<String, VariableDeclaration>();

    public MxmlCompilationUnit(@Nonnull InputSource source, @Nullable XmlHeader optXmlHeader, @Nonnull XmlElement rootNode, @Nonnull MxmlParserHelper mxmlParserHelper) {
        super(null, MxmlAstUtils.SYM_LBRACE, new LinkedList<Directive>(), null, MxmlAstUtils.SYM_RBRACE, Collections.emptyList());
        this.source = source;
        this.optXmlHeader = optXmlHeader;
        this.rootNode = rootNode;
        this.mxmlParserHelper = mxmlParserHelper;
        this.classQName = CompilerUtils.qNameFromRelativePath((String)source.getRelativePath());
    }

    @Override
    public void scope(Scope scope) {
        VariableDeclaration variableDeclaration;
        this.packageDeclaration = this.mxmlParserHelper.parsePackageDeclaration(this.classQName);
        JangarooParser parser2 = scope.getCompiler();
        this.constructorScope = new DeclarationScope(this, null, parser2);
        this.mxmlToModelParser = new MxmlToModelParser(parser2, this.mxmlParserHelper, this);
        this.rootElementProcessor.process(this.rootNode);
        for (JooSymbol jooSymbol : this.rootElementProcessor.getImports()) {
            this.addImport(jooSymbol);
        }
        ClassDeclaration classDeclaration = new ClassDeclarationBuilder(parser2, this.mxmlParserHelper, this).build();
        this.primaryDeclaration = classDeclaration;
        Ide superClassIde = classDeclaration.getOptExtends().getSuperClass();
        this.addImport(superClassIde);
        Implements impl = classDeclaration.getOptImplements();
        if (null != impl) {
            Iterator<Directive> superTypes = impl.getSuperTypes();
            for (AstNode superType : ((CommaSeparatedList)((Object)superTypes)).getChildren()) {
                if (!(superType instanceof Ide)) continue;
                this.addImport((Ide)superType);
            }
        }
        for (JooSymbol jooSymbol : this.rootElementProcessor.getMetadata()) {
            List<Annotation> annotations = this.mxmlParserHelper.parseMetadata(jooSymbol);
            if (null == annotations) continue;
            this.primaryDeclaration.getAnnotations().addAll(annotations);
        }
        for (Directive directive : this.classBodyDirectives) {
            if (!(directive instanceof VariableDeclaration)) continue;
            variableDeclaration = (VariableDeclaration)directive;
            this.classVariablesByName.put(variableDeclaration.getName(), variableDeclaration);
        }
        this.preProcessClassBodyDirectives();
        Ide superConfigVar = null;
        if (CompilationUnitUtils.constructorSupportsConfigOptionsParameter(superClassIde.getQualifiedNameStr(), parser2)) {
            superConfigVar = this.createAuxVar("config");
            Ide primaryDeclaration = classDeclaration.getOptExtends().getSuperClass();
            variableDeclaration = MxmlAstUtils.createVariableDeclaration(superConfigVar, primaryDeclaration);
            this.constructorBodyDirectives.add(variableDeclaration);
        }
        if (null == this.constructorParam || null == superConfigVar) {
            this.createFields(superConfigVar);
        } else {
            Ide defaultsConfigVar = this.createAuxVar(DEFAULTS);
            Ide primaryDeclaration = this.getPrimaryDeclaration().getIde();
            VariableDeclaration variableDeclaration2 = MxmlAstUtils.createVariableDeclaration(defaultsConfigVar, primaryDeclaration);
            this.constructorBodyDirectives.add(variableDeclaration2);
            this.createFields(defaultsConfigVar);
            ImportDirective importDirective = this.mxmlParserHelper.parseImport(NET_JANGAROO_EXT_EXML);
            this.getDirectives().add(importDirective);
            Ide exml = this.mxmlParserHelper.parseIde(" net.jangaroo.ext.Exml");
            CommaSeparatedList<Expr> exprCommaSeparatedList = new CommaSeparatedList<Expr>(new IdeExpr(defaultsConfigVar), MxmlAstUtils.SYM_COMMA, new CommaSeparatedList<IdeExpr>(new IdeExpr(this.constructorParam.getIde())));
            ApplyExpr applyExpr = new ApplyExpr(new DotExpr(new IdeExpr(exml), MxmlAstUtils.SYM_DOT, new Ide(new JooSymbol(APPLY))), MxmlAstUtils.SYM_LPAREN, exprCommaSeparatedList, MxmlAstUtils.SYM_RPAREN);
            IdeExpr config = new IdeExpr(this.constructorParam.getIde().getSymbol().withWhitespace("\n    "));
            AssignmentOpExpr assignmentOpExpr = new AssignmentOpExpr(config, MxmlAstUtils.SYM_EQ.withWhitespace(" "), applyExpr);
            this.constructorBodyDirectives.add(MxmlAstUtils.createSemicolonTerminatedStatement(assignmentOpExpr));
        }
        this.mxmlToModelParser.processAttributesAndChildNodes(this.rootNode, superConfigVar, new Ide("this"), superConfigVar != null);
        this.constructorBodyDirectives.addAll(this.mxmlToModelParser.getConstructorBodyDirectives());
        this.classBodyDirectives.addAll(this.mxmlToModelParser.getClassBodyDirectives());
        if (null != this.constructorParam && null != superConfigVar) {
            CommaSeparatedList<Expr> exprCommaSeparatedList = new CommaSeparatedList<Expr>(new IdeExpr(superConfigVar), MxmlAstUtils.SYM_COMMA, new CommaSeparatedList<IdeExpr>(new IdeExpr(this.constructorParam.getIde())));
            Ide exml = this.mxmlParserHelper.parseIde("\n    net.jangaroo.ext.Exml");
            ApplyExpr applyExpr = new ApplyExpr(new DotExpr(new IdeExpr(exml), MxmlAstUtils.SYM_DOT, new Ide(new JooSymbol(APPLY))), MxmlAstUtils.SYM_LPAREN, exprCommaSeparatedList, MxmlAstUtils.SYM_RPAREN);
            this.constructorBodyDirectives.add(MxmlAstUtils.createSemicolonTerminatedStatement(applyExpr));
            this.constructorBodyDirectives.add(MxmlAstUtils.createSuperConstructorCall(superConfigVar));
        }
        this.postProcessClassBodyDirectives();
        super.scope(scope);
    }

    Ide createAuxVar(String name) {
        return this.constructorScope.createAuxVar(name);
    }

    void preProcessClassBodyDirectives() {
        Directive directive;
        boolean hasNativeConstructor = false;
        for (int i = 0; i < this.classBodyDirectives.size(); ++i) {
            directive = this.classBodyDirectives.get(i);
            if (this.isNativeConstructor.apply(directive)) {
                hasNativeConstructor = true;
                FunctionDeclaration constructor = MxmlAstUtils.createConstructor((FunctionDeclaration)directive, this.constructorBodyDirectives);
                Parameters params = constructor.getParams();
                if (null != params) {
                    this.constructorParam = (Parameter)params.getHead();
                }
                this.classBodyDirectives.set(i, constructor);
                continue;
            }
            if (!this.isInitMethod.apply(directive)) continue;
            this.initMethod = (FunctionDeclaration)directive;
        }
        if (!hasNativeConstructor) {
            this.classBodyDirectives.add(MxmlAstUtils.createConstructor(this.primaryDeclaration.getIde(), this.constructorBodyDirectives));
        } else if (null != this.constructorParam) {
            Iterator<Directive> iterator = this.classBodyDirectives.iterator();
            while (iterator.hasNext()) {
                IdeDeclaration declaration;
                directive = iterator.next();
                if (!(directive instanceof IdeDeclaration) || !(declaration = (IdeDeclaration)directive).isPrivate() || !this.constructorParam.getName().equals(declaration.getName())) continue;
                iterator.remove();
                break;
            }
        }
        if (null != this.initMethod) {
            CommaSeparatedList<Expr> args = null;
            if (null != this.constructorParam) {
                args = new CommaSeparatedList<Expr>(new IdeExpr(this.constructorParam.getIde()));
            }
            DotExpr initFunctionInvocation = new DotExpr(new IdeExpr(new Ide(MxmlAstUtils.SYM_THIS)), MxmlAstUtils.SYM_DOT, new Ide(this.initMethod.getIde().getSymbol().withoutWhitespace()));
            SemicolonTerminatedStatement directive2 = MxmlAstUtils.createSemicolonTerminatedStatement(new ApplyExpr(initFunctionInvocation, this.initMethod.getFun().getLParen(), args, this.initMethod.getFun().getRParen()));
            this.constructorBodyDirectives.add(directive2);
        }
    }

    void postProcessClassBodyDirectives() {
        for (Directive directive : this.classBodyDirectives) {
            directive.setClassMember(true);
        }
    }

    void createFields(@Nullable Ide targetIde) {
        for (XmlElement declaration : this.rootElementProcessor.getDeclarations()) {
            this.mxmlToModelParser.createValueCodeFromElement(targetIde, declaration, null);
        }
        Collection<Directive> directives = this.mxmlToModelParser.getConstructorBodyDirectives();
        this.constructorBodyDirectives.addAll(directives);
        directives.clear();
    }

    List<Directive> getClassBodyDirectives() {
        return this.classBodyDirectives;
    }

    @Override
    public String getQualifiedNameStr() {
        return this.classQName;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    XmlTag getOptXmlHeader() {
        return this.optXmlHeader;
    }

    XmlElement getRootNode() {
        return this.rootNode;
    }

    RootElementProcessor getRootElementProcessor() {
        return this.rootElementProcessor;
    }

    @Override
    public InputSource getInputSource() {
        return this.source;
    }

    private void addImport(Ide classIde) {
        if (this.isNotYetImported(classIde)) {
            ImportDirective directive = MxmlAstUtils.createImport(classIde);
            this.getDirectives().add(directive);
        }
    }

    private boolean isNotYetImported(Ide classIde) {
        Ide qualifier = classIde.getQualifier();
        return qualifier != null && !this.importedSymbols.contains(qualifier.getQualifiedNameStr() + ".*") && this.importedSymbols.add(classIde.getQualifiedNameStr());
    }

    void addImport(@Nonnull JooSymbol symbol) {
        ImportDirective directive;
        String jooValue = (String)symbol.getJooValue();
        if (!this.importedSymbols.contains(jooValue) && null != (directive = this.mxmlParserHelper.parseImport(symbol)) && this.isNotYetImported(directive.getIde())) {
            this.getDirectives().add(directive);
        }
    }

    @Nullable
    public Ide addImport(@Nonnull String classQName) {
        ImportDirective importDirective;
        Ide ide = null;
        if (classQName.contains(".") && null != (importDirective = this.mxmlParserHelper.parseImport(classQName)) && this.isNotYetImported(ide = importDirective.getIde())) {
            this.getDirectives().add(importDirective);
        }
        return ide;
    }

    @Nonnull
    public Map<String, VariableDeclaration> getVariables() {
        return this.classVariablesByName;
    }

    @Nullable
    public String getConstructorParamName() {
        return null != this.constructorParam ? this.constructorParam.getName() : null;
    }
}

