/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.Statement;

public class SuperConstructorCallStatement
extends Statement {
    private Expr fun;
    private ParenthesizedExpr<CommaSeparatedList<Expr>> args;
    private JooSymbol symSemicolon;
    private ClassDeclaration classDeclaration;

    public SuperConstructorCallStatement(JooSymbol symSuper, JooSymbol lParen, CommaSeparatedList<Expr> args, JooSymbol rParen, JooSymbol symSemicolon) {
        this.fun = new IdeExpr(symSuper);
        this.args = new ParenthesizedExpr<CommaSeparatedList<Expr>>(lParen, args, rParen);
        this.symSemicolon = symSemicolon;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.fun, this.args);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitSuperConstructorCallStatement(this);
    }

    @Override
    public void scope(Scope scope) {
        FunctionDeclaration method = scope.getMethodDeclaration();
        if (method == null || !method.isConstructor()) {
            throw JangarooParser.error(this.getSymbol(), "must only call super constructor from constructor method");
        }
        if (method.containsSuperConstructorCall()) {
            throw JangarooParser.error(this.getSymbol(), "must not call super constructor twice");
        }
        method.setContainsSuperConstructorCall(true);
        this.getFun().scope(scope);
        if (this.getArgs() != null) {
            this.getArgs().scope(scope);
        }
        this.setClassDeclaration(scope.getClassDeclaration());
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.getFun().analyze(this);
        if (this.getArgs() != null) {
            this.getArgs().analyze(this);
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getFun().getSymbol();
    }

    public Expr getFun() {
        return this.fun;
    }

    public ParenthesizedExpr<CommaSeparatedList<Expr>> getArgs() {
        return this.args;
    }

    public JooSymbol getSymSemicolon() {
        return this.symSemicolon;
    }

    public ClassDeclaration getClassDeclaration() {
        return this.classDeclaration;
    }

    public void setClassDeclaration(ClassDeclaration classDeclaration) {
        this.classDeclaration = classDeclaration;
    }
}

