/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import net.jangaroo.jooc.Dependency;
import net.jangaroo.jooc.DependencyLevel;
import net.jangaroo.jooc.ast.AstVisitorBase;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.TransitiveAstVisitor;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;

class StaticDependencyVisitor
extends TransitiveAstVisitor {
    private final CompilationUnit compilationUnit;
    private final Multimap<FunctionDeclaration, FunctionDeclaration> internalUses = HashMultimap.create();
    private final Multimap<FunctionDeclaration, Dependency> nonFunctionUses = HashMultimap.create();
    private FunctionDeclaration currentDeclaration = null;

    public StaticDependencyVisitor(CompilationUnit compilationUnit) {
        super(new AstVisitorBase());
        this.compilationUnit = compilationUnit;
    }

    public Multimap<FunctionDeclaration, FunctionDeclaration> getInternalUses() {
        return this.internalUses;
    }

    public Multimap<FunctionDeclaration, Dependency> getNonFunctionUses() {
        return this.nonFunctionUses;
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) throws IOException {
        if (functionDeclaration.isStatic()) {
            this.currentDeclaration = functionDeclaration;
            super.visitFunctionDeclaration(functionDeclaration);
            this.currentDeclaration = null;
        }
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration variableDeclaration) throws IOException {
        if (variableDeclaration.isStatic() || this.compilationUnit.getPrimaryDeclaration() instanceof VariableDeclaration) {
            super.visitVariableDeclaration(variableDeclaration);
        }
    }

    private void declarationReferenced(IdeDeclaration ideDeclaration, boolean isNew) {
        CompilationUnit ideCompilationUnit;
        if (ideDeclaration != null && (ideCompilationUnit = ideDeclaration.getCompilationUnit()) != null && ideCompilationUnit.isInSourcePath()) {
            if (isNew) {
                this.constructorReferenced(ideDeclaration);
            } else if (!ideCompilationUnit.getPrimaryDeclaration().getQualifiedNameStr().equals(this.compilationUnit.getPrimaryDeclaration().getQualifiedNameStr())) {
                this.otherCompilationUnitReferenced(ideDeclaration);
            } else if (ideDeclaration instanceof FunctionDeclaration) {
                this.ownFunctionReferenced((FunctionDeclaration)ideDeclaration);
            }
        }
    }

    private void ownFunctionReferenced(FunctionDeclaration functionDeclaration) {
        if (functionDeclaration.isMethod() && functionDeclaration.isStatic()) {
            this.internalUses.put((Object)this.currentDeclaration, (Object)functionDeclaration);
        }
    }

    private void otherCompilationUnitReferenced(IdeDeclaration ideDeclaration) {
        if (ideDeclaration.isStatic() || ideDeclaration instanceof ClassDeclaration) {
            this.nonFunctionUses.put((Object)this.currentDeclaration, (Object)new Dependency(ideDeclaration.getCompilationUnit(), DependencyLevel.STATIC));
        }
    }

    private void constructorReferenced(IdeDeclaration ideDeclaration) {
        this.nonFunctionUses.put((Object)this.currentDeclaration, (Object)new Dependency(ideDeclaration.getCompilationUnit(), DependencyLevel.DYNAMIC));
    }

    @Override
    public void visitIdeExpression(IdeExpr ideExpr) throws IOException {
        Expr normalizedExpr = ideExpr.getNormalizedExpr();
        if (normalizedExpr != ideExpr) {
            normalizedExpr.visit(this);
        } else {
            this.declarationReferenced(ideExpr.getIde().getDeclaration(false), ideExpr.getParentNode() instanceof NewExpr);
        }
    }

    @Override
    public void visitDotExpr(DotExpr dotExpr) throws IOException {
        TypedIdeDeclaration staticMemberDeclaration;
        IdeDeclaration argDeclaration;
        boolean isNew = dotExpr.getParentNode() instanceof NewExpr;
        Ide ide = dotExpr.getIde();
        this.declarationReferenced(ide.getDeclaration(false), isNew);
        Expr arg = dotExpr.getArg();
        arg.visit(this);
        if (arg instanceof IdeExpr && (argDeclaration = ((IdeExpr)arg).getIde().getDeclaration(false)) instanceof ClassDeclaration && (staticMemberDeclaration = ((ClassDeclaration)argDeclaration).getStaticMemberDeclaration(ide.getName())) != null) {
            this.declarationReferenced(staticMemberDeclaration, isNew);
        }
    }

    @Override
    public void visitQualifiedIde(QualifiedIde qualifiedIde) throws IOException {
        this.visitIde(qualifiedIde);
    }
}

