/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import net.jangaroo.jooc.DependencyLevel;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.utils.CompilerUtils;

class Dependency {
    private String compilationUnitId;
    private final String name;
    private DependencyLevel level;

    public Dependency(String compilationUnitId, DependencyLevel level) {
        this.compilationUnitId = compilationUnitId;
        this.name = CompilerUtils.className((String)compilationUnitId);
        this.level = level;
    }

    public Dependency(CompilationUnit compilationUnit, DependencyLevel level) {
        this.compilationUnitId = Dependency.getCompilationUnitId(compilationUnit);
        this.name = compilationUnit.getPrimaryDeclaration().getIde().getIde().getText();
        this.level = level;
    }

    static String getCompilationUnitId(CompilationUnit compilationUnit) {
        return compilationUnit.getPrimaryDeclaration().getQualifiedNameStr();
    }

    public String getCompilationUnitId() {
        return this.compilationUnitId;
    }

    public String getCompilationUnitName() {
        return this.name;
    }

    public DependencyLevel getLevel() {
        return this.level;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency dependency = (Dependency)o;
        if (this.level != dependency.level) {
            return false;
        }
        return this.compilationUnitId.equals(dependency.compilationUnitId);
    }

    public int hashCode() {
        int result = this.compilationUnitId.hashCode();
        result = 31 * result + this.level.hashCode();
        return result;
    }

    public String toString() {
        return this.name + this.level.suffix;
    }
}

