/* The following code was generated by JFlex 1.4.3 on 9/20/17 7:41 PM */

/*
 * Copyright 2008-2010 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/*
 * JangarooScript lexical scanner definition for the JFlex scanner generator
 *
 * Author: Andreas Gawecki
 */

/*
From http://livedocs.adobe.com/specs/actionscript/3/as3_specification118.html:

13.1 Lexical

Lexical keywords are removed from the available program namespace during scanning. It is a syntax error to use any of
these names except as indicated by the grammar. Syntactic keywords appear to the lexical scanner as identifier tokens,
but are given special meaning in certain contexts by the parser.

The following list contains all keywords:

as break case catch class const continue default delete do else extends false finally for function if implements import
in instanceof interface internal is new null package private protected public return super switch this throw
true try typeof use var void while with

The following list contains all identifiers that are syntactic keywords:

each get set to namespace include dynamic final native override static

Former Jangaroo keywords:

abstract assert enum final goto namespace override static synchronized throws transient volatile


13.2 Syntactic

Identifiers with special meaning become keywords in certain syntactic contexts:

    * In a for-each-in statement between the 'for' token and the '(' token:
      each
    * In a function definition between the 'function' token and an identifier token:
      get set
    * As the first word of a directive:
      namespace include
    * In an attribute list or wherever an attribute list can be used:
      dynamic final native override static

It is a syntax error to use a syntactic keyword in a context where it is treated as a keyword:

namespace = "hello"
namespace()

In these cases, the grammar requires an identifier after the namespace keyword.


*/

package net.jangaroo.jooc;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 9/20/17 7:41 PM from the specification file
 * <tt>/var/lib/jenkins/workspace/jangaroo-tools-release/target/checkout/jangaroo/jangaroo-compiler/src/main/jflex/net/jangaroo/jooc/joo.flex</tt>
 */
class Scanner extends ScannerBase implements sym, java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int XML_TEXT_CONTENT = 20;
  public static final int VECTOR_TYPE = 12;
  public static final int REGEXP_START = 6;
  public static final int XML_ATTRIBUTE_VALUE_DQ = 16;
  public static final int REGEXP_REST = 10;
  public static final int REGEXP_FIRST = 8;
  public static final int STRING_SQ = 2;
  public static final int YYINITIAL = 0;
  public static final int CDATA_SECTION = 22;
  public static final int STRING_DQ = 4;
  public static final int MXML = 14;
  public static final int XML_ATTRIBUTE_VALUE_SQ = 18;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\76\1\0\1\3\1\2\22\0\1\32\1\35\1\33"+
    "\1\0\1\6\1\73\1\70\1\75\1\57\1\60\1\5\1\16\1\64"+
    "\1\10\1\14\1\4\1\11\11\12\1\67\1\63\1\34\1\65\1\36"+
    "\1\66\1\6\1\101\1\22\1\77\1\100\1\15\1\22\15\6\1\102"+
    "\3\6\1\13\2\6\1\17\1\20\1\21\1\72\1\6\1\0\1\37"+
    "\1\41\1\25\1\30\1\31\1\47\1\55\1\45\1\23\1\6\1\43"+
    "\1\26\1\52\1\24\1\46\1\53\1\6\1\42\1\40\1\44\1\27"+
    "\1\56\1\54\1\50\1\51\1\6\1\61\1\71\1\62\1\74\53\0"+
    "\1\6\12\0\1\6\4\0\1\6\5\0\27\6\1\0\37\6\1\0"+
    "\u01ca\6\4\0\14\6\16\0\5\6\7\0\1\6\1\0\1\6\201\0"+
    "\5\6\1\0\2\6\2\0\4\6\10\0\1\6\1\0\3\6\1\0"+
    "\1\6\1\0\24\6\1\0\123\6\1\0\213\6\10\0\236\6\11\0"+
    "\46\6\2\0\1\6\7\0\47\6\110\0\33\6\5\0\3\6\55\0"+
    "\53\6\25\0\12\7\4\0\2\6\1\0\143\6\1\0\1\6\17\0"+
    "\2\6\7\0\2\6\12\7\3\6\2\0\1\6\20\0\1\6\1\0"+
    "\36\6\35\0\131\6\13\0\1\6\16\0\12\7\41\6\11\0\2\6"+
    "\4\0\1\6\5\0\26\6\4\0\1\6\11\0\1\6\3\0\1\6"+
    "\27\0\31\6\107\0\1\6\1\0\13\6\127\0\66\6\3\0\1\6"+
    "\22\0\1\6\7\0\12\6\4\0\12\7\1\0\7\6\1\0\7\6"+
    "\5\0\10\6\2\0\2\6\2\0\26\6\1\0\7\6\1\0\1\6"+
    "\3\0\4\6\3\0\1\6\20\0\1\6\15\0\2\6\1\0\3\6"+
    "\4\0\12\7\2\6\23\0\6\6\4\0\2\6\2\0\26\6\1\0"+
    "\7\6\1\0\2\6\1\0\2\6\1\0\2\6\37\0\4\6\1\0"+
    "\1\6\7\0\12\7\2\0\3\6\20\0\11\6\1\0\3\6\1\0"+
    "\26\6\1\0\7\6\1\0\2\6\1\0\5\6\3\0\1\6\22\0"+
    "\1\6\17\0\2\6\4\0\12\7\25\0\10\6\2\0\2\6\2\0"+
    "\26\6\1\0\7\6\1\0\2\6\1\0\5\6\3\0\1\6\36\0"+
    "\2\6\1\0\3\6\4\0\12\7\1\0\1\6\21\0\1\6\1\0"+
    "\6\6\3\0\3\6\1\0\4\6\3\0\2\6\1\0\1\6\1\0"+
    "\2\6\3\0\2\6\3\0\3\6\3\0\14\6\26\0\1\6\25\0"+
    "\12\7\25\0\10\6\1\0\3\6\1\0\27\6\1\0\12\6\1\0"+
    "\5\6\3\0\1\6\32\0\2\6\6\0\2\6\4\0\12\7\25\0"+
    "\10\6\1\0\3\6\1\0\27\6\1\0\12\6\1\0\5\6\3\0"+
    "\1\6\40\0\1\6\1\0\2\6\4\0\12\7\1\0\2\6\22\0"+
    "\10\6\1\0\3\6\1\0\51\6\2\0\1\6\20\0\1\6\21\0"+
    "\2\6\4\0\12\7\12\0\6\6\5\0\22\6\3\0\30\6\1\0"+
    "\11\6\1\0\1\6\2\0\7\6\72\0\60\6\1\0\2\6\14\0"+
    "\7\6\11\0\12\7\47\0\2\6\1\0\1\6\2\0\2\6\1\0"+
    "\1\6\2\0\1\6\6\0\4\6\1\0\7\6\1\0\3\6\1\0"+
    "\1\6\1\0\1\6\2\0\2\6\1\0\4\6\1\0\2\6\11\0"+
    "\1\6\2\0\5\6\1\0\1\6\11\0\12\7\2\0\4\6\40\0"+
    "\1\6\37\0\12\7\26\0\10\6\1\0\44\6\33\0\5\6\163\0"+
    "\53\6\24\0\1\6\12\7\6\0\6\6\4\0\4\6\3\0\1\6"+
    "\3\0\2\6\7\0\3\6\4\0\15\6\14\0\1\6\1\0\12\7"+
    "\6\0\46\6\1\0\1\6\5\0\1\6\2\0\53\6\1\0\u014d\6"+
    "\1\0\4\6\2\0\7\6\1\0\1\6\1\0\4\6\2\0\51\6"+
    "\1\0\4\6\2\0\41\6\1\0\4\6\2\0\7\6\1\0\1\6"+
    "\1\0\4\6\2\0\17\6\1\0\71\6\1\0\4\6\2\0\103\6"+
    "\45\0\20\6\20\0\125\6\14\0\u026c\6\2\0\21\6\1\0\32\6"+
    "\5\0\113\6\25\0\15\6\1\0\4\6\16\0\22\6\16\0\22\6"+
    "\16\0\15\6\1\0\3\6\17\0\64\6\43\0\1\6\4\0\1\6"+
    "\3\0\12\7\46\0\12\7\6\0\130\6\10\0\51\6\1\0\1\6"+
    "\5\0\106\6\12\0\35\6\51\0\12\7\36\6\2\0\5\6\13\0"+
    "\54\6\25\0\7\6\10\0\12\7\46\0\27\6\11\0\65\6\53\0"+
    "\12\7\6\0\12\7\15\0\1\6\135\0\57\6\21\0\7\6\4\0"+
    "\12\7\51\0\36\6\15\0\2\6\12\7\54\6\32\0\44\6\34\0"+
    "\12\7\3\0\3\6\12\7\44\6\153\0\4\6\1\0\4\6\3\0"+
    "\2\6\11\0\300\6\100\0\u0116\6\2\0\6\6\2\0\46\6\2\0"+
    "\6\6\2\0\10\6\1\0\1\6\1\0\1\6\1\0\1\6\1\0"+
    "\37\6\2\0\65\6\1\0\7\6\1\0\1\6\3\0\3\6\1\0"+
    "\7\6\3\0\4\6\2\0\6\6\4\0\15\6\5\0\3\6\1\0"+
    "\7\6\53\0\2\1\107\0\1\6\15\0\1\6\20\0\15\6\145\0"+
    "\1\6\4\0\1\6\2\0\12\6\1\0\1\6\3\0\5\6\6\0"+
    "\1\6\1\0\1\6\1\0\1\6\1\0\4\6\1\0\13\6\2\0"+
    "\4\6\5\0\5\6\4\0\1\6\64\0\2\6\u0a7b\0\57\6\1\0"+
    "\57\6\1\0\205\6\6\0\4\6\3\0\2\6\14\0\46\6\1\0"+
    "\1\6\5\0\1\6\2\0\70\6\7\0\1\6\20\0\27\6\11\0"+
    "\7\6\1\0\7\6\1\0\7\6\1\0\7\6\1\0\7\6\1\0"+
    "\7\6\1\0\7\6\1\0\7\6\120\0\1\6\u01d5\0\2\6\52\0"+
    "\5\6\5\0\2\6\4\0\126\6\6\0\3\6\1\0\132\6\1\0"+
    "\4\6\5\0\51\6\3\0\136\6\21\0\33\6\65\0\20\6\u0200\0"+
    "\u19b6\6\112\0\u51cd\6\63\0\u048d\6\103\0\56\6\2\0\u010d\6\3\0"+
    "\20\6\12\7\2\6\24\0\57\6\20\0\31\6\10\0\106\6\61\0"+
    "\11\6\2\0\147\6\2\0\4\6\1\0\4\6\14\0\13\6\115\0"+
    "\12\6\1\0\3\6\1\0\4\6\1\0\27\6\35\0\64\6\16\0"+
    "\62\6\34\0\12\7\30\0\6\6\3\0\1\6\4\0\12\7\34\6"+
    "\12\0\27\6\31\0\35\6\7\0\57\6\34\0\1\6\12\7\46\0"+
    "\51\6\27\0\3\6\1\0\10\6\4\0\12\7\6\0\27\6\3\0"+
    "\1\6\5\0\60\6\1\0\1\6\3\0\2\6\2\0\5\6\2\0"+
    "\1\6\1\0\1\6\30\0\3\6\2\0\13\6\7\0\3\6\14\0"+
    "\6\6\2\0\6\6\2\0\6\6\11\0\7\6\1\0\7\6\221\0"+
    "\43\6\15\0\12\7\6\0\u2ba4\6\14\0\27\6\4\0\61\6\u2104\0"+
    "\u016e\6\2\0\152\6\46\0\7\6\14\0\5\6\5\0\1\6\1\0"+
    "\12\6\1\0\15\6\1\0\5\6\1\0\1\6\1\0\2\6\1\0"+
    "\2\6\1\0\154\6\41\0\u016b\6\22\0\100\6\2\0\66\6\50\0"+
    "\14\6\164\0\5\6\1\0\207\6\23\0\12\7\7\0\32\6\6\0"+
    "\32\6\13\0\131\6\3\0\6\6\2\0\6\6\2\0\6\6\2\0"+
    "\3\6\40\0\1\3\2\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\14\0\1\1\1\2\1\3\1\4\1\5\1\6\2\7"+
    "\1\10\1\11\1\12\1\13\6\5\1\14\1\15\1\16"+
    "\1\17\11\5\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\0\1\41\1\37\1\42\1\43"+
    "\1\44\1\45\1\46\3\43\1\47\2\43\2\50\1\4"+
    "\1\10\1\51\1\1\1\5\1\52\1\15\1\53\1\26"+
    "\1\1\1\30\1\54\1\55\1\56\1\55\4\57\1\2"+
    "\1\0\1\60\1\61\1\62\1\63\1\64\1\0\1\64"+
    "\2\0\1\65\1\66\1\67\1\70\1\71\1\72\10\5"+
    "\1\73\2\5\1\74\1\75\1\76\1\77\1\100\1\101"+
    "\22\5\1\102\1\103\1\104\1\105\1\106\1\107\1\110"+
    "\1\111\1\112\1\113\1\114\1\112\1\115\1\116\1\117"+
    "\1\120\1\121\1\112\1\122\6\0\1\123\1\124\1\125"+
    "\1\0\1\126\1\0\1\127\1\130\1\131\3\0\1\132"+
    "\1\0\1\64\1\133\5\5\1\134\4\5\1\135\4\5"+
    "\1\136\1\137\1\140\1\141\5\5\1\142\6\5\1\143"+
    "\6\5\1\144\1\5\1\145\1\146\1\147\3\0\1\150"+
    "\1\0\1\127\2\0\1\151\5\5\1\152\1\5\1\153"+
    "\5\5\1\154\1\5\1\155\4\5\1\156\1\157\11\5"+
    "\1\160\1\5\1\161\1\0\1\162\1\150\4\0\1\163"+
    "\5\5\1\164\1\165\1\166\4\5\1\167\1\5\1\170"+
    "\1\5\1\171\3\5\1\172\4\5\1\173\4\0\5\5"+
    "\1\174\1\5\1\175\2\5\1\176\1\177\1\200\2\5"+
    "\1\201\3\5\4\0\6\5\1\202\1\203\1\204\1\5"+
    "\1\205\1\206\1\5\4\0\1\5\1\207\2\5\1\210"+
    "\1\211\1\5\4\0\1\5\1\212\1\5\1\213\2\0"+
    "\1\214\1\215\1\216\1\217\1\0\1\220\1\221";

  private static int [] zzUnpackAction() {
    int [] result = new int[376];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\103\0\206\0\311\0\u010c\0\u014f\0\u0192\0\u01d5"+
    "\0\u0218\0\u025b\0\u029e\0\u02e1\0\u0324\0\u0324\0\u0367\0\u03aa"+
    "\0\u03ed\0\u0430\0\u0473\0\u04b6\0\u04f9\0\u053c\0\u0324\0\u0324"+
    "\0\u057f\0\u05c2\0\u0605\0\u0648\0\u068b\0\u06ce\0\u0324\0\u0711"+
    "\0\u0754\0\u0797\0\u07da\0\u081d\0\u0860\0\u08a3\0\u08e6\0\u0929"+
    "\0\u096c\0\u09af\0\u09f2\0\u0324\0\u0324\0\u0324\0\u0324\0\u0324"+
    "\0\u0324\0\u0a35\0\u0324\0\u0a78\0\u0abb\0\u0afe\0\u0b41\0\u0b84"+
    "\0\u0324\0\u0324\0\u0bc7\0\u0324\0\u0c0a\0\u0324\0\u0c4d\0\u0324"+
    "\0\u0324\0\u0324\0\u0324\0\u0324\0\u0c90\0\u0cd3\0\u0d16\0\u0d59"+
    "\0\u0d9c\0\u0ddf\0\u0324\0\u0e22\0\u0324\0\u0e65\0\u0324\0\u0ea8"+
    "\0\u0eeb\0\u0324\0\u0f2e\0\u0f71\0\u0324\0\u0fb4\0\u0324\0\u0324"+
    "\0\u0ff7\0\u0324\0\u103a\0\u107d\0\u10c0\0\u0324\0\u1103\0\u1146"+
    "\0\u1189\0\u0324\0\u0324\0\u0324\0\u0324\0\u11cc\0\u120f\0\u1252"+
    "\0\u1295\0\u12d8\0\u0324\0\u0324\0\u0324\0\u131b\0\u03ed\0\u03ed"+
    "\0\u135e\0\u13a1\0\u13e4\0\u1427\0\u146a\0\u14ad\0\u14f0\0\u1533"+
    "\0\u03ed\0\u1576\0\u15b9\0\u15fc\0\u0324\0\u163f\0\u1682\0\u0324"+
    "\0\u03ed\0\u16c5\0\u1708\0\u174b\0\u178e\0\u17d1\0\u1814\0\u1857"+
    "\0\u189a\0\u18dd\0\u1920\0\u1963\0\u19a6\0\u19e9\0\u1a2c\0\u1a6f"+
    "\0\u1ab2\0\u1af5\0\u1b38\0\u1b7b\0\u0324\0\u0324\0\u1bbe\0\u0324"+
    "\0\u1c01\0\u0324\0\u0324\0\u0324\0\u0324\0\u0324\0\u1c44\0\u0324"+
    "\0\u0324\0\u0324\0\u0324\0\u0324\0\u1c87\0\u0324\0\u0c90\0\u1cca"+
    "\0\u0d16\0\u0d9c\0\u0ddf\0\u1d0d\0\u0324\0\u1d50\0\u0324\0\u1d93"+
    "\0\u0324\0\u1dd6\0\u1e19\0\u0324\0\u0324\0\u1e5c\0\u1e9f\0\u1ee2"+
    "\0\u120f\0\u1f25\0\u1f25\0\u0324\0\u1f68\0\u1fab\0\u1fee\0\u2031"+
    "\0\u2074\0\u03ed\0\u20b7\0\u20fa\0\u213d\0\u2180\0\u03ed\0\u21c3"+
    "\0\u2206\0\u2249\0\u228c\0\u0324\0\u0324\0\u22cf\0\u0324\0\u2312"+
    "\0\u2355\0\u2398\0\u23db\0\u241e\0\u03ed\0\u2461\0\u24a4\0\u24e7"+
    "\0\u252a\0\u256d\0\u25b0\0\u03ed\0\u25f3\0\u2636\0\u2679\0\u26bc"+
    "\0\u26ff\0\u2742\0\u03ed\0\u2785\0\u0324\0\u0324\0\u0324\0\u27c8"+
    "\0\u280b\0\u284e\0\u2891\0\u28d4\0\u0324\0\u2917\0\u295a\0\u299d"+
    "\0\u29e0\0\u2a23\0\u2a66\0\u2aa9\0\u2aec\0\u03ed\0\u2b2f\0\u03ed"+
    "\0\u2b72\0\u2bb5\0\u2bf8\0\u2c3b\0\u2c7e\0\u03ed\0\u2cc1\0\u0324"+
    "\0\u2d04\0\u2d47\0\u2d8a\0\u2dcd\0\u03ed\0\u03ed\0\u2e10\0\u2e53"+
    "\0\u2e96\0\u2ed9\0\u2f1c\0\u2f5f\0\u2fa2\0\u2fe5\0\u3028\0\u03ed"+
    "\0\u306b\0\u03ed\0\u1c87\0\u0324\0\u0324\0\u30ae\0\u30f1\0\u3134"+
    "\0\u3177\0\u0324\0\u31ba\0\u31fd\0\u3240\0\u3283\0\u32c6\0\u03ed"+
    "\0\u03ed\0\u03ed\0\u3309\0\u334c\0\u338f\0\u33d2\0\u03ed\0\u3415"+
    "\0\u03ed\0\u3458\0\u03ed\0\u349b\0\u34de\0\u3521\0\u03ed\0\u3564"+
    "\0\u35a7\0\u35ea\0\u362d\0\u03ed\0\u3670\0\u36b3\0\u36f6\0\u3739"+
    "\0\u377c\0\u37bf\0\u3802\0\u3845\0\u3888\0\u03ed\0\u38cb\0\u03ed"+
    "\0\u390e\0\u3951\0\u03ed\0\u03ed\0\u03ed\0\u3994\0\u39d7\0\u03ed"+
    "\0\u3a1a\0\u3a5d\0\u3aa0\0\u3ae3\0\u3b26\0\u3b69\0\u3bac\0\u3bef"+
    "\0\u3c32\0\u3c75\0\u3cb8\0\u3cfb\0\u3d3e\0\u03ed\0\u03ed\0\u03ed"+
    "\0\u3d81\0\u03ed\0\u03ed\0\u3dc4\0\u3e07\0\u3e4a\0\u3e8d\0\u3ed0"+
    "\0\u3f13\0\u03ed\0\u3f56\0\u3f99\0\u03ed\0\u03ed\0\u3fdc\0\u401f"+
    "\0\u4062\0\u40a5\0\u40e8\0\u412b\0\u03ed\0\u416e\0\u03ed\0\u41b1"+
    "\0\u41f4\0\u0324\0\u0324\0\u03ed\0\u03ed\0\u4237\0\u0324\0\u0324";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[376];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\15\3\16\1\17\1\20\1\21\1\15\1\22\1\23"+
    "\1\24\1\21\1\25\1\21\1\26\1\27\1\15\1\30"+
    "\1\21\1\31\1\32\1\33\1\21\1\34\1\35\1\36"+
    "\1\16\1\37\1\40\1\41\1\42\1\43\1\44\1\45"+
    "\1\46\1\21\1\47\2\21\1\50\3\21\1\51\1\52"+
    "\1\21\1\53\1\54\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\1\70\1\71"+
    "\1\72\1\16\4\21\2\73\1\74\15\73\1\75\54\73"+
    "\1\76\1\74\4\73\2\77\1\74\15\77\1\75\12\77"+
    "\1\100\42\77\1\74\4\77\4\101\1\102\76\101\1\103"+
    "\2\104\1\103\2\101\11\103\1\105\1\106\55\103\1\104"+
    "\4\103\1\107\2\104\1\107\1\110\12\107\1\111\1\112"+
    "\55\107\1\104\4\107\1\113\3\16\1\114\1\115\1\21"+
    "\4\113\1\21\1\116\1\21\4\113\10\21\1\16\3\113"+
    "\1\117\20\21\17\113\1\16\4\21\1\15\3\16\1\120"+
    "\1\15\1\121\4\15\1\121\1\15\1\121\4\15\10\121"+
    "\1\16\1\122\1\123\1\15\1\124\20\121\6\15\1\125"+
    "\1\126\1\127\5\15\1\130\1\16\4\121\33\131\1\132"+
    "\47\131\75\133\1\132\5\133\34\134\1\135\46\134\21\136"+
    "\1\137\61\136\107\0\1\140\1\141\57\0\1\142\102\0"+
    "\1\143\23\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\20\21\20\0\4\21\10\0\1\144\54\0"+
    "\1\145\26\0\2\146\1\147\1\150\1\151\13\0\1\151"+
    "\16\0\1\147\43\0\2\24\1\0\1\150\1\151\13\0"+
    "\1\151\62\0\2\150\1\0\1\152\17\0\1\153\64\0"+
    "\1\154\46\0\1\155\23\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\2\21\1\156\5\21\5\0\1\21\1\157"+
    "\6\21\1\160\2\21\1\161\4\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\5\21\1\162"+
    "\1\21\1\163\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\4\21\1\164\3\21"+
    "\5\0\1\165\6\21\1\166\10\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\1\21\1\167\16\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\7\21\1\170\5\0\7\21"+
    "\1\171\10\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\4\21\1\172\3\21\5\0\11\21"+
    "\1\173\6\21\20\0\4\21\34\0\1\174\30\0\1\175"+
    "\102\0\1\176\53\0\1\177\26\0\1\200\23\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\1\21"+
    "\1\201\16\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\5\21\1\202\2\21\5\0\15\21"+
    "\1\203\2\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\3\21\1\204\14\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\7\21\1\205\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\3\21\1\206\2\21\1\207\3\21\1\210\5\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\1\21\1\211\3\21\1\212\2\21\5\0\1\213\6\21"+
    "\1\214\10\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\5\21\1\215\2\21\5\0\1\216"+
    "\2\21\1\217\14\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\1\21\1\220\6\21\5\0"+
    "\6\21\1\221\11\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\1\222\6\21"+
    "\1\223\10\21\20\0\4\21\65\0\1\224\104\0\1\225"+
    "\100\0\1\226\2\0\1\227\77\0\1\230\3\0\1\231"+
    "\76\0\1\232\102\0\1\233\15\0\2\73\1\0\15\73"+
    "\1\0\54\73\2\0\4\73\20\234\1\235\3\234\1\236"+
    "\2\234\1\237\3\234\1\240\5\234\1\241\1\242\1\234"+
    "\1\243\2\234\1\244\1\245\24\234\1\246\1\0\4\234"+
    "\2\77\1\0\15\77\1\0\12\77\1\0\42\77\1\0"+
    "\4\77\1\247\2\0\15\247\1\250\1\103\54\247\1\0"+
    "\4\247\1\103\2\0\73\103\1\0\4\103\1\251\2\0"+
    "\1\251\1\110\12\251\1\252\1\253\55\251\1\0\4\251"+
    "\6\0\1\110\4\0\1\110\1\0\1\110\4\0\10\110"+
    "\5\0\20\110\20\0\4\110\1\252\2\0\15\252\1\254"+
    "\1\251\54\252\1\0\4\252\1\251\2\0\73\251\1\0"+
    "\4\251\4\0\1\140\1\141\131\0\1\255\104\0\1\256"+
    "\52\0\6\121\1\0\1\121\4\0\10\121\5\0\20\121"+
    "\20\0\4\121\4\0\1\257\30\0\1\260\30\0\1\261"+
    "\15\0\3\262\26\0\1\262\1\0\1\263\41\0\1\262"+
    "\42\0\1\264\44\0\33\131\1\0\47\131\75\133\1\0"+
    "\5\133\34\0\1\265\102\0\1\265\1\266\66\0\1\267"+
    "\61\0\2\140\1\16\73\140\1\16\4\140\5\141\1\270"+
    "\75\141\11\0\2\146\1\0\1\150\1\151\13\0\1\151"+
    "\62\0\2\271\2\0\1\271\4\0\1\271\2\0\1\271"+
    "\2\0\2\271\5\0\1\271\1\0\1\271\5\0\1\271"+
    "\27\0\3\271\12\0\2\150\2\0\1\151\13\0\1\151"+
    "\61\0\1\272\2\273\3\0\1\272\100\0\1\274\74\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\3\21\1\275"+
    "\4\21\5\0\1\21\1\276\3\21\1\277\12\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\14\21\1\300\3\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\4\21\1\301"+
    "\3\21\5\0\20\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\15\21\1\302"+
    "\2\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\10\21\5\0\1\303\17\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\1\21\1\304\3\21\1\305\12\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\2\21"+
    "\1\306\5\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\7\21\1\307\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\4\21\1\310\3\21\5\0\10\21\1\311"+
    "\7\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\10\21\5\0\1\21\1\312\16\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\5\21\1\313\12\21\20\0\4\21\65\0"+
    "\1\314\102\0\1\315\53\0\1\316\26\0\1\317\23\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\14\21\1\320\3\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\1\21\1\321\6\21\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\7\21\1\322\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\5\21\1\323\12\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\5\21\1\324\2\21"+
    "\5\0\12\21\1\325\5\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\1\21\1\326\6\21"+
    "\5\0\3\21\1\327\14\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\14\21"+
    "\1\330\3\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\2\21\1\331\5\21\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\2\21\1\332\5\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\4\21"+
    "\1\333\3\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\3\21"+
    "\1\334\14\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\2\21\1\335\15\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\3\21\1\336\4\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\1\21"+
    "\1\337\6\21\5\0\7\21\1\340\10\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\5\21\1\341\12\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\1\21\1\342\6\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\3\21\1\343\14\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\1\21\1\344\6\21\5\0\20\21\20\0\4\21"+
    "\65\0\1\345\102\0\1\346\102\0\1\347\26\0\2\350"+
    "\2\0\1\350\4\0\1\350\2\0\1\350\2\0\2\350"+
    "\5\0\1\350\1\0\1\350\5\0\1\350\27\0\3\350"+
    "\12\0\2\351\2\0\1\351\4\0\1\351\2\0\1\351"+
    "\2\0\2\351\5\0\1\351\1\0\1\351\5\0\1\351"+
    "\27\0\3\351\1\0\1\247\2\0\73\247\1\0\4\247"+
    "\1\252\2\0\73\252\1\0\4\252\1\0\3\352\26\0"+
    "\1\352\1\0\1\353\41\0\1\352\14\0\1\354\73\0"+
    "\3\262\26\0\1\262\1\0\1\355\41\0\1\262\41\0"+
    "\1\356\64\0\1\357\121\0\1\360\44\0\4\141\1\16"+
    "\1\270\75\141\11\0\2\273\76\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\4\21\1\361\3\21\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\5\21\1\362\12\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\7\21"+
    "\1\363\5\0\20\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\4\21\1\364\3\21\5\0"+
    "\7\21\1\365\10\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\4\21\1\366\3\21\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\10\21\5\0\1\21\1\367\16\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\7\21\1\370\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\3\21\1\371\4\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\1\21\1\372\3\21"+
    "\1\373\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\374\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\1\375\17\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\7\21\1\376\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\7\21\1\377\5\0\20\21\20\0\4\21"+
    "\65\0\1\u0100\23\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\7\21\1\u0101\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\5\21\1\u0102\12\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\1\u0103\17\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\5\21\1\u0104\2\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\7\21"+
    "\1\u0105\5\0\20\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\1\21\1\u0106"+
    "\16\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\10\21\5\0\7\21\1\u0107\10\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\7\21\1\u0108\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\1\u0109"+
    "\17\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\3\21\1\u010a\4\21\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\1\21\1\u010b\16\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\4\21\1\u010c"+
    "\3\21\5\0\20\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\4\21\1\u010d"+
    "\13\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\10\21\5\0\17\21\1\u010e\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\5\21\1\u010f\12\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\6\21"+
    "\1\u0110\11\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\4\21\1\u0111\3\21\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\6\21\1\u0112\1\21\5\0\20\21\20\0\4\21"+
    "\11\0\2\u0113\2\0\1\u0113\4\0\1\u0113\2\0\1\u0113"+
    "\2\0\2\u0113\5\0\1\u0113\1\0\1\u0113\5\0\1\u0113"+
    "\27\0\3\u0113\12\0\2\u0114\2\0\1\u0114\4\0\1\u0114"+
    "\2\0\1\u0114\2\0\2\u0114\5\0\1\u0114\1\0\1\u0114"+
    "\5\0\1\u0114\27\0\3\u0114\2\0\3\352\26\0\1\352"+
    "\1\0\1\u0115\41\0\1\352\41\0\1\u0116\55\0\1\u0117"+
    "\111\0\1\u0118\162\0\1\u0119\37\0\1\u011a\54\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\5\21\1\u011b\2\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\1\u011c\17\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\3\21\1\u011d\14\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\7\21\1\u011e"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\3\21\1\u011f\14\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\1\21\1\u0120\16\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\6\21\1\u0121\11\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\u0122\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\1\21\1\u0123\6\21\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\5\21\1\u0124\12\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\5\21"+
    "\1\u0125\2\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\2\21\1\u0126\5\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\3\21\1\u0127\14\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\3\21\1\u0128\4\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\4\21\1\u0129\13\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\3\21"+
    "\1\u012a\14\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\15\21\1\u012b\2\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\7\21\1\u012c\10\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\4\21"+
    "\1\u012d\3\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\u012e\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\u012f\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\1\21\1\u0130\6\21\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\1\u0131\17\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\1\u0132\17\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\7\21\1\u0133\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\7\21\1\u0134\5\0"+
    "\20\21\20\0\4\21\17\0\1\u0135\63\0\10\u0117\1\u0136"+
    "\72\u0117\77\0\1\u0137\103\0\1\u0138\10\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\6\21\1\u0139\1\21\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\2\21\1\u013a\5\21\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\2\21\1\u013b\5\21\5\0\10\21\1\u013c\7\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\13\21\1\u013d\4\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\5\21\1\u013e\12\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\2\21\1\u013f\5\21\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\7\21\1\u0140\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\4\21"+
    "\1\u0141\3\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\6\21\1\u0142\1\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\6\21\1\u0143\11\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\2\21\1\u0144\5\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\10\21\1\u0145\7\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\4\21\1\u0146\3\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\1\21\1\u0147\6\21\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\3\21\1\u0148\4\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\16\21\1\u0149\1\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\u014a\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\3\21\1\u014b\4\21\5\0\20\21"+
    "\20\0\4\21\77\0\1\u014c\3\0\10\u0117\1\u014d\72\u0117"+
    "\100\0\1\u014e\103\0\1\u014f\7\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\u0150\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\3\21\1\u0151\4\21\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\1\u0152\17\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\1\u0153\17\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\7\21\1\u0154\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\5\21\1\u0155\2\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\5\21\1\u0156\12\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\1\21\1\u0157\16\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\12\21\1\u0158\5\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\7\21"+
    "\1\u0159\10\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\u015a\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\7\21\1\u015b\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\u015c\12\21\20\0\4\21\100\0\1\u015d\2\0\10\u0117"+
    "\1\u014d\25\u0117\1\16\44\u0117\101\0\1\u015e\103\0\1\u015f"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\1\u0160\4\0\20\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\7\21\1\u0161\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\4\21\1\u0162\3\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\3\21"+
    "\1\u0163\4\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\2\21\1\u0164\5\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\u0165\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\2\21\1\u0166\5\21\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\7\21\1\u0167"+
    "\5\0\20\21\20\0\4\21\101\0\1\u0168\103\0\1\u0169"+
    "\101\0\1\u016a\34\0\1\u016b\55\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\7\21\1\u016c\10\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\7\21\1\u016d\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\5\21\1\u016e\12\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\6\21\1\u016f\1\21\5\0"+
    "\20\21\20\0\4\21\102\0\1\u0170\101\0\1\u0171\20\0"+
    "\1\u0172\63\0\33\u016b\1\u0173\47\u016b\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\10\21\1\u0174"+
    "\7\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\10\21\5\0\1\21\1\u0175\16\21\20\0"+
    "\4\21\101\0\1\u0176\20\0\1\u0177\102\0\1\u0178\63\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[17018];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\14\0\2\11\10\1\2\11\6\1\1\11\14\1\6\11"+
    "\1\1\1\11\5\1\2\11\1\1\1\11\1\0\1\11"+
    "\1\1\5\11\6\1\1\11\1\1\1\11\1\1\1\11"+
    "\2\1\1\11\2\1\1\11\1\1\2\11\1\1\1\11"+
    "\3\1\1\11\2\1\1\0\4\11\1\1\1\0\1\1"+
    "\2\0\3\11\17\1\1\11\2\1\1\11\24\1\2\11"+
    "\1\1\1\11\1\1\5\11\1\1\5\11\1\1\1\11"+
    "\6\0\1\11\1\1\1\11\1\0\1\11\1\0\1\1"+
    "\2\11\3\0\1\1\1\0\1\1\1\11\17\1\2\11"+
    "\1\1\1\11\25\1\3\11\3\0\1\1\1\0\1\11"+
    "\2\0\20\1\1\11\22\1\1\0\2\11\4\0\1\11"+
    "\32\1\4\0\23\1\4\0\15\1\4\0\7\1\4\0"+
    "\4\1\2\0\2\11\2\1\1\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[376];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;
  
  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /** the stack of open (nested) input streams to read from */
  private java.util.Stack zzStreams = new java.util.Stack();

  /**
   * inner class used to store info for nested
   * input streams
   */
  private static final class ZzFlexStreamInfo {
    java.io.Reader zzReader;
    int zzEndRead;
    int zzStartRead;
    int zzCurrentPos;
    int zzMarkedPos;
    int yyline;
    int yycolumn;
    char [] zzBuffer;
    boolean zzAtEOF;
    boolean zzEOFDone;

    /** sets all values stored in this class */
    ZzFlexStreamInfo(java.io.Reader zzReader, int zzEndRead, int zzStartRead,
                  int zzCurrentPos, int zzMarkedPos, 
                  char [] zzBuffer, boolean zzAtEOF, boolean zzEOFDone, int yyline, int yycolumn) {
      this.zzReader      = zzReader;
      this.zzEndRead     = zzEndRead;
      this.zzStartRead   = zzStartRead;
      this.zzCurrentPos  = zzCurrentPos;
      this.zzMarkedPos   = zzMarkedPos;
      this.zzBuffer      = zzBuffer;
      this.zzAtEOF       = zzAtEOF;
      this.zzEOFDone     = zzEOFDone;
      this.yyline         = yyline;
      this.yycolumn       = yycolumn;
    }
  }

  /* user code: */
  void prepareEmbedded(java.io.Reader reader, int line, int column) {
    yyreset(reader);
    yyline = line;
    yycolumn = column;
  }

  protected int getColumn() {
    return yycolumn + 1;
  }

  protected int getLine() {
    return yyline + 1;
  }

  protected void yybeginRegExpStart() {
    yybegin(REGEXP_START);
  }



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1748) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }
    
    // numRead < 0) 
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Stores the current input stream on a stack, and
   * reads from a new stream. Lexical state, line,
   * char, and column counting remain untouched.
   *
   * The current input stream can be restored with
   * yypopstream (usually in an <<EOF>> action).
   *
   * @param reader the new input stream to read from
   *
   * @see #yypopStream()
   */
  public final void yypushStream(java.io.Reader reader) {
    zzStreams.push(
      new ZzFlexStreamInfo(zzReader, zzEndRead, zzStartRead, zzCurrentPos,
                        zzMarkedPos, zzBuffer, zzAtEOF, zzEOFDone,
                        yyline, yycolumn)
    );
    zzAtEOF  = false;
    zzBuffer = new char[ZZ_BUFFERSIZE];
    zzReader = reader;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yycolumn = 0;
  }
    

  /**
   * Closes the current input stream and continues to
   * read from the one on top of the stream stack. 
   *
   * @throws java.util.EmptyStackException
   *         if there is no further stream to read from.
   *
   * @throws java.io.IOException
   *         if there was an error in closing the stream.
   *
   * @see #yypushStream(java.io.Reader)
   */
  public final void yypopStream() throws java.io.IOException {
    zzReader.close();
    ZzFlexStreamInfo s = (ZzFlexStreamInfo) zzStreams.pop();
    zzBuffer      = s.zzBuffer;
    zzReader      = s.zzReader;
    zzEndRead     = s.zzEndRead;
    zzStartRead   = s.zzStartRead;
    zzCurrentPos  = s.zzCurrentPos;
    zzMarkedPos   = s.zzMarkedPos ;
    zzAtEOF       = s.zzAtEOF;
    zzEOFDone     = s.zzEOFDone;
    yyline         = s.yyline;
    yycolumn       = s.yycolumn;
  }


  /**
   * Returns true iff there are still streams left 
   * to read from on the stream stack.
   */
  public final boolean yymoreStreams() {
    return !zzStreams.isEmpty();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   *
   * @see #yypushStream(java.io.Reader)
   * @see #yypopStream()
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol scan() throws java.io.IOException {
    int zzInput;
    int zzAction;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      // cached fields:
      int zzCurrentPosL;
      int zzMarkedPosL = zzMarkedPos;
      int zzEndReadL = zzEndRead;
      char [] zzBufferL = zzBuffer;
      char [] zzCMapL = ZZ_CMAP;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 62: 
          { return symbol(NOTEQ);
          }
        case 146: break;
        case 137: 
          { return symbol(FUNCTION);
          }
        case 147: break;
        case 129: 
          { return symbol(PUBLIC);
          }
        case 148: break;
        case 33: 
          { pushMultiStateText(yytext()); yybegin(YYINITIAL); return multiStateSymbol(STRING_LITERAL, getString());
          }
        case 149: break;
        case 25: 
          { return symbol(AND);
          }
        case 150: break;
        case 26: 
          { return symbol(OR);
          }
        case 151: break;
        case 145: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 2;
          { setMultiStateText(""); yybegin(XML_TEXT_CONTENT); clearString(); return symbol(SLASH_GT);
          }
        case 152: break;
        case 84: 
          { setMultiStateText(""); yybegin(XML_TEXT_CONTENT); clearString(); return symbol(SLASH_GT);
          }
        case 153: break;
        case 21: 
          { return symbol(COMMA);
          }
        case 154: break;
        case 4: 
          { return symbol(MUL);
          }
        case 155: break;
        case 91: 
          { return symbol(REST);
          }
        case 156: break;
        case 10: 
          { return symbol(LBRACK);
          }
        case 157: break;
        case 111: 
          { return symbol(THIS);
          }
        case 158: break;
        case 48: 
          { return symbol(DIVEQ);
          }
        case 159: break;
        case 85: 
          { return symbol(LT_SLASH);
          }
        case 160: break;
        case 32: 
          { error("Unterminated string at end of line");
          }
        case 161: break;
        case 70: 
          { return symbol(OREQ);
          }
        case 162: break;
        case 18: 
          { return symbol(LBRACE);
          }
        case 163: break;
        case 100: 
          { return symbol(VAR);
          }
        case 164: break;
        case 24: 
          { return symbol(COLON);
          }
        case 165: break;
        case 124: 
          { return symbol(IMPORT);
          }
        case 166: break;
        case 59: 
          { return symbol(DO);
          }
        case 167: break;
        case 55: 
          { return symbol(PLUSEQ);
          }
        case 168: break;
        case 46: 
          { pushMultiStateText(yytext()); yybegin(MXML);
                                    return multiStateSymbol(STRING_LITERAL, getString());
          }
        case 169: break;
        case 115: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 3;
          { pushMultiStateText(yytext()); yybegin(MXML);
                                    return multiStateSymbol(STRING_LITERAL, getString());
          }
        case 170: break;
        case 140: 
          { pushMultiStateText(yytext()); yybegin(CDATA_SECTION);
          }
        case 171: break;
        case 101: 
          { return symbol(EQEQEQ);
          }
        case 172: break;
        case 39: 
          { pushMultiStateText(yytext());
                                    pushString(yytext());
                                    yybegin(YYINITIAL);
                                    return multiStateSymbol(REGEXP_LITERAL, getString());
          }
        case 173: break;
        case 88: 
          { return symbol(QUESTION_GT);
          }
        case 174: break;
        case 57: 
          { return symbol(IS);
          }
        case 175: break;
        case 97: 
          { return symbol(RSHIFTEQ);
          }
        case 176: break;
        case 67: 
          { return symbol(NAMESPACESEP);
          }
        case 177: break;
        case 142: 
          { return symbol(INSTANCEOF);
          }
        case 178: break;
        case 8: 
          { return symbol(DOT);
          }
        case 179: break;
        case 45: 
          { pushMultiStateText(yytext()); pushString(unescapeXml(yytext()));
          }
        case 180: break;
        case 72: 
          { return symbol(XOREQ);
          }
        case 181: break;
        case 130: 
          { return symbol(DEFAULT);
          }
        case 182: break;
        case 15: 
          { return symbol(GT);
          }
        case 183: break;
        case 87: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 1;
          { return symbol(GT);
          }
        case 184: break;
        case 53: 
          { increaseVectorNestingLevel(); yybegin(VECTOR_TYPE); return symbol(DOTLT);
          }
        case 185: break;
        case 113: 
          { return symbol(VOID);
          }
        case 186: break;
        case 96: 
          { return symbol(URSHIFT);
          }
        case 187: break;
        case 41: 
          { if (decreaseVectorNestingLevel()) { yybegin(YYINITIAL); } return symbol(GT);
          }
        case 188: break;
        case 139: 
          { return symbol(PROTECTED);
          }
        case 189: break;
        case 7: 
          { return symbol(INT_LITERAL, new Long(yytext()));
          }
        case 190: break;
        case 79: 
          { pushMultiStateText(yytext()); pushString( '\r' );
          }
        case 191: break;
        case 36: 
          { pushMultiStateText(yytext()); pushString(yytext()); yybegin(REGEXP_FIRST);
          }
        case 192: break;
        case 13: 
          { return symbol(LT);
          }
        case 193: break;
        case 17: 
          { return symbol(RPAREN);
          }
        case 194: break;
        case 30: 
          { setMultiStateText(yytext()); yybegin(STRING_SQ); clearString();
          }
        case 195: break;
        case 22: 
          { return symbol(EQ);
          }
        case 196: break;
        case 110: 
          { return symbol(BOOL_LITERAL, Boolean.TRUE);
          }
        case 197: break;
        case 138: 
          { return symbol(INTERFACE);
          }
        case 198: break;
        case 35: 
          { error("invalid regular expression literal");
          }
        case 199: break;
        case 108: 
          { return symbol(ELSE);
          }
        case 200: break;
        case 102: 
          { return symbol(ANDANDEQ);
          }
        case 201: break;
        case 118: 
          { return symbol(CONST);
          }
        case 202: break;
        case 14: 
          { return symbol(NOT);
          }
        case 203: break;
        case 50: 
          { return symbol(MINUSMINUS);
          }
        case 204: break;
        case 95: 
          { return symbol(NOTEQEQ);
          }
        case 205: break;
        case 134: 
          { return symbol(PRIVATE);
          }
        case 206: break;
        case 127: 
          { return symbol(RETURN);
          }
        case 207: break;
        case 89: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 1;
          { pushMultiStateText(yytext()); pushString(yytext()); yybegin(MXML);
                                    return multiStateSymbol(STRING_LITERAL, unescapeXml(getString()));
          }
        case 208: break;
        case 103: 
          { return symbol(OROREQ);
          }
        case 209: break;
        case 109: 
          { return symbol(URSHIFTEQ);
          }
        case 210: break;
        case 76: 
          { pushMultiStateText(yytext()); pushString( '\n' );
          }
        case 211: break;
        case 120: 
          { return symbol(BREAK);
          }
        case 212: break;
        case 65: 
          { return symbol(AS);
          }
        case 213: break;
        case 37: 
          { pushMultiStateText(yytext()); pushString(yytext()); yybegin(REGEXP_REST);
          }
        case 214: break;
        case 128: 
          { return symbol(TYPEOF);
          }
        case 215: break;
        case 82: 
          { pushMultiStateText(yytext()); pushString( '\'' );
          }
        case 216: break;
        case 49: 
          { return symbol(MULTEQ);
          }
        case 217: break;
        case 31: 
          { pushMultiStateText(yytext()); pushString( yytext() );
          }
        case 218: break;
        case 73: 
          { return symbol(MODEQ);
          }
        case 219: break;
        case 64: 
          { return symbol(GTEQ);
          }
        case 220: break;
        case 68: 
          { return symbol(ANDEQ);
          }
        case 221: break;
        case 105: 
          { pushMultiStateText(yytext()); yybegin(XML_TEXT_CONTENT);
          }
        case 222: break;
        case 9: 
          { return symbol(PLUS);
          }
        case 223: break;
        case 75: 
          { pushMultiStateText(yytext()); pushString( '\\' );
          }
        case 224: break;
        case 16: 
          { return symbol(LPAREN);
          }
        case 225: break;
        case 106: 
          { return symbol(NULL_LITERAL, null);
          }
        case 226: break;
        case 112: 
          { return symbol(WITH);
          }
        case 227: break;
        case 38: 
          { error("unterminated regular expression at end of line");
          }
        case 228: break;
        case 6: 
          { return symbol(MINUS);
          }
        case 229: break;
        case 94: 
          { return symbol(LSHIFTEQ);
          }
        case 230: break;
        case 34: 
          { pushMultiStateText(yytext()); yybegin(YYINITIAL);
                                    return multiStateSymbol(STRING_LITERAL, getString());
          }
        case 231: break;
        case 42: 
          { setMultiStateText(yytext()); yybegin(XML_ATTRIBUTE_VALUE_DQ); clearString();
          }
        case 232: break;
        case 5: 
          { return symbol(IDE, yytext());
          }
        case 233: break;
        case 126: 
          { return symbol(SWITCH);
          }
        case 234: break;
        case 90: 
          { return symbol(INT_LITERAL, Long.parseLong(yytext().substring(2),16));
          }
        case 235: break;
        case 27: 
          { return symbol(XOR);
          }
        case 236: break;
        case 121: 
          { return symbol(THROW);
          }
        case 237: break;
        case 54: 
          { return symbol(PLUSPLUS);
          }
        case 238: break;
        case 123: 
          { return symbol(WHILE);
          }
        case 239: break;
        case 99: 
          { return symbol(FOR);
          }
        case 240: break;
        case 20: 
          { return symbol(SEMICOLON);
          }
        case 241: break;
        case 40: 
          { error("invalid Vector type");
          }
        case 242: break;
        case 74: 
          { pushMultiStateText(yytext()); pushString(yytext().substring(1));
          }
        case 243: break;
        case 81: 
          { pushMultiStateText(yytext()); pushString( '\f' );
          }
        case 244: break;
        case 141: 
          { yypushStream(createIncludeReader(yytext()));
          }
        case 245: break;
        case 92: 
          { return symbol(NEW);
          }
        case 246: break;
        case 86: 
          { return symbol(LT_QUESTION);
          }
        case 247: break;
        case 117: 
          { return symbol(CATCH);
          }
        case 248: break;
        case 63: 
          { return symbol(RSHIFT);
          }
        case 249: break;
        case 125: 
          { return symbol(DELETE);
          }
        case 250: break;
        case 56: 
          { return symbol(IN);
          }
        case 251: break;
        case 80: 
          { pushMultiStateText(yytext()); pushString( '\t' );
          }
        case 252: break;
        case 29: 
          { return symbol(BITNOT);
          }
        case 253: break;
        case 135: 
          { return symbol(INTERNAL);
          }
        case 254: break;
        case 114: 
          { pushMultiStateText(yytext());
                                   char val = (char) Integer.parseInt(yytext().substring(2),16);
                        	   pushString(val);
          }
        case 255: break;
        case 71: 
          { return symbol(OROR);
          }
        case 256: break;
        case 61: 
          { return symbol(LTEQ);
          }
        case 257: break;
        case 47: 
          { pushMultiStateText(yytext()); pushString(yytext());
          }
        case 258: break;
        case 116: 
          { return symbol(CLASS);
          }
        case 259: break;
        case 131: 
          { return symbol(EXTENDS);
          }
        case 260: break;
        case 58: 
          { return symbol(IF);
          }
        case 261: break;
        case 66: 
          { return symbol(EQEQ);
          }
        case 262: break;
        case 98: 
          { return symbol(TRY);
          }
        case 263: break;
        case 69: 
          { return symbol(ANDAND);
          }
        case 264: break;
        case 78: 
          { pushMultiStateText(yytext()); pushString( '\b' );
          }
        case 265: break;
        case 28: 
          { return symbol(MOD);
          }
        case 266: break;
        case 133: 
          { return symbol(PACKAGE);
          }
        case 267: break;
        case 83: 
          { increaseVectorNestingLevel(); return symbol(DOTLT);
          }
        case 268: break;
        case 11: 
          { return symbol(RBRACK);
          }
        case 269: break;
        case 122: 
          { return symbol(BOOL_LITERAL, Boolean.FALSE);
          }
        case 270: break;
        case 77: 
          { pushMultiStateText(yytext()); pushString( '\"' );
          }
        case 271: break;
        case 143: 
          { return symbol(IMPLEMENTS);
          }
        case 272: break;
        case 52: 
          { return symbol(FLOAT_LITERAL, new Double(yytext()));
          }
        case 273: break;
        case 132: 
          { return symbol(FINALLY);
          }
        case 274: break;
        case 3: 
          { return symbol(DIV);
          }
        case 275: break;
        case 60: 
          { return symbol(LSHIFT);
          }
        case 276: break;
        case 19: 
          { return symbol(RBRACE);
          }
        case 277: break;
        case 136: 
          { return symbol(CONTINUE);
          }
        case 278: break;
        case 93: 
          { return symbol(USE);
          }
        case 279: break;
        case 104: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 2;
          { return symbol(SLASH_GT);
          }
        case 280: break;
        case 51: 
          { return symbol(MINUSEQ);
          }
        case 281: break;
        case 12: 
          { setMultiStateText(yytext()); yybegin(STRING_DQ); clearString();
          }
        case 282: break;
        case 107: 
          { return symbol(CASE);
          }
        case 283: break;
        case 1: 
          { error("unrecognized input token");
          }
        case 284: break;
        case 23: 
          { return symbol(QUESTION);
          }
        case 285: break;
        case 44: 
          { setMultiStateText(yytext()); yybegin(XML_ATTRIBUTE_VALUE_SQ); clearString();
          }
        case 286: break;
        case 119: 
          { return symbol(SUPER);
          }
        case 287: break;
        case 2: 
          { pushWhitespace(yytext());
          }
        case 288: break;
        case 144: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 1;
          { setMultiStateText(""); yybegin(XML_TEXT_CONTENT); clearString(); return symbol(GT);
          }
        case 289: break;
        case 43: 
          { setMultiStateText(""); yybegin(XML_TEXT_CONTENT); clearString(); return symbol(GT);
          }
        case 290: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case XML_TEXT_CONTENT: {
              if (!getString().trim().isEmpty())  { error("unexpected tokens");
                                    } else {
                                      if (yymoreStreams()) yypopStream(); else return symbol(EOF);
                                    }
            }
            case 377: break;
            default:
              {
                if (yymoreStreams()) yypopStream(); else return symbol(EOF);
              }
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
