/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.StringReader;
import java.util.regex.Pattern;
import java_cup.runtime.Symbol;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scanner;
import net.jangaroo.jooc.ScannerBase;
import net.jangaroo.jooc.SilentLog;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.parser;

public class JooParser
extends parser {
    private static final SilentLog SILENT_LOG = new SilentLog();
    private SemicolonInsertionMode semicolonInsertionMode;
    private CompileLog log = SILENT_LOG;
    private boolean eofSeen = false;
    private static final Pattern LINE_TERMINATORS_PATTERN = Pattern.compile("[\n\r\u2028\u2029]");
    private Scanner scanner;

    public JooParser(Scanner scanner) {
        super(scanner);
        this.scanner = scanner;
    }

    public void setCompileLog(CompileLog log) {
        this.log = log;
    }

    public void setSemicolonInsertionMode(SemicolonInsertionMode semicolonInsertionMode) {
        this.semicolonInsertionMode = semicolonInsertionMode;
    }

    private boolean containsLineTerminator(String text) {
        return LINE_TERMINATORS_PATTERN.matcher(text).find();
    }

    private boolean insertVirtualToken(int token, String text) {
        if (this.eofSeen) {
            return false;
        }
        JooSymbol currentToken = (JooSymbol)this.cur_token;
        boolean bl = this.eofSeen = currentToken.sym == 0;
        if (token == 71) {
            boolean isBraceOrEof;
            if (currentToken.isSemicolonInsertedBefore()) {
                this.unrecovered_syntax_error(this.cur_token);
            }
            boolean bl2 = isBraceOrEof = this.cur_token.sym == 91 || this.cur_token.sym == 0;
            if (!isBraceOrEof) {
                this.checkSemicolonInsertionMode();
            }
        }
        if (currentToken.isVirtual() && currentToken.sym == token) {
            this.report_error("Internal parser error: infinite loop during virtual token insertion: " + this.scanner.getSymbolAbbreviation(this.cur_token.sym), this.cur_token);
            return false;
        }
        JooSymbol virtualToken = new JooSymbol(token, currentToken.getFileName(), currentToken.getLine(), currentToken.getColumn(), "", text);
        virtualToken.setVirtual(true);
        currentToken.setSemicolonInsertedBefore(token == 71);
        this.cur_token = virtualToken;
        this.scanner.pushback(currentToken);
        return true;
    }

    private boolean replaceToken(int token) {
        JooSymbol currentToken = (JooSymbol)this.cur_token;
        this.cur_token = new JooSymbol(token, currentToken.getFileName(), currentToken.getLine(), currentToken.getColumn(), currentToken.getWhitespace(), currentToken.getText());
        return true;
    }

    private int getActionFromTable(int sym2) {
        return this.get_action(((Symbol)this.stack.peek()).parse_state, sym2);
    }

    private boolean isActionDefinedFor(int sym2) {
        return this.getActionFromTable(sym2) != 0;
    }

    private boolean isShiftActionDefinedFor(int sym2) {
        return this.getActionFromTable(sym2) > 0;
    }

    protected boolean error_recovery(boolean debug) {
        boolean isPostfixOp;
        String whitespace = ((JooSymbol)this.cur_token).getWhitespace();
        boolean bl = isPostfixOp = this.cur_token.sym == 43 || this.cur_token.sym == 44;
        if ((this.cur_token.sym == 48 || this.cur_token.sym == 75) && this.isActionDefinedFor(109)) {
            this.scanner.startRegexp((JooSymbol)this.cur_token);
            return this.replaceToken(109);
        }
        if (this.cur_token.sym == 74 && this.isActionDefinedFor(110)) {
            this.scanner.startType((JooSymbol)this.cur_token);
            return this.replaceToken(110);
        }
        if (this.cur_token.sym == 90 && this.isActionDefinedFor(108)) {
            return this.replaceToken(108);
        }
        if (this.cur_token.sym == 16 && this.isActionDefinedFor(106)) {
            return this.replaceToken(106);
        }
        if (this.cur_token.sym == 92 && this.isActionDefinedFor(107)) {
            return this.replaceToken(107);
        }
        boolean isShiftActionDefinedForNoLineTerminatorHere = this.isShiftActionDefinedFor(111);
        if (isShiftActionDefinedForNoLineTerminatorHere || isPostfixOp && this.isActionDefinedFor(112)) {
            if (this.containsLineTerminator(whitespace)) {
                if (this.isActionDefinedFor(71)) {
                    return this.insertVirtualToken(71, ";");
                }
                if (isPostfixOp) {
                    this.report_fatal_error("postfix operator should be on same line (semicolon insertion would produce syntax error)", this.cur_token);
                }
            }
            return this.insertVirtualToken(isShiftActionDefinedForNoLineTerminatorHere ? 111 : 112, "[no line terminator here]");
        }
        if (this.isActionDefinedFor(71)) {
            boolean isBraceOrEof;
            boolean bl2 = isBraceOrEof = this.cur_token.sym == 91 || this.cur_token.sym == 0;
            if (isBraceOrEof || this.containsLineTerminator(whitespace)) {
                return this.insertVirtualToken(71, ";");
            }
        }
        return false;
    }

    private void checkSemicolonInsertionMode() {
        switch (this.semicolonInsertionMode) {
            case ERROR: {
                this.log.error((FilePosition)((JooSymbol)this.cur_token), "automatic semicolon insertion required by language spec, but forbidden by jooc semicolonInsertionMode");
                break;
            }
            case WARN: {
                this.log.warning((FilePosition)((JooSymbol)this.cur_token), "automatic semicolon insertion");
            }
        }
    }

    public void report_error(String message, Object info) {
        if (info instanceof JooSymbol) {
            this.log.error((FilePosition)((JooSymbol)((Object)info)), message);
        } else {
            this.log.error("Error: " + message);
        }
    }

    public void unrecovered_syntax_error(Symbol cur_token) {
        this.report_fatal_error("Syntax error: " + this.scanner.getSymbolAbbreviation(cur_token.sym), cur_token);
    }

    public void report_fatal_error(String message, Object info) {
        this.report_error(message, info);
        this.done_parsing();
        throw new FatalSyntaxError("Fatal Syntax Error");
    }

    public void syntax_error(Symbol cur_token) {
    }

    @Nonnull
    public Symbol parseEmbedded(String string, int line, int column) {
        StringReader reader = new StringReader(string);
        this.scanner.prepareEmbedded(reader, line, column);
        try {
            return this.parse();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not parse Jangaroo source", e);
        }
    }

    public JooParser silent() {
        return new JooParser(this.scanner);
    }

    public ScannerBase getScannerBase() {
        return this.scanner;
    }

    class FatalSyntaxError
    extends RuntimeException {
        FatalSyntaxError(String msg) {
            super(msg);
        }
    }
}

