/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AnnotationsAndModifiers;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.Typed;

public abstract class TypedIdeDeclaration
extends IdeDeclaration
implements Typed {
    private Ide namespace;
    private TypeRelation optTypeRelation;

    TypedIdeDeclaration(AnnotationsAndModifiers am, Ide ide, TypeRelation optTypeRelation) {
        super(am, ide);
        this.namespace = this.findNamespace(am.getModifiers());
        this.optTypeRelation = optTypeRelation;
    }

    private Ide findNamespace(List<JooSymbol> modifiers) {
        for (JooSymbol modifier : modifiers) {
            if (this.getModifierFlag(modifier) != 512) continue;
            return new Ide(modifier);
        }
        return null;
    }

    public Ide getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isPublicApi() {
        return super.isPublicApi() || this.getNamespace() != null;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.optTypeRelation);
    }

    @Override
    public void scope(Scope scope) {
        if (this.namespace != null) {
            this.namespace.scope(scope);
        }
        if (this.getOptTypeRelation() != null) {
            this.getOptTypeRelation().scope(scope);
        }
        ClassDeclaration classDeclaration = scope.getClassDeclaration();
        super.scope(scope);
        if (this.isClassMember() && classDeclaration != null) {
            classDeclaration.registerMember(this);
        }
    }

    void addPublicApiDependencyOn(TypeRelation optTypeRelation) {
        if (optTypeRelation != null) {
            optTypeRelation.getType().getIde().addPublicApiDependency();
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.namespace != null) {
            this.namespace.analyze(parentNode);
        }
        if (this.isPublicApi()) {
            if (this.namespace != null) {
                this.namespace.addPublicApiDependency();
            }
            this.addPublicApiDependencyOn(this.optTypeRelation);
        }
        if (this.optTypeRelation != null) {
            this.optTypeRelation.analyze(parentNode);
        }
    }

    @Override
    boolean allowDuplicates(Scope scope) {
        return scope.getClassDeclaration() == null || super.allowDuplicates(scope);
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        return this.getOptTypeRelation() == null ? null : this.getOptTypeRelation().getType().resolveDeclaration();
    }

    @Override
    public TypeRelation getOptTypeRelation() {
        return this.optTypeRelation;
    }
}

