/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties;

import java.io.File;
import java.util.Locale;
import net.jangaroo.utils.CompilerUtils;

public class PropcHelper {
    public static final String DEFAULT_LOCALE = "en";

    public static Locale computeLocale(String propertiesClassName) {
        String[] parts = PropcHelper.getBundleName(propertiesClassName).split("_", 4);
        switch (parts.length) {
            case 4: {
                return new Locale(parts[1], parts[2], parts[3]);
            }
            case 3: {
                return new Locale(parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[1]);
            }
        }
        return null;
    }

    public static String computeBaseClassName(String propertiesClassName) {
        String bundleName = PropcHelper.getBundleName(propertiesClassName);
        int underscorePos = bundleName.indexOf(95);
        if (underscorePos != -1) {
            return propertiesClassName.substring(0, underscorePos) + "_properties";
        }
        return propertiesClassName;
    }

    public static String getBundleName(String propertiesClassName) {
        return propertiesClassName.substring(0, propertiesClassName.length() - "_properties".length());
    }

    public static File computeGeneratedPropertiesAS3File(File apiOutputDirectory, String className) {
        String generatedPropertiesClassFileName = CompilerUtils.fileNameFromQName((String)className, (char)'/', (String)".as");
        return new File(apiOutputDirectory, generatedPropertiesClassFileName);
    }

    public static File computeGeneratedPropertiesJsFile(File outputDirectory, String className, Locale locale) {
        String localeSubDir = locale == null ? DEFAULT_LOCALE : locale.toString();
        String generatedPropertiesClassFileName = localeSubDir + '/' + CompilerUtils.fileNameFromQName((String)className, (char)'/', (String)".js");
        return new File(outputDirectory, generatedPropertiesClassFileName);
    }
}

