/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.PropertyDeclaration;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.mxml.MxmlParserHelper;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.jooc.mxml.ast.CompilationUnitUtils;
import net.jangaroo.jooc.mxml.ast.MxmlAstUtils;
import net.jangaroo.jooc.mxml.ast.MxmlCompilationUnit;
import net.jangaroo.jooc.mxml.ast.XmlAttribute;
import net.jangaroo.jooc.mxml.ast.XmlElement;
import net.jangaroo.utils.CompilerUtils;
import org.apache.commons.lang3.StringUtils;

final class MxmlToModelParser {
    private static final String EXT_CONFIG_CREATE_FLAG = "create";
    private static final String EXT_CONFIG_EXTRACT_XTYPE_PARAMETER = "extractXType";
    private static final String CONFIG_MODE_AT_SUFFIX = "$at";
    private static final String CONFIG_MODE_ATTRIBUTE_NAME = "mode";
    private static final Map<String, String> CONFIG_MODE_TO_AT_VALUE = new HashMap<String, String>();
    private static final String DELETE_OBJECT_PROPERTY_CODE = "\n    delete %s['%s'];";
    private static final String UNTYPED_MARKER = "__UNTYPED__";
    private final JangarooParser jangarooParser;
    private final MxmlParserHelper mxmlParserHelper;
    private final MxmlCompilationUnit compilationUnit;
    private final Collection<Directive> initConfigBodyDirectives = new LinkedList<Directive>();
    private final Collection<Directive> classBodyDirectives = new LinkedList<Directive>();

    MxmlToModelParser(JangarooParser jangarooParser, MxmlParserHelper mxmlParserHelper, MxmlCompilationUnit mxmlCompilationUnit) {
        this.jangarooParser = jangarooParser;
        this.mxmlParserHelper = mxmlParserHelper;
        this.compilationUnit = mxmlCompilationUnit;
    }

    private void renderConfigAuxVar(@Nonnull Ide ide, Ide type) {
        this.initConfigBodyDirectives.add(MxmlAstUtils.createVariableDeclaration(ide, type));
    }

    private void processAttributes(XmlElement objectNode, CompilationUnit type, Ide configVariable, @Nonnull Ide targetVariable, boolean generatingConfig) {
        Ide variable = generatingConfig ? configVariable : targetVariable;
        ClassDeclaration classModel = type == null ? null : (ClassDeclaration)type.getPrimaryDeclaration();
        boolean hasIdAttribute = false;
        for (XmlAttribute attribute : objectNode.getAttributes()) {
            Annotation eventModel;
            String propertyName = attribute.getLocalName();
            boolean noPrefix = attribute.getPrefix() == null;
            hasIdAttribute |= noPrefix && "id".equals(propertyName);
            String attributeNamespaceUri = objectNode.getNamespaceUri(attribute.getPrefix());
            boolean isUntypedAccess = "exml:untyped".equals(attributeNamespaceUri);
            if ((!noPrefix || "id".equals(propertyName)) && !isUntypedAccess) continue;
            JooSymbol value = attribute.getValue();
            TypedIdeDeclaration propertyModel = null;
            if (!isUntypedAccess && classModel != null && (propertyModel = this.findPropertyModel(classModel, propertyName)) == null && (eventModel = this.findEvent(classModel, propertyName)) != null) {
                this.createEventHandlerCode(variable, value, eventModel);
                continue;
            }
            if (propertyModel == null) {
                propertyModel = this.createDynamicPropertyModel(objectNode, type, propertyName, isUntypedAccess);
            }
            this.createPropertyAssignmentCodeWithBindings(configVariable, targetVariable, generatingConfig, value, propertyModel);
        }
    }

    private void createPropertyAssignmentCodeWithBindings(Ide configVariable, @Nonnull Ide targetVariable, boolean generatingConfig, @Nonnull JooSymbol value, @Nonnull TypedIdeDeclaration propertyModel) {
        Ide variable;
        Ide ide = variable = generatingConfig ? configVariable : targetVariable;
        if (generatingConfig || configVariable == null) {
            this.createPropertyAssignmentCode(variable, propertyModel, value, generatingConfig);
        }
    }

    private static Annotation getAnnotationAtSetter(TypedIdeDeclaration memberModel, String annotationName) {
        Iterator<Annotation> annotations;
        TypedIdeDeclaration setter = null;
        if (memberModel instanceof PropertyDeclaration) {
            setter = ((PropertyDeclaration)memberModel).getSetter();
        } else if (memberModel instanceof VariableDeclaration && !((VariableDeclaration)memberModel).isConst()) {
            setter = memberModel;
        }
        if (setter != null && (annotations = setter.getAnnotations(annotationName).iterator()).hasNext()) {
            return annotations.next();
        }
        return null;
    }

    void processAttributesAndChildNodes(XmlElement objectNode, Ide configVariable, @Nonnull Ide targetVariable, boolean generatingConfig) {
        if (!objectNode.getAttributes().isEmpty() || !objectNode.getElements().isEmpty()) {
            CompilationUnit type = this.getCompilationUnitModel(objectNode);
            this.processAttributes(objectNode, type, configVariable, targetVariable, generatingConfig);
            this.processChildNodes(objectNode, type, configVariable, targetVariable, generatingConfig);
        }
    }

    private void processChildNodes(XmlElement objectNode, CompilationUnit type, Ide configVariable, @Nonnull Ide targetVariable, boolean generatingConfig) {
        Ide variable = generatingConfig ? configVariable : targetVariable;
        ClassDeclaration classModel = type == null ? null : (ClassDeclaration)type.getPrimaryDeclaration();
        List<XmlElement> childNodes = objectNode.getElements();
        TypedIdeDeclaration defaultPropertyModel = this.findDefaultPropertyModel(classModel);
        ArrayList<XmlElement> defaultPropertyValues = new ArrayList<XmlElement>();
        for (XmlElement element : childNodes) {
            String configMode;
            String atValue;
            List<XmlElement> childElements;
            Object textContent;
            if (MxmlUtils.isMxmlNamespace(element.getNamespaceURI())) continue;
            TypedIdeDeclaration propertyModel = null;
            String propertyName = element.getLocalName();
            if (objectNode.getNamespaceURI().equals(element.getNamespaceURI()) && classModel != null) {
                propertyModel = this.findPropertyModel(classModel, propertyName);
                if (propertyModel == null) {
                    Annotation eventModel = this.findEvent(classModel, propertyName);
                    if (eventModel != null) {
                        textContent = MxmlToModelParser.getTextContent(element);
                        this.createEventHandlerCode(variable, (JooSymbol)((Object)textContent), eventModel);
                        continue;
                    }
                } else if ("__mixins__".equals(MxmlToModelParser.getConfigOptionName(propertyModel))) {
                    List<XmlElement> exmlMixins = element.getElements();
                    for (XmlElement exmlMixin : exmlMixins) {
                        this.processAttributesAndChildNodes(exmlMixin, configVariable, targetVariable, generatingConfig);
                    }
                    continue;
                }
            }
            if (propertyModel == null && defaultPropertyModel != null) {
                defaultPropertyValues.add(element);
                continue;
            }
            if (propertyModel == null) {
                propertyModel = this.createDynamicPropertyModel(element, type, propertyName, false);
            }
            if ((childElements = element.getElements()).isEmpty()) {
                textContent = MxmlToModelParser.getTextContent(element);
                this.createPropertyAssignmentCodeWithBindings(configVariable, targetVariable, generatingConfig, (JooSymbol)((Object)textContent), propertyModel);
            } else {
                this.createChildElementsPropertyAssignmentCode(childElements, variable, propertyModel, generatingConfig);
            }
            if ((atValue = CONFIG_MODE_TO_AT_VALUE.get(configMode = MxmlToModelParser.getConfigMode(element, propertyModel))) == null) continue;
            String atPropertyName = generatingConfig ? MxmlToModelParser.getConfigOptionName(propertyModel) : propertyModel.getName();
            ArrayIndexExpr dotExpr = new ArrayIndexExpr(new IdeExpr(new Ide(variable.getIde().withWhitespace("\n    "))), MxmlAstUtils.SYM_LBRACK, new LiteralExpr(new JooSymbol(CompilerUtils.quote((String)(atPropertyName + CONFIG_MODE_AT_SUFFIX)))), MxmlAstUtils.SYM_RBRACK);
            IdeExpr ideExpr = new IdeExpr(this.mxmlParserHelper.parseIde(atValue));
            this.initConfigBodyDirectives.add(MxmlAstUtils.createSemicolonTerminatedStatement(new AssignmentOpExpr(dotExpr, MxmlAstUtils.SYM_EQ.withWhitespace(" "), ideExpr)));
        }
        if (!defaultPropertyValues.isEmpty()) {
            this.createChildElementsPropertyAssignmentCode(defaultPropertyValues, variable, defaultPropertyModel, generatingConfig);
        }
    }

    private static String getConfigMode(XmlElement element, TypedIdeDeclaration propertyModel) {
        if ("Array".equals(propertyModel.getOptTypeRelation().getType().getIde().getName())) {
            String configMode = element.getAttributeNS("http://www.jangaroo.net/exml/0.8", CONFIG_MODE_ATTRIBUTE_NAME);
            if (!configMode.isEmpty()) {
                return configMode;
            }
            Annotation extConfigAnnotation = propertyModel.getAnnotation("ExtConfig");
            if (extConfigAnnotation != null) {
                for (CommaSeparatedList<AnnotationParameter> annotationParameters = extConfigAnnotation.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
                    Object jooValue;
                    AstNode value;
                    Ide name = annotationParameters.getHead().getOptName();
                    if (name == null || !CONFIG_MODE_ATTRIBUTE_NAME.equals(name.getName()) || !((value = annotationParameters.getHead().getValue()) instanceof LiteralExpr) || !((jooValue = value.getSymbol().getJooValue()) instanceof String)) continue;
                    return (String)jooValue;
                }
            }
        }
        return "";
    }

    private void createChildElementsPropertyAssignmentCode(List<XmlElement> childElements, Ide variable, TypedIdeDeclaration propertyModel, boolean generatingConfig) {
        Object extractXType;
        Map<String, Object> propertiesByName;
        boolean forceArray = "Array".equals(propertyModel.getOptTypeRelation().getType().getIde().getName());
        Annotation extConfigAnnotation = MxmlToModelParser.getAnnotationAtSetter(propertyModel, "ExtConfig");
        Boolean useConfigObjects = extConfigAnnotation == null ? null : MxmlToModelParser.useConfigObjects(extConfigAnnotation, null);
        String value = this.createArrayCodeFromChildElements(childElements, forceArray, useConfigObjects);
        if (extConfigAnnotation != null && (propertiesByName = extConfigAnnotation.getPropertiesByName()).containsKey(EXT_CONFIG_EXTRACT_XTYPE_PARAMETER) && ((extractXType = propertiesByName.get(EXT_CONFIG_EXTRACT_XTYPE_PARAMETER)) == null || extractXType instanceof String)) {
            String extractXTypeToProperty = (String)extractXType;
            StringBuilder methodBodyCode = new StringBuilder();
            if (extractXTypeToProperty != null) {
                methodBodyCode.append("    ").append(MxmlToModelParser.getPropertyAssignmentCode(variable, extractXTypeToProperty, value + "['xtype']"));
            }
            methodBodyCode.append(String.format(DELETE_OBJECT_PROPERTY_CODE, value, "xtype"));
            methodBodyCode.append(String.format(DELETE_OBJECT_PROPERTY_CODE, value, "xclass"));
            this.initConfigBodyDirectives.addAll(this.mxmlParserHelper.parseMethodBody(methodBodyCode.toString()));
        }
        this.createPropertyAssignmentCode(variable, propertyModel, new JooSymbol(MxmlUtils.createBindingExpression(value)), generatingConfig);
    }

    private String createArrayCodeFromChildElements(List<XmlElement> childElements, boolean forceArray, Boolean useConfigObjects) {
        ArrayList<String> arrayItems = new ArrayList<String>();
        for (XmlElement arrayItemNode : childElements) {
            String itemValue = this.createValueCodeFromElement(null, arrayItemNode, useConfigObjects);
            arrayItems.add(itemValue);
        }
        String value = arrayItems.size() > 1 || forceArray ? "[" + MxmlToModelParser.join(arrayItems, ", ") + "]" : (arrayItems.isEmpty() ? "null" : (String)arrayItems.get(0));
        return value;
    }

    private static String join(List<String> array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(array.get(i));
        }
        return sb.toString();
    }

    @Nullable
    String createValueCodeFromElement(@Nullable Ide configVar, XmlElement objectElement, Boolean defaultUseConfigObjects) {
        String className;
        try {
            className = this.mxmlParserHelper.getClassNameForElement(this.jangarooParser, objectElement);
        }
        catch (CompilerError e) {
            throw JangarooParser.error(objectElement.getSymbol(), e.getMessage(), e.getCause());
        }
        Ide typeIde = this.compilationUnit.addImport(className);
        String targetVariableName = null;
        XmlAttribute idAttribute = objectElement.getAttribute("id");
        String id = null;
        if (null != idAttribute) {
            String qualifier;
            JooSymbol idSymbol = idAttribute.getValue();
            id = idSymbol.getText();
            if (id.equals(this.compilationUnit.getConstructorParamName())) {
                return null;
            }
            Ide.verifyIdentifier(id, idSymbol);
            VariableDeclaration variableDeclaration = this.compilationUnit.getVariables().get(id);
            String string = qualifier = null != configVar ? configVar.getName() : "";
            if (null != variableDeclaration) {
                if (!variableDeclaration.isPublic()) {
                    qualifier = "";
                }
            } else {
                String asDoc = MxmlUtils.toASDoc(objectElement.getSymbol().getWhitespace());
                int i = asDoc.lastIndexOf(10);
                StringBuilder classBodyCode = new StringBuilder();
                classBodyCode.append(asDoc).append('[').append("Bindable").append(']').append(i < 0 ? "\n" : asDoc.substring(i)).append("public var ").append(id).append(':').append(className).append(';');
                this.classBodyDirectives.addAll(this.mxmlParserHelper.parseClassBody(new JooSymbol(classBodyCode.toString())).getDirectives());
            }
            targetVariableName = CompilerUtils.qName((String)qualifier, (String)id);
        }
        if (id != null && configVar != null && objectElement.getAttributes().size() == 1 && objectElement.getChildren().isEmpty() && objectElement.getTextNodes().isEmpty()) {
            return null;
        }
        Ide configVariable = null;
        if (Boolean.TRUE.equals(defaultUseConfigObjects) || CompilationUnitUtils.constructorSupportsConfigOptionsParameter(className, this.jangarooParser)) {
            configVariable = this.createAuxVar(objectElement, id);
            this.renderConfigAuxVar(configVariable, typeIde != null ? typeIde : new Ide(className));
            if (targetVariableName == null) {
                targetVariableName = this.createAuxVar(objectElement).getName();
            }
            this.processAttributesAndChildNodes(objectElement, configVariable, new Ide(targetVariableName), true);
        }
        String value = this.createValueCodeFromElement(objectElement, defaultUseConfigObjects, className, configVariable);
        StringBuilder methodBodyCode = new StringBuilder();
        if (null != id) {
            methodBodyCode.append("    ").append(targetVariableName);
        } else if (configVariable == null) {
            targetVariableName = this.createAuxVar(objectElement).getName();
            methodBodyCode.append("    ").append("var ").append(targetVariableName).append(":").append(className);
        } else {
            if (this.useConfigObjects(defaultUseConfigObjects, className)) {
                return configVariable.getName();
            }
            return value;
        }
        methodBodyCode.append(" = ").append(value).append(";");
        this.initConfigBodyDirectives.addAll(this.mxmlParserHelper.parseMethodBody(methodBodyCode.toString()));
        if (configVariable == null && !"Array".equals(className)) {
            Ide ide;
            Ide ide2 = ide = null != targetVariableName ? new Ide(targetVariableName) : null;
            if (null == ide) {
                throw new IllegalStateException("potential NPE ahead!");
            }
            this.processAttributesAndChildNodes(objectElement, null, ide, false);
        }
        return targetVariableName;
    }

    private String createValueCodeFromElement(XmlElement objectElement, Boolean defaultUseConfigObjects, String className, Ide configVariable) {
        String value;
        JooSymbol textContentSymbol = MxmlToModelParser.getTextContent(objectElement);
        String textContent = textContentSymbol.getText().trim();
        if (MxmlUtils.isBindingExpression(textContent)) {
            return MxmlUtils.getBindingExpression(textContent);
        }
        if ("String".equals(className)) {
            return CompilerUtils.quote((String)textContent);
        }
        if ("int".equals(className) || "uint".equals(className) || "Number".equals(className) || "Boolean".equals(className)) {
            return textContent.isEmpty() ? null : textContent;
        }
        if (!textContent.isEmpty()) {
            throw Jooc.error(textContentSymbol, String.format("Unexpected text inside MXML element: '%s'.", textContent));
        }
        if ("Object".equals(className)) {
            value = "{}";
        } else if ("Array".equals(className)) {
            value = this.createArrayCodeFromChildElements(objectElement.getElements(), true, defaultUseConfigObjects);
        } else {
            StringBuilder valueBuilder = new StringBuilder();
            valueBuilder.append("new ").append(className).append("(");
            if (configVariable != null) {
                valueBuilder.append(configVariable);
            }
            valueBuilder.append(")");
            value = valueBuilder.toString();
        }
        return value;
    }

    private boolean useConfigObjects(Boolean defaultUseConfigObjects, String className) {
        if (defaultUseConfigObjects != null) {
            return defaultUseConfigObjects;
        }
        ClassDeclaration classModel = (ClassDeclaration)this.jangarooParser.resolveCompilationUnit(className).getPrimaryDeclaration();
        CompilationUnit extPluginCompilationUnit = this.jangarooParser.getCompilationUnit("ext.Plugin");
        if (extPluginCompilationUnit != null && classModel.isAssignableTo((ClassDeclaration)extPluginCompilationUnit.getPrimaryDeclaration())) {
            return true;
        }
        ClassDeclaration current = classModel;
        while (current != null) {
            Iterator<Annotation> extConfigAnnotations = current.getAnnotations("ExtConfig").iterator();
            if (extConfigAnnotations.hasNext()) {
                Annotation extConfigAnnotation = extConfigAnnotations.next();
                return MxmlToModelParser.useConfigObjects(extConfigAnnotation, true);
            }
            current = this.getSuperClassModel(current);
        }
        return false;
    }

    private static Boolean useConfigObjects(Annotation extConfigAnnotation, Boolean defaultValue) {
        for (CommaSeparatedList<AnnotationParameter> annotationParameters = extConfigAnnotation.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
            AnnotationParameter annotationParameter = annotationParameters.getHead();
            Ide annotationParameterName = annotationParameter.getOptName();
            if (annotationParameterName == null) continue;
            if (EXT_CONFIG_CREATE_FLAG.equals(annotationParameterName.getName())) {
                AstNode value = annotationParameter.getValue();
                return value instanceof LiteralExpr && Boolean.FALSE.equals(((LiteralExpr)value).getValue().getJooValue());
            }
            if (!EXT_CONFIG_EXTRACT_XTYPE_PARAMETER.equals(annotationParameterName.getName())) continue;
            return true;
        }
        return defaultValue;
    }

    private Ide createAuxVar(XmlElement element) {
        JooSymbol symbol = element.getSymbol();
        String prefix = element.getName();
        return this.createAuxVar(symbol, prefix);
    }

    @Nonnull
    private Ide createAuxVar(@Nonnull XmlElement element, @Nullable String idAttributeValue) {
        JooSymbol symbol = element.getSymbol();
        StringBuilder name = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)idAttributeValue)) {
            String prefix = element.getPrefix();
            if (null != prefix) {
                name.append(prefix).append('_');
            }
            name.append(element.getLocalName());
        } else {
            name.append(idAttributeValue);
            Ide.verifyIdentifier(idAttributeValue, symbol);
        }
        return this.createAuxVar(symbol, name.toString());
    }

    @Nonnull
    private Ide createAuxVar(@Nonnull JooSymbol symbol, @Nonnull String prefix) {
        String preferredName = CompilerUtils.uncapitalize((String)prefix.replaceAll("-", "\\$")) + '_' + symbol.getLine() + '_' + symbol.getColumn();
        return this.compilationUnit.createAuxVar(preferredName);
    }

    private void createEventHandlerCode(@Nonnull Ide ide, @Nonnull JooSymbol value, @Nonnull Annotation event) {
        String eventTypeStr;
        Map<String, Object> eventPropertiesByName = event.getPropertiesByName();
        Object eventType = eventPropertiesByName.get("type");
        if (eventType instanceof String) {
            eventTypeStr = (String)eventType;
            this.compilationUnit.addImport(eventTypeStr);
        } else {
            eventTypeStr = "Object";
        }
        Object eventNameModel = eventPropertiesByName.get("name");
        String eventName = (String)(eventNameModel != null ? eventNameModel : eventPropertiesByName.get(null));
        if (eventName.startsWith("on")) {
            eventName = eventName.substring(2);
        }
        String eventNameConstant = (eventName.substring(0, 1) + eventName.substring(1).replaceAll("([A-Z])", "_$1")).toUpperCase();
        String variable = ide.getName();
        String eventHandlerName = "$on_" + variable + "_" + eventName.replace('-', '_');
        StringBuilder classBodyCode = new StringBuilder();
        classBodyCode.append("private function ").append(eventHandlerName).append(" (").append("event").append(':').append(eventTypeStr).append(") :void {\n").append("\n    ").append(value.getText()).append('}');
        this.classBodyDirectives.addAll(this.mxmlParserHelper.parseClassBody(new JooSymbol(classBodyCode.toString())).getDirectives());
        StringBuilder methodBodyCode = new StringBuilder();
        methodBodyCode.append("    ").append(variable).append(".addEventListener(").append(eventTypeStr).append(".").append(eventNameConstant).append(", ").append(eventHandlerName).append(");");
        this.initConfigBodyDirectives.addAll(this.mxmlParserHelper.parseMethodBody(methodBodyCode.toString()));
    }

    private void createPropertyAssignmentCode(@Nonnull Ide variable, @Nonnull TypedIdeDeclaration propertyModel, @Nonnull JooSymbol value, boolean generatingConfig) {
        Directive propertyAssignment = this.createPropertyAssigment(variable, propertyModel, value, generatingConfig);
        this.initConfigBodyDirectives.add(propertyAssignment);
    }

    @Nonnull
    private Directive createPropertyAssigment(@Nonnull Ide variable, @Nonnull TypedIdeDeclaration propertyModel, @Nonnull JooSymbol value, boolean generatingConfig) {
        TypeRelation typeRelation = propertyModel.getOptTypeRelation();
        String propertyType = typeRelation == null ? null : typeRelation.getType().getIde().getName();
        boolean untyped = UNTYPED_MARKER.equals(propertyType);
        String attributeValueAsString = MxmlUtils.valueToString(MxmlUtils.getAttributeValue(value.getText(), untyped ? null : propertyType));
        String propertyName = generatingConfig ? MxmlToModelParser.getConfigOptionName(propertyModel) : propertyModel.getName();
        boolean untypedAccess = true;
        Expr rightHandSide = this.mxmlParserHelper.parseExpression(value.replacingSymAndTextAndJooValue(value.sym, attributeValueAsString, null));
        return MxmlAstUtils.createPropertyAssignment(variable, rightHandSide, propertyName, untypedAccess);
    }

    @Nonnull
    private static String getPropertyAssignmentCode(@Nonnull Ide variable, String propertyName, String attributeValueAsString) {
        String leftHandSide = MessageFormat.format("{0}[{1}]", variable.getName(), CompilerUtils.quote((String)propertyName));
        return MessageFormat.format("{0} = {1};", leftHandSide, attributeValueAsString);
    }

    private static String getConfigOptionName(TypedIdeDeclaration propertyModel) {
        Object configOption;
        Iterator<Annotation> configOptionAnnotations;
        TypedIdeDeclaration setter;
        TypedIdeDeclaration typedIdeDeclaration = setter = propertyModel instanceof PropertyDeclaration ? ((PropertyDeclaration)propertyModel).getSetter() : propertyModel;
        if (setter != null && (configOptionAnnotations = setter.getAnnotations("ExtConfig").iterator()).hasNext() && (configOption = configOptionAnnotations.next().getPropertiesByName().get(null)) instanceof String) {
            return (String)configOption;
        }
        return propertyModel.getName();
    }

    @Nonnull
    private CompilationUnit getCompilationUnitModel(XmlElement element) {
        String fullClassName = this.mxmlParserHelper.getClassNameForElement(this.jangarooParser, element);
        try {
            return this.jangarooParser.resolveCompilationUnit(fullClassName);
        }
        catch (CompilerError e) {
            throw JangarooParser.error(element, e.getMessage());
        }
    }

    private TypedIdeDeclaration findPropertyModel(ClassDeclaration classModel, String propertyName) {
        TypedIdeDeclaration memberModel;
        TypedIdeDeclaration propertyModel = null;
        ClassDeclaration superClassModel = this.getSuperClassModel(classModel);
        if (superClassModel != null) {
            propertyModel = this.findPropertyModel(superClassModel, propertyName);
        }
        if (propertyModel == null && (memberModel = classModel.getMemberDeclaration(propertyName)) != null) {
            propertyModel = memberModel;
        }
        return propertyModel;
    }

    private Annotation findEvent(ClassDeclaration classModel, String propertyName) {
        ClassDeclaration current = classModel;
        while (current != null) {
            Annotation eventModel = this.getEvent(current, propertyName);
            if (eventModel != null) {
                return eventModel;
            }
            current = this.getSuperClassModel(current);
        }
        return null;
    }

    private Annotation getEvent(ClassDeclaration classDeclaration, String propertyName) {
        for (Annotation eventAnnotation : classDeclaration.getAnnotations("Event")) {
            for (CommaSeparatedList<AnnotationParameter> annotationParameters = eventAnnotation.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
                AstNode value;
                Ide name = annotationParameters.getHead().getOptName();
                if (name == null || !"name".equals(name.getName()) || !((value = annotationParameters.getHead().getValue()) instanceof LiteralExpr) || !propertyName.equals(value.getSymbol().getJooValue())) continue;
                return eventAnnotation;
            }
        }
        return null;
    }

    private TypedIdeDeclaration findDefaultPropertyModel(ClassDeclaration classModel) {
        ClassDeclaration current = classModel;
        while (current != null) {
            TypedIdeDeclaration defaultPropertyModel = this.findPropertyWithAnnotation(current, "DefaultProperty");
            if (defaultPropertyModel != null) {
                return defaultPropertyModel;
            }
            current = this.getSuperClassModel(current);
        }
        return null;
    }

    private TypedIdeDeclaration findPropertyWithAnnotation(ClassDeclaration current, String annotation) {
        for (TypedIdeDeclaration member : current.getMembers()) {
            if (member.getAnnotations(annotation).isEmpty()) continue;
            return member;
        }
        return null;
    }

    @Nonnull
    private TypedIdeDeclaration createDynamicPropertyModel(XmlElement element, CompilationUnit compilationUnitModel, String name, boolean allowAnyProperty) {
        if (!allowAnyProperty && compilationUnitModel != null && compilationUnitModel.getPrimaryDeclaration() != null && !compilationUnitModel.getPrimaryDeclaration().isDynamic()) {
            this.jangarooParser.getLog().error((FilePosition)element.getSymbol(), "MXML: property " + name + " not found in class " + compilationUnitModel.getQualifiedNameStr() + ".");
        }
        return new VariableDeclaration(new JooSymbol("var"), new Ide(name), new TypeRelation(new JooSymbol(allowAnyProperty ? UNTYPED_MARKER : "*")));
    }

    private ClassDeclaration getSuperClassModel(ClassDeclaration classModel) {
        return classModel.getSuperTypeDeclaration();
    }

    @Nonnull
    private static JooSymbol getTextContent(XmlElement element) {
        return (JooSymbol)((Object)Iterables.getFirst(element.getTextNodes(), (Object)((Object)new JooSymbol(""))));
    }

    Collection<Directive> getInitConfigBodyDirectives() {
        return this.initConfigBodyDirectives;
    }

    Collection<Directive> getClassBodyDirectives() {
        return this.classBodyDirectives;
    }

    static {
        CONFIG_MODE_TO_AT_VALUE.put("append", "net.jangaroo.ext.Exml.APPEND");
        CONFIG_MODE_TO_AT_VALUE.put("prepend", "net.jangaroo.ext.Exml.PREPEND");
    }
}

