/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.jangaroo.jooc.CompressorImpl;
import net.jangaroo.jooc.api.Compressor;
import net.jangaroo.jooc.api.Packager;

public class PackagerImpl
implements Packager {
    private static final String DEFAULT_LOCALE = "en";
    private Compressor compressor = new CompressorImpl();

    public void doPackage(File sourceDirectory, File overridesDirectory, File localizedOverridesDirectory, File outputDirectory, String outputFilePrefix) throws IOException {
        this.pack(outputDirectory, this.packageJsFileName(outputFilePrefix), sourceDirectory, new File(localizedOverridesDirectory, DEFAULT_LOCALE));
        this.pack(outputDirectory, this.overridesJsFilename(outputFilePrefix), overridesDirectory);
        File[] children = localizedOverridesDirectory.listFiles();
        if (children != null) {
            for (File child : children) {
                String locale = child.getName();
                if (!child.isDirectory() || DEFAULT_LOCALE.equals(locale)) continue;
                this.pack(outputDirectory, this.overridesJsFilename(outputFilePrefix, locale), child);
            }
        }
    }

    private void pack(File outputDirectory, String outputFileName, File ... sourceDirectories) throws IOException {
        File outputFile = new File(outputDirectory, outputFileName);
        ArrayList<File> sources = new ArrayList<File>();
        long timestamp = outputFile.lastModified();
        boolean somethingChanged = false;
        for (File dir : sourceDirectories) {
            somethingChanged |= this.scanSources(dir, timestamp, sources);
        }
        String outputFilePath = outputFile.getAbsolutePath();
        if (somethingChanged && !sources.isEmpty()) {
            System.out.println(String.format("Packing %d js files into %s", sources.size(), outputFilePath));
            this.pack(sources, outputFile);
        } else if (sources.isEmpty()) {
            if (outputFile.exists()) {
                System.out.println(String.format("No js files found, removing %s", outputFilePath));
                if (!outputFile.delete()) {
                    throw new IOException(String.format("failed to delete %s", outputFilePath));
                }
            } else {
                System.out.println(String.format("No js files found, skipping generation of %s", outputFile.getAbsolutePath()));
            }
        } else {
            System.out.println(String.format("Nothing changed, keeping %s", outputFilePath));
        }
    }

    private boolean scanSources(File dir, long timestamp, ArrayList<File> sources) {
        boolean somethingChanged = dir.lastModified() > timestamp;
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    somethingChanged |= this.scanSources(child, timestamp, sources);
                    continue;
                }
                if (!child.getName().endsWith(".js")) continue;
                sources.add(child);
                somethingChanged |= child.lastModified() > timestamp;
            }
        }
        return somethingChanged;
    }

    private void pack(Collection<File> inputFiles, File output) throws IOException {
        this.compressor.compress(inputFiles, output);
    }

    private String packageJsFileName(String prefix) {
        return this.packageJsFileName(prefix, "");
    }

    private String packageJsFileName(String prefix, String suffix) {
        return String.format("%s%s.js", prefix, suffix);
    }

    private String overridesJsFilename(String prefix, String locale) {
        return this.packageJsFileName(prefix, "-overrides" + (locale.isEmpty() ? "" : "-") + locale);
    }

    private String overridesJsFilename(String prefix) {
        return this.overridesJsFilename(prefix, "");
    }
}

