/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.model.AbstractAnnotatedModel;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.ModelVisitor;
import net.jangaroo.jooc.model.NamespacedModel;
import net.jangaroo.jooc.model.PropertyModel;

public class ClassModel
extends AbstractAnnotatedModel
implements NamespacedModel {
    private boolean isInterface = false;
    private boolean isFinal = false;
    private boolean isDynamic = false;
    private String namespace = "public";
    private String superclass = null;
    private String annotationCode = "";
    private String bodyCode = "";
    private List<String> interfaces = new ArrayList<String>();
    private List<MemberModel> members = new ArrayList<MemberModel>();

    public ClassModel() {
    }

    public ClassModel(String name) {
        super(name);
    }

    public ClassModel(String name, String superclass) {
        super(name);
        this.superclass = superclass;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean value) {
        this.isInterface = value;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public void addInterface(String interfaceName) {
        this.interfaces.add(interfaceName);
    }

    public String getAnnotationCode() {
        return this.annotationCode;
    }

    public void setAnnotationCode(String annotationCode) {
        this.annotationCode = annotationCode;
    }

    public void addAnnotationCode(String code) {
        this.annotationCode = this.annotationCode + code;
    }

    public String getBodyCode() {
        return this.bodyCode;
    }

    public void setBodyCode(String bodyCode) {
        this.bodyCode = bodyCode;
    }

    public void addBodyCode(String code) {
        this.bodyCode = this.bodyCode + code;
    }

    public List<AnnotationModel> getEvents() {
        return this.getAnnotations("Event");
    }

    public AnnotationModel getEvent(String name) {
        for (AnnotationModel event : this.getEvents()) {
            AnnotationPropertyModel eventName = event.getPropertiesByName().get("name");
            if (eventName == null && (eventName = event.getPropertiesByName().get(null)) == null) {
                System.out.println("*** no event value found: " + event.getProperties());
            }
            if (eventName == null || !name.equals(eventName.getStringValue())) continue;
            return event;
        }
        return null;
    }

    public List<MemberModel> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public void setMembers(List<MemberModel> members) {
        this.members = members;
    }

    public MemberModel addMember(MemberModel member) {
        MemberModel oldMember = this.getMember(member.isStatic(), member.getName());
        if (oldMember != null) {
            if (oldMember.isProperty()) {
                PropertyModel oldPropertyModel = (PropertyModel)oldMember;
                if (member.isGetter()) {
                    oldMember = oldPropertyModel.getGetter();
                } else if (member.isSetter()) {
                    oldMember = oldPropertyModel.getSetter();
                }
            }
            if (oldMember != null) {
                if (oldMember.equals(member)) {
                    return null;
                }
                this.removeMember(oldMember);
            }
        }
        if (member.isProperty()) {
            PropertyModel propertyModel = (PropertyModel)member;
            this.addIfNotNull(propertyModel.getGetter());
            this.addIfNotNull(propertyModel.getSetter());
        } else {
            this.members.add(member);
        }
        return oldMember;
    }

    private void addIfNotNull(MethodModel method) {
        if (method != null) {
            this.members.add(method);
        }
    }

    public PropertyModel getProperty(boolean isStatic, String name) {
        MemberModel member = this.getMember(isStatic, name);
        return member != null && member.isProperty() ? (PropertyModel)member : null;
    }

    public MemberModel getMember(String name) {
        return this.getMember(false, name);
    }

    public MemberModel getStaticMember(String name) {
        return this.getMember(true, name);
    }

    public MemberModel getMember(boolean isStatic, String name) {
        MemberModel member = this.getMethodOrField(isStatic, name);
        if (member instanceof MethodModel && member.isAccessor()) {
            return this.getProperty((MethodModel)member);
        }
        return member;
    }

    public PropertyModel getProperty(MethodModel accessor) {
        if (accessor == null || !accessor.isAccessor()) {
            return null;
        }
        MethodModel counterpart = this.getMethod(accessor.isStatic(), accessor.isGetter() ? MethodType.SET : MethodType.GET, accessor.getName());
        return new PropertyModel(accessor, counterpart);
    }

    private MemberModel getMethodOrField(boolean isStatic, String name) {
        int index = this.getMethodOrFieldIndex(isStatic, name);
        return index != -1 ? this.members.get(index) : null;
    }

    public boolean removeMember(MemberModel memberModel) {
        int index = this.getMethodOrFieldIndex(memberModel.isStatic(), memberModel.getName());
        return index != -1 && this.members.remove(index) != null;
    }

    private int getMethodOrFieldIndex(boolean isStatic, String name) {
        for (int i = 0; i < this.members.size(); ++i) {
            MemberModel memberModel = this.members.get(i);
            if (memberModel.isStatic() != isStatic || !name.equals(memberModel.getName())) continue;
            return i;
        }
        return -1;
    }

    public MethodModel getConstructor() {
        return this.getMethod(this.getName());
    }

    public MethodModel getStaticMethod(String name) {
        return this.getStaticMethod(null, name);
    }

    public MethodModel getStaticMethod(MethodType methodType, String name) {
        return this.getMethod(false, methodType, name);
    }

    public MethodModel getMethod(String name) {
        return this.getMethod(false, name);
    }

    public MethodModel getMethod(MethodType methodType, String name) {
        return this.getMethod(false, methodType, name);
    }

    private MethodModel getMethod(boolean isStatic, String name) {
        return this.getMethod(isStatic, null, name);
    }

    public MethodModel getMethod(boolean isStatic, MethodType methodType, String name) {
        for (MemberModel memberModel : this.members) {
            if (!memberModel.isMethod() || ((MethodModel)memberModel).getMethodType() != methodType || memberModel.isStatic() != isStatic || !name.equals(memberModel.getName())) continue;
            return (MethodModel)memberModel;
        }
        return null;
    }

    public MethodModel createConstructor() {
        MethodModel constructor = new MethodModel(this.getName(), null);
        this.addMember(constructor);
        return constructor;
    }

    @Override
    public void visit(ModelVisitor visitor) {
        visitor.visitClass(this);
    }

    public MemberModel findPropertyWithAnnotation(boolean isStatic, String annotationName) {
        for (MemberModel memberModel : this.members) {
            if (memberModel.isStatic() != isStatic || memberModel.getAnnotations(annotationName).isEmpty()) continue;
            return this.asFieldOrProperty(memberModel);
        }
        return null;
    }

    private MemberModel asFieldOrProperty(MemberModel memberModel) {
        if (memberModel.isField()) {
            return memberModel;
        }
        if (memberModel instanceof MethodModel) {
            return this.getProperty((MethodModel)memberModel);
        }
        return null;
    }

    public Set<MemberModel> findPropertiesWithAnnotation(boolean isStatic, String annotationName) {
        LinkedHashSet<MemberModel> result = new LinkedHashSet<MemberModel>();
        for (MemberModel memberModel : this.members) {
            if (memberModel.isStatic() != isStatic || memberModel.getAnnotations(annotationName).isEmpty()) continue;
            result.add(this.asFieldOrProperty(memberModel));
        }
        return Collections.unmodifiableSet(result);
    }
}

