/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.jangaroo.jooc.CompilationUnitRegistry;
import net.jangaroo.jooc.CompilationUnitResolver;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.TransitiveAstVisitor;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.ActionScriptCodeGeneratingModelVisitor;
import net.jangaroo.jooc.backend.ApiModelGenerator;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.EmbeddedAssetResolver;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.config.JoocOptions;
import net.jangaroo.utils.CompilerUtils;
import org.apache.tools.ant.util.FileUtils;

public class SingleFileCompilationUnitSinkFactory
extends AbstractCompilationUnitSinkFactory {
    private final CompilationUnitRegistry compilationUnitRegistry;
    private String suffix;
    private boolean generateApi;
    private final CompilationUnitResolver compilationUnitModelResolver;

    public SingleFileCompilationUnitSinkFactory(JoocOptions options, File destinationDir, boolean generateApi, String suffix, CompilationUnitResolver compilationUnitModelResolver, CompilationUnitRegistry compilationUnitRegistry) {
        super(options, destinationDir);
        this.suffix = suffix;
        this.generateApi = generateApi;
        this.compilationUnitModelResolver = compilationUnitModelResolver;
        this.compilationUnitRegistry = compilationUnitRegistry;
    }

    protected File getOutputFile(File sourceFile, String qName) {
        if (this.getOutputDir() == null) {
            File outputDirectory = sourceFile.getAbsoluteFile().getParentFile();
            return new File(outputDirectory, CompilerUtils.qNameFromFile((File)outputDirectory, (File)sourceFile) + this.suffix);
        }
        return CompilerUtils.fileFromQName((String)qName, (File)this.getOutputDir(), (String)this.suffix);
    }

    @Override
    public CompilationUnitSink createSink(PackageDeclaration packageDeclaration, IdeDeclaration primaryDeclaration, final File sourceFile, final boolean verbose) {
        final File outFile = this.getOutputFile(sourceFile, primaryDeclaration.getQualifiedNameStr());
        this.createOutputDirs(outFile);
        return new CompilationUnitSink(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public File writeOutput(CompilationUnit compilationUnit) {
                block11: {
                    if (verbose) {
                        System.out.println("writing file: '" + outFile.getAbsolutePath() + "'");
                    }
                    try {
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
                        try {
                            if (SingleFileCompilationUnitSinkFactory.this.generateApi) {
                                ApiModelGenerator apiModelGenerator = new ApiModelGenerator(SingleFileCompilationUnitSinkFactory.isExcludeClassByDefault(SingleFileCompilationUnitSinkFactory.this.getOptions()));
                                apiModelGenerator.generateModel(compilationUnit).visit(new ActionScriptCodeGeneratingModelVisitor(writer));
                                break block11;
                            }
                            JsWriter out = new JsWriter(writer);
                            String codeSuffix = "";
                            try {
                                out.setOptions(SingleFileCompilationUnitSinkFactory.this.getOptions());
                                compilationUnit.visit(new TransitiveAstVisitor(new EmbeddedAssetResolver(compilationUnit, SingleFileCompilationUnitSinkFactory.this.compilationUnitRegistry)));
                                compilationUnit.visit(new JsCodeGenerator(out, SingleFileCompilationUnitSinkFactory.this.compilationUnitModelResolver));
                                if (SingleFileCompilationUnitSinkFactory.this.options.isGenerateSourceMaps()) {
                                    codeSuffix = SingleFileCompilationUnitSinkFactory.this.generateSourceMap(out, outFile);
                                }
                            }
                            finally {
                                out.close(codeSuffix);
                            }
                            if (SingleFileCompilationUnitSinkFactory.this.options.isGenerateSourceMaps()) {
                                FileUtils.getFileUtils().copyFile(sourceFile, new File(outFile.getParentFile(), sourceFile.getName()));
                            }
                        }
                        catch (IOException e) {
                            outFile.delete();
                            throw JangarooParser.error("error writing file: '" + outFile.getAbsolutePath() + "'", outFile, (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        throw JangarooParser.error("cannot open output file for writing: '" + outFile.getAbsolutePath() + "'", outFile, (Throwable)e);
                    }
                }
                return outFile;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateSourceMap(JsWriter out, File outFile) throws IOException {
        SourceMapGenerator sourceMapGenerator = SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3);
        sourceMapGenerator.validate(true);
        for (JsWriter.SymbolToOutputFilePosition entry : out.getSourceMappings()) {
            String sourceFilename = entry.getSymbol().getFileName();
            sourceFilename = sourceFilename.substring(sourceFilename.lastIndexOf(File.separatorChar) + 1);
            sourceMapGenerator.addMapping(sourceFilename, entry.getSymbol().getText(), entry.getSourceFilePosition(), entry.getOutputFileStartPosition(), entry.getOutputFileEndPosition());
        }
        String sourceMapFilename = outFile.getAbsolutePath() + ".map";
        try (FileWriter sourceMapWriter = new FileWriter(sourceMapFilename);){
            sourceMapGenerator.appendTo((Appendable)sourceMapWriter, outFile.getName());
        }
        return "//# sourceMappingURL=" + outFile.getName() + ".map";
    }

    private static boolean isExcludeClassByDefault(JoocOptions options) {
        try {
            return options.isExcludeClassByDefault();
        }
        catch (IncompatibleClassChangeError e) {
            return false;
        }
    }
}

