/* The following code was generated by JFlex 1.4.3 on 11/30/16 3:56 PM */

/*
 * Copyright 2008-2010 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/*
 * JangarooScript lexical scanner definition for the JFlex scanner generator
 *
 * Author: Andreas Gawecki
 */

/*
From http://livedocs.adobe.com/specs/actionscript/3/as3_specification118.html:

13.1 Lexical

Lexical keywords are removed from the available program namespace during scanning. It is a syntax error to use any of
these names except as indicated by the grammar. Syntactic keywords appear to the lexical scanner as identifier tokens,
but are given special meaning in certain contexts by the parser.

The following list contains all keywords:

as break case catch class const continue default delete do else extends false finally for function if implements import
in instanceof interface internal is new null package private protected public return super switch this throw
true try typeof use var void while with

The following list contains all identifiers that are syntactic keywords:

each get set to namespace include dynamic final native override static

Former Jangaroo keywords:

abstract assert enum final goto namespace override static synchronized throws transient volatile


13.2 Syntactic

Identifiers with special meaning become keywords in certain syntactic contexts:

    * In a for-each-in statement between the 'for' token and the '(' token:
      each
    * In a function definition between the 'function' token and an identifier token:
      get set
    * As the first word of a directive:
      namespace include
    * In an attribute list or wherever an attribute list can be used:
      dynamic final native override static

It is a syntax error to use a syntactic keyword in a context where it is treated as a keyword:

namespace = "hello"
namespace()

In these cases, the grammar requires an identifier after the namespace keyword.


*/

package net.jangaroo.jooc;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 11/30/16 3:56 PM from the specification file
 * <tt>/var/lib/jenkins/workspace/jangaroo-tools-release/target/checkout/jangaroo/jangaroo-compiler/src/main/jflex/net/jangaroo/jooc/joo.flex</tt>
 */
class Scanner extends ScannerBase implements sym, java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int XML_TEXT_CONTENT = 20;
  public static final int VECTOR_TYPE = 12;
  public static final int REGEXP_START = 6;
  public static final int XML_ATTRIBUTE_VALUE_DQ = 16;
  public static final int REGEXP_REST = 10;
  public static final int REGEXP_FIRST = 8;
  public static final int STRING_SQ = 2;
  public static final int YYINITIAL = 0;
  public static final int CDATA_SECTION = 22;
  public static final int STRING_DQ = 4;
  public static final int MXML = 14;
  public static final int XML_ATTRIBUTE_VALUE_SQ = 18;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\76\1\0\1\3\1\2\22\0\1\32\1\35\1\33"+
    "\1\0\1\6\1\73\1\70\1\75\1\57\1\60\1\5\1\16\1\64"+
    "\1\10\1\14\1\4\1\11\11\12\1\67\1\63\1\34\1\65\1\36"+
    "\1\66\1\6\1\101\1\22\1\77\1\100\1\15\1\22\15\6\1\102"+
    "\3\6\1\13\2\6\1\17\1\20\1\21\1\72\1\6\1\0\1\37"+
    "\1\41\1\25\1\30\1\31\1\47\1\55\1\45\1\23\1\6\1\43"+
    "\1\26\1\52\1\24\1\46\1\53\1\6\1\42\1\40\1\44\1\27"+
    "\1\56\1\54\1\50\1\51\1\6\1\61\1\71\1\62\1\74\53\0"+
    "\1\6\12\0\1\6\4\0\1\6\5\0\27\6\1\0\37\6\1\0"+
    "\u01ca\6\4\0\14\6\16\0\5\6\7\0\1\6\1\0\1\6\201\0"+
    "\5\6\1\0\2\6\2\0\4\6\10\0\1\6\1\0\3\6\1\0"+
    "\1\6\1\0\24\6\1\0\123\6\1\0\213\6\10\0\236\6\11\0"+
    "\46\6\2\0\1\6\7\0\47\6\110\0\33\6\5\0\3\6\55\0"+
    "\53\6\25\0\12\7\4\0\2\6\1\0\143\6\1\0\1\6\17\0"+
    "\2\6\7\0\2\6\12\7\3\6\2\0\1\6\20\0\1\6\1\0"+
    "\36\6\35\0\131\6\13\0\1\6\16\0\12\7\41\6\11\0\2\6"+
    "\4\0\1\6\5\0\26\6\4\0\1\6\11\0\1\6\3\0\1\6"+
    "\27\0\31\6\107\0\1\6\1\0\13\6\127\0\66\6\3\0\1\6"+
    "\22\0\1\6\7\0\12\6\4\0\12\7\1\0\7\6\1\0\7\6"+
    "\5\0\10\6\2\0\2\6\2\0\26\6\1\0\7\6\1\0\1\6"+
    "\3\0\4\6\3\0\1\6\20\0\1\6\15\0\2\6\1\0\3\6"+
    "\4\0\12\7\2\6\23\0\6\6\4\0\2\6\2\0\26\6\1\0"+
    "\7\6\1\0\2\6\1\0\2\6\1\0\2\6\37\0\4\6\1\0"+
    "\1\6\7\0\12\7\2\0\3\6\20\0\11\6\1\0\3\6\1\0"+
    "\26\6\1\0\7\6\1\0\2\6\1\0\5\6\3\0\1\6\22\0"+
    "\1\6\17\0\2\6\4\0\12\7\25\0\10\6\2\0\2\6\2\0"+
    "\26\6\1\0\7\6\1\0\2\6\1\0\5\6\3\0\1\6\36\0"+
    "\2\6\1\0\3\6\4\0\12\7\1\0\1\6\21\0\1\6\1\0"+
    "\6\6\3\0\3\6\1\0\4\6\3\0\2\6\1\0\1\6\1\0"+
    "\2\6\3\0\2\6\3\0\3\6\3\0\14\6\26\0\1\6\25\0"+
    "\12\7\25\0\10\6\1\0\3\6\1\0\27\6\1\0\12\6\1\0"+
    "\5\6\3\0\1\6\32\0\2\6\6\0\2\6\4\0\12\7\25\0"+
    "\10\6\1\0\3\6\1\0\27\6\1\0\12\6\1\0\5\6\3\0"+
    "\1\6\40\0\1\6\1\0\2\6\4\0\12\7\1\0\2\6\22\0"+
    "\10\6\1\0\3\6\1\0\51\6\2\0\1\6\20\0\1\6\21\0"+
    "\2\6\4\0\12\7\12\0\6\6\5\0\22\6\3\0\30\6\1\0"+
    "\11\6\1\0\1\6\2\0\7\6\72\0\60\6\1\0\2\6\14\0"+
    "\7\6\11\0\12\7\47\0\2\6\1\0\1\6\2\0\2\6\1\0"+
    "\1\6\2\0\1\6\6\0\4\6\1\0\7\6\1\0\3\6\1\0"+
    "\1\6\1\0\1\6\2\0\2\6\1\0\4\6\1\0\2\6\11\0"+
    "\1\6\2\0\5\6\1\0\1\6\11\0\12\7\2\0\4\6\40\0"+
    "\1\6\37\0\12\7\26\0\10\6\1\0\44\6\33\0\5\6\163\0"+
    "\53\6\24\0\1\6\12\7\6\0\6\6\4\0\4\6\3\0\1\6"+
    "\3\0\2\6\7\0\3\6\4\0\15\6\14\0\1\6\1\0\12\7"+
    "\6\0\46\6\1\0\1\6\5\0\1\6\2\0\53\6\1\0\u014d\6"+
    "\1\0\4\6\2\0\7\6\1\0\1\6\1\0\4\6\2\0\51\6"+
    "\1\0\4\6\2\0\41\6\1\0\4\6\2\0\7\6\1\0\1\6"+
    "\1\0\4\6\2\0\17\6\1\0\71\6\1\0\4\6\2\0\103\6"+
    "\45\0\20\6\20\0\125\6\14\0\u026c\6\2\0\21\6\1\0\32\6"+
    "\5\0\113\6\25\0\15\6\1\0\4\6\16\0\22\6\16\0\22\6"+
    "\16\0\15\6\1\0\3\6\17\0\64\6\43\0\1\6\4\0\1\6"+
    "\3\0\12\7\46\0\12\7\6\0\130\6\10\0\51\6\1\0\1\6"+
    "\5\0\106\6\12\0\35\6\51\0\12\7\36\6\2\0\5\6\13\0"+
    "\54\6\25\0\7\6\10\0\12\7\46\0\27\6\11\0\65\6\53\0"+
    "\12\7\6\0\12\7\15\0\1\6\135\0\57\6\21\0\7\6\4\0"+
    "\12\7\51\0\36\6\15\0\2\6\12\7\54\6\32\0\44\6\34\0"+
    "\12\7\3\0\3\6\12\7\44\6\153\0\4\6\1\0\4\6\3\0"+
    "\2\6\11\0\300\6\100\0\u0116\6\2\0\6\6\2\0\46\6\2\0"+
    "\6\6\2\0\10\6\1\0\1\6\1\0\1\6\1\0\1\6\1\0"+
    "\37\6\2\0\65\6\1\0\7\6\1\0\1\6\3\0\3\6\1\0"+
    "\7\6\3\0\4\6\2\0\6\6\4\0\15\6\5\0\3\6\1\0"+
    "\7\6\53\0\2\1\107\0\1\6\15\0\1\6\20\0\15\6\145\0"+
    "\1\6\4\0\1\6\2\0\12\6\1\0\1\6\3\0\5\6\6\0"+
    "\1\6\1\0\1\6\1\0\1\6\1\0\4\6\1\0\13\6\2\0"+
    "\4\6\5\0\5\6\4\0\1\6\64\0\2\6\u0a7b\0\57\6\1\0"+
    "\57\6\1\0\205\6\6\0\4\6\3\0\2\6\14\0\46\6\1\0"+
    "\1\6\5\0\1\6\2\0\70\6\7\0\1\6\20\0\27\6\11\0"+
    "\7\6\1\0\7\6\1\0\7\6\1\0\7\6\1\0\7\6\1\0"+
    "\7\6\1\0\7\6\1\0\7\6\120\0\1\6\u01d5\0\2\6\52\0"+
    "\5\6\5\0\2\6\4\0\126\6\6\0\3\6\1\0\132\6\1\0"+
    "\4\6\5\0\51\6\3\0\136\6\21\0\33\6\65\0\20\6\u0200\0"+
    "\u19b6\6\112\0\u51cd\6\63\0\u048d\6\103\0\56\6\2\0\u010d\6\3\0"+
    "\20\6\12\7\2\6\24\0\57\6\20\0\31\6\10\0\106\6\61\0"+
    "\11\6\2\0\147\6\2\0\4\6\1\0\4\6\14\0\13\6\115\0"+
    "\12\6\1\0\3\6\1\0\4\6\1\0\27\6\35\0\64\6\16\0"+
    "\62\6\34\0\12\7\30\0\6\6\3\0\1\6\4\0\12\7\34\6"+
    "\12\0\27\6\31\0\35\6\7\0\57\6\34\0\1\6\12\7\46\0"+
    "\51\6\27\0\3\6\1\0\10\6\4\0\12\7\6\0\27\6\3\0"+
    "\1\6\5\0\60\6\1\0\1\6\3\0\2\6\2\0\5\6\2\0"+
    "\1\6\1\0\1\6\30\0\3\6\2\0\13\6\7\0\3\6\14\0"+
    "\6\6\2\0\6\6\2\0\6\6\11\0\7\6\1\0\7\6\221\0"+
    "\43\6\15\0\12\7\6\0\u2ba4\6\14\0\27\6\4\0\61\6\u2104\0"+
    "\u016e\6\2\0\152\6\46\0\7\6\14\0\5\6\5\0\1\6\1\0"+
    "\12\6\1\0\15\6\1\0\5\6\1\0\1\6\1\0\2\6\1\0"+
    "\2\6\1\0\154\6\41\0\u016b\6\22\0\100\6\2\0\66\6\50\0"+
    "\14\6\164\0\5\6\1\0\207\6\23\0\12\7\7\0\32\6\6\0"+
    "\32\6\13\0\131\6\3\0\6\6\2\0\6\6\2\0\6\6\2\0"+
    "\3\6\40\0\1\3\2\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\14\0\1\1\1\2\1\3\1\4\1\5\1\6\2\7"+
    "\1\10\1\11\1\12\1\13\6\5\1\14\1\15\1\16"+
    "\1\17\11\5\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\0\1\41\1\37\1\42\1\43"+
    "\1\44\1\45\1\46\3\43\1\47\2\43\2\50\1\4"+
    "\1\10\1\51\1\1\1\5\1\52\1\15\1\53\1\26"+
    "\1\1\1\30\1\54\1\55\1\56\1\0\1\57\1\55"+
    "\2\60\2\61\1\2\1\0\1\62\1\63\1\64\1\65"+
    "\1\66\1\0\1\66\2\0\1\67\1\70\1\71\1\72"+
    "\1\73\1\74\10\5\1\75\2\5\1\76\1\77\1\100"+
    "\1\101\1\102\1\103\22\5\1\104\1\105\1\106\1\107"+
    "\1\110\1\111\1\112\1\113\1\114\1\115\1\116\1\114"+
    "\1\117\1\120\1\121\1\122\1\123\1\114\1\124\6\0"+
    "\1\125\1\126\1\127\1\0\1\130\1\131\1\132\3\133"+
    "\1\134\3\0\1\135\1\0\1\66\1\136\5\5\1\137"+
    "\4\5\1\140\4\5\1\141\1\142\1\143\1\144\5\5"+
    "\1\145\6\5\1\146\6\5\1\147\1\5\1\150\1\151"+
    "\1\152\2\0\1\153\5\0\1\154\5\5\1\155\1\5"+
    "\1\156\5\5\1\157\1\5\1\160\4\5\1\161\1\162"+
    "\11\5\1\163\1\5\1\164\1\0\1\165\5\0\1\166"+
    "\5\5\1\167\1\170\1\171\4\5\1\172\1\5\1\173"+
    "\1\5\1\174\3\5\1\175\4\5\1\176\4\0\5\5"+
    "\1\177\1\5\1\200\2\5\1\201\1\202\1\203\2\5"+
    "\1\204\3\5\4\0\6\5\1\205\1\206\1\207\1\5"+
    "\1\210\1\211\1\5\4\0\1\5\1\212\2\5\1\213"+
    "\1\214\1\5\4\0\1\5\1\215\1\5\1\216\2\0"+
    "\1\217\1\220\1\221\1\222\1\0\1\223\1\224";

  private static int [] zzUnpackAction() {
    int [] result = new int[380];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\103\0\206\0\311\0\u010c\0\u014f\0\u0192\0\u01d5"+
    "\0\u0218\0\u025b\0\u029e\0\u02e1\0\u0324\0\u0324\0\u0367\0\u03aa"+
    "\0\u03ed\0\u0430\0\u0473\0\u04b6\0\u04f9\0\u053c\0\u0324\0\u0324"+
    "\0\u057f\0\u05c2\0\u0605\0\u0648\0\u068b\0\u06ce\0\u0324\0\u0711"+
    "\0\u0754\0\u0797\0\u07da\0\u081d\0\u0860\0\u08a3\0\u08e6\0\u0929"+
    "\0\u096c\0\u09af\0\u09f2\0\u0324\0\u0324\0\u0324\0\u0324\0\u0324"+
    "\0\u0324\0\u0a35\0\u0324\0\u0a78\0\u0abb\0\u0afe\0\u0b41\0\u0b84"+
    "\0\u0324\0\u0324\0\u0bc7\0\u0324\0\u0c0a\0\u0324\0\u0c4d\0\u0324"+
    "\0\u0324\0\u0324\0\u0324\0\u0324\0\u0c90\0\u0cd3\0\u0d16\0\u0d59"+
    "\0\u0d9c\0\u0ddf\0\u0324\0\u0e22\0\u0324\0\u0e65\0\u0324\0\u0ea8"+
    "\0\u0eeb\0\u0324\0\u0f2e\0\u0f71\0\u0324\0\u0fb4\0\u0324\0\u0324"+
    "\0\u0ff7\0\u0324\0\u103a\0\u0324\0\u107d\0\u10c0\0\u1103\0\u0324"+
    "\0\u1146\0\u1189\0\u11cc\0\u0324\0\u0324\0\u0324\0\u0324\0\u120f"+
    "\0\u1252\0\u1295\0\u12d8\0\u131b\0\u0324\0\u0324\0\u0324\0\u135e"+
    "\0\u03ed\0\u03ed\0\u13a1\0\u13e4\0\u1427\0\u146a\0\u14ad\0\u14f0"+
    "\0\u1533\0\u1576\0\u03ed\0\u15b9\0\u15fc\0\u163f\0\u0324\0\u1682"+
    "\0\u16c5\0\u0324\0\u03ed\0\u1708\0\u174b\0\u178e\0\u17d1\0\u1814"+
    "\0\u1857\0\u189a\0\u18dd\0\u1920\0\u1963\0\u19a6\0\u19e9\0\u1a2c"+
    "\0\u1a6f\0\u1ab2\0\u1af5\0\u1b38\0\u1b7b\0\u1bbe\0\u0324\0\u0324"+
    "\0\u1c01\0\u0324\0\u1c44\0\u0324\0\u0324\0\u0324\0\u0324\0\u0324"+
    "\0\u1c87\0\u0324\0\u0324\0\u0324\0\u0324\0\u0324\0\u1cca\0\u0324"+
    "\0\u0c90\0\u1d0d\0\u0d16\0\u0d9c\0\u0ddf\0\u1d50\0\u0324\0\u1d93"+
    "\0\u0324\0\u1dd6\0\u0324\0\u1e19\0\u0324\0\u0324\0\u1e5c\0\u1e9f"+
    "\0\u0324\0\u1ee2\0\u1f25\0\u1f68\0\u1252\0\u1fab\0\u1fab\0\u0324"+
    "\0\u1fee\0\u2031\0\u2074\0\u20b7\0\u20fa\0\u03ed\0\u213d\0\u2180"+
    "\0\u21c3\0\u2206\0\u03ed\0\u2249\0\u228c\0\u22cf\0\u2312\0\u0324"+
    "\0\u0324\0\u2355\0\u0324\0\u2398\0\u23db\0\u241e\0\u2461\0\u24a4"+
    "\0\u03ed\0\u24e7\0\u252a\0\u256d\0\u25b0\0\u25f3\0\u2636\0\u03ed"+
    "\0\u2679\0\u26bc\0\u26ff\0\u2742\0\u2785\0\u27c8\0\u03ed\0\u280b"+
    "\0\u0324\0\u0324\0\u0324\0\u284e\0\u2891\0\u28d4\0\u2917\0\u295a"+
    "\0\u299d\0\u29e0\0\u2a23\0\u2a66\0\u2aa9\0\u2aec\0\u2b2f\0\u2b72"+
    "\0\u2bb5\0\u03ed\0\u2bf8\0\u03ed\0\u2c3b\0\u2c7e\0\u2cc1\0\u2d04"+
    "\0\u2d47\0\u03ed\0\u2d8a\0\u0324\0\u2dcd\0\u2e10\0\u2e53\0\u2e96"+
    "\0\u03ed\0\u03ed\0\u2ed9\0\u2f1c\0\u2f5f\0\u2fa2\0\u2fe5\0\u3028"+
    "\0\u306b\0\u30ae\0\u30f1\0\u03ed\0\u3134\0\u03ed\0\u1cca\0\u0324"+
    "\0\u3177\0\u31ba\0\u31fd\0\u1e9f\0\u3240\0\u0324\0\u3283\0\u32c6"+
    "\0\u3309\0\u334c\0\u338f\0\u03ed\0\u03ed\0\u03ed\0\u33d2\0\u3415"+
    "\0\u3458\0\u349b\0\u03ed\0\u34de\0\u03ed\0\u3521\0\u03ed\0\u3564"+
    "\0\u35a7\0\u35ea\0\u03ed\0\u362d\0\u3670\0\u36b3\0\u36f6\0\u03ed"+
    "\0\u3739\0\u377c\0\u37bf\0\u3802\0\u3845\0\u3888\0\u38cb\0\u390e"+
    "\0\u3951\0\u03ed\0\u3994\0\u03ed\0\u39d7\0\u3a1a\0\u03ed\0\u03ed"+
    "\0\u03ed\0\u3a5d\0\u3aa0\0\u03ed\0\u3ae3\0\u3b26\0\u3b69\0\u3bac"+
    "\0\u3bef\0\u3c32\0\u3c75\0\u3cb8\0\u3cfb\0\u3d3e\0\u3d81\0\u3dc4"+
    "\0\u3e07\0\u03ed\0\u03ed\0\u03ed\0\u3e4a\0\u03ed\0\u03ed\0\u3e8d"+
    "\0\u3ed0\0\u3f13\0\u3f56\0\u3f99\0\u3fdc\0\u03ed\0\u401f\0\u4062"+
    "\0\u03ed\0\u03ed\0\u40a5\0\u40e8\0\u412b\0\u416e\0\u41b1\0\u41f4"+
    "\0\u03ed\0\u4237\0\u03ed\0\u427a\0\u42bd\0\u0324\0\u0324\0\u03ed"+
    "\0\u03ed\0\u4300\0\u0324\0\u0324";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[380];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\15\3\16\1\17\1\20\1\21\1\15\1\22\1\23"+
    "\1\24\1\21\1\25\1\21\1\26\1\27\1\15\1\30"+
    "\1\21\1\31\1\32\1\33\1\21\1\34\1\35\1\36"+
    "\1\16\1\37\1\40\1\41\1\42\1\43\1\44\1\45"+
    "\1\46\1\21\1\47\2\21\1\50\3\21\1\51\1\52"+
    "\1\21\1\53\1\54\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\1\70\1\71"+
    "\1\72\1\16\4\21\2\73\1\74\15\73\1\75\54\73"+
    "\1\76\1\74\4\73\2\77\1\74\15\77\1\75\12\77"+
    "\1\100\42\77\1\74\4\77\4\101\1\102\76\101\1\103"+
    "\2\104\1\103\2\101\11\103\1\105\1\106\55\103\1\104"+
    "\4\103\1\107\2\104\1\107\1\110\12\107\1\111\1\112"+
    "\55\107\1\104\4\107\1\113\3\16\1\114\1\115\1\21"+
    "\4\113\1\21\1\116\1\21\4\113\10\21\1\16\3\113"+
    "\1\117\20\21\17\113\1\16\4\21\1\15\3\16\1\120"+
    "\1\15\1\121\4\15\1\121\1\15\1\121\4\15\10\121"+
    "\1\16\1\122\1\123\1\15\1\124\20\121\6\15\1\125"+
    "\1\126\1\127\5\15\1\130\1\16\4\121\2\131\1\132"+
    "\15\131\1\133\12\131\1\134\42\131\1\132\4\131\2\135"+
    "\1\132\15\135\1\133\54\135\1\134\1\132\4\135\34\136"+
    "\1\137\46\136\21\140\1\141\61\140\107\0\1\142\1\143"+
    "\57\0\1\144\102\0\1\145\23\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\20\21\20\0\4\21"+
    "\10\0\1\146\54\0\1\147\26\0\2\150\1\151\1\152"+
    "\1\153\13\0\1\153\16\0\1\151\43\0\2\24\1\0"+
    "\1\152\1\153\13\0\1\153\62\0\2\152\1\0\1\154"+
    "\17\0\1\155\64\0\1\156\46\0\1\157\23\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\2\21\1\160\5\21"+
    "\5\0\1\21\1\161\6\21\1\162\2\21\1\163\4\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\5\21\1\164\1\21\1\165\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\4\21\1\166\3\21\5\0\1\167\6\21\1\170\10\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\1\21\1\171\16\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\7\21"+
    "\1\172\5\0\7\21\1\173\10\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\4\21\1\174"+
    "\3\21\5\0\11\21\1\175\6\21\20\0\4\21\34\0"+
    "\1\176\30\0\1\177\102\0\1\200\53\0\1\201\26\0"+
    "\1\202\23\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\1\21\1\203\16\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\5\21\1\204"+
    "\2\21\5\0\15\21\1\205\2\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\3\21\1\206\14\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\7\21\1\207\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\3\21\1\210\2\21\1\211\3\21"+
    "\1\212\5\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\1\21\1\213\3\21\1\214\2\21"+
    "\5\0\1\215\6\21\1\216\10\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\5\21\1\217"+
    "\2\21\5\0\1\220\2\21\1\221\14\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\1\21"+
    "\1\222\6\21\5\0\6\21\1\223\11\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\1\224\6\21\1\225\10\21\20\0\4\21\65\0"+
    "\1\226\104\0\1\227\100\0\1\230\2\0\1\231\77\0"+
    "\1\232\3\0\1\233\76\0\1\234\102\0\1\235\15\0"+
    "\2\73\1\0\15\73\1\0\54\73\2\0\4\73\20\236"+
    "\1\237\3\236\1\240\2\236\1\241\3\236\1\242\5\236"+
    "\1\243\1\244\1\236\1\245\2\236\1\246\1\247\24\236"+
    "\1\250\1\0\4\236\2\77\1\0\15\77\1\0\12\77"+
    "\1\0\42\77\1\0\4\77\1\251\2\0\15\251\1\252"+
    "\1\103\54\251\1\0\4\251\1\103\2\0\73\103\1\0"+
    "\4\103\1\253\2\0\1\253\1\110\12\253\1\254\1\255"+
    "\55\253\1\0\4\253\6\0\1\110\4\0\1\110\1\0"+
    "\1\110\4\0\10\110\5\0\20\110\20\0\4\110\1\254"+
    "\2\0\15\254\1\256\1\253\54\254\1\0\4\254\1\253"+
    "\2\0\73\253\1\0\4\253\4\0\1\142\1\143\131\0"+
    "\1\257\104\0\1\260\52\0\6\121\1\0\1\121\4\0"+
    "\10\121\5\0\20\121\20\0\4\121\4\0\1\261\30\0"+
    "\1\262\30\0\1\263\50\0\1\264\104\0\1\265\44\0"+
    "\2\131\1\0\15\131\1\0\12\131\1\0\42\131\1\0"+
    "\4\131\27\266\1\267\20\266\1\270\25\266\1\0\4\266"+
    "\2\135\1\0\15\135\1\0\54\135\2\0\4\135\34\0"+
    "\1\271\102\0\1\271\1\272\66\0\1\273\61\0\2\142"+
    "\1\16\73\142\1\16\4\142\5\143\1\274\75\143\11\0"+
    "\2\150\1\0\1\152\1\153\13\0\1\153\62\0\2\275"+
    "\2\0\1\275\4\0\1\275\2\0\1\275\2\0\2\275"+
    "\5\0\1\275\1\0\1\275\5\0\1\275\27\0\3\275"+
    "\12\0\2\152\2\0\1\153\13\0\1\153\61\0\1\276"+
    "\2\277\3\0\1\276\100\0\1\300\74\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\3\21\1\301\4\21\5\0"+
    "\1\21\1\302\3\21\1\303\12\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\14\21\1\304\3\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\4\21\1\305\3\21\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\10\21\5\0\15\21\1\306\2\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\1\307\17\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\1\21"+
    "\1\310\3\21\1\311\12\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\2\21\1\312\5\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\313\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\4\21\1\314\3\21\5\0\10\21\1\315\7\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\1\21\1\316\16\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\5\21\1\317\12\21\20\0\4\21\65\0\1\320\102\0"+
    "\1\321\53\0\1\322\26\0\1\323\23\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\14\21\1\324"+
    "\3\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\1\21\1\325\6\21\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\7\21\1\326\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\327\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\5\21\1\330\2\21\5\0\12\21"+
    "\1\331\5\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\1\21\1\332\6\21\5\0\3\21"+
    "\1\333\14\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\14\21\1\334\3\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\2\21\1\335\5\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\2\21"+
    "\1\336\5\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\4\21\1\337\3\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\3\21\1\340\14\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\2\21\1\341\15\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\3\21"+
    "\1\342\4\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\1\21\1\343\6\21"+
    "\5\0\7\21\1\344\10\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\345\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\1\21\1\346\6\21\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\3\21\1\347\14\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\1\21"+
    "\1\350\6\21\5\0\20\21\20\0\4\21\65\0\1\351"+
    "\102\0\1\352\102\0\1\353\26\0\2\354\2\0\1\354"+
    "\4\0\1\354\2\0\1\354\2\0\2\354\5\0\1\354"+
    "\1\0\1\354\5\0\1\354\27\0\3\354\12\0\2\355"+
    "\2\0\1\355\4\0\1\355\2\0\1\355\2\0\2\355"+
    "\5\0\1\355\1\0\1\355\5\0\1\355\27\0\3\355"+
    "\1\0\1\251\2\0\73\251\1\0\4\251\1\254\2\0"+
    "\73\254\1\0\4\254\34\0\1\356\56\0\1\357\127\0"+
    "\1\360\56\0\2\361\2\0\1\361\4\0\1\361\2\0"+
    "\1\361\2\0\2\361\5\0\1\361\1\0\1\361\5\0"+
    "\1\361\27\0\3\361\12\0\2\362\2\0\1\362\4\0"+
    "\1\362\2\0\1\362\2\0\2\362\5\0\1\362\1\0"+
    "\1\362\5\0\1\362\27\0\3\362\20\0\1\363\121\0"+
    "\1\364\44\0\4\143\1\16\1\274\75\143\11\0\2\277"+
    "\76\0\2\21\1\0\3\21\1\0\1\21\4\0\4\21"+
    "\1\365\3\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\366\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\367\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\4\21\1\370\3\21\5\0\7\21\1\371\10\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\4\21\1\372\3\21\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\1\21\1\373\16\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\7\21\1\374\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\3\21\1\375\4\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\1\21\1\376\3\21\1\377\12\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\7\21"+
    "\1\u0100\5\0\20\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\1\u0101\17\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\7\21\1\u0102\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\7\21\1\u0103"+
    "\5\0\20\21\20\0\4\21\65\0\1\u0104\23\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\7\21\1\u0105\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\10\21\5\0\5\21\1\u0106\12\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\1\u0107\17\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\5\21\1\u0108\2\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\u0109\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\1\21\1\u010a\16\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\7\21\1\u010b\10\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\7\21\1\u010c\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\1\u010d\17\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\3\21\1\u010e"+
    "\4\21\5\0\20\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\1\21\1\u010f"+
    "\16\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\4\21\1\u0110\3\21\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\4\21\1\u0111\13\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\17\21\1\u0112\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\5\21\1\u0113\12\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\6\21\1\u0114\11\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\4\21"+
    "\1\u0115\3\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\6\21\1\u0116\1\21"+
    "\5\0\20\21\20\0\4\21\11\0\2\u0117\2\0\1\u0117"+
    "\4\0\1\u0117\2\0\1\u0117\2\0\2\u0117\5\0\1\u0117"+
    "\1\0\1\u0117\5\0\1\u0117\27\0\3\u0117\12\0\2\u0118"+
    "\2\0\1\u0118\4\0\1\u0118\2\0\1\u0118\2\0\2\u0118"+
    "\5\0\1\u0118\1\0\1\u0118\5\0\1\u0118\27\0\3\u0118"+
    "\36\0\1\u0119\55\0\1\u011a\111\0\1\u011b\74\0\2\u011c"+
    "\2\0\1\u011c\4\0\1\u011c\2\0\1\u011c\2\0\2\u011c"+
    "\5\0\1\u011c\1\0\1\u011c\5\0\1\u011c\27\0\3\u011c"+
    "\12\0\2\266\2\0\1\266\4\0\1\266\2\0\1\266"+
    "\2\0\2\266\5\0\1\266\1\0\1\266\5\0\1\266"+
    "\27\0\3\266\100\0\1\u011d\37\0\1\u011e\54\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\5\21\1\u011f\2\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\1\u0120\17\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\3\21\1\u0121\14\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\7\21\1\u0122"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\3\21\1\u0123\14\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\1\21\1\u0124\16\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\6\21\1\u0125\11\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\u0126\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\1\21\1\u0127\6\21\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\5\21\1\u0128\12\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\5\21"+
    "\1\u0129\2\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\2\21\1\u012a\5\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\3\21\1\u012b\14\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\3\21\1\u012c\4\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\4\21\1\u012d\13\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\3\21"+
    "\1\u012e\14\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\15\21\1\u012f\2\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\7\21\1\u0130\10\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\4\21"+
    "\1\u0131\3\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\u0132\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\u0133\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\1\21\1\u0134\6\21\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\1\u0135\17\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\1\u0136\17\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\7\21\1\u0137\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\7\21\1\u0138\5\0"+
    "\20\21\20\0\4\21\17\0\1\u0139\63\0\10\u011a\1\u013a"+
    "\72\u011a\77\0\1\u013b\103\0\1\u013c\10\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\6\21\1\u013d\1\21\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\2\21\1\u013e\5\21\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\2\21\1\u013f\5\21\5\0\10\21\1\u0140\7\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\10\21\5\0\13\21\1\u0141\4\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\5\21\1\u0142\12\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\2\21\1\u0143\5\21\5\0"+
    "\20\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\7\21\1\u0144\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\4\21"+
    "\1\u0145\3\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\6\21\1\u0146\1\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\6\21\1\u0147\11\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\2\21\1\u0148\5\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\10\21\1\u0149\7\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\4\21\1\u014a\3\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\1\21\1\u014b\6\21\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\3\21\1\u014c\4\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\16\21\1\u014d\1\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\u014e\12\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\3\21\1\u014f\4\21\5\0\20\21"+
    "\20\0\4\21\77\0\1\u0150\3\0\10\u011a\1\u0151\72\u011a"+
    "\100\0\1\u0152\103\0\1\u0153\7\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\u0154\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\3\21\1\u0155\4\21\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\1\u0156\17\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\1\u0157\17\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\7\21\1\u0158\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\5\21\1\u0159\2\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\5\21\1\u015a\12\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\10\21\5\0\1\21\1\u015b\16\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\5\0\12\21\1\u015c\5\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\7\21"+
    "\1\u015d\10\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\u015e\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\7\21\1\u015f\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\10\21\5\0\5\21"+
    "\1\u0160\12\21\20\0\4\21\100\0\1\u0161\2\0\10\u011a"+
    "\1\u0151\25\u011a\1\16\44\u011a\101\0\1\u0162\103\0\1\u0163"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\10\21"+
    "\1\u0164\4\0\20\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\7\21\1\u0165\5\0\20\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\4\21\1\u0166\3\21\5\0\20\21\20\0\4\21"+
    "\6\0\2\21\1\0\3\21\1\0\1\21\4\0\3\21"+
    "\1\u0167\4\21\5\0\20\21\20\0\4\21\6\0\2\21"+
    "\1\0\3\21\1\0\1\21\4\0\2\21\1\u0168\5\21"+
    "\5\0\20\21\20\0\4\21\6\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\7\21\1\u0169\5\0\20\21\20\0"+
    "\4\21\6\0\2\21\1\0\3\21\1\0\1\21\4\0"+
    "\2\21\1\u016a\5\21\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\7\21\1\u016b"+
    "\5\0\20\21\20\0\4\21\101\0\1\u016c\103\0\1\u016d"+
    "\101\0\1\u016e\34\0\1\u016f\55\0\2\21\1\0\3\21"+
    "\1\0\1\21\4\0\10\21\5\0\7\21\1\u0170\10\21"+
    "\20\0\4\21\6\0\2\21\1\0\3\21\1\0\1\21"+
    "\4\0\7\21\1\u0171\5\0\20\21\20\0\4\21\6\0"+
    "\2\21\1\0\3\21\1\0\1\21\4\0\10\21\5\0"+
    "\5\21\1\u0172\12\21\20\0\4\21\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\6\21\1\u0173\1\21\5\0"+
    "\20\21\20\0\4\21\102\0\1\u0174\101\0\1\u0175\20\0"+
    "\1\u0176\63\0\33\u016f\1\u0177\47\u016f\6\0\2\21\1\0"+
    "\3\21\1\0\1\21\4\0\10\21\5\0\10\21\1\u0178"+
    "\7\21\20\0\4\21\6\0\2\21\1\0\3\21\1\0"+
    "\1\21\4\0\10\21\5\0\1\21\1\u0179\16\21\20\0"+
    "\4\21\101\0\1\u017a\20\0\1\u017b\102\0\1\u017c\63\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[17219];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\14\0\2\11\10\1\2\11\6\1\1\11\14\1\6\11"+
    "\1\1\1\11\5\1\2\11\1\1\1\11\1\0\1\11"+
    "\1\1\5\11\6\1\1\11\1\1\1\11\1\1\1\11"+
    "\2\1\1\11\2\1\1\11\1\1\2\11\1\1\1\11"+
    "\1\0\1\11\3\1\1\11\2\1\1\0\4\11\1\1"+
    "\1\0\1\1\2\0\3\11\17\1\1\11\2\1\1\11"+
    "\24\1\2\11\1\1\1\11\1\1\5\11\1\1\5\11"+
    "\1\1\1\11\6\0\1\11\1\1\1\11\1\0\1\11"+
    "\1\1\2\11\2\1\1\11\3\0\1\1\1\0\1\1"+
    "\1\11\17\1\2\11\1\1\1\11\25\1\3\11\2\0"+
    "\1\1\5\0\20\1\1\11\22\1\1\0\1\11\5\0"+
    "\1\11\32\1\4\0\23\1\4\0\15\1\4\0\7\1"+
    "\4\0\4\1\2\0\2\11\2\1\1\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[380];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;
  
  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /** the stack of open (nested) input streams to read from */
  private java.util.Stack zzStreams = new java.util.Stack();

  /**
   * inner class used to store info for nested
   * input streams
   */
  private static final class ZzFlexStreamInfo {
    java.io.Reader zzReader;
    int zzEndRead;
    int zzStartRead;
    int zzCurrentPos;
    int zzMarkedPos;
    int yyline;
    int yycolumn;
    char [] zzBuffer;
    boolean zzAtEOF;
    boolean zzEOFDone;

    /** sets all values stored in this class */
    ZzFlexStreamInfo(java.io.Reader zzReader, int zzEndRead, int zzStartRead,
                  int zzCurrentPos, int zzMarkedPos, 
                  char [] zzBuffer, boolean zzAtEOF, boolean zzEOFDone, int yyline, int yycolumn) {
      this.zzReader      = zzReader;
      this.zzEndRead     = zzEndRead;
      this.zzStartRead   = zzStartRead;
      this.zzCurrentPos  = zzCurrentPos;
      this.zzMarkedPos   = zzMarkedPos;
      this.zzBuffer      = zzBuffer;
      this.zzAtEOF       = zzAtEOF;
      this.zzEOFDone     = zzEOFDone;
      this.yyline         = yyline;
      this.yycolumn       = yycolumn;
    }
  }

  /* user code: */
  void prepareEmbedded(java.io.Reader reader, int line, int column) {
    yyreset(reader);
    yyline = line;
    yycolumn = column;
  }

  protected int getColumn() {
    return yycolumn + 1;
  }

  protected int getLine() {
    return yyline + 1;
  }

  protected void yybeginRegExpStart() {
    yybegin(REGEXP_START);
  }



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1748) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }
    
    // numRead < 0) 
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Stores the current input stream on a stack, and
   * reads from a new stream. Lexical state, line,
   * char, and column counting remain untouched.
   *
   * The current input stream can be restored with
   * yypopstream (usually in an <<EOF>> action).
   *
   * @param reader the new input stream to read from
   *
   * @see #yypopStream()
   */
  public final void yypushStream(java.io.Reader reader) {
    zzStreams.push(
      new ZzFlexStreamInfo(zzReader, zzEndRead, zzStartRead, zzCurrentPos,
                        zzMarkedPos, zzBuffer, zzAtEOF, zzEOFDone,
                        yyline, yycolumn)
    );
    zzAtEOF  = false;
    zzBuffer = new char[ZZ_BUFFERSIZE];
    zzReader = reader;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yycolumn = 0;
  }
    

  /**
   * Closes the current input stream and continues to
   * read from the one on top of the stream stack. 
   *
   * @throws java.util.EmptyStackException
   *         if there is no further stream to read from.
   *
   * @throws java.io.IOException
   *         if there was an error in closing the stream.
   *
   * @see #yypushStream(java.io.Reader)
   */
  public final void yypopStream() throws java.io.IOException {
    zzReader.close();
    ZzFlexStreamInfo s = (ZzFlexStreamInfo) zzStreams.pop();
    zzBuffer      = s.zzBuffer;
    zzReader      = s.zzReader;
    zzEndRead     = s.zzEndRead;
    zzStartRead   = s.zzStartRead;
    zzCurrentPos  = s.zzCurrentPos;
    zzMarkedPos   = s.zzMarkedPos ;
    zzAtEOF       = s.zzAtEOF;
    zzEOFDone     = s.zzEOFDone;
    yyline         = s.yyline;
    yycolumn       = s.yycolumn;
  }


  /**
   * Returns true iff there are still streams left 
   * to read from on the stream stack.
   */
  public final boolean yymoreStreams() {
    return !zzStreams.isEmpty();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   *
   * @see #yypushStream(java.io.Reader)
   * @see #yypopStream()
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol scan() throws java.io.IOException {
    int zzInput;
    int zzAction;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      // cached fields:
      int zzCurrentPosL;
      int zzMarkedPosL = zzMarkedPos;
      int zzEndReadL = zzEndRead;
      char [] zzBufferL = zzBuffer;
      char [] zzCMapL = ZZ_CMAP;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 64: 
          { return symbol(NOTEQ);
          }
        case 149: break;
        case 143: 
          { setMultiStateText(""); yybegin(CDATA_SECTION); clearString();
          }
        case 150: break;
        case 140: 
          { return symbol(FUNCTION);
          }
        case 151: break;
        case 132: 
          { return symbol(PUBLIC);
          }
        case 152: break;
        case 33: 
          { pushMultiStateText(yytext()); yybegin(YYINITIAL); return multiStateSymbol(STRING_LITERAL, getString());
          }
        case 153: break;
        case 48: 
          { pushString(yytext());
          }
        case 154: break;
        case 25: 
          { return symbol(AND);
          }
        case 155: break;
        case 26: 
          { return symbol(OR);
          }
        case 156: break;
        case 108: 
          { yybegin(XML_TEXT_CONTENT);
          }
        case 157: break;
        case 148: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 2;
          { setMultiStateText(""); yybegin(XML_TEXT_CONTENT); clearString(); return symbol(SLASH_GT);
          }
        case 158: break;
        case 86: 
          { setMultiStateText(""); yybegin(XML_TEXT_CONTENT); clearString(); return symbol(SLASH_GT);
          }
        case 159: break;
        case 21: 
          { return symbol(COMMA);
          }
        case 160: break;
        case 4: 
          { return symbol(MUL);
          }
        case 161: break;
        case 94: 
          { return symbol(REST);
          }
        case 162: break;
        case 10: 
          { return symbol(LBRACK);
          }
        case 163: break;
        case 114: 
          { return symbol(THIS);
          }
        case 164: break;
        case 50: 
          { return symbol(DIVEQ);
          }
        case 165: break;
        case 118: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 3;
          { yybegin(MXML);
                                    return multiStateSymbol(STRING_LITERAL, getString());
          }
        case 166: break;
        case 87: 
          { return symbol(LT_SLASH);
          }
        case 167: break;
        case 32: 
          { error("Unterminated string at end of line");
          }
        case 168: break;
        case 72: 
          { return symbol(OREQ);
          }
        case 169: break;
        case 18: 
          { return symbol(LBRACE);
          }
        case 170: break;
        case 103: 
          { return symbol(VAR);
          }
        case 171: break;
        case 24: 
          { return symbol(COLON);
          }
        case 172: break;
        case 127: 
          { return symbol(IMPORT);
          }
        case 173: break;
        case 61: 
          { return symbol(DO);
          }
        case 174: break;
        case 57: 
          { return symbol(PLUSEQ);
          }
        case 175: break;
        case 104: 
          { return symbol(EQEQEQ);
          }
        case 176: break;
        case 39: 
          { pushMultiStateText(yytext());
                                    pushString(yytext());
                                    yybegin(YYINITIAL);
                                    return multiStateSymbol(REGEXP_LITERAL, getString());
          }
        case 177: break;
        case 90: 
          { return symbol(QUESTION_GT);
          }
        case 178: break;
        case 59: 
          { return symbol(IS);
          }
        case 179: break;
        case 100: 
          { return symbol(RSHIFTEQ);
          }
        case 180: break;
        case 69: 
          { return symbol(NAMESPACESEP);
          }
        case 181: break;
        case 145: 
          { return symbol(INSTANCEOF);
          }
        case 182: break;
        case 8: 
          { return symbol(DOT);
          }
        case 183: break;
        case 74: 
          { return symbol(XOREQ);
          }
        case 184: break;
        case 133: 
          { return symbol(DEFAULT);
          }
        case 185: break;
        case 15: 
          { return symbol(GT);
          }
        case 186: break;
        case 89: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 1;
          { return symbol(GT);
          }
        case 187: break;
        case 55: 
          { increaseVectorNestingLevel(); yybegin(VECTOR_TYPE); return symbol(DOTLT);
          }
        case 188: break;
        case 116: 
          { return symbol(VOID);
          }
        case 189: break;
        case 99: 
          { return symbol(URSHIFT);
          }
        case 190: break;
        case 41: 
          { if (decreaseVectorNestingLevel()) { yybegin(YYINITIAL); } return symbol(GT);
          }
        case 191: break;
        case 142: 
          { return symbol(PROTECTED);
          }
        case 192: break;
        case 7: 
          { return symbol(INT_LITERAL, new Long(yytext()));
          }
        case 193: break;
        case 81: 
          { pushMultiStateText(yytext()); pushString( '\r' );
          }
        case 194: break;
        case 36: 
          { pushMultiStateText(yytext()); pushString(yytext()); yybegin(REGEXP_FIRST);
          }
        case 195: break;
        case 47: 
          { yybegin(MXML);
                                    return multiStateSymbol(STRING_LITERAL, null);
          }
        case 196: break;
        case 13: 
          { return symbol(LT);
          }
        case 197: break;
        case 17: 
          { return symbol(RPAREN);
          }
        case 198: break;
        case 30: 
          { setMultiStateText(yytext()); yybegin(STRING_SQ); clearString();
          }
        case 199: break;
        case 22: 
          { return symbol(EQ);
          }
        case 200: break;
        case 113: 
          { return symbol(BOOL_LITERAL, Boolean.TRUE);
          }
        case 201: break;
        case 141: 
          { return symbol(INTERFACE);
          }
        case 202: break;
        case 35: 
          { error("invalid regular expression literal");
          }
        case 203: break;
        case 111: 
          { return symbol(ELSE);
          }
        case 204: break;
        case 105: 
          { return symbol(ANDANDEQ);
          }
        case 205: break;
        case 121: 
          { return symbol(CONST);
          }
        case 206: break;
        case 91: 
          { pushMultiStateText(yytext());
          }
        case 207: break;
        case 14: 
          { return symbol(NOT);
          }
        case 208: break;
        case 52: 
          { return symbol(MINUSMINUS);
          }
        case 209: break;
        case 98: 
          { return symbol(NOTEQEQ);
          }
        case 210: break;
        case 137: 
          { return symbol(PRIVATE);
          }
        case 211: break;
        case 130: 
          { return symbol(RETURN);
          }
        case 212: break;
        case 106: 
          { return symbol(OROREQ);
          }
        case 213: break;
        case 42: 
          { setMultiStateText(""); yybegin(XML_ATTRIBUTE_VALUE_DQ); clearString();
          }
        case 214: break;
        case 112: 
          { return symbol(URSHIFTEQ);
          }
        case 215: break;
        case 78: 
          { pushMultiStateText(yytext()); pushString( '\n' );
          }
        case 216: break;
        case 123: 
          { return symbol(BREAK);
          }
        case 217: break;
        case 67: 
          { return symbol(AS);
          }
        case 218: break;
        case 37: 
          { pushMultiStateText(yytext()); pushString(yytext()); yybegin(REGEXP_REST);
          }
        case 219: break;
        case 131: 
          { return symbol(TYPEOF);
          }
        case 220: break;
        case 84: 
          { pushMultiStateText(yytext()); pushString( '\'' );
          }
        case 221: break;
        case 51: 
          { return symbol(MULTEQ);
          }
        case 222: break;
        case 31: 
          { pushMultiStateText(yytext()); pushString( yytext() );
          }
        case 223: break;
        case 75: 
          { return symbol(MODEQ);
          }
        case 224: break;
        case 66: 
          { return symbol(GTEQ);
          }
        case 225: break;
        case 70: 
          { return symbol(ANDEQ);
          }
        case 226: break;
        case 9: 
          { return symbol(PLUS);
          }
        case 227: break;
        case 77: 
          { pushMultiStateText(yytext()); pushString( '\\' );
          }
        case 228: break;
        case 16: 
          { return symbol(LPAREN);
          }
        case 229: break;
        case 109: 
          { return symbol(NULL_LITERAL, null);
          }
        case 230: break;
        case 115: 
          { return symbol(WITH);
          }
        case 231: break;
        case 38: 
          { error("unterminated regular expression at end of line");
          }
        case 232: break;
        case 6: 
          { return symbol(MINUS);
          }
        case 233: break;
        case 97: 
          { return symbol(LSHIFTEQ);
          }
        case 234: break;
        case 34: 
          { pushMultiStateText(yytext()); yybegin(YYINITIAL);
                                    return multiStateSymbol(STRING_LITERAL, getString());
          }
        case 235: break;
        case 5: 
          { return symbol(IDE, yytext());
          }
        case 236: break;
        case 129: 
          { return symbol(SWITCH);
          }
        case 237: break;
        case 93: 
          { return symbol(INT_LITERAL, Long.parseLong(yytext().substring(2),16));
          }
        case 238: break;
        case 27: 
          { return symbol(XOR);
          }
        case 239: break;
        case 124: 
          { return symbol(THROW);
          }
        case 240: break;
        case 56: 
          { return symbol(PLUSPLUS);
          }
        case 241: break;
        case 126: 
          { return symbol(WHILE);
          }
        case 242: break;
        case 102: 
          { return symbol(FOR);
          }
        case 243: break;
        case 20: 
          { return symbol(SEMICOLON);
          }
        case 244: break;
        case 40: 
          { error("invalid Vector type");
          }
        case 245: break;
        case 76: 
          { pushMultiStateText(yytext()); pushString(yytext().substring(1));
          }
        case 246: break;
        case 83: 
          { pushMultiStateText(yytext()); pushString( '\f' );
          }
        case 247: break;
        case 144: 
          { yypushStream(createIncludeReader(yytext()));
          }
        case 248: break;
        case 95: 
          { return symbol(NEW);
          }
        case 249: break;
        case 88: 
          { return symbol(LT_QUESTION);
          }
        case 250: break;
        case 120: 
          { return symbol(CATCH);
          }
        case 251: break;
        case 65: 
          { return symbol(RSHIFT);
          }
        case 252: break;
        case 128: 
          { return symbol(DELETE);
          }
        case 253: break;
        case 58: 
          { return symbol(IN);
          }
        case 254: break;
        case 82: 
          { pushMultiStateText(yytext()); pushString( '\t' );
          }
        case 255: break;
        case 29: 
          { return symbol(BITNOT);
          }
        case 256: break;
        case 138: 
          { return symbol(INTERNAL);
          }
        case 257: break;
        case 117: 
          { pushMultiStateText(yytext());
                                   char val = (char) Integer.parseInt(yytext().substring(2),16);
                        	   pushString(val);
          }
        case 258: break;
        case 73: 
          { return symbol(OROR);
          }
        case 259: break;
        case 63: 
          { return symbol(LTEQ);
          }
        case 260: break;
        case 49: 
          { pushMultiStateText(yytext()); pushString(yytext());
          }
        case 261: break;
        case 119: 
          { return symbol(CLASS);
          }
        case 262: break;
        case 134: 
          { return symbol(EXTENDS);
          }
        case 263: break;
        case 60: 
          { return symbol(IF);
          }
        case 264: break;
        case 68: 
          { return symbol(EQEQ);
          }
        case 265: break;
        case 101: 
          { return symbol(TRY);
          }
        case 266: break;
        case 71: 
          { return symbol(ANDAND);
          }
        case 267: break;
        case 80: 
          { pushMultiStateText(yytext()); pushString( '\b' );
          }
        case 268: break;
        case 28: 
          { return symbol(MOD);
          }
        case 269: break;
        case 44: 
          { setMultiStateText(""); yybegin(XML_ATTRIBUTE_VALUE_SQ); clearString();
          }
        case 270: break;
        case 136: 
          { return symbol(PACKAGE);
          }
        case 271: break;
        case 92: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 1;
          { pushString(yytext()); yybegin(MXML);
                                    return xmlUnescaped(STRING_LITERAL, getString());
          }
        case 272: break;
        case 85: 
          { increaseVectorNestingLevel(); return symbol(DOTLT);
          }
        case 273: break;
        case 45: 
          { pushMultiStateText(unescapeXml(yytext()));
          }
        case 274: break;
        case 11: 
          { return symbol(RBRACK);
          }
        case 275: break;
        case 125: 
          { return symbol(BOOL_LITERAL, Boolean.FALSE);
          }
        case 276: break;
        case 79: 
          { pushMultiStateText(yytext()); pushString( '\"' );
          }
        case 277: break;
        case 146: 
          { return symbol(IMPLEMENTS);
          }
        case 278: break;
        case 54: 
          { return symbol(FLOAT_LITERAL, new Double(yytext()));
          }
        case 279: break;
        case 135: 
          { return symbol(FINALLY);
          }
        case 280: break;
        case 3: 
          { return symbol(DIV);
          }
        case 281: break;
        case 62: 
          { return symbol(LSHIFT);
          }
        case 282: break;
        case 19: 
          { return symbol(RBRACE);
          }
        case 283: break;
        case 139: 
          { return symbol(CONTINUE);
          }
        case 284: break;
        case 46: 
          { pushMultiStateText(yytext()); pushWhitespace(yytext());
          }
        case 285: break;
        case 96: 
          { return symbol(USE);
          }
        case 286: break;
        case 107: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 2;
          { return symbol(SLASH_GT);
          }
        case 287: break;
        case 53: 
          { return symbol(MINUSEQ);
          }
        case 288: break;
        case 12: 
          { setMultiStateText(yytext()); yybegin(STRING_DQ); clearString();
          }
        case 289: break;
        case 110: 
          { return symbol(CASE);
          }
        case 290: break;
        case 1: 
          { error("unrecognized input token");
          }
        case 291: break;
        case 23: 
          { return symbol(QUESTION);
          }
        case 292: break;
        case 122: 
          { return symbol(SUPER);
          }
        case 293: break;
        case 2: 
          { pushWhitespace(yytext());
          }
        case 294: break;
        case 147: 
          // lookahead expression with fixed base length
          zzMarkedPos = zzStartRead + 1;
          { setMultiStateText(""); yybegin(XML_TEXT_CONTENT); clearString(); return symbol(GT);
          }
        case 295: break;
        case 43: 
          { setMultiStateText(""); yybegin(XML_TEXT_CONTENT); clearString(); return symbol(GT);
          }
        case 296: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case XML_TEXT_CONTENT: {
              if (!getString().trim().isEmpty())  { error("unexpected tokens");
                                    } else {
                                      if (yymoreStreams()) yypopStream(); else return symbol(EOF);
                                    }
            }
            case 381: break;
            default:
              {
                if (yymoreStreams()) yypopStream(); else return symbol(EOF);
              }
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
