/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.Dependency;
import net.jangaroo.jooc.DependencyGraphFile;
import net.jangaroo.jooc.DependencyLevel;
import net.jangaroo.jooc.StaticDependencyVisitor;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.util.GraphUtil;

public class DependencyGraph {
    private Map<String, CompilationUnit> primaryCompilationUnits = new HashMap<String, CompilationUnit>();
    private Multimap<Dependency, Dependency> dependencyGraph = HashMultimap.create();
    private Collection<Set<Dependency>> sccs;
    private Collection<Set<Dependency>> errorSCCs;

    DependencyGraph() throws IOException {
    }

    void analyze() {
        this.reduceDependencyGraph();
        this.sccs = GraphUtil.stronglyConnectedComponent(this.dependencyGraph.asMap());
        this.errorSCCs = new ArrayList<Set<Dependency>>();
        for (Set<Dependency> scc : this.sccs) {
            List<Dependency> initDependencies = this.getInitDependencies(scc);
            if (initDependencies.size() > 1) {
                this.errorSCCs.add(scc);
            }
            if (initDependencies.size() != 1) continue;
            Dependency initializer = initDependencies.get(0);
            this.addTransitiveDependenciesAsRequires(this.dependencyGraph, initializer);
        }
    }

    private void reduceDependencyGraph() {
        for (Collection dependencies : new ArrayList(this.dependencyGraph.asMap().values())) {
            ArrayList<Dependency> toRemove = new ArrayList<Dependency>();
            for (Dependency dependency : dependencies) {
                if (this.primaryCompilationUnits.containsKey(dependency.getCompilationUnitId())) continue;
                toRemove.add(dependency);
            }
            dependencies.removeAll(toRemove);
        }
    }

    boolean hasErrors() {
        return !this.errorSCCs.isEmpty();
    }

    private List<Dependency> getInitDependencies(Set<Dependency> scc) {
        ArrayList<Dependency> initializingDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : scc) {
            if (dependency.getLevel() != DependencyLevel.INIT) continue;
            initializingDependencies.add(dependency);
        }
        return initializingDependencies;
    }

    void fillInDependencies(CompilationUnit compilationUnit) throws IOException {
        this.primaryCompilationUnits.put(Dependency.getCompilationUnitId(compilationUnit), compilationUnit);
        this.dependencyGraph.put((Object)new Dependency(compilationUnit, DependencyLevel.DYNAMIC), (Object)new Dependency(compilationUnit, DependencyLevel.STATIC));
        this.dependencyGraph.put((Object)new Dependency(compilationUnit, DependencyLevel.STATIC), (Object)new Dependency(compilationUnit, DependencyLevel.INIT));
        StaticDependencyVisitor visitor = new StaticDependencyVisitor(compilationUnit);
        compilationUnit.visit(visitor);
        HashSet<Dependency> initDependencies = new HashSet<Dependency>();
        Collection nonFunctionDependencies = visitor.getNonFunctionUses().get(null);
        if (nonFunctionDependencies != null) {
            initDependencies.addAll(nonFunctionDependencies);
        }
        HashSet<FunctionDeclaration> done = new HashSet<FunctionDeclaration>();
        LinkedList todo = new LinkedList();
        todo.addAll(visitor.getInternalUses().get(null));
        while (!todo.isEmpty()) {
            FunctionDeclaration ideDeclaration = (FunctionDeclaration)todo.removeLast();
            if (!done.add(ideDeclaration)) continue;
            if (ideDeclaration.isConstructor()) {
                initDependencies.add(new Dependency(compilationUnit, DependencyLevel.DYNAMIC));
                continue;
            }
            Collection collection = visitor.getNonFunctionUses().get((Object)ideDeclaration);
            if (collection != null) {
                initDependencies.addAll(collection);
            }
            if (!visitor.getInternalUses().containsKey((Object)ideDeclaration)) continue;
            todo.addAll(visitor.getInternalUses().get((Object)ideDeclaration));
        }
        for (Dependency dependency : initDependencies) {
            this.dependencyGraph.put((Object)new Dependency(compilationUnit, DependencyLevel.INIT), (Object)dependency);
        }
        for (Dependency dependency : visitor.getNonFunctionUses().values()) {
            this.dependencyGraph.put((Object)new Dependency(compilationUnit, DependencyLevel.STATIC), (Object)dependency);
        }
        for (String string : compilationUnit.getTransitiveDependencies()) {
            this.dependencyGraph.put((Object)new Dependency(compilationUnit, DependencyLevel.DYNAMIC), (Object)new Dependency(string, DependencyLevel.DYNAMIC));
            boolean isRequired = compilationUnit.isRequiredDependency(string);
            if (!isRequired) continue;
            this.dependencyGraph.put((Object)new Dependency(compilationUnit, DependencyLevel.INIT), (Object)new Dependency(string, DependencyLevel.INIT));
        }
    }

    private void addTransitiveDependenciesAsRequires(Multimap<Dependency, Dependency> dependencyGraph, Dependency initializer) {
        CompilationUnit compilationUnit = this.primaryCompilationUnits.get(initializer.getCompilationUnitId());
        if (compilationUnit != null) {
            LinkedList<Dependency> todo = new LinkedList<Dependency>();
            todo.add(initializer);
            HashSet<Dependency> visited = new HashSet<Dependency>();
            while (!todo.isEmpty()) {
                Dependency dependency = (Dependency)todo.removeLast();
                if (!visited.add(dependency)) continue;
                todo.addAll(dependencyGraph.get((Object)dependency));
                CompilationUnit requiredCompilationUnit = this.primaryCompilationUnits.get(dependency.getCompilationUnitId());
                if (requiredCompilationUnit == null) continue;
                compilationUnit.addRequiredDependency(requiredCompilationUnit);
            }
        }
    }

    void writeDependencyGraphToFile(File dependencyGraphFile) throws IOException {
        this.writeGraphFile(dependencyGraphFile, this.sccs, Collections.emptySet());
    }

    void writeErrorGraphToFile(File dependencyGraphFile) throws IOException {
        HashSet<String> allInitializedNames = new HashSet<String>();
        for (Map.Entry entry : this.dependencyGraph.asMap().entrySet()) {
            Dependency source = (Dependency)entry.getKey();
            String sourceName = source.toString();
            if (source.getLevel() != DependencyLevel.INIT) continue;
            allInitializedNames.add(sourceName);
        }
        this.writeGraphFile(dependencyGraphFile, this.errorSCCs, allInitializedNames);
    }

    private void writeGraphFile(File dependencyGraphFile, Collection<Set<Dependency>> sccsToExport, Set<String> marked) throws IOException {
        HashMultimap edges = HashMultimap.create();
        for (Map.Entry entry : this.dependencyGraph.asMap().entrySet()) {
            String sourceName = ((Dependency)entry.getKey()).toString();
            Collection dependencies = (Collection)entry.getValue();
            for (Dependency target : dependencies) {
                edges.put((Object)sourceName, (Object)target.toString());
            }
        }
        HashSet<String> nodes = new HashSet<String>();
        for (Set<Dependency> errorSCC : sccsToExport) {
            for (Dependency dependency : errorSCC) {
                nodes.add(dependency.toString());
            }
        }
        DependencyGraphFile.writeDependencyFile((Multimap<String, String>)edges, nodes, marked, dependencyGraphFile);
    }

    String createDependencyError() {
        Set<Dependency> errorSCC = this.errorSCCs.iterator().next();
        List<Dependency> initializedDependencies = this.getInitDependencies(errorSCC);
        Dependency dependency1 = initializedDependencies.get(0);
        Dependency dependency2 = initializedDependencies.get(1);
        ArrayList<Dependency> path12 = new ArrayList<Dependency>(GraphUtil.findPath(this.dependencyGraph.asMap(), dependency1, dependency2));
        ArrayList<Dependency> path21 = new ArrayList<Dependency>(GraphUtil.findPath(this.dependencyGraph.asMap(), dependency2, dependency1));
        ArrayList<Dependency> cycle = new ArrayList<Dependency>();
        cycle.addAll(path12);
        cycle.addAll(path21.subList(1, path21.size()));
        StringBuilder message = new StringBuilder();
        message.append("The compilation units ");
        message.append(dependency1.getCompilationUnitName());
        message.append(" and ");
        message.append(dependency2.getCompilationUnitName());
        message.append(" contain static initializers");
        message.append(" (for example code blocks or static variables with a complex initializer)");
        message.append(" and the static initializers are mutually dependent: ");
        for (int i = 0; i < cycle.size(); ++i) {
            if (i > 0) {
                message.append(" -> ");
            }
            message.append(cycle.get(i));
        }
        message.append(". You can either remove a static initializer or break the dependency cycle");
        message.append(" to make this module compile. (Other dependency cycles might exist, though.)");
        return message.toString();
    }
}

