/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.mxml.ast.XmlAttribute;

public class XmlHeader {
    public static void verifyXmlHeader(@Nonnull Ide xmlIde, @Nullable List<XmlAttribute> attributes) {
        XmlAttribute version;
        if (!"xml".equals(xmlIde.getName())) {
            throw JangarooParser.error(xmlIde, "XML header must start with 'xml'");
        }
        if (null == attributes || null == (version = (XmlAttribute)Iterables.getFirst((Iterable)Iterables.consumingIterable(attributes), null))) {
            throw JangarooParser.error(xmlIde, "XML header must contain version info");
        }
        if (!"version".equals(version.getLocalName())) {
            throw JangarooParser.error(version, "XML header must start with version info");
        }
        for (XmlAttribute attribute : attributes) {
            if (Arrays.asList("encoding", "standalone").contains(attribute.getLocalName())) continue;
            throw JangarooParser.error(attribute, "unsupported XML header attribute");
        }
    }
}

