/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationsAndModifiers;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.utils.CompilerUtils;

class MxmlAstUtils {
    static final JooSymbol[] SYM_EMPTY_MODIFIERS = new JooSymbol[0];
    static final JooSymbol SYM_CLASS = new JooSymbol(6, "class");
    static final JooSymbol SYM_COLON = new JooSymbol(70, ":");
    static final JooSymbol SYM_COMMA = new JooSymbol(72, ",");
    static final JooSymbol SYM_DOT = new JooSymbol(73, ".");
    static final JooSymbol SYM_EQ = new JooSymbol(58, "=");
    static final JooSymbol SYM_FUNCTION = new JooSymbol(16, "function");
    static final JooSymbol SYM_IMPORT = new JooSymbol(19, "import").withWhitespace("\n");
    static final JooSymbol SYM_LBRACE = new JooSymbol(90, "{");
    static final JooSymbol SYM_LBRACK = new JooSymbol(92, "[");
    static final JooSymbol SYM_LPAREN = new JooSymbol(88, "(");
    static final JooSymbol SYM_NULL = new JooSymbol(100, "null");
    static final JooSymbol SYM_PUBLIC = new JooSymbol(29, "public");
    static final JooSymbol SYM_RBRACE = new JooSymbol(91, "}");
    static final JooSymbol SYM_RBRACK = new JooSymbol(93, "]");
    static final JooSymbol SYM_RPAREN = new JooSymbol(89, ")");
    static final JooSymbol SYM_SEMICOLON = new JooSymbol(71, ";");
    static final JooSymbol SYM_SUPER = new JooSymbol(31, "super");
    static final JooSymbol SYM_THIS = new JooSymbol(33, "this");
    static final JooSymbol SYM_VAR = new JooSymbol(38, "var");
    private static final List<Annotation> EMPTY_ANNOTATIONS = Collections.emptyList();

    private MxmlAstUtils() {
    }

    @Nonnull
    static FunctionDeclaration createConstructor(@Nonnull FunctionDeclaration directive, @Nonnull List<Directive> constructorBodyDirectives) {
        BlockStatement constructorBody = new BlockStatement(SYM_LBRACE, constructorBodyDirectives, SYM_RBRACE);
        String whitespace = "";
        JooSymbol firstSymbol = (JooSymbol)((Object)Iterables.getFirst(Arrays.asList(directive.getSymModifiers()), null));
        if (null != firstSymbol) {
            whitespace = firstSymbol.getWhitespace();
        }
        return new FunctionDeclaration(new AnnotationsAndModifiers(null, Collections.singletonList(SYM_PUBLIC.withWhitespace(whitespace))), SYM_FUNCTION, directive.getSymGetOrSet(), directive.getIde(), directive.getFun().getLParen(), directive.getParams(), directive.getFun().getRParen(), null, constructorBody, null);
    }

    @Nonnull
    static FunctionDeclaration createConstructor(@Nonnull Ide ide, @Nonnull List<Directive> constructorBodyDirectives) {
        BlockStatement constructorBody = new BlockStatement(SYM_LBRACE, constructorBodyDirectives, SYM_RBRACE.withWhitespace("\n"));
        TypeRelation typeRelation = new TypeRelation(SYM_COLON, new Type(ide));
        Parameters params = new Parameters(new Parameter(null, new Ide("config"), typeRelation, new Initializer(SYM_EQ, new LiteralExpr(SYM_NULL))));
        return new FunctionDeclaration(new AnnotationsAndModifiers(null, Collections.singletonList(SYM_PUBLIC)), SYM_FUNCTION, null, ide, SYM_LPAREN, params, SYM_RPAREN, null, constructorBody, null);
    }

    @Nonnull
    static ImportDirective createImport(@Nonnull Ide superClass) {
        return new ImportDirective(SYM_IMPORT, superClass, SYM_SEMICOLON);
    }

    @Nonnull
    static ClassDeclaration createClassDeclaration(@Nonnull String classQName, @Nonnull JooSymbol rootNodeSymbol, @Nonnull Extends ext, @Nullable Implements impl, @Nonnull List<Directive> classBodyDirectives, @Nonnull InputSource source) {
        ClassBody classBody = new ClassBody(SYM_LBRACE, classBodyDirectives, SYM_RBRACE);
        String whitespace = MxmlUtils.toASDoc(rootNodeSymbol.getWhitespace());
        return new ClassDeclaration(new AnnotationsAndModifiers(new LinkedList<Annotation>(), Collections.singletonList(SYM_PUBLIC.withWhitespace(whitespace))), SYM_CLASS, new Ide(CompilerUtils.className((String)classQName)), ext, impl, classBody);
    }

    @Nonnull
    static VariableDeclaration createVariableDeclaration(@Nonnull Ide name, @Nonnull Ide type) {
        TypeRelation typeRelation = new TypeRelation(SYM_COLON, new Type(type));
        Expr value = new ObjectLiteral(SYM_LBRACE, null, null, SYM_RBRACE);
        value = new ApplyExpr(new IdeExpr(type), SYM_LPAREN, new CommaSeparatedList<Expr>(value), SYM_RPAREN);
        Initializer initializer = new Initializer(SYM_EQ, value);
        return new VariableDeclaration(new AnnotationsAndModifiers(null, null), SYM_VAR.withWhitespace("\n    "), name, typeRelation, initializer, null, SYM_SEMICOLON);
    }

    @Nonnull
    static SemicolonTerminatedStatement createSemicolonTerminatedStatement(@Nonnull AstNode astNode) {
        return new SemicolonTerminatedStatement(astNode, SYM_SEMICOLON);
    }

    @Nonnull
    static SuperConstructorCallStatement createSuperConstructorCall(Ide superConfigVar) {
        CommaSeparatedList<Expr> args = new CommaSeparatedList<Expr>(new IdeExpr(superConfigVar));
        return new SuperConstructorCallStatement(SYM_SUPER, SYM_LPAREN, args, SYM_RPAREN, SYM_SEMICOLON);
    }

    @Nonnull
    static Directive createPropertyAssignment(@Nonnull Ide variable, @Nonnull Expr rightHandSide, @Nonnull String propertyName, boolean untypedAccess) {
        Expr leftHandSide;
        Ide varWithWhitespace = new Ide(variable.getIde().withWhitespace("\n    "));
        if (untypedAccess) {
            leftHandSide = new ArrayIndexExpr(new IdeExpr(varWithWhitespace), SYM_LBRACK, new LiteralExpr(new JooSymbol('\"' + propertyName + '\"')), SYM_RBRACK);
        } else {
            Ide propertyNameIde = new Ide(propertyName);
            leftHandSide = "this".equals(varWithWhitespace.getName()) ? new IdeExpr(propertyNameIde) : new DotExpr(new IdeExpr(varWithWhitespace), SYM_DOT, propertyNameIde);
        }
        AssignmentOpExpr assignmentOpExpr = new AssignmentOpExpr(leftHandSide, SYM_EQ.withWhitespace(" "), rightHandSide);
        return MxmlAstUtils.createSemicolonTerminatedStatement(assignmentOpExpr);
    }
}

