/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java_cup.runtime.Symbol;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.CompilationUnitRegistry;
import net.jangaroo.jooc.CompilationUnitResolver;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.JooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scanner;
import net.jangaroo.jooc.ScannerBase;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.PredefinedTypeDeclaration;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.mxml.MxmlComponentRegistry;
import net.jangaroo.properties.Propc;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.BOMStripperInputStream;
import net.jangaroo.utils.CompilerUtils;

public class JangarooParser
implements CompilationUnitResolver,
CompilationUnitRegistry {
    public static final String JOO_API_IN_JAR_DIRECTORY_PREFIX = "META-INF/joo-api/";
    static final String UTF_8 = "UTF-8";
    protected CompileLog log;
    private static ThreadLocal<CompileLog> defaultLog = new ThreadLocal();
    private InputSource sourcePathInputSource;
    private InputSource classPathInputSource;
    private ParserOptions config;
    private Map<InputSource, CompilationUnit> compilationUnitsByInputSource = new HashMap<InputSource, CompilationUnit>();
    private Map<CompilationUnit, InputSource> inputSourceByCompilationUnit = new HashMap<CompilationUnit, InputSource>();
    private Map<String, CompilationUnit> compilationUnitsByQName = new LinkedHashMap<String, CompilationUnit>();
    private MxmlComponentRegistry mxmlComponentRegistry = new MxmlComponentRegistry();
    private List<String> compilableSuffixes = Arrays.asList(".properties", ".as", ".mxml");
    private final Scope globalScope = new DeclarationScope(null, null, this);
    private final TypeDeclaration voidType = JangarooParser.declareType(this.globalScope, AS3Type.VOID.toString(), false);
    private final TypeDeclaration anyType = JangarooParser.declareType(this.globalScope, AS3Type.ANY.toString(), true);

    public JangarooParser(@Nonnull ParserOptions config, @Nonnull CompileLog log) {
        JangarooParser.declareValues(this.globalScope, new String[]{"this"});
        this.config = config;
        this.log = log;
    }

    public TypeDeclaration getAnyType() {
        return this.anyType;
    }

    public TypeDeclaration getVoidType() {
        return this.anyType;
    }

    public static CompilerError error(String msg) {
        return new CompilerError(msg);
    }

    public static CompilerError error(String msg, File file) {
        return new CompilerError(new FilePositionImpl(file), msg);
    }

    public static CompilerError error(FilePosition symbol, String msg) {
        return new CompilerError(symbol, msg);
    }

    public static CompilerError error(FilePosition symbol, String msg, Throwable t) {
        return new CompilerError(symbol, msg, t);
    }

    public static CompilerError error(AstNode node, String msg) {
        return JangarooParser.error(node.getSymbol(), msg);
    }

    public static CompilerError error(String msg, File file, Throwable t) {
        return new CompilerError(new FilePositionImpl(file), msg, t);
    }

    public static CompilerError error(String msg, Throwable t) {
        return new CompilerError(msg, t);
    }

    public static void warning(FilePosition symbol, String msg) {
        defaultLog.get().warning(symbol, msg);
    }

    public static void warning(String msg, File file) {
        defaultLog.get().warning((FilePosition)new FilePositionImpl(file), msg);
    }

    public static void warning(String msg) {
        defaultLog.get().warning(msg);
    }

    public ParserOptions getConfig() {
        return this.config;
    }

    public void setConfig(ParserOptions config) {
        this.config = config;
    }

    public CompileLog getLog() {
        return this.log;
    }

    public void setLog(CompileLog log) {
        this.log = log;
    }

    public List<String> getCompilableSuffixes() {
        return this.compilableSuffixes;
    }

    public void setCompilableSuffixes(List<String> compilableSuffixes) {
        this.compilableSuffixes = compilableSuffixes;
    }

    public CompilationUnit doParse(InputSource in, CompileLog log, SemicolonInsertionMode semicolonInsertionMode) {
        Reader reader;
        if (this.config.isVerbose()) {
            System.out.println("Parsing " + in.getPath() + " (" + (in.isInSourcePath() ? "source" : "class") + "path)");
        }
        String inputSourceName = in.getName();
        boolean parseMxml = inputSourceName.endsWith(".mxml");
        try {
            if (inputSourceName.endsWith(".properties")) {
                if (inputSourceName.contains("_")) {
                    return null;
                }
                reader = this.createPropertiesClassReader(in);
            } else {
                reader = new InputStreamReader((InputStream)new BOMStripperInputStream(in.getInputStream()), UTF_8);
            }
        }
        catch (IOException e) {
            throw new CompilerError("Cannot read input file: " + in.getPath(), e);
        }
        Scanner s = new Scanner(reader);
        s.yybegin(parseMxml ? 14 : 0);
        s.setInputSource(in);
        JooParser p = new JooParser(s);
        p.setCompileLog(log);
        p.setSemicolonInsertionMode(semicolonInsertionMode);
        try {
            Symbol tree = p.parse();
            return (CompilationUnit)tree.value;
        }
        catch (ScannerBase.ScanError se) {
            log.error((FilePosition)se.getSym(), se.getMessage());
            return null;
        }
        catch (JooParser.FatalSyntaxError e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not parse Jangaroo source", e);
        }
    }

    public Reader createPropertiesClassReader(InputSource in) throws IOException {
        Propc propertyClassGenerator = new Propc();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        propertyClassGenerator.generateApi(CompilerUtils.qNameFromRelativePath((String)in.getRelativePath()), in.getInputStream(), new OutputStreamWriter((OutputStream)outputStream, UTF_8));
        String output = outputStream.toString(UTF_8);
        return new StringReader(output);
    }

    private static TypeDeclaration declareType(Scope scope, String identifier, boolean dynamic) {
        PredefinedTypeDeclaration decl = new PredefinedTypeDeclaration(identifier, dynamic);
        decl.scope(scope);
        return decl;
    }

    protected static void declareValues(Scope scope, String[] identifiers) {
        for (String identifier : identifiers) {
            Ide ide = new Ide(new JooSymbol(identifier));
            VariableDeclaration decl = new VariableDeclaration(new JooSymbol("var"), ide, null, null);
            ((IdeDeclaration)decl).scope(scope);
        }
    }

    protected InputSource findSource(String qname) {
        InputSource result;
        for (String suffix : this.compilableSuffixes) {
            result = JangarooParser.findInputSource(qname, this.sourcePathInputSource, suffix);
            if (result == null) continue;
            return result;
        }
        for (String suffix : this.compilableSuffixes) {
            result = JangarooParser.findInputSource(qname, this.classPathInputSource, suffix);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static InputSource findInputSource(String qname, InputSource pathInputSource, String suffix) {
        String inputSourceFileName = JangarooParser.getInputSourceFileName(qname, pathInputSource, suffix);
        return inputSourceFileName == null ? null : pathInputSource.getChild(inputSourceFileName);
    }

    public static String getInputSourceFileName(String qname, InputSource is, String extension) {
        return CompilerUtils.fileNameFromQName((String)qname, (char)is.getFileSeparatorChar(), (String)extension);
    }

    public CompilationUnit importSource(InputSource source) {
        CompilationUnit unit = this.compilationUnitsByInputSource.get(source);
        if (unit != null) {
            return unit;
        }
        String fileName = source.getName();
        if (!this.hasCompilableSuffix(fileName)) {
            throw JangarooParser.error("Input file must end with one of '" + this.getCompilableSuffixes() + "': " + fileName);
        }
        unit = this.doParse(source, this.log, this.config.getSemicolonInsertionMode());
        if (unit == null) {
            return null;
        }
        String qname = unit.getQualifiedNameStr();
        this.compilationUnitsByQName.put(qname, unit);
        this.compilationUnitsByInputSource.put(source, unit);
        this.inputSourceByCompilationUnit.put(unit, source);
        unit.scope(this.globalScope);
        return unit;
    }

    private boolean hasCompilableSuffix(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex != -1 && this.getCompilableSuffixes().contains(fileName.substring(dotIndex));
    }

    public IdeDeclaration resolveImport(ImportDirective importDirective) {
        CompilationUnit compilationUnit;
        String qname = importDirective.getQualifiedName();
        try {
            compilationUnit = this.getCompilationUnit(qname);
        }
        catch (CompilerError e) {
            this.getLog().error(e.getSymbol(), e.getMessage());
            throw JangarooParser.error(importDirective.getSymbol(), "Unable to import " + qname + ": error while parsing its source (see error above).");
        }
        if (compilationUnit == null) {
            throw JangarooParser.error(importDirective.getSymbol(), "unable to resolve import of " + qname);
        }
        return compilationUnit.getPrimaryDeclaration();
    }

    public Collection<CompilationUnit> getCompilationUnits() {
        return this.compilationUnitsByQName.values();
    }

    @Override
    public CompilationUnit getCompilationUnit(String qname) {
        InputSource source;
        CompilationUnit compilationUnit = this.compilationUnitsByQName.get(qname);
        if (compilationUnit == null && (source = this.findSource(qname)) != null) {
            compilationUnit = this.importSource(source);
        }
        return compilationUnit;
    }

    public boolean isClass(String name) {
        InputSource source;
        if (name == null) {
            return false;
        }
        CompilationUnit compilationUnit = this.compilationUnitsByQName.get(name);
        if (compilationUnit == null && (source = this.findSource(name)) != null && source.getName().endsWith(".mxml")) {
            return true;
        }
        return this.resolveCompilationUnit(name).isClass();
    }

    @Override
    @Nonnull
    public CompilationUnit resolveCompilationUnit(@Nonnull String fullClassName) {
        CompilationUnit compilationUnit = this.getCompilationUnit(fullClassName);
        if (compilationUnit == null) {
            throw JangarooParser.error("Undefined type: " + fullClassName);
        }
        return compilationUnit;
    }

    public MxmlComponentRegistry getMxmlComponentRegistry() {
        return this.mxmlComponentRegistry;
    }

    public List<String> getPackageIdes(String packageName) {
        ArrayList<String> result = new ArrayList<String>(10);
        this.addPackageFolderSymbols(result, packageName, this.sourcePathInputSource);
        this.addPackageFolderSymbols(result, packageName, this.classPathInputSource);
        return result;
    }

    private void addPackageFolderSymbols(List<String> result, String packageName, InputSource path) {
        InputSource folder = JangarooParser.findInputSource(packageName, path, "");
        if (folder != null) {
            for (InputSource inputSource : folder.list()) {
                if (inputSource.isDirectory() || !this.hasCompilableSuffix(inputSource.getName())) continue;
                result.add(CompilerUtils.qNameFromRelativePath((String)inputSource.getName()));
            }
        }
    }

    public void setUp(InputSource sourcePathInputSource, InputSource classPathInputSource) {
        defaultLog.set(this.log);
        this.sourcePathInputSource = sourcePathInputSource;
        this.classPathInputSource = classPathInputSource;
    }

    public void tearDown() {
        defaultLog.remove();
    }

    public InputSource getInputSource(CompilationUnit compilationUnit) {
        return this.inputSourceByCompilationUnit.get(compilationUnit);
    }

    @Override
    public boolean implementsInterface(CompilationUnit classCompilationUnit, String anInterface) {
        return classCompilationUnit != null && classCompilationUnit.isClass() && this.implementsInterface((ClassDeclaration)classCompilationUnit.getPrimaryDeclaration(), anInterface);
    }

    public boolean implementsInterface(@Nonnull ClassDeclaration classDeclaration, String anInterface) {
        CompilationUnit interfaceCompilationUnit = this.getCompilationUnit(anInterface);
        return interfaceCompilationUnit != null && interfaceCompilationUnit.isClass() && classDeclaration.isAssignableTo((ClassDeclaration)interfaceCompilationUnit.getPrimaryDeclaration());
    }

    private static class FilePositionImpl
    implements FilePosition {
        private final String fileName;
        private final int line;
        private final int column;

        public FilePositionImpl(File file) {
            this(file.getAbsolutePath(), -1, -1);
        }

        public FilePositionImpl(String fileName, int line, int column) {
            this.fileName = fileName;
            this.line = line;
            this.column = column;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

