/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.ActionScriptCodeGeneratingModelVisitor;
import net.jangaroo.jooc.backend.ApiModelGenerator;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.config.JoocOptions;
import org.apache.tools.ant.util.FileUtils;

public class SingleFileCompilationUnitSinkFactory
extends AbstractCompilationUnitSinkFactory {
    private String suffix;
    private boolean generateApi;

    public SingleFileCompilationUnitSinkFactory(JoocOptions options, File destinationDir, boolean generateApi, String suffix) {
        super(options, destinationDir);
        this.suffix = suffix;
        this.generateApi = generateApi;
    }

    protected File getOutputFile(File sourceFile, String[] packageName) {
        return new File(this.getOutputFileName(sourceFile, packageName));
    }

    protected String getOutputFileName(File sourceFile, String[] packageName) {
        String result;
        if (this.getOutputDir() == null) {
            result = sourceFile.getAbsoluteFile().getParentFile().getAbsolutePath();
        } else {
            result = this.getOutputDir().getAbsolutePath();
            StringBuilder buffy = new StringBuilder(result);
            for (String aPackageName : packageName) {
                buffy.append(File.separator);
                buffy.append(aPackageName);
            }
            result = buffy.toString();
        }
        result = result + File.separator;
        result = result + sourceFile.getName();
        int dotpos = result.lastIndexOf(46);
        if (dotpos >= 0) {
            result = result.substring(0, dotpos);
        }
        result = result + this.suffix;
        return result;
    }

    @Override
    public CompilationUnitSink createSink(PackageDeclaration packageDeclaration, IdeDeclaration primaryDeclaration, final File sourceFile, final boolean verbose) {
        String className;
        final File outFile = this.getOutputFile(sourceFile, packageDeclaration.getQualifiedName());
        String fileName = outFile.getName();
        String classPart = fileName.substring(0, fileName.lastIndexOf(46));
        if (!classPart.equals(className = primaryDeclaration.getName())) {
            Jooc.warning(primaryDeclaration.getSymbol(), "class name should be equal to file name: expected " + classPart + ", found " + className);
        }
        this.createOutputDirs(outFile);
        return new CompilationUnitSink(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public File writeOutput(CompilationUnit compilationUnit) {
                block11: {
                    if (verbose) {
                        System.out.println("writing file: '" + outFile.getAbsolutePath() + "'");
                    }
                    try {
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
                        try {
                            if (SingleFileCompilationUnitSinkFactory.this.generateApi) {
                                ApiModelGenerator apiModelGenerator = new ApiModelGenerator(SingleFileCompilationUnitSinkFactory.isExcludeClassByDefault(SingleFileCompilationUnitSinkFactory.this.getOptions()));
                                apiModelGenerator.generateModel(compilationUnit).visit(new ActionScriptCodeGeneratingModelVisitor(writer));
                                break block11;
                            }
                            JsWriter out = new JsWriter(writer);
                            String codeSuffix = "";
                            try {
                                out.setOptions(SingleFileCompilationUnitSinkFactory.this.getOptions());
                                compilationUnit.visit(new JsCodeGenerator(out));
                                if (SingleFileCompilationUnitSinkFactory.this.options.isGenerateSourceMaps()) {
                                    codeSuffix = SingleFileCompilationUnitSinkFactory.this.generateSourceMap(out, outFile);
                                }
                            }
                            finally {
                                out.close(codeSuffix);
                            }
                            if (SingleFileCompilationUnitSinkFactory.this.options.isGenerateSourceMaps()) {
                                FileUtils.getFileUtils().copyFile(sourceFile, new File(outFile.getParentFile(), sourceFile.getName()));
                            }
                        }
                        catch (IOException e) {
                            outFile.delete();
                            throw Jooc.error("error writing file: '" + outFile.getAbsolutePath() + "'", outFile, e);
                        }
                    }
                    catch (IOException e) {
                        throw Jooc.error("cannot open output file for writing: '" + outFile.getAbsolutePath() + "'", outFile, e);
                    }
                }
                return outFile;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateSourceMap(JsWriter out, File outFile) throws IOException {
        SourceMapGenerator sourceMapGenerator = SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3);
        sourceMapGenerator.validate(true);
        for (JsWriter.SymbolToOutputFilePosition entry : out.getSourceMappings()) {
            String sourceFilename = entry.getSymbol().getFileName();
            sourceFilename = sourceFilename.substring(sourceFilename.lastIndexOf(File.separatorChar) + 1);
            sourceMapGenerator.addMapping(sourceFilename, entry.getSymbol().getText(), entry.getSourceFilePosition(), entry.getOutputFileStartPosition(), entry.getOutputFileEndPosition());
        }
        String sourceMapFilename = outFile.getAbsolutePath() + ".map";
        FileWriter sourceMapWriter = new FileWriter(sourceMapFilename);
        try {
            sourceMapGenerator.appendTo((Appendable)sourceMapWriter, outFile.getName());
        }
        finally {
            sourceMapWriter.close();
        }
        return "//# sourceMappingURL=" + outFile.getName() + ".map";
    }

    private static boolean isExcludeClassByDefault(JoocOptions options) {
        try {
            return options.isExcludeClassByDefault();
        }
        catch (IncompatibleClassChangeError e) {
            return false;
        }
    }
}

