/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;

public class IdeExpr
extends Expr {
    private Ide ide;
    private Expr normalizedExpr;

    public IdeExpr(JooSymbol symIde) {
        this(new Ide(symIde));
    }

    public IdeExpr(Ide ide) {
        this.ide = ide;
    }

    public static IdeExpr fromPrefix(JooSymbol symPrefix, JooSymbol symDot, Ide ide) {
        return new IdeExpr(ide.qualify(symPrefix, symDot));
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.ide);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        Expr normalizedExpr = this.getNormalizedExpr();
        if (normalizedExpr != this) {
            normalizedExpr.visit(visitor);
        } else {
            visitor.visitIdeExpression(this);
        }
    }

    public Expr getNormalizedExpr() {
        if (this.normalizedExpr == null) {
            this.normalizedExpr = this;
            IdeDeclaration ideDeclaration = this.ide.getDeclaration(false);
            if (this.ide instanceof QualifiedIde && ideDeclaration == null || ideDeclaration != null && ideDeclaration.isClassMember()) {
                DotExpr dotExpr = null;
                if (this.ide instanceof QualifiedIde) {
                    dotExpr = new DotExpr(new IdeExpr(this.ide.getQualifier()), ((QualifiedIde)this.ide).getSymDot(), new Ide(this.ide.getIde()));
                } else if (!ideDeclaration.isStatic()) {
                    JooSymbol ideSymbol = this.ide.getSymbol();
                    Ide thisIde = new Ide(ideSymbol.replacingSymAndTextAndJooValue(33, "this", null));
                    if (this.ide.isRewriteThis()) {
                        thisIde.setRewriteThis(true);
                        this.setThisDeclaration(thisIde);
                    }
                    dotExpr = new DotExpr(new IdeExpr(thisIde), IdeExpr.synthesizeDotSymbol(ideSymbol), new Ide(ideSymbol.withoutWhitespace()));
                } else if (!ideDeclaration.isPrivate()) {
                    JooSymbol ideSymbol = this.ide.getSymbol();
                    ClassDeclaration classDeclaration = ideDeclaration.getClassDeclaration();
                    Ide classIde = new Ide(ideSymbol.replacingSymAndTextAndJooValue(99, classDeclaration.getName(), null));
                    classIde.setDeclaration(classDeclaration);
                    dotExpr = new DotExpr(new IdeExpr(classIde), IdeExpr.synthesizeDotSymbol(ideSymbol), new Ide(ideSymbol.withoutWhitespace()));
                }
                if (dotExpr != null) {
                    dotExpr.setOriginal(this);
                    this.normalizedExpr = dotExpr;
                }
            }
        }
        return this.normalizedExpr;
    }

    private void setThisDeclaration(Ide thisIde) {
        for (Scope scope = this.ide.getScope(); scope != null && scope.getFunctionExpr() != null; scope = scope.getParentScope()) {
            FunctionDeclaration functionDeclaration = scope.getFunctionExpr().getFunctionDeclaration();
            if (functionDeclaration == null || !functionDeclaration.isClassMember()) continue;
            thisIde.setDeclaration(scope.lookupDeclaration(thisIde));
            break;
        }
    }

    private static JooSymbol synthesizeDotSymbol(JooSymbol ideSymbol) {
        return ideSymbol.replacingSymAndTextAndJooValue(73, ".", null).withoutWhitespace();
    }

    @Override
    public void scope(Scope scope) {
        this.getIde().scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.getIde().analyze(this);
        this.getIde().analyzeAsExpr(parentNode, this);
        IdeDeclaration type = this.getIde().resolveDeclaration();
        if (type instanceof VariableDeclaration) {
            TypeRelation optTypeRelation = ((VariableDeclaration)type).getOptTypeRelation();
            type = optTypeRelation == null ? null : optTypeRelation.getType().getIde().getDeclaration(false);
        }
        this.setType(type);
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getIde().getSymbol();
    }

    @Override
    public boolean isRuntimeConstant() {
        String qualifiedNameStr = this.ide.getQualifiedNameStr();
        return qualifiedNameStr.equals("undefined") || qualifiedNameStr.equals("NaN");
    }

    @Override
    public boolean isCompileTimeConstant() {
        IdeDeclaration qualifierDeclaration;
        if (this.isRuntimeConstant()) {
            return true;
        }
        IdeDeclaration declaration = this.ide.getDeclaration(false);
        if (declaration != null) {
            return declaration.isDeclaringCompileTimeConstant();
        }
        if (this.ide.isQualified() && (qualifierDeclaration = this.ide.getQualifier().getDeclaration(false)) instanceof ClassDeclaration) {
            ClassDeclaration classDeclaration = (ClassDeclaration)qualifierDeclaration;
            TypedIdeDeclaration staticMemberDeclaration = classDeclaration.getStaticMemberDeclaration(this.ide.getName());
            return staticMemberDeclaration.isDeclaringCompileTimeConstant();
        }
        return false;
    }

    public final Ide getIde() {
        return this.ide;
    }
}

