/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.PredefinedTypeDeclaration;

public class ApplyExpr
extends Expr {
    private Expr fun;
    private ParenthesizedExpr<CommaSeparatedList<Expr>> args;
    private boolean insideNewExpr = false;
    private static final Set<String> COERCE_FUNCTION_NAMES = new HashSet<String>(Arrays.asList("Number", "String", "Boolean", "int", "uint", "Date", "Object", "Array", "RegExp", "XML"));

    public ApplyExpr(Expr fun, JooSymbol lParen, CommaSeparatedList<Expr> args, JooSymbol rParen) {
        this.fun = fun;
        this.args = new ParenthesizedExpr<CommaSeparatedList<Expr>>(lParen, args, rParen);
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.fun, this.args);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitApplyExpr(this);
    }

    public boolean isInsideNewExpr() {
        return this.insideNewExpr;
    }

    public void setInsideNewExpr(boolean insideNewExpr) {
        this.insideNewExpr = insideNewExpr;
    }

    @Override
    public void scope(Scope scope) {
        this.getFun().scope(scope);
        this.getArgs().scope(scope);
    }

    public boolean isTypeCast() {
        return this.getFun() instanceof IdeExpr && !this.isInsideNewExpr() && this.isNonCoercingType((IdeExpr)this.getFun()) && this.hasExactlyOneArgument();
    }

    private boolean hasExactlyOneArgument() {
        CommaSeparatedList<Expr> expr;
        return this.getArgs() != null && (expr = this.getArgs().getExpr()) != null && expr.getHead() != null && expr.getTail() == null;
    }

    private boolean isNonCoercingType(IdeExpr fun) {
        Ide ide = fun.getIde();
        IdeDeclaration declaration = ide.getDeclaration(false);
        return declaration != null && (declaration instanceof ClassDeclaration || declaration instanceof PredefinedTypeDeclaration || declaration instanceof FunctionDeclaration && declaration.isConstructor()) && (declaration.isClassMember() || !ApplyExpr.isCoerceFunction(declaration.getQualifiedNameStr()));
    }

    public static boolean isCoerceFunction(String qualifiedName) {
        return COERCE_FUNCTION_NAMES.contains(qualifiedName);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.getFun().analyze(this);
        if (this.getArgs() != null) {
            this.getArgs().analyze(this);
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getFun().getSymbol();
    }

    public Expr getFun() {
        return this.fun;
    }

    public ParenthesizedExpr<CommaSeparatedList<Expr>> getArgs() {
        return this.args;
    }
}

