/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.backend.ApiModelGenerator;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.ClassModel;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.FieldModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.PropertyModel;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.jooc.util.PreserveLineNumberHandler;
import net.jangaroo.utils.CompilerUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class MxmlToModelParser {
    public static final String MXML_UNTYPED_NAMESPACE = "mxml:untyped";
    public static final String MXML_DECLARATIONS = "Declarations";
    public static final String MXML_SCRIPT = "Script";
    public static final String MXML_METADATA = "Metadata";
    public static final String MXML_ID_ATTRIBUTE = "id";
    public static final String MXML_DEFAULT_PROPERTY_ANNOTATION = "DefaultProperty";
    public static final String RESOURCE_MANAGER_QNAME = "mx.resources.ResourceManager";
    public static final Pattern AT_RESOURCE_PATTERN = Pattern.compile("^\\s*@Resource\\s*\\(\\s*bundle\\s*=\\s*['\"]([a-zA-Z0-9_$]+)['\"]\\s*,\\s*key\\s*=\\s*['\"]([a-zA-Z0-9_$]+)['\"]\\s*\\)\\s*$");
    public static final String RESOURCE_ACCESS_CODE = "{%s.getInstance().getString(\"%s\",\"%s\")}";
    public static final String CONSTRUCTOR_PARAMETER_ANNOTATION = "ConstructorParameter";
    public static final String CONSTRUCTOR_PARAMETER_ANNOTATION_VALUE = "value";
    public static final String ALLOW_CONSTRUCTOR_PARAMETERS_ANNOTATION = "AllowConstructorParameters";
    private final JangarooParser jangarooParser;
    private CompilationUnitModel compilationUnitModel;
    private int auxVarIndex;
    private StringBuilder code;

    public MxmlToModelParser(JangarooParser jangarooParser) {
        this.jangarooParser = jangarooParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilationUnitModel parse(InputSource in) throws IOException, SAXException {
        String qName = CompilerUtils.qNameFromRelativPath((String)in.getRelativePath());
        this.compilationUnitModel = new CompilationUnitModel(CompilerUtils.packageName((String)qName), new ClassModel(CompilerUtils.className((String)qName)));
        this.auxVarIndex = 0;
        this.code = new StringBuilder();
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(in.getInputStream());
            this.parse(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return this.compilationUnitModel;
    }

    private void parse(InputStream inputStream) throws IOException, SAXException {
        Document document = this.buildDom(inputStream);
        Element objectNode = document.getDocumentElement();
        String superClassName = this.createClassNameFromNode(objectNode);
        if (superClassName == null) {
            throw Jooc.error("Could not resolve super class from node " + objectNode.getNamespaceURI() + ":" + objectNode.getLocalName());
        }
        if (superClassName.equals(this.compilationUnitModel.getQName())) {
            throw Jooc.error("Cyclic inheritance error: super class and this component are the same!. There is something wrong!");
        }
        ClassModel classModel = this.compilationUnitModel.getClassModel();
        classModel.setSuperclass(superClassName);
        this.compilationUnitModel.addImport(superClassName);
        MethodModel constructorModel = classModel.createConstructor();
        String superConfigVar = null;
        boolean hasBindings = false;
        FieldModel bindingsField = new FieldModel("$bindings", "Array");
        bindingsField.setNamespace("private");
        classModel.addMember(bindingsField);
        this.code.append("\n    $bindings = [];");
        if (this.constructorSupportsConfigOptionsParameter(superClassName)) {
            String configVar = this.createAuxVar();
            constructorModel.addParam(new ParamModel(configVar, "Object", "null"));
            superConfigVar = this.createAuxVar();
            this.renderConfigAuxVar(superConfigVar);
            this.createFields(objectNode);
            hasBindings = this.processAttributesAndChildNodes(objectNode, superConfigVar, "this", true);
            String keyVar = this.createAuxVar();
            this.code.append(MessageFormat.format("\n    if ({1}) for (var {0}:String in {1}) {2}[{0}] = {1}[{0}];\n    super({2});", keyVar, configVar, superConfigVar));
        } else {
            this.createFields(objectNode);
        }
        if (superConfigVar == null || hasBindings) {
            this.processAttributesAndChildNodes(objectNode, superConfigVar, "this", false);
        }
        this.code.append("\n    for each (var $binding in $bindings) $binding.execute();");
        constructorModel.setBody(this.code.toString());
    }

    private void renderConfigAuxVar(String configAuxVar) {
        this.code.append("\n    var ").append(configAuxVar).append(":Object = {};");
    }

    private boolean constructorSupportsConfigOptionsParameter(String classQName) throws IOException {
        ParamModel firstParam;
        Iterator<ParamModel> constructorParams;
        MethodModel constructorModel;
        ClassModel classModel;
        CompilationUnitModel compilationUnitModel = this.getCompilationUnitModel(classQName);
        return compilationUnitModel != null && (classModel = compilationUnitModel.getClassModel()) != null && (constructorModel = classModel.getConstructor()) != null && (constructorParams = constructorModel.getParams().iterator()).hasNext() && "Object".equals((firstParam = constructorParams.next()).getType()) && "config".equals(firstParam.getName());
    }

    private void createFields(Element objectNode) throws IOException {
        ClassModel classModel = this.compilationUnitModel.getClassModel();
        for (Element element : MxmlUtils.getChildElements(objectNode)) {
            if (!MxmlUtils.isMxmlNamespace(element.getNamespaceURI())) continue;
            String elementName = element.getLocalName();
            if (MXML_DECLARATIONS.equals(elementName)) {
                for (Element declaration : MxmlUtils.getChildElements(element)) {
                    this.createValueCodeFromElement(declaration, false);
                }
                continue;
            }
            if (MXML_SCRIPT.equals(elementName)) {
                classModel.addBodyCode(MxmlToModelParser.getTextContent(element));
                continue;
            }
            if (MXML_METADATA.equals(elementName)) {
                classModel.addAnnotationCode(MxmlToModelParser.getTextContent(element));
                continue;
            }
            throw Jooc.error("Unknown MXML element: " + elementName);
        }
    }

    private boolean processAttributes(Element objectNode, CompilationUnitModel type, String configVariable, String targetVariable, boolean generatingConfig) throws IOException {
        String variable = generatingConfig ? configVariable : targetVariable;
        ClassModel classModel = type == null ? null : type.getClassModel();
        NamedNodeMap attributes = objectNode.getAttributes();
        boolean hasBindings = false;
        boolean hasIdAttribute = attributes.getNamedItem(MXML_ID_ATTRIBUTE) != null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String propertyName = attribute.getLocalName();
            if ((attribute.getNamespaceURI() != null || MXML_ID_ATTRIBUTE.equals(propertyName)) && !MXML_UNTYPED_NAMESPACE.equals(attribute.getNamespaceURI())) continue;
            String value = attribute.getValue();
            MemberModel propertyModel = null;
            if (classModel != null && (propertyModel = this.findPropertyModel(classModel, propertyName)) == null) {
                if (generatingConfig && hasIdAttribute) {
                    hasBindings = true;
                    continue;
                }
                AnnotationModel eventModel = this.findEvent(classModel, propertyName);
                if (eventModel != null) {
                    this.createEventHandlerCode(variable, value, eventModel);
                    continue;
                }
            }
            if (propertyModel == null) {
                propertyModel = this.createDynamicPropertyModel(type, propertyName, MXML_UNTYPED_NAMESPACE.equals(attribute.getNamespaceURI()));
            }
            if (!this.createPropertyAssignmentCodeWithBindings(configVariable, targetVariable, generatingConfig, value, propertyModel)) continue;
            hasBindings = true;
        }
        return hasBindings;
    }

    private boolean createPropertyAssignmentCodeWithBindings(String configVariable, String targetVariable, boolean generatingConfig, String value, MemberModel propertyModel) {
        String variable;
        String string = variable = generatingConfig ? configVariable : targetVariable;
        if (MxmlUtils.isBindingExpression(value) && MxmlToModelParser.hasSetter(propertyModel)) {
            if (generatingConfig) {
                this.createPropertyAssignmentCode(configVariable, propertyModel, MxmlUtils.createBindingExpression(this.getOrCreateExpressionMethod(targetVariable, propertyModel, value) + "()"), true);
            } else {
                this.createBindingMethodCode(targetVariable, propertyModel, value);
            }
            return true;
        }
        if (generatingConfig || configVariable == null) {
            this.createPropertyAssignmentCode(variable, propertyModel, value, generatingConfig);
        }
        return false;
    }

    private static boolean hasSetter(MemberModel memberModel) {
        return MxmlToModelParser.hasAnnotationAtSetter(memberModel, "Accessor");
    }

    private static boolean hasAnnotationAtSetter(MemberModel memberModel, String annotationName) {
        MemberModel setter = null;
        if (memberModel instanceof PropertyModel) {
            setter = ((PropertyModel)memberModel).getSetter();
        } else if (memberModel instanceof FieldModel && !((FieldModel)memberModel).isConst()) {
            setter = memberModel;
        }
        return setter != null && !setter.getAnnotations(annotationName).isEmpty();
    }

    private boolean processAttributesAndChildNodes(Element objectNode, String configVariable, String targetVariable, boolean generatingConfig) throws IOException {
        CompilationUnitModel type = this.getCompilationUnitModel(objectNode);
        boolean hasBindings = this.processAttributes(objectNode, type, configVariable, targetVariable, generatingConfig);
        if (this.processChildNodes(objectNode, type, configVariable, targetVariable, generatingConfig)) {
            hasBindings = true;
        }
        return hasBindings;
    }

    private boolean processChildNodes(Element objectNode, CompilationUnitModel type, String configVariable, String targetVariable, boolean generatingConfig) throws IOException {
        String variable = generatingConfig ? configVariable : targetVariable;
        boolean hasBindings = false;
        ClassModel classModel = type == null ? null : type.getClassModel();
        List<Element> childNodes = MxmlUtils.getChildElements(objectNode);
        MemberModel defaultPropertyModel = this.findDefaultPropertyModel(classModel);
        ArrayList<Element> defaultPropertyValues = new ArrayList<Element>();
        for (Element element : childNodes) {
            List<Element> childElements;
            AnnotationModel eventModel;
            if (MxmlUtils.isMxmlNamespace(element.getNamespaceURI())) continue;
            MemberModel propertyModel = null;
            String propertyName = element.getLocalName();
            if (objectNode.getNamespaceURI().equals(element.getNamespaceURI()) && classModel != null && (propertyModel = this.findPropertyModel(classModel, propertyName)) == null && (eventModel = this.findEvent(classModel, propertyName)) != null) {
                String value = MxmlToModelParser.getTextContent(element);
                this.createEventHandlerCode(variable, value, eventModel);
                continue;
            }
            if (propertyModel == null && defaultPropertyModel != null && this.createClassNameFromNode(element) != null) {
                defaultPropertyValues.add(element);
                continue;
            }
            if (propertyModel == null) {
                propertyModel = this.createDynamicPropertyModel(type, propertyName, false);
            }
            if ((childElements = MxmlUtils.getChildElements(element)).isEmpty()) {
                if (!this.createPropertyAssignmentCodeWithBindings(configVariable, targetVariable, generatingConfig, MxmlToModelParser.getTextContent(element), propertyModel)) continue;
                hasBindings = true;
                continue;
            }
            this.createChildElementsPropertyAssignmentCode(childElements, variable, propertyModel, generatingConfig);
        }
        if (!defaultPropertyValues.isEmpty()) {
            this.createChildElementsPropertyAssignmentCode(defaultPropertyValues, variable, defaultPropertyModel, generatingConfig);
        }
        return hasBindings;
    }

    private void createChildElementsPropertyAssignmentCode(List<Element> childElements, String variable, MemberModel propertyModel, boolean generatingConfig) throws IOException {
        boolean forceArray = "Array".equals(propertyModel.getType());
        boolean allowConstructorParameters = MxmlToModelParser.hasAnnotationAtSetter(propertyModel, ALLOW_CONSTRUCTOR_PARAMETERS_ANNOTATION);
        String value = this.createArrayCodeFromChildElements(childElements, forceArray, allowConstructorParameters);
        this.createPropertyAssignmentCode(variable, propertyModel, MxmlUtils.createBindingExpression(value), generatingConfig);
    }

    private String createArrayCodeFromChildElements(List<Element> childElements, boolean forceArray, boolean allowConstructorParameters) throws IOException {
        ArrayList<String> arrayItems = new ArrayList<String>();
        for (Element arrayItemNode : childElements) {
            String itemValue = this.createValueCodeFromElement(arrayItemNode, allowConstructorParameters);
            arrayItems.add(itemValue);
        }
        String value = arrayItems.size() > 1 || forceArray ? "[" + MxmlToModelParser.join(arrayItems, ", ") + "]" : (arrayItems.isEmpty() ? "null" : (String)arrayItems.get(0));
        return value;
    }

    private static String join(List<String> array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(array.get(i));
        }
        return sb.toString();
    }

    private String createValueCodeFromElement(Element objectElement, boolean allowConstructorParameters) throws IOException {
        String value;
        String className = this.createClassNameFromNode(objectElement);
        if (className == null) {
            throw Jooc.error("Could not resolve class from node " + objectElement.getNamespaceURI() + ":" + objectElement.getLocalName());
        }
        this.compilationUnitModel.addImport(className);
        String targetVariable = null;
        String id = objectElement.getAttribute(MXML_ID_ATTRIBUTE);
        if (!id.isEmpty()) {
            PropertyModel fieldModel = new PropertyModel(id, className);
            fieldModel.addGetter();
            fieldModel.addSetter();
            this.compilationUnitModel.getClassModel().addMember(fieldModel);
            targetVariable = id;
        }
        String configVariable = null;
        boolean hasBindings = false;
        if (this.constructorSupportsConfigOptionsParameter(className)) {
            configVariable = this.createAuxVar();
            this.renderConfigAuxVar(configVariable);
            if (targetVariable == null) {
                targetVariable = this.createAuxVar();
            }
            hasBindings = this.processAttributesAndChildNodes(objectElement, configVariable, targetVariable, true);
        }
        if ("String".equals(className)) {
            String stringValue = MxmlToModelParser.getTextContent(objectElement);
            value = CompilerUtils.quote((String)stringValue);
        } else if ("int".equals(className) || "uint".equals(className) || "Number".equals(className)) {
            value = MxmlToModelParser.getTextContent(objectElement);
            if (MxmlUtils.isBindingExpression(value)) {
                value = MxmlUtils.getBindingExpression(value);
            }
        } else if ("Object".equals(className)) {
            value = "{}";
        } else if ("Array".equals(className)) {
            value = this.createArrayCodeFromChildElements(MxmlUtils.getChildElements(objectElement), true, allowConstructorParameters);
        } else {
            StringBuilder valueBuilder = new StringBuilder();
            valueBuilder.append("new ").append(className).append("(");
            if (configVariable != null) {
                valueBuilder.append(configVariable);
            }
            valueBuilder.append(")");
            value = valueBuilder.toString();
        }
        if (id.length() > 0) {
            this.code.append("\n    ").append(targetVariable);
        } else if (configVariable == null || hasBindings) {
            if (targetVariable == null) {
                targetVariable = this.createAuxVar();
            }
            this.code.append("\n    ").append("var ").append(targetVariable).append(":").append(className);
        } else {
            if (allowConstructorParameters) {
                Set<MemberModel> configOptionsWithValue = this.findConfigOptionsWithValue(this.getCompilationUnitModel(className).getClassModel());
                for (MemberModel configOption : configOptionsWithValue) {
                    this.createPropertyAssignmentCode(configVariable, configOption, this.getConfigOptionValue(configOption), true);
                }
                return configVariable;
            }
            return value;
        }
        this.code.append(" = ").append(value).append(";");
        if (configVariable == null || hasBindings) {
            this.processAttributesAndChildNodes(objectElement, configVariable, targetVariable, false);
        }
        return targetVariable;
    }

    private String createAuxVar() {
        return "$_" + ++this.auxVarIndex;
    }

    private void createEventHandlerCode(String variable, String value, AnnotationModel event) {
        AnnotationPropertyModel eventType = event.getPropertiesByName().get("type");
        String eventTypeStr = eventType == null ? "Object" : eventType.getStringValue();
        this.compilationUnitModel.addImport(eventTypeStr);
        AnnotationPropertyModel eventNameModel = event.getPropertiesByName().get("name");
        String eventName = (eventNameModel != null ? eventNameModel : event.getPropertiesByName().get(null)).getStringValue();
        if (eventName.startsWith("on")) {
            eventName = eventName.substring(2);
        }
        String eventHandlerName = "$on_" + variable + "_" + eventName.replace('-', '_');
        MethodModel eventHandler = new MethodModel(eventHandlerName, "void", new ParamModel("event", eventTypeStr));
        eventHandler.setNamespace("private");
        eventHandler.setBody(value);
        this.compilationUnitModel.getClassModel().addMember(eventHandler);
        this.compilationUnitModel.addImport("joo.addEventListener");
        this.code.append("\n    ").append("joo.addEventListener(").append(variable).append(", ").append(CompilerUtils.quote((String)eventName)).append(", ").append(eventHandlerName).append(", ").append(eventTypeStr).append(");");
    }

    private void createBindingMethodCode(String variable, MemberModel propertyModel, String value) {
        String expressionMethodName = this.getOrCreateExpressionMethod(variable, propertyModel, value);
        this.compilationUnitModel.addImport("joo.binding.Binding");
        this.code.append("\n    $bindings.push(new joo.binding.Binding(").append(expressionMethodName).append(", function($value){").append("\n      ").append(MxmlToModelParser.getPropertyAssignmentCode(variable, propertyModel.getName(), "$value")).append("\n    }));");
    }

    private String getOrCreateExpressionMethod(String variable, MemberModel propertyModel, String value) {
        String expressionMethodName = "$bind_" + variable + "_" + propertyModel.getName();
        MethodModel bindingMethod = this.compilationUnitModel.getClassModel().getMethod(null, expressionMethodName);
        if (bindingMethod == null) {
            bindingMethod = new MethodModel(expressionMethodName, propertyModel.getType());
            bindingMethod.setNamespace("private");
            bindingMethod.setBody("return " + MxmlUtils.getBindingExpression(value) + ";");
            this.compilationUnitModel.getClassModel().addMember(bindingMethod);
        }
        return expressionMethodName;
    }

    private void createPropertyAssignmentCode(String variable, MemberModel propertyModel, String value, boolean generatingConfig) {
        String attributeValueAsString = MxmlUtils.valueToString(this.getPropertyValue(propertyModel, value));
        String propertyName = generatingConfig ? MxmlToModelParser.getConfigOptionName(propertyModel) : propertyModel.getName();
        this.code.append("\n    ").append(MxmlToModelParser.getPropertyAssignmentCode(variable, propertyName, attributeValueAsString));
    }

    private static String getPropertyAssignmentCode(String variable, String propertyName, String attributeValueAsString) {
        String assignment = MessageFormat.format("{0} = {1};", propertyName, attributeValueAsString);
        return "this".equals(variable) ? assignment : MessageFormat.format("{0}.{1}", variable, assignment);
    }

    private static String getConfigOptionName(MemberModel propertyModel) {
        AnnotationPropertyModel configOption;
        Iterator<AnnotationModel> configOptionAnnotations;
        MethodModel setter;
        if (propertyModel instanceof PropertyModel && (setter = ((PropertyModel)propertyModel).getSetter()) != null && (configOptionAnnotations = setter.getAnnotations(CONSTRUCTOR_PARAMETER_ANNOTATION).iterator()).hasNext() && (configOption = configOptionAnnotations.next().getPropertiesByName().get(null)) != null) {
            return configOption.getStringValue();
        }
        return propertyModel.getName();
    }

    private CompilationUnitModel getCompilationUnitModel(String fullClassName) throws IOException {
        if (fullClassName == null) {
            return null;
        }
        CompilationUnit compilationUnit = this.jangarooParser.getCompilationUnit(fullClassName);
        if (compilationUnit == null) {
            throw Jooc.error("Undefined type: " + fullClassName);
        }
        return new ApiModelGenerator(false).generateModel(compilationUnit);
    }

    private CompilationUnitModel getCompilationUnitModel(Element element) throws IOException {
        return this.getCompilationUnitModel(this.createClassNameFromNode(element));
    }

    private MemberModel findPropertyModel(ClassModel classModel, String propertyName) throws IOException {
        MemberModel memberModel;
        MemberModel propertyModel = null;
        ClassModel superClassModel = this.getSuperClassModel(classModel);
        if (superClassModel != null) {
            propertyModel = this.findPropertyModel(superClassModel, propertyName);
        }
        if (propertyModel == null && (memberModel = classModel.getMember(propertyName)) != null && memberModel.isWritable()) {
            propertyModel = memberModel;
        }
        return propertyModel;
    }

    private AnnotationModel findEvent(ClassModel classModel, String propertyName) throws IOException {
        ClassModel current = classModel;
        while (current != null) {
            AnnotationModel eventModel = current.getEvent(propertyName);
            if (eventModel != null) {
                return eventModel;
            }
            current = this.getSuperClassModel(current);
        }
        return null;
    }

    private MemberModel findDefaultPropertyModel(ClassModel classModel) throws IOException {
        ClassModel current = classModel;
        while (current != null) {
            MemberModel defaultPropertyModel = current.findPropertyWithAnnotation(false, MXML_DEFAULT_PROPERTY_ANNOTATION);
            if (defaultPropertyModel != null) {
                return defaultPropertyModel;
            }
            current = this.getSuperClassModel(current);
        }
        return null;
    }

    private Set<MemberModel> findConfigOptionsWithValue(ClassModel classModel) throws IOException {
        LinkedHashSet<MemberModel> result = new LinkedHashSet<MemberModel>();
        ClassModel current = classModel;
        while (current != null) {
            Set<MemberModel> configOptionPropertyModels = current.findPropertiesWithAnnotation(false, CONSTRUCTOR_PARAMETER_ANNOTATION);
            for (MemberModel configOptionPropertyModel : configOptionPropertyModels) {
                if (configOptionPropertyModel instanceof PropertyModel) {
                    configOptionPropertyModel = ((PropertyModel)configOptionPropertyModel).getGetter();
                }
                if (this.getConfigOptionValue(configOptionPropertyModel) == null) continue;
                result.add(configOptionPropertyModel);
            }
            current = this.getSuperClassModel(current);
        }
        return result;
    }

    private String getConfigOptionValue(MemberModel propertyModel) {
        AnnotationPropertyModel configOptionValue;
        List<AnnotationModel> configOptionAnnotations;
        if (propertyModel instanceof PropertyModel) {
            propertyModel = ((PropertyModel)propertyModel).getGetter();
        }
        if (!(configOptionAnnotations = propertyModel.getAnnotations(CONSTRUCTOR_PARAMETER_ANNOTATION)).isEmpty() && (configOptionValue = configOptionAnnotations.get(0).getPropertiesByName().get(CONSTRUCTOR_PARAMETER_ANNOTATION_VALUE)) != null) {
            return configOptionValue.getStringValue();
        }
        return null;
    }

    private MemberModel createDynamicPropertyModel(CompilationUnitModel compilationUnitModel, String name, boolean allowAnyProperty) {
        if (!allowAnyProperty && compilationUnitModel != null && compilationUnitModel.getClassModel() != null && !compilationUnitModel.getClassModel().isDynamic()) {
            throw Jooc.error("MXML: property " + name + " not found in class " + compilationUnitModel.getQName() + ".");
        }
        return new FieldModel(name, "*");
    }

    private ClassModel getSuperClassModel(ClassModel classModel) throws IOException {
        CompilationUnitModel superCompilationUnitModel;
        String superclass = classModel.getSuperclass();
        if (superclass != null && (superCompilationUnitModel = this.getCompilationUnitModel(superclass)) != null && superCompilationUnitModel.getPrimaryDeclaration() instanceof ClassModel) {
            return superCompilationUnitModel.getClassModel();
        }
        return null;
    }

    private Object getPropertyValue(MemberModel propertyModel, String value) {
        Matcher resourceBundleMatcher = AT_RESOURCE_PATTERN.matcher(value);
        if (resourceBundleMatcher.matches()) {
            String bundle = resourceBundleMatcher.group(1);
            String key = resourceBundleMatcher.group(2);
            value = String.format(RESOURCE_ACCESS_CODE, RESOURCE_MANAGER_QNAME, bundle, key);
            this.compilationUnitModel.addImport(RESOURCE_MANAGER_QNAME);
            MxmlUtils.addResourceBundleAnnotation(this.compilationUnitModel.getClassModel(), bundle);
        }
        return MxmlUtils.getAttributeValue(value, propertyModel == null ? null : propertyModel.getType());
    }

    private String createClassNameFromNode(Node objectNode) {
        String name = objectNode.getLocalName();
        String uri = objectNode.getNamespaceURI();
        if (uri != null) {
            String packageName = MxmlUtils.parsePackageFromNamespace(uri);
            if (packageName != null) {
                String qName = CompilerUtils.qName((String)packageName, (String)name);
                CompilationUnit compilationsUnit = this.jangarooParser.getCompilationUnit(qName);
                if (compilationsUnit != null && compilationsUnit.getPrimaryDeclaration() instanceof ClassDeclaration) {
                    return qName;
                }
            } else {
                return this.jangarooParser.getMxmlComponentRegistry().getClassName(uri, name);
            }
        }
        return null;
    }

    private static String getTextContent(Element element) {
        return element.getChildNodes().getLength() == 1 && element.getFirstChild().getNodeType() == 3 ? ((Text)element.getFirstChild()).getData() : "";
    }

    private Document buildDom(InputStream inputStream) throws SAXException, IOException {
        Document doc;
        SAXParser parser2;
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            parser2 = saxFactory.newSAXParser();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("a default dom builder should be provided", e);
        }
        PreserveLineNumberHandler handler = new PreserveLineNumberHandler(doc);
        parser2.parse(inputStream, (DefaultHandler)handler);
        return doc;
    }
}

